/*************************************************************************
 *
 *  $RCSfile: SchRangeChecker.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: af $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**	$Revision  
	@descr A RangeChecker has the task to test if the y value range of a given
		data set complies with a given chart type.
	
	@author
		Andre Fischer (af)
*/

#ifndef CHART_RANGE_CHECKER_HEADER
#define CHART_RANGE_CHECKER_HEADER

#ifndef _SVX_CHRTITEM_HXX
#include <svx/chrtitem.hxx>
#endif

class	ChartModel;

class	SchRangeChecker
{
public:
	/**
		@descr The constructor stores a pointer to a chart model so that the
			testing methods can derive information from it.
			
		@param pChartModel	
			Chart model from which the data values are taken and tested.
	*/
	SchRangeChecker		(ChartModel * pChartModel);
	
	///	@descr	Destroy the object.
	~SchRangeChecker	(void);

	/**
		@descr Test if there are positive and negative y-values and the given 
			chart style does not allow signed values.
			
		@param eChartStyle
			Chart style that defines the valid value range.
			
		@return
			TRUE if y-values comply with the valid value range.
	*/
	BOOL	TestAbsoluteValues		(SvxChartStyle eChartStyle);
	
	/**
		@descr Test if there are negative y-values and the given chart 
			style does not allow them.
			
		@param eChartStyle
			Chart style that defines the valid value range.
			
		@return
			TRUE if y-values comply with the valid value range.
	*/
	BOOL	TestNegativeValues		(SvxChartStyle eChartStyle);
	
	/**
		@descr Test if there are negative or zero y-values on a logarithmic
			scale.
			
		@return
			TRUE if y-values comply with the valid value range.
	*/
	BOOL	TestLogarithmicValues	(void);
	
private:
	/**	@descr	Chart model used for testing value ranges.  This shoud be a 
		const pointer because the model is not modified in this class, but 
		all relevant Get methods are non const :(
	*/
	ChartModel	*	mpChartModel;
	double			mfMin,	//	Minimum value of all data points.
					mfMax;	//	Maximum value of all data points.
};

#endif
