/*************************************************************************
 *
 *  $RCSfile: ChartElementFactory.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2002/04/29 15:54:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "ChartElementFactory.hxx"

#include "AccLegend.hxx"
#include "AccLegendEntry.hxx"
#include "AccTitle.hxx"
#include "AccDataSeries.hxx"
#include "AccDataPoint.hxx"
#include "AccDiagram.hxx"
#include "AccAxis.hxx"
#include "AccGrid.hxx"
#include "AccStatisticsObject.hxx"
#include "AccWall.hxx"
#include "AccFloor.hxx"
#include "AccArea.hxx"

#ifndef _SCH_ACCESSIBLEBASE_HXX_
#include "AccessibleBase.hxx"
#endif

#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif

namespace accessibility
{

AccessibleBase * ChartElementFactory::CreateChartElement(
    AccessibleBase * pParent,
    const AccessibleUniqueId & rId )
{
    sal_uInt16 nObjId = rId.GetObjectId();
    switch( nObjId )
    {
        case CHOBJID_LEGEND:
            return new Legend( pParent );
        case LegendEntry::ObjectId:
            return new LegendEntry( pParent, rId.GetIndex1() );

        case CHOBJID_TITLE_MAIN:
            return new Title( pParent, Title::MAIN );
        case CHOBJID_TITLE_SUB:
            return new Title( pParent, Title::SUB );
        case CHOBJID_DIAGRAM_TITLE_X_AXIS:
            return new Title( pParent, Title::X_AXIS );
        case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
            return new Title( pParent, Title::Y_AXIS );
        case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
            return new Title( pParent, Title::Z_AXIS );

        case CHOBJID_DIAGRAM:
            return new Diagram( pParent );

        // series
        case CHOBJID_DIAGRAM_ROWGROUP:
            return new DataSeries( pParent, rId.GetIndex1() );

        // data points
        case CHOBJID_DIAGRAM_DATA:
            return new DataPoint( pParent, rId.GetIndex1(), rId.GetIndex2() );

        case Axis::X_AXIS:
        case Axis::Y_AXIS:
        case Axis::Z_AXIS:
        case Axis::SEC_X_AXIS:
        case Axis::SEC_Y_AXIS:
            return new Axis( pParent, static_cast< Axis::AxisType >( nObjId ) );

        case Grid::X_MAJOR:
        case Grid::Y_MAJOR:
        case Grid::Z_MAJOR:
        case Grid::X_MINOR:
        case Grid::Y_MINOR:
        case Grid::Z_MINOR:
            return new Grid( pParent, static_cast< Grid::GridType >( nObjId ) );

        case StatisticsObject::MEAN_VAL_LINE:
        case StatisticsObject::ERROR_BARS:
        case StatisticsObject::REGRESSION:
            return new StatisticsObject( pParent,
                                         static_cast< StatisticsObject::StatisticsObjectType >( nObjId ),
                                         rId.GetIndex1() );

        case CHOBJID_DIAGRAM_WALL:
            return new Wall( pParent );

        case CHOBJID_DIAGRAM_FLOOR:
            return new Floor( pParent );

        case CHOBJID_DIAGRAM_AREA:
            return new Area( pParent );
    }
    return NULL;
}

AccessibleUniqueId ChartElementFactory::GetUniqueIdForDrawObject( const SdrObject * pObj )
{
    if( ! pObj )
        return AccessibleUniqueId();

    sal_uInt16 nObjId = GetObjectIdNum( *pObj );
    sal_uInt16 nIndex1 = 0;
    sal_uInt16 nIndex2 = 0;

    switch( nObjId )
    {
        case CHOBJID_LEGEND_SYMBOL_COL:
            {
                // the col variant is for pie charts.  The accessibility object, however,
                // just uses the row variant for identification.
                nObjId = CHOBJID_LEGEND_SYMBOL_ROW;

                SchDataPoint *pDataPoint = GetDataPoint( *pObj );
                if( pDataPoint )
                    nIndex1 = pDataPoint->GetCol();
            }
            break;

        // series
        case CHOBJID_DIAGRAM_ROWGROUP:
        case CHOBJID_LEGEND_SYMBOL_ROW:
            {
                SchDataRow *pDataRow = GetDataRow( *pObj );
                if( pDataRow )
                    nIndex1 = pDataRow->GetRow();
            }
            break;


        // data points
        case CHOBJID_DIAGRAM_DATA:
            {
                SchDataPoint* pDataPoint = GetDataPoint( *pObj );
                if( pDataPoint )
                {
                    nIndex1 = pDataPoint->GetRow();
                    nIndex2 = pDataPoint->GetCol();
                }
            }
            break;

        case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:
            nObjId = CHOBJID_DIAGRAM_X_GRID_MAIN;
            break;
        case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:
            nObjId = CHOBJID_DIAGRAM_Y_GRID_MAIN;
            break;
        case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:
            nObjId = CHOBJID_DIAGRAM_Z_GRID_MAIN;
            break;

        case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:
            nObjId = CHOBJID_DIAGRAM_X_GRID_HELP;
            break;
        case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:
            nObjId = CHOBJID_DIAGRAM_Y_GRID_HELP;
            break;
        case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:
            nObjId = CHOBJID_DIAGRAM_Z_GRID_HELP;
            break;
    }

    return AccessibleUniqueId( nObjId, nIndex1, nIndex2 );
}

} // namespace accessibility
