/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xl_comp.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:59:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XL_COMP_HXX
#define _XL_COMP_HXX

#ifndef _SOLAR_H
#include <solar.h>
#endif

#ifndef SC_FUNCTAB
#include "functab.h"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif

#ifndef SC_CELL_HXX
#include "cell.hxx"
#endif
namespace binfilter {

#define LONG	UINT32


// Maximalwerte
const	UINT16			nMaxCodeLen				= 4096;
const	UINT16			nMaxTokenLen			= 1024;
const	UINT16			nMaxStrLen				= 1024;

// ErrorCode
const	UINT16			nErrIllegalChar			= 1;
const	UINT16			nErrIllegalSymbol		= 2;
const	UINT16			nErrIllegalToken		= 3;
const	UINT16			nErrSeparator			= 4;
const	UINT16			nErrPair				= 5;
const	UINT16			nErrParameterExpected	= 6;
const	UINT16			nErrIllegalParameter	= 7;
const	UINT16			nErrIllegalStackVar		= 8;
const	UINT16			nErrOperatorExpected	= 9;
const	UINT16			nErrCodeOverflow		= 10;
const	UINT16			nErrStringToLong		= 11;
const	UINT16			nErrUnknownFuncType		= 12;


struct SBoolNum
{
	UINT8				otBool;
	UINT8				reserved1;
	UINT8				BoolValue;
	UINT8				reserved2[3];
	UINT16				fExprO;
};


struct SErrNum
{
	UINT8				otErr;
	UINT8				reserved1;
	UINT8				ErrValue;
	UINT8				reserved2[3];
	UINT16				fExprO;
};


struct SStrNum
{
	UINT8				otString;
	UINT8				reserved[5];
	UINT16				fExprO;
};


struct SFormulaRec
{
	UINT16				nLen;
	UINT16				nCce;
	UINT8				nCode[nMaxCodeLen];

	inline void			Set( const UINT16 nIndex, const UINT16 nVal );
	inline void			Get( const UINT16 nIndex, UINT16 &nVal );
};


inline void SFormulaRec::Set( const UINT16 nIndex, const UINT16 nVal )
{
	DBG_ASSERT( nIndex < nMaxCodeLen - 1, "-SFormulaRec::Set(): Index zu gross!" );
	ShortToSVBT16( nVal, &nCode[ nIndex ] );
}


inline void SFormulaRec::Get( const UINT16 nIndex, UINT16 &nVal )
{
	DBG_ASSERT( nIndex < nMaxCodeLen - 1, "-SFormulaRec::Get(): Index zu gross!" );
	nVal = SVBT16ToShort( &nCode[ nIndex ] );
}



struct SToken
{
	UINT8				ptg;
	UINT8				Data[nMaxTokenLen];
	String				aStr;	// for string purposes only
						SToken( void );
						SToken( const SToken& rCpy );

	inline void			Set( const UINT16 nIndex, const UINT8 nVal );
	inline void			Set( const UINT16 nIndex, const UINT16 nVal );
	inline void			Set( const UINT16 nIndex, const INT16 nVal );
	inline void			Set( const UINT16 nIndex, const UINT32 nVal );
	inline void			Set( const UINT16 nIndex, const INT32 nVal );
	inline void			Set( const UINT16 nIndex, const double &rVal );
};


inline void SToken::Set( const UINT16 nIndex, const UINT8 nVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen, "-SToken::Set(): Index zu gross!" );
	Data[ nIndex ] = nVal;
}


inline void SToken::Set( const UINT16 nIndex, const UINT16 nVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen - 1, "-SToken::Set(): Index zu gross!" );
	ShortToSVBT16( nVal, &Data[ nIndex ] );
}


inline void SToken::Set( const UINT16 nIndex, const INT16 nVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen - 1, "-SToken::Set(): Index zu gross!" );
	ShortToSVBT16( *( ( UINT16* ) &nVal ), &Data[ nIndex ] );
}


inline void SToken::Set( const UINT16 nIndex, const UINT32 nVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen - 3, "-SToken::Set(): Index zu gross!" );
	LongToSVBT32( nVal , &Data[ nIndex ] );
}


inline void SToken::Set( const UINT16 nIndex, const INT32 nVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen - 3, "-SToken::Set(): Index zu gross!" );
	LongToSVBT32( *( ( UINT32* ) &nVal ), &Data[ nIndex ] );
}


inline void SToken::Set( const UINT16 nIndex, const double &rVal )
{
	DBG_ASSERT( nIndex < nMaxTokenLen - 7, "-SToken::Set(): Index zu gross!" );
	DoubleToSVBT64( rVal, &Data[ nIndex ] );
}


class NameBuffer;
class ScAddress;
class ExcArrays;


enum EC_Codetype
{
	EC_StdFmla,			// standard cell formula
	EC_ArrayFmla,		// part of matrix
	EC_ShrdFmla			// part of shared formula
};


enum RefClassHandling
{
	RCH_Cell,			// treat like cell-formulas			(formerly pAddress != NULL)
	RCH_Name,			// treat like name-range-formulas	(formerly pAddress == NULL)
	RCH_Array			// for array formulas aka matrix ~
};



class CExcelCompiler : public ExcRoot
{
	const ScTokenArray* pCode;
	const ScToken*		pCur;
	const SFuncData*   	pFuncData;
	UINT16				m_nError;
	SFormulaRec			m_sFormulaRec;
	UINT16				m_nPos;
	SToken				m_Token;
	UINT16				m_nLastPtg;
	UINT16				m_pc;
	UINT8				m_nParamType;
    UINT8               m_nFuncParamType;
	UINT8*				m_pPrevRef;
	UINT8*				m_pLastRef;
	BOOL				m_bDelCode;		// set if pCode gets cloned and must be deleted in dtor
	BOOL				bCondForm;

	sal_Char*			pShrdFmla;
	UINT16				nShrdFmla;
	BOOL				bFirstShrdFmla;
	UINT32				nArrayFormId;

//	BOOL				bRefClassInCell;	// treat reference classes like cell formula
	RefClassHandling	eRefClHandl;

	const ScAddress*	pAddress;
public:
						CExcelCompiler( RootData*, const ScTokenArray&, const ScAddress* p = NULL,
										BOOL bConditionlFormat = FALSE );
	virtual				~CExcelCompiler();

	UINT16				GetError() const	{ return m_nError; }
	UINT16				GetLen() const		{ return (m_sFormulaRec.nLen + 4); }
	const SFormulaRec*	GetCode() const		{ return &m_sFormulaRec; }

	EC_Codetype			CreateCode( ExcArrays* pShrdFmlas = NULL );
	EC_Codetype			CreateArrayCode( BOOL bCreateArrayRecCode = FALSE );	// -> code in pShrdFmla!

	const sal_Char*		GetDataWithShrdFmla( void ) const;	// formula only with ref to shared formula
															//  -> shared formula in m_sFormulaRec
	UINT16				GetLenWithShrdFmla( void ) const;
	BOOL				GetShrdFmla( sal_Char*& rpCode, UINT16& rLen );
								// gives buffer back in rpCode -> delete necessary outside from CExcelCompiler
								// return == FALSE -> rpCode is undefined
	inline BOOL			IsFirstShrdFmla( void ) const;

	inline UINT32		GetArrayFormId( void ) const;
private:
	void				SetError(UINT16 nError);

	BOOL				IsOperator();
	BOOL				IsValue();
	BOOL				IsString();
	BOOL				IsFunc();
	BOOL				IsReference();
	BOOL				IsReferenceBiff8();
	BOOL				IsNamedRange();
//	BOOL				IsExternName();
	BOOL				IsDBArea();
    BOOL                IsDDE();
	BOOL				GetNextToken();

	UINT16				GetOperatorValueClass( UINT8 nPtg );
	void				PutCode(const SToken& rToken);
	void				PutCodeStr(const SToken& rToken);
	void				InsertMove( UINT16 nAtPc, UINT16 nCount );
	void				InsertJumpTable(UINT16* pJumpTable, UINT16 nJumpCount);
	void				Factor();
	void				Unary();
	void				PowLine();
	void				SignLine();
	void				UnionCutLine();
	void				MulDivLine();
	void				AddSubLine();
    void                ConcatLine();
	void				CompareLine();
	void				Expression();
	void				IgnoreParameter();
	void				InsertParameter( const SFuncData* pFuncData, UINT8 nScParam,
										UINT16 nLenAddData, const void* pAddData = NULL );

	ScRangeData*		GetSharedFormula();
    EC_Codetype         BreakSharedFormula( ScRangeData*, ExcArrays* pShrdFmlas = NULL );

	void				CalcBitsAbs( SingleRefData& rSRD, UINT16& rBitRow, UINT8& rBitCol );
	void				CalcBitsRel( SingleRefData& rSRD, UINT16& rBitRow, UINT8& rBitCol );

	void				CalcBitsAbsBiff8( SingleRefData& rSRD, UINT16& rBitRow, UINT16& rBitCol );
	void				CalcBitsRelBiff8( SingleRefData& rSRD, UINT16& rBitRow, UINT16& rBitCol );

    void                CheckAndChangeCurrClass();

						// CalcBitsAbs/CalcBitsRel must be executed first
	inline	BOOL		IsRefDeleted( const SingleRefData& rSRD );

    inline  BOOL        IsRefExternal( const SingleRefData& rSRD );

	UINT16				GetTabNum( const SingleRefData& rSRD );

	static	inline	UINT8	GetPtgBase( UINT8 nPtg );

	inline UINT8		GetPtg( UINT8 nRCH_Cell, UINT8 nRCH_Name, UINT8 nRCH_Array ) const;
	inline void			IncrPtg( UINT8& rPtg ) const;
	inline void			IncrPtg( UINT8* pPtg ) const;
};


inline BOOL CExcelCompiler::IsFirstShrdFmla( void ) const
{
	return bFirstShrdFmla;
}


inline UINT32 CExcelCompiler::GetArrayFormId( void ) const
{
	return nArrayFormId;
}


inline UINT8 CExcelCompiler::GetPtg( UINT8 nRCH_Cell, UINT8 nRCH_Name, UINT8 nRCH_Array ) const
{
	return ( eRefClHandl == RCH_Cell )? nRCH_Cell : ( ( eRefClHandl == RCH_Name )? nRCH_Name : nRCH_Array );
}


inline void CExcelCompiler::IncrPtg( UINT8& rPtg ) const
{
    switch( eRefClHandl )
    {
        case RCH_Name:  rPtg += 0x40;   break;
        case RCH_Array: rPtg += (m_nFuncParamType == nTypeRef) ? 0x40 : 0x20;   break;
        default:        rPtg += 0x20;
    }
}


inline void CExcelCompiler::IncrPtg( UINT8* pPtg ) const
{
//	rPtg += ( eRefClHandl == RCH_Cell )? 0x20 : ( ( eRefClHandl == RCH_Name )? 0x40 : 0x20 );
    IncrPtg( *pPtg );
}


} //namespace binfilter
#endif
