/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_chwindow.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:15:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include <bf_svx/flstitem.hxx>

#pragma hdrstop

// auto strip #ifndef _SV_HELP_HXX //autogen wg. Help
// auto strip #include <vcl/help.hxx>
// auto strip #endif

// auto strip #ifndef _SVDPAGV_HXX //autogen wg. SdrPageView
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif

#ifndef _ZFORLIST_HXX //autogen wg. SvNumberFormatter
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
// auto strip #include <svtools/zforlist.hxx>
#endif

#include "chwindow.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "schhids.h"
// auto strip #include "objid.hxx"

#include "strings.hrc"		// for QuickHelp Strings
#include "glob.hrc"
// auto strip #include "schresid.hxx"
// auto strip #include "datarow.hxx"
// auto strip #include "datapoin.hxx"
// auto strip #include "schattr.hxx"
// auto strip #include "chaxis.hxx"

// auto strip #include "AccessibleDocumentView.hxx"
namespace binfilter {

#define QUICK_HELP_TOLERANCE	  2		// in pixels

/************************************************************************/

#define MIN_ZOOM	10
#define MAX_ZOOM	650


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchWindow::SchWindow( Window* pParent ) :
/*N*/ 		DropTargetHelper( pParent ),
/*N*/ 		Window( pParent, WinBits( WB_CLIPCHILDREN )),
/*N*/ 		pViewShell( NULL ),
/*N*/ 		aWinPos( 0, 0 ),
/*N*/ 		aViewOrigin( 0,  0),
/*N*/ 		aViewSize( 1000, 1000 )
/*N*/ {
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	aMap.SetMapUnit(MAP_100TH_MM);
/*N*/ 	SetMapMode(aMap);
/*N*/ 
/*N*/ 	Color aWhiteColor( COL_WHITE );
/*N*/ 	SetBackground ( aWhiteColor );
/*N*/ 
/*N*/ 	// adjust contrast mode initially
/*N*/ 	bool bUseContrast = GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/     SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
/*N*/ 
/*N*/ 	// Hilfe-ID setzen
/*N*/ 	SetHelpId( HID_SCH_WIN_DOCUMENT );
/*N*/ 	SetUniqueId( HID_SCH_WIN_DOCUMENT );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchWindow::~SchWindow()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Die Haelfte des Sichtbaren Bereich eines anderen Fensters darstellen
|*
\************************************************************************/

//STRIP001 void SchWindow::ShareViewArea(const SchWindow* pOtherWin)
//STRIP001 {
//STRIP001 	aViewOrigin	= pOtherWin->aViewOrigin;
//STRIP001 	aViewSize  	= pOtherWin->aViewSize;
//STRIP001 
//STRIP001 	long nZoom = pOtherWin->GetZoom();
//STRIP001 	MapMode aMap(GetMapMode());
//STRIP001 	aMap.SetScaleX(Fraction(nZoom, 100));
//STRIP001 	aMap.SetScaleY(Fraction(nZoom, 100));
//STRIP001 	aMap.SetOrigin(pOtherWin->GetMapMode().GetOrigin());
//STRIP001 	SetMapMode(aMap);
//STRIP001 }

/*************************************************************************
|*
|* Paint event
|*
\************************************************************************/

//STRIP001 void SchWindow::Paint(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->Paint(rRect);
//STRIP001 }

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

//STRIP001 void SchWindow::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	if (!pViewShell || !pViewShell->KeyInput(rKEvt))
//STRIP001 		Window::KeyInput(rKEvt);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

//STRIP001 void SchWindow::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if (!pViewShell || !pViewShell->MouseButtonDown(rMEvt))
//STRIP001 		Window::MouseButtonDown(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

//STRIP001 void SchWindow::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if (!pViewShell || !pViewShell->MouseMove(rMEvt))
//STRIP001 		Window::MouseMove(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

//STRIP001 void SchWindow::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if (!pViewShell || !pViewShell->MouseButtonUp(rMEvt))
//STRIP001 		Window::MouseButtonUp(rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SchWindow::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	if (!pViewShell || !pViewShell->Command(rCEvt))
//STRIP001 		Window::Command(rCEvt);
//STRIP001 }

/*************************************************************************
|*
|* den eigentlichen Zoomfaktor in Prozent setzen; protected, wird
|* nur intern benutzt
|*
\************************************************************************/

/*N*/ long SchWindow::SetZoomFactor(long nZoom)
/*N*/ {
/*N*/ 	if (nZoom > MAX_ZOOM)
/*N*/ 		nZoom = MAX_ZOOM;
/*N*/ 	if (nZoom < MIN_ZOOM)
/*N*/ 		nZoom = MIN_ZOOM;
/*N*/ 
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	aMap.SetScaleX(Fraction(nZoom, 100));
/*N*/ 	aMap.SetScaleY(Fraction(nZoom, 100));
/*N*/ 	SetMapMode(aMap);
/*N*/ 	return nZoom;
/*N*/ }

/*************************************************************************
|*
|* Zoomfaktor in Prozent setzen und Darstellungsbereich um den
|* Zoom-Mittelpunkt zentrieren
|*
\************************************************************************/

/*N*/ void SchWindow::SetZoom(long nZoom)
/*N*/ {
/*N*/ 	if (nZoom > MAX_ZOOM)
/*N*/ 		nZoom = MAX_ZOOM;
/*N*/ 	if (nZoom < MIN_ZOOM)
/*N*/ 		nZoom = MIN_ZOOM;
/*N*/ 
/*N*/ 	Size aSize = PixelToLogic(GetSizePixel());
/*N*/ 	long nW = aSize.Width()  * GetZoom() / nZoom;
/*N*/ 	long nH = aSize.Height() * GetZoom() / nZoom;
/*N*/ 	aWinPos.X() += (aSize.Width()  - nW) / 2;
/*N*/ 	aWinPos.Y() += (aSize.Height() - nH) / 2;
/*N*/ 	SetZoomFactor(nZoom);
/*N*/ }

/*************************************************************************
|*
|* Fensterposition und Zoomfaktor nach uebergebenem Rechteck setzen
|* obere linke Ecke des Rechtecks muss relativ zur linken oberen
|* Ecke des Fensters angegeben werden; gibt den berechneten Zoom-
|* faktor zurueck
|*
\************************************************************************/

//STRIP001 long SchWindow::SetZoomRect(const Rectangle& rZoomRect)
//STRIP001 {
//STRIP001 	Size aWinSize = PixelToLogic(GetSizePixel());
//STRIP001 	DBG_ASSERT(rZoomRect.GetWidth(), "ZoomRect-Breite = 0!");
//STRIP001 	DBG_ASSERT(rZoomRect.GetHeight(), "ZoomRect-Hoehe = 0!");
//STRIP001 	long nX = aWinSize.Width()	* 100 / rZoomRect.GetWidth();
//STRIP001 	long nY = aWinSize.Height() * 100 / rZoomRect.GetHeight();
//STRIP001 	long nZoom = Min(nX, nY) * GetZoom() / 100;
//STRIP001 
//STRIP001 	aWinPos.X() = aViewOrigin.X() + rZoomRect.Left();
//STRIP001 	aWinPos.Y() = aViewOrigin.Y() + rZoomRect.Top();
//STRIP001 
//STRIP001 	if (nX < nY)
//STRIP001 	{
//STRIP001 		aWinSize.Height() = aWinSize.Height() * 100 / nX;
//STRIP001 		aWinPos.Y() += rZoomRect.GetHeight() / 2 - aWinSize.Height() / 2;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nY < nX)
//STRIP001 	{
//STRIP001 		aWinSize.Width()  = aWinSize.Width() * 100 / nY;
//STRIP001 		aWinPos.X() += rZoomRect.GetWidth() / 2 - aWinSize.Width() / 2;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SetZoomFactor(nZoom);
//STRIP001 }

/*************************************************************************
|*
|* Neuen MapMode-Origin berechnen und setzen
|*
\************************************************************************/

//STRIP001 void SchWindow::UpdateMapOrigin()
//STRIP001 {
//STRIP001 	MapMode aMap(GetMapMode());
//STRIP001 
//STRIP001 	Point aNewOrigin(-aWinPos.X() + aViewOrigin.X(),
//STRIP001 					 -aWinPos.Y() + aViewOrigin.Y());
//STRIP001 
//STRIP001 	if (aMap.GetOrigin() != aNewOrigin)
//STRIP001 	{
//STRIP001 		aMap.SetOrigin(aNewOrigin);
//STRIP001 		SetMapMode(aMap);
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* DataChanged
|*
\************************************************************************/

//STRIP001 void SchWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	// PRINTER bei allen Dokumenten weglassen, die keinen Printer benutzen.
//STRIP001 	// FONTS und FONTSUBSTITUTION weglassen, wenn keine Textausgaben
//STRIP001 	// vorhanden sind, bzw. wenn das Dokument keinen Text zulaesst.
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_PRINTER) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) ||
//STRIP001 		 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 	{
//STRIP001     	// adjust contrast mode initially
//STRIP001     	bool bUseContrast = GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001         SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 		
//STRIP001         if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 			 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 		{
//STRIP001 			// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
//STRIP001 			// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
//STRIP001 			// Resize-Handler aber auch die Groesse der ScrollBars aus
//STRIP001 			// den Settings abgefragt werden.
//STRIP001 			Resize();
//STRIP001 
//STRIP001 			// Daten neu Setzen, die aus den Systemeinstellungen bzw. aus
//STRIP001 			// den Settings uebernommen werden. Evtl. weitere Daten neu
//STRIP001 			// berechnen, da sich auch die Aufloesung hierdurch geaendert
//STRIP001 			// haben kann.
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 			 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 			  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 		{
//STRIP001 			// Virtuelle Device die auch von der Aufloesung oder von
//STRIP001 			// Systemeinstellungen abhaengen, sollten geupdatet werden.
//STRIP001 			// Ansonsten sollte zumindest bei DATACHANGED_DISPLAY
//STRIP001 			// die virtuellen Devices geupdatet werden, da es einige
//STRIP001 			// Systeme erlauben die Aufloesung und Farbtiefe waehrend
//STRIP001 			// der Laufzeit zu aendern oder eben bei Palettenaenderungen
//STRIP001 			// die virtuellen Device geupdatet werden muessen, da bei
//STRIP001 			// Ausgaben ein anderes Farbmatching stattfinden kann.
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_FONTS )
//STRIP001 		{
//STRIP001 			// Wenn das Dokument Font-AuswahlBoxen anbietet, muessen
//STRIP001 			// diese geupdatet werden. Wie dies genau aussehen muss,
//STRIP001 			// weiss ich leider auch nicht. Aber evtl. kann man das
//STRIP001 			// ja global handeln. Dies muessten wir evtl. mal
//STRIP001 			// mit PB absprechen, aber der ist derzeit leider Krank.
//STRIP001 			// Also bevor dies hier gehandelt wird, vorher mit
//STRIP001 			// PB und mir absprechen.
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 			 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) )
//STRIP001 		{
//STRIP001 			// Formatierung neu durchfuehren, da Fonts die im Dokument
//STRIP001 			// vorkommen, nicht mehr vorhanden sein muessen oder
//STRIP001 			// jetzt vorhanden sind oder durch andere ersetzt wurden
//STRIP001 			// sind.
//STRIP001 			if( pViewShell )
//STRIP001 			{
//STRIP001 				SchChartDocShell* pDocSh = pViewShell->GetDocSh();
//STRIP001 				if( pDocSh )
//STRIP001 					pDocSh->SetPrinter( pDocSh->GetPrinter() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_PRINTER )
//STRIP001 		{
//STRIP001 			// Wie hier die Behandlung aussehen soll, weiss ich leider
//STRIP001 			// selbst noch nicht. Evtl. mal einen Printer loeschen und
//STRIP001 			// schauen was gemacht werden muss. Evtl. muesste ich in
//STRIP001 			// VCL dafuer noch etwas einbauen, wenn der benutze Printer
//STRIP001 			// geloescht wird. Ansonsten wuerde ich hier evtl. die
//STRIP001 			// Formatierung neu berechnen, wenn der aktuelle Drucker
//STRIP001 			// zerstoert wurde.
//STRIP001 			if( pViewShell )
//STRIP001 			{
//STRIP001 				SchChartDocShell* pDocSh = pViewShell->GetDocSh();
//STRIP001 				if( pDocSh )
//STRIP001 					pDocSh->SetPrinter( pDocSh->GetPrinter() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Alles neu ausgeben
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }


// for quick help
//STRIP001 void SchWindow::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 	if ( rHEvt.GetMode() & HELPMODE_QUICK )
//STRIP001 	{
//STRIP001 		if( pViewShell ) {
//STRIP001 			SdrView* pView = pViewShell->GetView();
//STRIP001 			if( pView && ! pView->IsDragObj() )
//STRIP001 			{
//STRIP001 				SdrPage* pPage = pView->GetPageViewPvNum(0)->GetPage();
//STRIP001 
//STRIP001 				if( pPage )
//STRIP001 				{
//STRIP001 					// find object under cursor
//STRIP001 					Point aPointerPos = PixelToLogic( GetPointerPosPixel() );
//STRIP001 					SdrObject *pHitObj = GetHitObject( (SdrObjList*)pPage, aPointerPos );
//STRIP001 
//STRIP001 					if( pHitObj )
//STRIP001 					{	
//STRIP001 						if( Help::IsBalloonHelpEnabled())
//STRIP001                         {
//STRIP001                             String aHelpText = GetQuickHelpText( pHitObj, (ChartModel*)pPage->GetModel(), TRUE ).ConvertLineEnd();
//STRIP001                             Help::ShowBalloon( this, rHEvt.GetMousePosPixel(), pHitObj->GetBoundRect(), aHelpText );
//STRIP001                         }
//STRIP001                         else
//STRIP001                         {
//STRIP001                             String aHelpText = GetQuickHelpText( pHitObj, (ChartModel*)pPage->GetModel(), FALSE);
//STRIP001                             Help::ShowQuickHelp( this, pHitObj->GetBoundRect(), aHelpText );
//STRIP001                         }
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Window::RequestHelp( rHEvt );
//STRIP001 }


//STRIP001 SdrObject *SchWindow::GetHitObject( SdrObjList *pObjList, Point &aPos )
//STRIP001 {
//STRIP001 	USHORT nTolerance = (USHORT)PixelToLogic( Size( QUICK_HELP_TOLERANCE, 0 ) ).Width();
//STRIP001 
//STRIP001 	SdrObject *pHitObj;
//STRIP001 
//STRIP001 	// simple depth first search
//STRIP001 	if( pObjList )
//STRIP001 	{
//STRIP001 		SdrObjListIter aIterator( *pObjList, IM_FLAT, TRUE ); // iterate backward
//STRIP001 		while (aIterator.IsMore())
//STRIP001 		{
//STRIP001 			pHitObj = aIterator.Next();
//STRIP001 
//STRIP001 			if( pHitObj->IsHit( aPos, nTolerance ) )
//STRIP001 			{
//STRIP001 				SchObjectId* pId = GetObjectId( *pHitObj );
//STRIP001 				if( pHitObj->IsGroupObject() )
//STRIP001 				{
//STRIP001 					if( pId )
//STRIP001 					{
//STRIP001 						switch( pId->GetObjId() )
//STRIP001 						{
//STRIP001 							case CHOBJID_DIAGRAM_FLOOR:
//STRIP001 							case CHOBJID_DIAGRAM_WALL:
//STRIP001   							case CHOBJID_DIAGRAM_DATA:
//STRIP001 								return pHitObj;
//STRIP001 
//STRIP001 							case CHOBJID_TEXT:
//STRIP001 							case CHOBJID_LINE:
//STRIP001 							case CHOBJID_AREA:
//STRIP001 								return pObjList->GetOwnerObj();	// return parent object
//STRIP001 								
//STRIP001 							default:							// recurse with SubList
//STRIP001 								{
//STRIP001 									SdrObject *pResult = GetHitObject( pHitObj->GetSubList(), aPos );
//STRIP001 									if( pResult )
//STRIP001 										return pResult;
//STRIP001 									break;
//STRIP001 								}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else	// non-group object
//STRIP001 				{
//STRIP001 					if( pId )
//STRIP001 					{
//STRIP001 						switch( pId->GetObjId() )
//STRIP001 						{
//STRIP001 							case CHOBJID_TEXT:
//STRIP001 							case CHOBJID_LINE:
//STRIP001 							case CHOBJID_AREA:
//STRIP001 								return pObjList->GetOwnerObj();		// return parent object
//STRIP001 
//STRIP001 							default:
//STRIP001 								break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					return pHitObj;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 String SchWindow::GetQuickHelpText( SdrObject *pObj, ChartModel* pModel, BOOL bVerbose )
//STRIP001 {
//STRIP001 	SchObjectId* pId = GetObjectId( *pObj );
//STRIP001     UINT16 nId = CHOBJID_ANY;
//STRIP001 
//STRIP001 	if( pId )
//STRIP001 	{
//STRIP001         nId = pId->GetObjId();
//STRIP001         switch( nId )
//STRIP001         {
//STRIP001             case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001             case CHOBJID_DIAGRAM_ROWS:
//STRIP001             case CHOBJID_DIAGRAM_ROWSLINE:
//STRIP001             case CHOBJID_DIAGRAM_SPECIAL_GROUP:
//STRIP001             case CHOBJID_DIAGRAM_STACKEDGROUP:
//STRIP001             case CHOBJID_LEGEND_SYMBOL_ROW:
//STRIP001                 {
//STRIP001                     SchDataRow *pDataRow = GetDataRow(*pObj);
//STRIP001                     if( pDataRow )
//STRIP001                         return GetQuickHelpText( nId, pModel, bVerbose, pDataRow->GetRow() );
//STRIP001                 }
//STRIP001                 break;
//STRIP001                 
//STRIP001             case CHOBJID_DIAGRAM_DATA:
//STRIP001                 {
//STRIP001                     SchDataPoint *pDataPoint = GetDataPoint(*pObj);
//STRIP001                     if( pDataPoint )
//STRIP001                     {
//STRIP001                         return GetQuickHelpText( nId, pModel, bVerbose,
//STRIP001                                                  pDataPoint->GetRow(),
//STRIP001                                                  pDataPoint->GetCol() );
//STRIP001                     }
//STRIP001                 }
//STRIP001                 break;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return GetQuickHelpText( nId, pModel, bVerbose );
//STRIP001 }

//STRIP001 String SchWindow::GetQuickHelpText( UINT16 nObjId, ChartModel* pModel, BOOL bVerbose,
//STRIP001                                     UINT16 nSeriesIndex, UINT16 nDataPointIndex )
//STRIP001 {
//STRIP001     const sal_Unicode aQuote( '\"' );
//STRIP001     switch( nObjId )
//STRIP001     {
//STRIP001         case CHOBJID_DIAGRAM_AREA:
//STRIP001             return String(SchResId( STR_DIAGRAM_AREA ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001         case CHOBJID_DIAGRAM_ROWS:
//STRIP001         case CHOBJID_DIAGRAM_ROWSLINE:
//STRIP001         case CHOBJID_DIAGRAM_SPECIAL_GROUP:
//STRIP001         case CHOBJID_DIAGRAM_STACKEDGROUP:
//STRIP001         case CHOBJID_LEGEND_SYMBOL_ROW:
//STRIP001             {
//STRIP001                 String aResult( SchResId( STR_DIAGRAM_ROW ) );
//STRIP001                 if( pModel )
//STRIP001                 {
//STRIP001                     String aName( aQuote );
//STRIP001                     aName.Append( pModel->RowText( nSeriesIndex) );
//STRIP001                     aName.Append( aQuote );
//STRIP001                     aResult.SearchAndReplaceAscii( "$(ROW)",  aName );
//STRIP001                 }
//STRIP001                 return aResult;
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case CHOBJID_LEGEND_SYMBOL_COL:
//STRIP001             return String(SchResId( STR_LEGEND_SYMBOL_COL ));
//STRIP001 
//STRIP001         case CHOBJID_LEGEND:
//STRIP001         case CHOBJID_LEGEND_BACK:
//STRIP001             return String(SchResId( STR_LEGEND ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_DATA:
//STRIP001             {
//STRIP001                 String aText;
//STRIP001                 long nUId = ( (const SfxInt32Item&)pModel->GetDataRowAttr( nSeriesIndex ).Get( SCHATTR_AXIS ) ).GetValue();
//STRIP001                 ChartAxis *pAxis = pModel->GetAxisByUID( nUId );
//STRIP001                 long nNumf = pAxis->GetNumFormat( FALSE );
//STRIP001 
//STRIP001                 Color* pTextColor = NULL;
//STRIP001                 double fVal = pModel->GetData(nDataPointIndex, nSeriesIndex);
//STRIP001                 if( fVal == DBL_MIN )
//STRIP001                     aText = String( RTL_CONSTASCII_USTRINGPARAM( "NaN" ));
//STRIP001                 else
//STRIP001                     pModel->GetNumFormatter()->GetOutputString(
//STRIP001                         fVal, nNumf, aText, &pTextColor);
//STRIP001 
//STRIP001                 String aResult( SchResId( bVerbose? STR_BALLOONHELP_DATAPOINT: STR_QUICKHELP_DATAPOINT ) );
//STRIP001 
//STRIP001                 aResult.SearchAndReplaceAscii( "$(VALUE)", aText );
//STRIP001 
//STRIP001                 if( bVerbose )
//STRIP001                 {
//STRIP001                     String aStrQuoted( aQuote );
//STRIP001                     aStrQuoted.Append( pModel->ColText( nDataPointIndex ));
//STRIP001                     aStrQuoted.Append( aQuote );
//STRIP001                     aResult.SearchAndReplaceAll( String( RTL_CONSTASCII_USTRINGPARAM( "$(NEWLINE)" )),
//STRIP001                                                  String( RTL_CONSTASCII_USTRINGPARAM( "\n" )));
//STRIP001                     aResult.SearchAndReplaceAscii( "$(PT_STR)",  aStrQuoted );
//STRIP001                     aStrQuoted = aQuote;
//STRIP001                     aStrQuoted.Append( pModel->RowText( nSeriesIndex ));
//STRIP001                     aStrQuoted.Append( aQuote );
//STRIP001                     aResult.SearchAndReplaceAscii( "$(ROW_STR)", aStrQuoted );
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     aResult.SearchAndReplaceAscii( "$(PT_NUM)",  String::CreateFromInt32( nDataPointIndex + 1 ));
//STRIP001                     aResult.SearchAndReplaceAscii( "$(ROW_NUM)", String::CreateFromInt32( nSeriesIndex + 1 ));
//STRIP001                 }
//STRIP001 					
//STRIP001                 return aResult;
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case CHOBJID_TITLE_MAIN:
//STRIP001             return String(SchResId( STR_TITLE_MAIN ));
//STRIP001 
//STRIP001         case CHOBJID_TITLE_SUB:
//STRIP001             return String(SchResId( STR_TITLE_SUB ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_TITLE_X_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_TITLE_X_AXIS ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_TITLE_Y_AXIS ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_TITLE_Z_AXIS ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_X_AXIS:
//STRIP001         case CHOBJID_DIAGRAM_A_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_X_AXIS ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Y_AXIS:
//STRIP001         case CHOBJID_DIAGRAM_B_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_Y_AXIS ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Z_AXIS:
//STRIP001         case CHOBJID_DIAGRAM_C_AXIS:
//STRIP001             return String(SchResId( STR_DIAGRAM_Z_AXIS ));
//STRIP001 
//STRIP001             // attention: x and y grids are interchanged
//STRIP001         case CHOBJID_DIAGRAM_X_GRID_MAIN:
//STRIP001             return String(SchResId( STR_DIAGRAM_Y_GRID_MAIN ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Y_GRID_MAIN:
//STRIP001             return String(SchResId( STR_DIAGRAM_X_GRID_MAIN ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Z_GRID_MAIN:
//STRIP001             return String(SchResId( STR_DIAGRAM_Z_GRID_MAIN ));
//STRIP001 
//STRIP001             // attention: x and y grids are interchanged
//STRIP001         case CHOBJID_DIAGRAM_X_GRID_HELP:
//STRIP001             return String(SchResId( STR_DIAGRAM_Y_GRID_HELP ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Y_GRID_HELP:
//STRIP001             return String(SchResId( STR_DIAGRAM_X_GRID_HELP ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_Z_GRID_HELP:
//STRIP001             return String(SchResId( STR_DIAGRAM_Z_GRID_HELP ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_DESCR_ROW:
//STRIP001             return String(SchResId( STR_DIAGRAM_DESCR_ROW ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_DESCR_COL:
//STRIP001             return String(SchResId( STR_DIAGRAM_DESCR_COL ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_DESCR_SYMBOL:
//STRIP001             return String(SchResId( STR_LEGEND_SYMBOL_ROW ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_STOCKLINE:
//STRIP001             return String(SchResId( STR_LINE ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_WALL:
//STRIP001             return String(SchResId( STR_DIAGRAM_WALL ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_FLOOR:
//STRIP001             return String(SchResId( STR_DIAGRAM_FLOOR ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_AVERAGEVALUE:
//STRIP001             return String(SchResId( STR_AVERAGEVALUE ));
//STRIP001 				
//STRIP001         case CHOBJID_DIAGRAM_ERROR:
//STRIP001             return String(SchResId( STR_DIAGRAM_ERROR ));
//STRIP001 				
//STRIP001         case CHOBJID_DIAGRAM_REGRESSION:
//STRIP001             return String(SchResId( STR_DIAGRAM_REGRESSION ));
//STRIP001 
//STRIP001         case CHOBJID_DIAGRAM_NET:
//STRIP001             return String(SchResId( STR_NET ));
//STRIP001 
//STRIP001         case CHOBJID_ANY:
//STRIP001             // invalid entry => return empty string or 'invalid'
//STRIP001             break;
//STRIP001 
//STRIP001         default:
//STRIP001 #ifdef DBG_UTIL
//STRIP001             String aResult = String::CreateFromAscii( GetCHOBJIDName( nObjId ));
//STRIP001             aResult.Append( String::CreateFromAscii( " -> ", 4 ));
//STRIP001             aResult.Append( String::CreateFromInt32( nObjId ));
//STRIP001             return aResult;
//STRIP001 #else
//STRIP001             break;
//STRIP001 #endif
//STRIP001     }
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001     return String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "Invalid Id" ));
//STRIP001 #else
//STRIP001     return String();
//STRIP001 #endif
//STRIP001 }


// ========================================
// DropTargetHelper for drag and drop
// ========================================

//STRIP001 sal_Int8 SchWindow::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pViewShell && !pViewShell->GetDocSh()->IsReadOnly() )
//STRIP001 	{
//STRIP001 		if( pViewShell )
//STRIP001 			nRet = pViewShell->AcceptDrop( rEvt, this );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// ----------------------------------------

//STRIP001 sal_Int8 SchWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pViewShell )
//STRIP001 	{
//STRIP001 		nRet = pViewShell->ExecuteDrop( rEvt, this );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 SchViewShell * SchWindow::GetViewShell()
//STRIP001 {
//STRIP001     return pViewShell;
//STRIP001 }

// UNO stuff follows here

using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;

// ____________ get accessibility object for document root node ____________

//STRIP001 uno::Reference< XAccessible >
//STRIP001     SchWindow::CreateAccessible( void )
//STRIP001 {
//STRIP001     uno::Reference< frame::XController > xController( pViewShell->GetController() );
//STRIP001 
//STRIP001     if( xController.is() )
//STRIP001     {
//STRIP001         ChartModel* pChartModel = &( pViewShell->GetView()->GetDoc() );
//STRIP001         ::accessibility::AccessibleDocumentView * pAccDocView =
//STRIP001               new ::accessibility::AccessibleDocumentView
//STRIP001               ( this,
//STRIP001                 pChartModel,
//STRIP001                 xController,
//STRIP001                 GetAccessibleParentWindow()->GetAccessible());
//STRIP001         uno::Reference< XAccessible > aResult( pAccDocView );
//STRIP001         // late initialisation to avoid destruction problem in CTOR
//STRIP001         pAccDocView->StartUNOListening();
//STRIP001 
//STRIP001         // remember the document view as weak reference member
//STRIP001         m_xAccDocumentView = aResult;
//STRIP001         m_pAccDocumentView = pAccDocView;
//STRIP001 
//STRIP001         return aResult;
//STRIP001     }
//STRIP001 
//STRIP001     OSL_ENSURE( false, "no view shell or no controller" );
//STRIP001 
//STRIP001     return Window::CreateAccessible ();
//STRIP001 }

//STRIP001 ::accessibility::AccessibleDocumentView * SchWindow::GetAccessibleDocumentView() const
//STRIP001 {
//STRIP001     uno::Reference< XAccessible > aRef( m_xAccDocumentView );
//STRIP001     if( aRef.is())
//STRIP001     {
//STRIP001         OSL_ASSERT( m_pAccDocumentView );
//STRIP001         return m_pAccDocumentView;
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
}
