/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_filtergrouping.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:56:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SFX2_FILTERGROUPING_HXX
#include "filtergrouping.hxx"
#endif
#ifndef _SFX_FCONTNR_HXX
#include <fcontnr.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include "filedlghelper.hxx"
#endif
#ifndef _SFX_HRC
#include "sfx.hrc"
#endif
#ifndef _SFX_SFXRESID_HXX
#include "sfxresid.hxx"
#endif
#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERGROUPMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterGroupManager.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_STRINGPAIR_HPP_
#include <com/sun/star/beans/StringPair.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _UNOTOOLS_CONFIGNODE_HXX_
#include <unotools/confignode.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif

#ifndef _LIST_
#include <list>
#endif
#ifndef _VECTOR_
#include <vector>
#endif
#ifndef _MAP_
#include <map>
#endif
#ifndef _ALGORITHM_
#include <algorithm>
#endif
#ifndef _SFX_OBJFAC_HXX
#include <docfac.hxx>
#endif

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002
#endif
namespace binfilter {

//........................................................................
//STRIP001 namespace sfx2
//STRIP001 {
//STRIP001 //........................................................................
//STRIP001
//STRIP001 //#define DISABLE_GROUPING_AND_CLASSIFYING
//STRIP001 	// not using the functionallity herein, yet
//STRIP001
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 	using namespace ::com::sun::star::ui::dialogs;
//STRIP001 	using namespace ::com::sun::star::lang;
//STRIP001 	using namespace ::com::sun::star::beans;
//STRIP001 	using namespace ::utl;
//STRIP001
//STRIP001 	//====================================================================
//STRIP001 	/**
//STRIP001
//STRIP001 	Some general words about what's going on here ....
//STRIP001
//STRIP001 	<p>In our file open dialog, usually we display every filter we know. That's how it was before: every filter
//STRIP001 	lead to an own line in the filter list box, e.g. "StarWriter 5.0 Dokument" or "Microsoft Word 97".</p>
//STRIP001
//STRIP001 	<p>But then the PM came. And everything changed ....</p>
//STRIP001
//STRIP001 	<p>A basic idea are groups: Why simply listing all the single filters? Couldn't we draw nice separators
//STRIP001 	between the filters which logically belong together? I.e. all the filters which open a document in StarWriter:
//STRIP001 	couldn't we separate them from all the filters which open the document in StarCalc?<br/>
//STRIP001 	So spoke the PM, and engineering obeyed.</p>
//STRIP001
//STRIP001 	<p>So we have groups. They're just a visual aspect: All the filters of a group are presented together, separated
//STRIP001 	by a line from other groups.</p>
//STRIP001
//STRIP001 	<p>Let's be honest: How the concrete implementation of the file picker service separates the different groups
//STRIP001 	is a matter of this implementation. We only do this grouping and suggest it to the FilePicker service ...</p>
//STRIP001
//STRIP001 	<p>Now for the second concept:<br/>
//STRIP001 	Thinking about it (and that's what the PM did), both "StarWriter 5.0 Dokument" and "Microsoft Word 97"
//STRIP001 	describe a text document. It's a text. It's of no interest for the user that one of the texts was saved in
//STRIP001 	MS' format, and one in our own format.<br/>
//STRIP001 	So in a first step, we want to have a filter entry "Text documents". This would cover both above-mentioned
//STRIP001 	filters, as well as any other filters for documents which are texts.</p>
//STRIP001
//STRIP001 	<p>Such an entry as "Text documents" is - within the scope of this file - called "class" or "filter class".</p>
//STRIP001
//STRIP001 	<p>In the file-open-dialog, such a class looks like an ordinary filter: it's simply a name in the filter
//STRIP001 	listbox. Selecting means that all the files matching one of the "sub-filters" are displayed (in the example above,
//STRIP001 	this would be "*.sdw", "*.doc" and so on).</p>
//STRIP001
//STRIP001 	<p>Now there are two types of filter classes: global ones and local ones. "Text documents" is a global class. As
//STRIP001 	well as "Spreadsheets". Or "Web pages".<br/>
//STRIP001 	Let's have a look at a local class: The filters "MS Word 95" and "MS WinWord 6.0" together form the class
//STRIP001 	"Microsoft Word 6.0 / 95" (don't ask for the reasons. At least not me. Ask the PM). There are a lot of such
//STRIP001 	local classes ...</p>
//STRIP001
//STRIP001 	<p>The difference between global and local classes is as follows: Global classes are presented in an own group.
//STRIP001 	There is one dedicated group at the top of the list, containing all the global groups - no local groups and no
//STRIP001 	single filters.</p>
//STRIP001
//STRIP001 	<p>Ehm - it was a lie. Not really at the top. Before this group, there is this single "All files" entry. It forms
//STRIP001 	it's own group. But this is uninteresting here.</p>
//STRIP001
//STRIP001 	<p>Local classes must consist of filters which - without the classification - would all belong to the same group.
//STRIP001 	Then, they're combined to one entry (in the example above: "Microsoft Word 6.0 / 95"), and this entry is inserted
//STRIP001 	into the file picker filter list, instead of the single filters which form the class.</p>
//STRIP001
//STRIP001 	<p>This is an interesting difference between local and global classes: Filters which are part of a global class
//STRIP001 	are listed in there own group, too. Filters in local classes aren't listed a second time - neither directly (as
//STRIP001 	the filter itself) nor indirectly (as part of another local group).</p>
//STRIP001
//STRIP001 	<p>The only exception are filters which are part of a global class <em>and</em> a local class. This is allowed.
//STRIP001 	Beeing cotained in two local classes isn't.</p>
//STRIP001
//STRIP001 	<p>So that's all what you need to know: Understand the concept of "filter classes" (a filter class combines
//STRIP001 	different filters and acts as if it's a filter itself) and the concept of groups (a group just describes a
//STRIP001 	logical correlation of filters and usually is represented to the user by drawing group separators in the filter
//STRIP001 	list).</p>
//STRIP001
//STRIP001 	<p>If you got it, go try understanding this file :).</p>
//STRIP001
//STRIP001 	*/
//STRIP001
//STRIP001
//STRIP001 	//====================================================================
//STRIP001
//STRIP001 	typedef StringPair							FilterDescriptor;	// a single filter or a filter class (display name and filter mask)
//STRIP001 	typedef ::std::list< FilterDescriptor > 	FilterGroup;		// a list of single filter entries
//STRIP001 	typedef ::std::list< FilterGroup >			GroupedFilterList;	// a list of all filters, already grouped
//STRIP001
//STRIP001 	/// the logical name of a filter
//STRIP001 	typedef ::rtl::OUString 					FilterName;
//STRIP001
//STRIP001 	// a struct which holds references from a logical filter name to a filter group entry
//STRIP001 	// used for quick lookup of classes (means class entries - entries representing a class)
//STRIP001 	// which a given filter may belong to
//STRIP001 	typedef ::std::map< ::rtl::OUString, FilterGroup::iterator >	FilterGroupEntryReferrer;
//STRIP001
//STRIP001 	/// a descriptor for a filter class (which in the final dialog is represented by one filter entry)
//STRIP001 	typedef struct _tagFilterClass
//STRIP001 	{
//STRIP001 		::rtl::OUString 			sDisplayName;		// the display name
//STRIP001 		Sequence< FilterName >		aSubFilters;		// the (logical) names of the filter which belong to the class
//STRIP001 	} FilterClass;
//STRIP001
//STRIP001 	typedef ::std::list< FilterClass >									FilterClassList;
//STRIP001 	typedef ::std::map< ::rtl::OUString, FilterClassList::iterator >	FilterClassReferrer;
//STRIP001
//STRIP001 	typedef ::std::vector< ::rtl::OUString >							StringArray;
//STRIP001
//STRIP001 // =======================================================================
//STRIP001 // = reading of configuration data
//STRIP001 // =======================================================================
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_ReadFilterClass( const OConfigurationNode& _rClassesNode, const ::rtl::OUString& _rLogicalClassName,
//STRIP001 		FilterClass& /* [out] */ _rClass )
//STRIP001 	{
//STRIP001 		static const ::rtl::OUString sDisplaNameNodeName( RTL_CONSTASCII_USTRINGPARAM( "DisplayName" ) );
//STRIP001 		static const ::rtl::OUString sSubFiltersNodeName( RTL_CONSTASCII_USTRINGPARAM( "Filters" ) );
//STRIP001
//STRIP001 			// the description node for the current class
//STRIP001 		OConfigurationNode aClassDesc = _rClassesNode.openNode( _rLogicalClassName );
//STRIP001
//STRIP001 		// the values
//STRIP001 		aClassDesc.getNodeValue( sDisplaNameNodeName ) >>= _rClass.sDisplayName;
//STRIP001 		aClassDesc.getNodeValue( sSubFiltersNodeName ) >>= _rClass.aSubFilters;
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct CreateEmptyClassRememberPos : public ::std::unary_function< FilterName, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		FilterClassList&		m_rClassList;
//STRIP001 		FilterClassReferrer&	m_rClassesReferrer;
//STRIP001
//STRIP001 	public:
//STRIP001 		CreateEmptyClassRememberPos( FilterClassList& _rClassList, FilterClassReferrer& _rClassesReferrer )
//STRIP001 			:m_rClassList		( _rClassList )
//STRIP001 			,m_rClassesReferrer ( _rClassesReferrer )
//STRIP001 		{
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single class name
//STRIP001 		void operator() ( const FilterName& _rLogicalFilterName )
//STRIP001 		{
//STRIP001 			// insert a new (empty) class
//STRIP001 			m_rClassList.push_back( FilterClass() );
//STRIP001 			// get the position of this new entry
//STRIP001 			FilterClassList::iterator aInsertPos = m_rClassList.end();
//STRIP001 			--aInsertPos;
//STRIP001 			// remember this position
//STRIP001 			m_rClassesReferrer.insert( FilterClassReferrer::value_type( _rLogicalFilterName, aInsertPos ) );
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct ReadGlobalFilter : public ::std::unary_function< FilterName, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		OConfigurationNode		m_aClassesNode;
//STRIP001 		FilterClassReferrer&	m_aClassReferrer;
//STRIP001
//STRIP001 	public:
//STRIP001 		ReadGlobalFilter( const OConfigurationNode& _rClassesNode, FilterClassReferrer& _rClassesReferrer )
//STRIP001 			:m_aClassesNode 	( _rClassesNode )
//STRIP001 			,m_aClassReferrer	( _rClassesReferrer )
//STRIP001 		{
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single logical name
//STRIP001 		void operator() ( const FilterName& _rName )
//STRIP001 		{
//STRIP001 			FilterClassReferrer::iterator aClassRef = m_aClassReferrer.find( _rName );
//STRIP001 			if ( m_aClassReferrer.end() == aClassRef )
//STRIP001 			{
//STRIP001 				// we do not know this global class
//STRIP001 				DBG_ERROR( "ReadGlobalFilter::operator(): unknown filter name!" );
//STRIP001 				// TODO: perhaps we should be more tolerant - at the moment, the filter is dropped
//STRIP001 				// We could silently push_back it to the container ....
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// read the data of this class into the node referred to by aClassRef
//STRIP001 				lcl_ReadFilterClass( m_aClassesNode, _rName, *aClassRef->second );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_ReadGlobalFilters( const OConfigurationNode& _rFilterClassification, FilterClassList& _rGlobalClasses, StringArray& _rGlobalClassNames )
//STRIP001 	{
//STRIP001 		_rGlobalClasses.clear();
//STRIP001 		_rGlobalClassNames.clear();
//STRIP001
//STRIP001 		// get the list describing the order of all global classes
//STRIP001 		Sequence< ::rtl::OUString > aGlobalClasses;
//STRIP001 		_rFilterClassification.getNodeValue( DEFINE_CONST_OUSTRING( "GlobalFilters/Order" ) ) >>= aGlobalClasses;
//STRIP001
//STRIP001 		const ::rtl::OUString* pNames = aGlobalClasses.getConstArray();
//STRIP001 		const ::rtl::OUString* pNamesEnd = pNames + aGlobalClasses.getLength();
//STRIP001
//STRIP001 		// copy the logical names
//STRIP001 		_rGlobalClassNames.resize( aGlobalClasses.getLength() );
//STRIP001 		::std::copy( pNames, pNamesEnd, _rGlobalClassNames.begin() );
//STRIP001
//STRIP001 		// Global classes are presented in an own group, so their order matters (while the order of the
//STRIP001 		// "local classes" doesn't).
//STRIP001 		// That's why we can't simply add the global classes to _rGlobalClasses using the order in which they
//STRIP001 		// are returned from the configuration - it is completely undefined, and we need a _defined_ order.
//STRIP001 		FilterClassReferrer aClassReferrer;
//STRIP001 		::std::for_each(
//STRIP001 			pNames,
//STRIP001 			pNamesEnd,
//STRIP001 			CreateEmptyClassRememberPos( _rGlobalClasses, aClassReferrer )
//STRIP001 		);
//STRIP001 			// now _rGlobalClasses contains a dummy entry for each global class,
//STRIP001 			// while aClassReferrer maps from the logical name of the class to the position within _rGlobalClasses where
//STRIP001 			// it's dummy entry resides
//STRIP001
//STRIP001 		// go for all the single class entries
//STRIP001 		OConfigurationNode aFilterClassesNode =
//STRIP001 			_rFilterClassification.openNode( DEFINE_CONST_OUSTRING( "GlobalFilters/Classes" ) );
//STRIP001 		Sequence< ::rtl::OUString > aFilterClasses = aFilterClassesNode.getNodeNames();
//STRIP001 		::std::for_each(
//STRIP001 			aFilterClasses.getConstArray(),
//STRIP001 			aFilterClasses.getConstArray() + aFilterClasses.getLength(),
//STRIP001 			ReadGlobalFilter( aFilterClassesNode, aClassReferrer )
//STRIP001 		);
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct ReadLocalFilter : public ::std::unary_function< FilterName, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		OConfigurationNode		m_aClassesNode;
//STRIP001 		FilterClassList&		m_rClasses;
//STRIP001
//STRIP001 	public:
//STRIP001 		ReadLocalFilter( const OConfigurationNode& _rClassesNode, FilterClassList& _rClasses )
//STRIP001 			:m_aClassesNode ( _rClassesNode )
//STRIP001 			,m_rClasses 	( _rClasses )
//STRIP001 		{
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single logical name
//STRIP001 		void operator() ( const FilterName& _rName )
//STRIP001 		{
//STRIP001 			// read the data for this class
//STRIP001 			FilterClass aClass;
//STRIP001 			lcl_ReadFilterClass( m_aClassesNode, _rName, aClass );
//STRIP001
//STRIP001 			// insert the class descriptor
//STRIP001 			m_rClasses.push_back( aClass );
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_ReadLocalFilters( const OConfigurationNode& _rFilterClassification, FilterClassList& _rLocalClasses )
//STRIP001 	{
//STRIP001 		_rLocalClasses.clear();
//STRIP001
//STRIP001 		// the node for the local classes
//STRIP001 		OConfigurationNode aFilterClassesNode =
//STRIP001 			_rFilterClassification.openNode( DEFINE_CONST_OUSTRING( "LocalFilters/Classes" ) );
//STRIP001 		Sequence< ::rtl::OUString > aFilterClasses = aFilterClassesNode.getNodeNames();
//STRIP001
//STRIP001 		::std::for_each(
//STRIP001 			aFilterClasses.getConstArray(),
//STRIP001 			aFilterClasses.getConstArray() + aFilterClasses.getLength(),
//STRIP001 			ReadLocalFilter( aFilterClassesNode, _rLocalClasses )
//STRIP001 		);
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_ReadClassification( FilterClassList& _rGlobalClasses, StringArray& _rGlobalClassNames, FilterClassList& _rLocalClasses )
//STRIP001 	{
//STRIP001 		// open our config node
//STRIP001 		OConfigurationTreeRoot aFilterClassification = OConfigurationTreeRoot::createWithServiceFactory(
//STRIP001 			::legacy_binfilters::getLegacyProcessServiceFactory(),
//STRIP001 			DEFINE_CONST_OUSTRING( "org.openoffice.Office.UI/FilterClassification" ),
//STRIP001 			-1,
//STRIP001 			OConfigurationTreeRoot::CM_READONLY
//STRIP001 		);
//STRIP001
//STRIP001 		// go for the global classes
//STRIP001 		lcl_ReadGlobalFilters( aFilterClassification, _rGlobalClasses, _rGlobalClassNames );
//STRIP001
//STRIP001 		// fo for the local classes
//STRIP001 		lcl_ReadLocalFilters( aFilterClassification, _rLocalClasses );
//STRIP001
//STRIP001 	}
//STRIP001
//STRIP001 // =======================================================================
//STRIP001 // = grouping and classifying
//STRIP001 // =======================================================================
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	// a struct which adds helps remembering a reference to a class entry
//STRIP001 	struct ReferToFilterEntry : public ::std::unary_function< FilterName, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		FilterGroupEntryReferrer&	m_rEntryReferrer;
//STRIP001 		FilterGroup::iterator		m_aClassPos;
//STRIP001
//STRIP001 	public:
//STRIP001 		ReferToFilterEntry( FilterGroupEntryReferrer& _rEntryReferrer, const FilterGroup::iterator& _rClassPos )
//STRIP001 			:m_rEntryReferrer( _rEntryReferrer )
//STRIP001 			,m_aClassPos( _rClassPos )
//STRIP001 		{
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single filter name
//STRIP001 		void operator() ( const FilterName& _rName )
//STRIP001 		{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 			::std::pair< FilterGroupEntryReferrer::iterator, bool > aInsertRes =
//STRIP001 #endif
//STRIP001 			m_rEntryReferrer.insert( FilterGroupEntryReferrer::value_type( _rName, m_aClassPos ) );
//STRIP001 			DBG_ASSERT( aInsertRes.second, "ReferToFilterEntry::operator(): already have an element for this name!" );
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct FillClassGroup : public ::std::unary_function< FilterClass, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		FilterGroup&				m_rClassGroup;
//STRIP001 		FilterGroupEntryReferrer&	m_rClassReferrer;
//STRIP001
//STRIP001 	public:
//STRIP001 		FillClassGroup( FilterGroup& _rClassGroup, FilterGroupEntryReferrer& _rClassReferrer )
//STRIP001 			:m_rClassGroup		( _rClassGroup )
//STRIP001 			,m_rClassReferrer	( _rClassReferrer )
//STRIP001 		{
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single class
//STRIP001 		void operator() ( const FilterClass& _rClass )
//STRIP001 		{
//STRIP001 			// create an empty filter descriptor for the class
//STRIP001 			FilterDescriptor aClassEntry;
//STRIP001 			// set it's name (which is all we know by now)
//STRIP001 			aClassEntry.First = _rClass.sDisplayName;
//STRIP001
//STRIP001 			// add it to the group
//STRIP001 			m_rClassGroup.push_back( aClassEntry );
//STRIP001 			// the position of the newly added class
//STRIP001 			FilterGroup::iterator aClassEntryPos = m_rClassGroup.end();
//STRIP001 			--aClassEntryPos;
//STRIP001
//STRIP001 			// and for all the sub filters of the class, remember the class
//STRIP001 			// (respectively the position of the class it the group)
//STRIP001 			::std::for_each(
//STRIP001 				_rClass.aSubFilters.getConstArray(),
//STRIP001 				_rClass.aSubFilters.getConstArray() + _rClass.aSubFilters.getLength(),
//STRIP001 				ReferToFilterEntry( m_rClassReferrer, aClassEntryPos )
//STRIP001 			);
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	static const sal_Unicode s_cWildcardSeparator( ';' );
//STRIP001
//STRIP001 	const ::rtl::OUString& getSeparatorString()
//STRIP001 	{
//STRIP001 		static ::rtl::OUString s_sSeparatorString( &s_cWildcardSeparator, 1 );
//STRIP001 		return s_sSeparatorString;
//STRIP001 	}
//STRIP001
//STRIP001 	struct CheckAppendSingleWildcard : public ::std::unary_function< ::rtl::OUString, void >
//STRIP001 	{
//STRIP001 		::rtl::OUString& _rToBeExtended;
//STRIP001
//STRIP001 		CheckAppendSingleWildcard( ::rtl::OUString& _rBase ) : _rToBeExtended( _rBase ) { }
//STRIP001
//STRIP001 		void operator() ( const ::rtl::OUString& _rWC )
//STRIP001 		{
//STRIP001 			// check for double wildcards
//STRIP001 			sal_Int32 nExistentPos = _rToBeExtended.indexOf( _rWC );
//STRIP001 			if	( -1 < nExistentPos )
//STRIP001 			{	// found this wildcard (already part of _rToBeExtended)
//STRIP001 				const sal_Unicode* pBuffer = _rToBeExtended.getStr();
//STRIP001 				if	(	( 0 == nExistentPos )
//STRIP001 					||	( s_cWildcardSeparator == pBuffer[ nExistentPos - 1 ] )
//STRIP001 					)
//STRIP001 				{	// the wildcard really starts at this position (it starts at pos 0 or the previous character is a separator
//STRIP001 					sal_Int32 nExistentWCEnd = nExistentPos + _rWC.getLength();
//STRIP001 					if	(	( _rToBeExtended.getLength() == nExistentWCEnd )
//STRIP001 						||	( s_cWildcardSeparator == pBuffer[ nExistentWCEnd ] )
//STRIP001 						)
//STRIP001 					{	// it's really the complete wildcard we found
//STRIP001 						// (not something like _rWC beeing "*.t" and _rToBeExtended containing "*.txt")
//STRIP001 						// -> outta here
//STRIP001 						return;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001
//STRIP001 			if ( _rToBeExtended.getLength() )
//STRIP001 				_rToBeExtended += getSeparatorString();
//STRIP001 			_rToBeExtended += _rWC;
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	// a helper struct which adds a fixed (Sfx-)filter to a filter group entry given by iterator
//STRIP001 	struct AppendWildcardToDescriptor : public ::std::unary_function< FilterGroupEntryReferrer::value_type, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		::std::vector< ::rtl::OUString > aWildCards;
//STRIP001
//STRIP001 	public:
//STRIP001 		AppendWildcardToDescriptor( const String& _rWildCard );
//STRIP001
//STRIP001 		// operate on a single class entry
//STRIP001 		void operator() ( const FilterGroupEntryReferrer::value_type& _rClassReference )
//STRIP001 		{
//STRIP001 			// simply add our wildcards
//STRIP001 			::std::for_each(
//STRIP001 				aWildCards.begin(),
//STRIP001 				aWildCards.end(),
//STRIP001 				CheckAppendSingleWildcard( _rClassReference.second->Second )
//STRIP001 			);
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	AppendWildcardToDescriptor::AppendWildcardToDescriptor( const String& _rWildCard )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( _rWildCard.Len(),
//STRIP001 			"AppendWildcardToDescriptor::AppendWildcardToDescriptor: invalid wildcard!" );
//STRIP001 		DBG_ASSERT( _rWildCard.GetBuffer()[0] != s_cWildcardSeparator,
//STRIP001 			"AppendWildcardToDescriptor::AppendWildcardToDescriptor: wildcard already separated!" );
//STRIP001
//STRIP001 		aWildCards.reserve( _rWildCard.GetTokenCount( s_cWildcardSeparator ) );
//STRIP001
//STRIP001 		const sal_Unicode* pTokenLoop = _rWildCard.GetBuffer();
//STRIP001 		const sal_Unicode* pTokenLoopEnd = pTokenLoop + _rWildCard.Len();
//STRIP001 		const sal_Unicode* pTokenStart = pTokenLoop;
//STRIP001 		for ( ; pTokenLoop != pTokenLoopEnd; ++pTokenLoop )
//STRIP001 		{
//STRIP001 			if ( ( s_cWildcardSeparator == *pTokenLoop ) && ( pTokenLoop > pTokenStart ) )
//STRIP001 			{	// found a new token separator (and a non-empty token)
//STRIP001 				aWildCards.push_back( ::rtl::OUString( pTokenStart, pTokenLoop - pTokenStart ) );
//STRIP001
//STRIP001 				// search the start of the next token
//STRIP001 				while ( ( pTokenStart != pTokenLoopEnd ) && ( *pTokenStart != s_cWildcardSeparator ) )
//STRIP001 					++pTokenStart;
//STRIP001
//STRIP001 				if ( pTokenStart == pTokenLoopEnd )
//STRIP001 					// reached the end
//STRIP001 					break;
//STRIP001
//STRIP001 				++pTokenStart;
//STRIP001 				pTokenLoop = pTokenStart;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( pTokenLoop > pTokenStart )
//STRIP001 			// the last one ....
//STRIP001 			aWildCards.push_back( ::rtl::OUString( pTokenStart, pTokenLoop - pTokenStart ) );
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_InitGlobalClasses( GroupedFilterList& _rAllFilters, const FilterClassList& _rGlobalClasses, FilterGroupEntryReferrer& _rGlobalClassesRef )
//STRIP001 	{
//STRIP001 		// we need an extra group in our "all filters" container
//STRIP001 		_rAllFilters.push_front( FilterGroup() );
//STRIP001 		FilterGroup& rGlobalFilters = _rAllFilters.front();
//STRIP001 			// it's important to work on the reference: we want to access the members of this filter group
//STRIP001 			// by an iterator (FilterGroup::const_iterator)
//STRIP001 		// the referrer for the global classes
//STRIP001
//STRIP001 		// initialize the group
//STRIP001 		::std::for_each(
//STRIP001 			_rGlobalClasses.begin(),
//STRIP001 			_rGlobalClasses.end(),
//STRIP001 			FillClassGroup( rGlobalFilters, _rGlobalClassesRef )
//STRIP001 		);
//STRIP001 			// now we have:
//STRIP001 			// in rGlobalFilters: a list of FilterDescriptor's, where each's discriptor's display name is set to the name of a class
//STRIP001 			// in aGlobalClassesRef: a mapping from logical filter names to positions within rGlobalFilters
//STRIP001 			//	this way, if we encounter an arbitrary filter, we can easily (and efficient) check if it belongs to a global class
//STRIP001 			//	and modify the descriptor for this class accordingly
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	typedef ::std::vector< ::std::pair< FilterGroupEntryReferrer::data_type, FilterGroup::iterator > >
//STRIP001 			MapGroupEntry2GroupEntry;
//STRIP001 			// this is not really a map - it's just called this way because it is used as a map
//STRIP001
//STRIP001 	struct FindGroupEntry : public ::std::unary_function< MapGroupEntry2GroupEntry::value_type, sal_Bool >
//STRIP001 	{
//STRIP001 		FilterGroupEntryReferrer::data_type aLookingFor;
//STRIP001 		FindGroupEntry( FilterGroupEntryReferrer::data_type _rLookingFor ) : aLookingFor( _rLookingFor ) { }
//STRIP001
//STRIP001 		sal_Bool operator() ( const MapGroupEntry2GroupEntry::value_type& _rMapEntry )
//STRIP001 		{
//STRIP001 			return _rMapEntry.first == aLookingFor ? sal_True : sal_False;
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	struct CopyGroupEntryContent : public ::std::unary_function< MapGroupEntry2GroupEntry::value_type, void >
//STRIP001 	{
//STRIP001 		void operator() ( const MapGroupEntry2GroupEntry::value_type& _rMapEntry )
//STRIP001 		{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 			FilterDescriptor aHaveALook = *_rMapEntry.first;
//STRIP001 #endif
//STRIP001 			*_rMapEntry.second = *_rMapEntry.first;
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct CopyNonEmptyFilter : public ::std::unary_function< FilterDescriptor, void >
//STRIP001 	{
//STRIP001 		FilterGroup& rTarget;
//STRIP001 		CopyNonEmptyFilter( FilterGroup& _rTarget ) :rTarget( _rTarget ) { }
//STRIP001
//STRIP001 		void operator() ( const FilterDescriptor& _rFilter )
//STRIP001 		{
//STRIP001 			if ( _rFilter.Second.getLength() )
//STRIP001 				rTarget.push_back( _rFilter );
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_GroupAndClassify( SfxFilterMatcherIter& _rFilterMatcher, GroupedFilterList& _rAllFilters )
//STRIP001 	{
//STRIP001 		_rAllFilters.clear();
//STRIP001
//STRIP001 		// read the classification of filters
//STRIP001 		FilterClassList aGlobalClasses, aLocalClasses;
//STRIP001 		StringArray aGlobalClassNames;
//STRIP001 		lcl_ReadClassification( aGlobalClasses, aGlobalClassNames, aLocalClasses );
//STRIP001
//STRIP001 		// for the global filter classes
//STRIP001 		FilterGroupEntryReferrer aGlobalClassesRef;
//STRIP001 		lcl_InitGlobalClasses( _rAllFilters, aGlobalClasses, aGlobalClassesRef );
//STRIP001
//STRIP001 		// insert as much placeholders (FilterGroup's) into _rAllFilter for groups as we have global classes
//STRIP001 		// (this assumes that both numbers are the same, which, speaking strictly, must not hold - but it does, as we know ...)
//STRIP001 		sal_Int32 nGlobalClasses = aGlobalClasses.size();
//STRIP001 		while ( nGlobalClasses-- )
//STRIP001 			_rAllFilters.push_back( );
//STRIP001
//STRIP001 		// for the local classes:
//STRIP001 		// if n filters belong to a local class, they do not appear in their respective group explicitly, instead
//STRIP001 		// and entry for the class is added to the group and the extensions of the filters are collected under
//STRIP001 		// this entry
//STRIP001 		FilterGroupEntryReferrer aLocalClassesRef;
//STRIP001 		FilterGroup aCollectedLocals;
//STRIP001 		::std::for_each(
//STRIP001 			aLocalClasses.begin(),
//STRIP001 			aLocalClasses.end(),
//STRIP001 			FillClassGroup( aCollectedLocals, aLocalClassesRef )
//STRIP001 		);
//STRIP001 		// to map from the position within aCollectedLocals to positions within the real groups
//STRIP001 		// (where they finally belong to)
//STRIP001 		MapGroupEntry2GroupEntry	aLocalFinalPositions;
//STRIP001
//STRIP001 		// now add the filters
//STRIP001 		// the group which we currently work with
//STRIP001 		GroupedFilterList::iterator aCurrentGroup = _rAllFilters.end(); // no current group
//STRIP001 		// the filter container of the current group - if this changes between two filters, a new group is reached
//STRIP001 		const SfxFilterContainer*	pCurrentGroupsContainer = NULL;
//STRIP001
//STRIP001 		String sFilterWildcard;
//STRIP001 		::rtl::OUString sFilterName;
//STRIP001 		// loop through all the filters
//STRIP001 		for ( const SfxFilter* pFilter = _rFilterMatcher.First(); pFilter; pFilter = _rFilterMatcher.Next() )
//STRIP001 		{
//STRIP001             sFilterName = pFilter->GetFilterName();
//STRIP001 			sFilterWildcard = pFilter->GetWildcard().GetWildCard();
//STRIP001 			AppendWildcardToDescriptor aExtendWildcard( sFilterWildcard );
//STRIP001
//STRIP001 			DBG_ASSERT( sFilterWildcard.Len(), "sfx2::lcl_GroupAndClassify: invalid wildcard of this filter!" );
//STRIP001
//STRIP001 			// check for a change in the group
//STRIP001 			const SfxFilterContainer* pContainer = pFilter->GetFilterContainer();
//STRIP001 			if ( pContainer != pCurrentGroupsContainer )
//STRIP001 			{	// we reached a new group
//STRIP001
//STRIP001 				// retrieve the document service name of the new group
//STRIP001 				const SfxFactoryFilterContainer* pFacFilterContainer =
//STRIP001 					static_cast< const SfxFactoryFilterContainer* >( pContainer );
//STRIP001 					// an SfxFilterContainer is always an SfxFactoryFilterContainer - according to mba@openoffice.org
//STRIP001 				::rtl::OUString sDocServName = pFacFilterContainer->GetFactory().GetDocumentServiceName();
//STRIP001
//STRIP001 				// look for the place in _rAllFilters where this ne group belongs - this is determined
//STRIP001 				// by the order of classes in aGlobalClassNames
//STRIP001 				GroupedFilterList::iterator aGroupPos = _rAllFilters.begin();
//STRIP001 				DBG_ASSERT( aGroupPos != _rAllFilters.end(),
//STRIP001 					"sfx2::lcl_GroupAndClassify: invalid all-filters array here!" );
//STRIP001 					// the loop below will work on invalid objects else ...
//STRIP001 				++aGroupPos;
//STRIP001 				const ::rtl::OUString* pGlobalClassNames = aGlobalClassNames.begin();
//STRIP001 				while	(	( aGroupPos != _rAllFilters.end() )
//STRIP001 						// #100545# ++pGlobalClassNames may exceed aGlobalClassNames.end()
//STRIP001 						&&  ( pGlobalClassNames != aGlobalClassNames.end() )
//STRIP001 						&&	( *pGlobalClassNames != sDocServName )
//STRIP001 						)
//STRIP001 				{
//STRIP001 					++pGlobalClassNames;
//STRIP001 					++aGroupPos;
//STRIP001 				}
//STRIP001 				if ( aGroupPos != _rAllFilters.end() )
//STRIP001 					// we found a global class name which matchies the doc service name -> fill the filters of this
//STRIP001 					// group in the respective prepared group
//STRIP001 					aCurrentGroup = aGroupPos;
//STRIP001 				else
//STRIP001 					// insert a new entry in our overall-list
//STRIP001 					aCurrentGroup = _rAllFilters.insert( _rAllFilters.end() );
//STRIP001
//STRIP001 				// remember the container to properly detect the next group
//STRIP001 				pCurrentGroupsContainer = pContainer;
//STRIP001
//STRIP001 			}
//STRIP001
//STRIP001 			DBG_ASSERT( aCurrentGroup != _rAllFilters.end(), "sfx2::lcl_GroupAndClassify: invalid current group!" );
//STRIP001
//STRIP001 			// check if the filter is part of a global group
//STRIP001 			::std::pair< FilterGroupEntryReferrer::iterator, FilterGroupEntryReferrer::iterator >
//STRIP001 				aBelongsTo = aGlobalClassesRef.equal_range( sFilterName );
//STRIP001 			// add the filter to the entries for these classes
//STRIP001 			// (if they exist - if not, the range is empty and the for_each is a no-op)
//STRIP001 			::std::for_each(
//STRIP001 				aBelongsTo.first,
//STRIP001 				aBelongsTo.second,
//STRIP001 				aExtendWildcard
//STRIP001 			);
//STRIP001
//STRIP001 			// add the filter to it's group
//STRIP001
//STRIP001 			// for this, check if the filter is part of a local filter
//STRIP001 			FilterGroupEntryReferrer::iterator aBelongsToLocal = aLocalClassesRef.find( sFilterName );
//STRIP001 			if ( aLocalClassesRef.end() != aBelongsToLocal )
//STRIP001 			{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 				const ::rtl::OUString& rLocalClassDisplayName = aBelongsToLocal->second->First;
//STRIP001 				const ::rtl::OUString& rLocalClassExtension = aBelongsToLocal->second->Second;
//STRIP001 #endif
//STRIP001 				// okay, there is a local class which the filter belongs to
//STRIP001 				// -> append the wildcard
//STRIP001 				aExtendWildcard( *aBelongsToLocal );
//STRIP001
//STRIP001 				MapGroupEntry2GroupEntry::iterator aThisGroupFinalPos =
//STRIP001 					::std::find_if( aLocalFinalPositions.begin(), aLocalFinalPositions.end(), FindGroupEntry( aBelongsToLocal->second ) );
//STRIP001
//STRIP001 				if ( aLocalFinalPositions.end() == aThisGroupFinalPos )
//STRIP001 				{	// the position within aCollectedLocals has not been mapped to a final position
//STRIP001 					// within the "real" group (aCollectedLocals is only temporary)
//STRIP001 					// -> do this now (as we just encountered the first filter belonging to this local class
//STRIP001 					// add a new entry which is the "real" group entry
//STRIP001 					aCurrentGroup->push_back( FilterDescriptor( aBelongsToLocal->second->First, String() ) );
//STRIP001 					// the position where we inserted the entry
//STRIP001 					FilterGroup::iterator aInsertPos = aCurrentGroup->end();
//STRIP001 					--aInsertPos;
//STRIP001 					// remember this pos
//STRIP001 					aLocalFinalPositions.push_back( MapGroupEntry2GroupEntry::value_type( aBelongsToLocal->second, aInsertPos ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aCurrentGroup->push_back( FilterDescriptor( pFilter->GetUIName(), sFilterWildcard ) );
//STRIP001 		}
//STRIP001
//STRIP001 		// now just complete the infos for the local groups:
//STRIP001 		// During the above loop, they have been collected in aCollectedLocals, but this is only temporary
//STRIP001 		// They have to be copied into their final positions (which are stored in aLocalFinalPositions)
//STRIP001 		::std::for_each(
//STRIP001 			aLocalFinalPositions.begin(),
//STRIP001 			aLocalFinalPositions.end(),
//STRIP001 			CopyGroupEntryContent()
//STRIP001 		);
//STRIP001
//STRIP001 		// and remove local groups which do not apply - e.g. have no entries due to the limited content of the
//STRIP001 		// current SfxFilterMatcherIter
//STRIP001
//STRIP001 		FilterGroup& rGlobalFilters = _rAllFilters.front();
//STRIP001 		FilterGroup aNonEmptyGlobalFilters;
//STRIP001 		::std::for_each(
//STRIP001 			rGlobalFilters.begin(),
//STRIP001 			rGlobalFilters.end(),
//STRIP001 			CopyNonEmptyFilter( aNonEmptyGlobalFilters )
//STRIP001 		);
//STRIP001 		rGlobalFilters.swap( aNonEmptyGlobalFilters );
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct AppendFilter : public ::std::unary_function< FilterDescriptor, void >
//STRIP001 	{
//STRIP001 		protected:
//STRIP001 			Reference< XFilterManager > 		m_xFilterManager;
//STRIP001 			FileDialogHelper_Impl*				m_pFileDlgImpl;
//STRIP001 			bool								m_bAddExtension;
//STRIP001
//STRIP001 		public:
//STRIP001 			AppendFilter( const Reference< XFilterManager >& _rxFilterManager,
//STRIP001 						  FileDialogHelper_Impl* _pImpl, bool _bAddExtension ) :
//STRIP001
//STRIP001 				m_xFilterManager( _rxFilterManager ),
//STRIP001 				m_pFileDlgImpl	( _pImpl ),
//STRIP001 				m_bAddExtension	( _bAddExtension )
//STRIP001
//STRIP001 			{
//STRIP001 				DBG_ASSERT( m_xFilterManager.is(), "AppendFilter::AppendFilter: invalid filter manager!" );
//STRIP001 				DBG_ASSERT( m_pFileDlgImpl, "AppendFilter::AppendFilter: invalid filedlg impl!" );
//STRIP001 			}
//STRIP001
//STRIP001 			// operate on a single filter
//STRIP001 			void operator() ( const FilterDescriptor& _rFilterEntry )
//STRIP001 			{
//STRIP001 				String sDisplayText = m_bAddExtension
//STRIP001 					? addExtension( _rFilterEntry.First, _rFilterEntry.Second, sal_True, *m_pFileDlgImpl )
//STRIP001 					: _rFilterEntry.First;
//STRIP001 				m_xFilterManager->appendFilter( sDisplayText, _rFilterEntry.Second );
//STRIP001 			}
//STRIP001 	};
//STRIP001
//STRIP001 // =======================================================================
//STRIP001 // = handling for the "all files" entry
//STRIP001 // =======================================================================
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	sal_Bool lcl_hasAllFilesFilter( SfxFilterMatcherIter& _rFilterMatcher, String& /* [out] */ _rAllFilterName )
//STRIP001 	{
//STRIP001 		::rtl::OUString sUIName;
//STRIP001 		sal_Bool		bHasAll = sal_False;
//STRIP001 		_rAllFilterName = String( SfxResId( STR_FILTERNAME_ALL ) );
//STRIP001
//STRIP001 		// check if there's already a filter <ALL>
//STRIP001 		for ( const SfxFilter* pFilter = _rFilterMatcher.First(); pFilter && !bHasAll; pFilter = _rFilterMatcher.Next() )
//STRIP001 		{
//STRIP001 			if ( pFilter->GetUIName() == _rAllFilterName )
//STRIP001 				bHasAll = sal_True;
//STRIP001 		}
//STRIP001 		return bHasAll;
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_EnsureAllFilesEntry( SfxFilterMatcherIter& _rFilterMatcher, GroupedFilterList& _rFilters )
//STRIP001 	{
//STRIP001 		String sAllFilterName;
//STRIP001 		if ( !lcl_hasAllFilesFilter( _rFilterMatcher, sAllFilterName ) )
//STRIP001 		{
//STRIP001 			// get the first group of filters (by definition, this group contains the global classes)
//STRIP001 			DBG_ASSERT( !_rFilters.empty(), "lcl_EnsureAllFilesEntry: invalid filter list!" );
//STRIP001 			if ( !_rFilters.empty() )
//STRIP001 			{
//STRIP001 				FilterGroup& rGlobalClasses = *_rFilters.begin();
//STRIP001 				rGlobalClasses.push_front( FilterDescriptor( sAllFilterName, DEFINE_CONST_UNICODE( FILEDIALOG_FILTER_ALL ) ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001
//STRIP001 #ifdef DISABLE_GROUPING_AND_CLASSIFYING
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void lcl_EnsureAllFilesEntry( SfxFilterMatcherIter& _rFilterMatcher, const Reference< XFilterManager >& _rxFilterManager, ::rtl::OUString& _rFirstNonEmpty )
//STRIP001 	{
//STRIP001 		String sAllFilterName;
//STRIP001 		if ( !lcl_hasAllFilesFilter( _rFilterMatcher, sAllFilterName ) )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				_rxFilterManager->appendFilter( sAllFilterName, DEFINE_CONST_UNICODE( FILEDIALOG_FILTER_ALL ) );
//STRIP001 				_rFirstNonEmpty = sAllFilterName;
//STRIP001 			}
//STRIP001 			catch( const IllegalArgumentException& )
//STRIP001 			{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 				ByteString aMsg( "sfx2::lcl_EnsureAllFilesEntry: could not append Filter" );
//STRIP001 				aMsg += ByteString( String( sAllFilterName ), RTL_TEXTENCODING_UTF8 );
//STRIP001 				DBG_ERROR( aMsg.GetBuffer() );
//STRIP001 #endif
//STRIP001 			}
//STRIP001 		}
//STRIP001
//STRIP001 	}
//STRIP001 #endif
//STRIP001
//STRIP001 // =======================================================================
//STRIP001 // = filling an XFilterManager
//STRIP001 // =======================================================================
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	struct AppendFilterGroup : public ::std::unary_function< FilterGroup, void >
//STRIP001 	{
//STRIP001 	protected:
//STRIP001 		Reference< XFilterManager > 		m_xFilterManager;
//STRIP001 		Reference< XFilterGroupManager >	m_xFilterGroupManager;
//STRIP001 		FileDialogHelper_Impl*				m_pFileDlgImpl;
//STRIP001
//STRIP001 	public:
//STRIP001 		AppendFilterGroup( const Reference< XFilterManager >& _rxFilterManager, FileDialogHelper_Impl* _pImpl )
//STRIP001 			:m_xFilterManager		( _rxFilterManager )
//STRIP001 			,m_xFilterGroupManager	( _rxFilterManager, UNO_QUERY )
//STRIP001 			,m_pFileDlgImpl			( _pImpl )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( m_xFilterManager.is(), "AppendFilterGroup::AppendFilterGroup: invalid filter manager!" );
//STRIP001 			DBG_ASSERT( m_pFileDlgImpl, "AppendFilterGroup::AppendFilterGroup: invalid filedlg impl!" );
//STRIP001 		}
//STRIP001
//STRIP001 		void appendGroup( const FilterGroup& _rGroup, bool _bAddExtension )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				if ( m_xFilterGroupManager.is() )
//STRIP001 				{	// the file dialog implementation supports visual grouping of filters
//STRIP001 					// create a representation of the group which is understandable by the XFilterGroupManager
//STRIP001 					if ( _rGroup.size() )
//STRIP001 					{
//STRIP001 						Sequence< StringPair > aFilters( _rGroup.size() );
//STRIP001 						::std::copy(
//STRIP001 							_rGroup.begin(),
//STRIP001 							_rGroup.end(),
//STRIP001 							aFilters.getArray()
//STRIP001 						);
//STRIP001 						if ( _bAddExtension )
//STRIP001 						{
//STRIP001 							StringPair* pFilters = aFilters.getArray();
//STRIP001 							StringPair* pEnd = pFilters + aFilters.getLength();
//STRIP001 							for ( ; pFilters != pEnd; ++pFilters )
//STRIP001 								pFilters->First = addExtension( pFilters->First, pFilters->Second, sal_True, *m_pFileDlgImpl );
//STRIP001 						}
//STRIP001 						m_xFilterGroupManager->appendFilterGroup( ::rtl::OUString(), aFilters );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					::std::for_each(
//STRIP001 						_rGroup.begin(),
//STRIP001 						_rGroup.end(),
//STRIP001 						AppendFilter( m_xFilterManager, m_pFileDlgImpl, _bAddExtension ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( const Exception& )
//STRIP001 			{
//STRIP001 				DBG_ERROR( "AppendFilterGroup::operator(): caught an exception while adding filters!" );
//STRIP001 			}
//STRIP001 		}
//STRIP001
//STRIP001 		// operate on a single filter group
//STRIP001 		void operator() ( const FilterGroup& _rGroup )
//STRIP001 		{
//STRIP001 			appendGroup( _rGroup, true );
//STRIP001 		}
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void appendFiltersForSave( SfxFilterMatcherIter& _rFilterMatcher,
//STRIP001 							   const Reference< XFilterManager >& _rxFilterManager,
//STRIP001 							   ::rtl::OUString& _rFirstNonEmpty, FileDialogHelper_Impl& _rFileDlgImpl )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( _rxFilterManager.is(), "sfx2::appendFiltersForSave: invalid manager!" );
//STRIP001 		if ( !_rxFilterManager.is() )
//STRIP001 			return;
//STRIP001
//STRIP001 		::rtl::OUString sUIName;
//STRIP001
//STRIP001 		for ( const SfxFilter* pFilter = _rFilterMatcher.First(); pFilter; pFilter = _rFilterMatcher.Next() )
//STRIP001 		{
//STRIP001 			::rtl::OUString sExtension = pFilter->GetWildcard().GetWildCard();
//STRIP001 			sUIName = addExtension( pFilter->GetUIName(), sExtension, sal_False, _rFileDlgImpl );
//STRIP001 			try
//STRIP001 			{
//STRIP001 				_rxFilterManager->appendFilter( sUIName, sExtension );
//STRIP001 				if ( !_rFirstNonEmpty.getLength() )
//STRIP001 					_rFirstNonEmpty = sUIName;
//STRIP001
//STRIP001 			}
//STRIP001 			catch( IllegalArgumentException )
//STRIP001 			{
//STRIP001 	#ifdef DBG_UTIL
//STRIP001 				ByteString aMsg( "Could not append Filter" );
//STRIP001 				aMsg += ByteString( String( sUIName ), osl_getThreadTextEncoding() );
//STRIP001 				DBG_ERRORFILE( aMsg.GetBuffer() );
//STRIP001 	#endif
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001
//STRIP001 	struct ExportFilter
//STRIP001 	{
//STRIP001 		ExportFilter( const ::rtl::OUString& _aUIName, const ::rtl::OUString& _aWildcard ) :
//STRIP001 			aUIName( _aUIName ), aWildcard( _aWildcard ) {}
//STRIP001
//STRIP001 		::rtl::OUString aUIName;
//STRIP001 		::rtl::OUString aWildcard;
//STRIP001 	};
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void appendExportFilters( SfxFilterMatcherIter& _rFilterMatcher,
//STRIP001 							  const Reference< XFilterManager >& _rxFilterManager,
//STRIP001 							  ::rtl::OUString& _rFirstNonEmpty, FileDialogHelper_Impl& _rFileDlgImpl )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( _rxFilterManager.is(), "sfx2::appendExportFilters: invalid manager!" );
//STRIP001 		if ( !_rxFilterManager.is() )
//STRIP001 			return;
//STRIP001
//STRIP001 		sal_Int32							nPDFIndex	= -1;
//STRIP001 		sal_Int32							nHTMLIndex	= -1;
//STRIP001 		sal_Int32							nFlashIndex = -1;
//STRIP001 		sal_Int32							nCount		= 0;
//STRIP001 		String								sPDFExtension = String::CreateFromAscii( "*.pdf" );
//STRIP001 		String								sHTMLExtension = String::CreateFromAscii( "*.htm*" );
//STRIP001 		String								sFlashExtension = String::CreateFromAscii( "*.swf" );
//STRIP001 		WildCard							aHTMLWildcardMatcher( sHTMLExtension, ';' );
//STRIP001 		WildCard							aPDFWildcardMatcher( sPDFExtension, ';' );
//STRIP001 		WildCard							aFlashWildcardMatcher( sFlashExtension, ';' );
//STRIP001 		::rtl::OUString						sUIName;
//STRIP001 		::rtl::OUString						sExtensions;
//STRIP001 		std::vector< ExportFilter >			aImportantFilterGroup;
//STRIP001 		std::vector< ExportFilter >			aFilterGroup;
//STRIP001 		Reference< XFilterGroupManager >	xFilterGroupManager( _rxFilterManager, UNO_QUERY );
//STRIP001
//STRIP001 		for ( const SfxFilter* pFilter = _rFilterMatcher.First(); pFilter; pFilter = _rFilterMatcher.Next() )
//STRIP001 		{
//STRIP001 			sUIName		= pFilter->GetUIName();
//STRIP001 			sExtensions = pFilter->GetWildcard().GetWildCard();
//STRIP001
//STRIP001 			ExportFilter aExportFilter( sUIName, sExtensions );
//STRIP001
//STRIP001 			String aExt = sExtensions;
//STRIP001 			if ( nHTMLIndex == -1 && aHTMLWildcardMatcher.Matches( aExt ))
//STRIP001 			{
//STRIP001 				aImportantFilterGroup.insert( aImportantFilterGroup.begin(), aExportFilter );
//STRIP001 				nHTMLIndex = 0;
//STRIP001 				nCount++;
//STRIP001 			}
//STRIP001 			else if ( nPDFIndex == -1 && aPDFWildcardMatcher.Matches( aExt ))
//STRIP001 			{
//STRIP001 				std::vector< ExportFilter >::iterator aIter = aImportantFilterGroup.begin();
//STRIP001 				if ( nHTMLIndex == -1 )
//STRIP001 					aImportantFilterGroup.insert( aIter, aExportFilter );
//STRIP001 				else
//STRIP001 					aImportantFilterGroup.insert( ++aIter, aExportFilter );
//STRIP001 				nPDFIndex = 0;
//STRIP001 				nCount++;
//STRIP001 			}
//STRIP001 			else if ( nFlashIndex == -1 && aFlashWildcardMatcher.Matches( aExt ))
//STRIP001 			{
//STRIP001 				std::vector< ExportFilter >::iterator aIter = aImportantFilterGroup.begin();
//STRIP001 				if ( nHTMLIndex != -1 )
//STRIP001 					aIter++;
//STRIP001
//STRIP001 				if ( nPDFIndex != -1 )
//STRIP001 					aIter++;
//STRIP001
//STRIP001 				aImportantFilterGroup.insert( aIter, aExportFilter );
//STRIP001 				nFlashIndex = 0;
//STRIP001 				nCount++;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aFilterGroup.push_back( aExportFilter );
//STRIP001 		}
//STRIP001
//STRIP001 		if ( xFilterGroupManager.is() )
//STRIP001 		{
//STRIP001 			// Add both html/pdf filter as a filter group to get a separator between both groups
//STRIP001 			if ( aImportantFilterGroup.size() > 0 )
//STRIP001 			{
//STRIP001 				Sequence< StringPair > aFilters( aImportantFilterGroup.size() );
//STRIP001 				for ( sal_Int32 i = 0; i < (sal_Int32)aImportantFilterGroup.size(); i++ )
//STRIP001 				{
//STRIP001 					aFilters[i].First	= addExtension( aImportantFilterGroup[i].aUIName,
//STRIP001 														aImportantFilterGroup[i].aWildcard,
//STRIP001 														sal_False, _rFileDlgImpl );
//STRIP001 					aFilters[i].Second	= aImportantFilterGroup[i].aWildcard;
//STRIP001 				}
//STRIP001
//STRIP001 				try
//STRIP001 				{
//STRIP001 					xFilterGroupManager->appendFilterGroup( ::rtl::OUString(), aFilters );
//STRIP001 				}
//STRIP001 				catch( IllegalArgumentException )
//STRIP001 				{
//STRIP001 				}
//STRIP001 			}
//STRIP001
//STRIP001 			if ( aFilterGroup.size() > 0 )
//STRIP001 			{
//STRIP001 				Sequence< StringPair > aFilters( aFilterGroup.size() );
//STRIP001 				for ( sal_Int32 i = 0; i < (sal_Int32)aFilterGroup.size(); i++ )
//STRIP001 				{
//STRIP001 					aFilters[i].First	= addExtension( aFilterGroup[i].aUIName,
//STRIP001 														aFilterGroup[i].aWildcard,
//STRIP001 														sal_False, _rFileDlgImpl );
//STRIP001 					aFilters[i].Second	= aFilterGroup[i].aWildcard;
//STRIP001 				}
//STRIP001
//STRIP001 				try
//STRIP001 				{
//STRIP001 					xFilterGroupManager->appendFilterGroup( ::rtl::OUString(), aFilters );
//STRIP001 				}
//STRIP001 				catch( IllegalArgumentException )
//STRIP001 				{
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Fallback solution just add both filter groups as single filters
//STRIP001 			for ( sal_Int32 n = 0; n < (sal_Int32)aImportantFilterGroup.size(); n++ )
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					::rtl::OUString aUIName = addExtension( aImportantFilterGroup[n].aUIName,
//STRIP001 														  aImportantFilterGroup[n].aWildcard,
//STRIP001 														  sal_False, _rFileDlgImpl );
//STRIP001 					_rxFilterManager->appendFilter( aUIName, aImportantFilterGroup[n].aWildcard  );
//STRIP001 					if ( !_rFirstNonEmpty.getLength() )
//STRIP001 						_rFirstNonEmpty = sUIName;
//STRIP001
//STRIP001 				}
//STRIP001 				catch( IllegalArgumentException )
//STRIP001 				{
//STRIP001 		#ifdef DBG_UTIL
//STRIP001 					ByteString aMsg( "Could not append Filter" );
//STRIP001 					aMsg += ByteString( String( sUIName ), osl_getThreadTextEncoding() );
//STRIP001 					DBG_ERRORFILE( aMsg.GetBuffer() );
//STRIP001 		#endif
//STRIP001 				}
//STRIP001 			}
//STRIP001
//STRIP001 			for ( n = 0; n < (sal_Int32)aFilterGroup.size(); n++ )
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					::rtl::OUString aUIName = addExtension( aFilterGroup[n].aUIName,
//STRIP001 														  aFilterGroup[n].aWildcard,
//STRIP001 														  sal_False, _rFileDlgImpl );
//STRIP001 					_rxFilterManager->appendFilter( aUIName, aFilterGroup[n].aWildcard );
//STRIP001 					if ( !_rFirstNonEmpty.getLength() )
//STRIP001 						_rFirstNonEmpty = sUIName;
//STRIP001
//STRIP001 				}
//STRIP001 				catch( IllegalArgumentException )
//STRIP001 				{
//STRIP001 		#ifdef DBG_UTIL
//STRIP001 					ByteString aMsg( "Could not append Filter" );
//STRIP001 					aMsg += ByteString( String( sUIName ), osl_getThreadTextEncoding() );
//STRIP001 					DBG_ERRORFILE( aMsg.GetBuffer() );
//STRIP001 		#endif
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 	void appendFiltersForOpen( SfxFilterMatcherIter& _rFilterMatcher,
//STRIP001 							   const Reference< XFilterManager >& _rxFilterManager,
//STRIP001 							   ::rtl::OUString& _rFirstNonEmpty, FileDialogHelper_Impl& _rFileDlgImpl )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( _rxFilterManager.is(), "sfx2::appendFiltersForOpen: invalid manager!" );
//STRIP001 		if ( !_rxFilterManager.is() )
//STRIP001 			return;
//STRIP001
//STRIP001 #ifdef DISABLE_GROUPING_AND_CLASSIFYING
//STRIP001 		// ensure that there's an entry "all" (with wildcard *.*)
//STRIP001 		lcl_EnsureAllFilesEntry( _rFilterMatcher, _rxFilterManager, _rFirstNonEmpty );
//STRIP001
//STRIP001 		appendFilters( _rFilterMatcher, _rxFilterManager, _rFirstNonEmpty );
//STRIP001 #else
//STRIP001
//STRIP001 		// group and classify the filters
//STRIP001 		GroupedFilterList aAllFilters;
//STRIP001 		lcl_GroupAndClassify( _rFilterMatcher, aAllFilters );
//STRIP001
//STRIP001 		// ensure that we have the one "all files" entry
//STRIP001 		lcl_EnsureAllFilesEntry( _rFilterMatcher, aAllFilters );
//STRIP001
//STRIP001 		// the first non-empty string - which we assume is the first overall entry
//STRIP001 		if ( !aAllFilters.empty() )
//STRIP001 		{
//STRIP001 			const FilterGroup& rFirstGroup = *aAllFilters.begin();	// should be the global classes
//STRIP001 			if ( !rFirstGroup.empty() )
//STRIP001 				_rFirstNonEmpty = rFirstGroup.begin()->First;
//STRIP001 			// append first group, without extension
//STRIP001 			AppendFilterGroup aGroup( _rxFilterManager, &_rFileDlgImpl );
//STRIP001 			aGroup.appendGroup( rFirstGroup, false );
//STRIP001 		}
//STRIP001
//STRIP001 		// append the filters to the manager
//STRIP001 		if ( !aAllFilters.empty() )
//STRIP001 		{
//STRIP001 			::std::list< FilterGroup >::iterator pIter = aAllFilters.begin();
//STRIP001 			++pIter;
//STRIP001 			::std::for_each(
//STRIP001 				pIter, // first filter group was handled seperately, see above
//STRIP001 				aAllFilters.end(),
//STRIP001 				AppendFilterGroup( _rxFilterManager, &_rFileDlgImpl ) );
//STRIP001 		}
//STRIP001 #endif
//STRIP001 	}
//STRIP001
//STRIP001 	::rtl::OUString addExtension( const ::rtl::OUString& _rDisplayText,
//STRIP001 								  const ::rtl::OUString& _rExtension,
//STRIP001 								  sal_Bool _bForOpen, FileDialogHelper_Impl& _rFileDlgImpl )
//STRIP001 	{
//STRIP001 		static ::rtl::OUString sAllFilter( RTL_CONSTASCII_USTRINGPARAM( "(*.*)" ) );
//STRIP001 		static ::rtl::OUString sOpenBracket( RTL_CONSTASCII_USTRINGPARAM( " (" ) );
//STRIP001 		static ::rtl::OUString sCloseBracket( RTL_CONSTASCII_USTRINGPARAM( ")" ) );
//STRIP001 		::rtl::OUString sRet = _rDisplayText;
//STRIP001
//STRIP001 		if ( sRet.indexOf( sAllFilter ) == -1 )
//STRIP001 		{
//STRIP001 			String sExt = _rExtension;
//STRIP001 			if ( !_bForOpen )
//STRIP001 				// show '*' in extensions only when opening a document
//STRIP001 				sExt.EraseAllChars( '*' );
//STRIP001 			sRet += sOpenBracket;
//STRIP001 			sRet += sExt;
//STRIP001 			sRet += sCloseBracket;
//STRIP001 		}
//STRIP001 		_rFileDlgImpl.addFilterPair( _rDisplayText, sRet );
//STRIP001 		return sRet;
//STRIP001 	}
//STRIP001
//STRIP001 //........................................................................
//STRIP001 }	// namespace sfx2
//STRIP001 //........................................................................
//STRIP001
//STRIP001
}
