/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ucbhelp.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:38:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_UCBHELP_HXX
#define _SFX_UCBHELP_HXX

// auto strip #ifndef _COM_SUN_STAR_UNO_ANY_HXX_
// auto strip #include <com/sun/star/uno/Any.hxx>
// auto strip #endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
// auto strip #ifndef _VOS_MUTEX_HXX_
// auto strip #include <vos/mutex.hxx>
// auto strip #endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

namespace com
{
	namespace sun
	{
		namespace star
		{
			namespace ucb
			{
				class XContent;
				class XCommandEnvironment;
			}
			namespace io
			{
				class XInputStream;
			}
		}
	}
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
class String;
class SfxCancelManager;
namespace binfilter {

class WrpJobList;

//----------------------------------------------------------------------------

class UCB_Helper
{
	static WrpJobList*				mpJobList;

public:
	static void						Initialize();
	static void						Deinitialize();
	static void                     SetConnectionMode( BOOL bOn );
	static BOOL                     GetConnectionMode();

	static BOOL						HasCommand( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >,
												USHORT nWhich );
	static ::com::sun::star::uno::Any ExecuteCommand( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >,
										const ::rtl::OUString& rName,
										const ::com::sun::star::uno::Any& rArgument,
										sal_Bool *pSuccess = NULL );
	static void                     ExecuteCommand( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >,
										USHORT nPropId,
										sal_Bool *pSuccess = NULL );
	static void                     ExecuteCommand( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >,
										USHORT nPropId,
										const ::com::sun::star::uno::Any& rArgument,
										sal_Bool *pSuccess = NULL );
	static void                     ExecuteCommand( const String& rURL,
										USHORT nPropId,
										sal_Bool *pSuccess = NULL );
	static void                     ExecuteCommand( const String& rURL,
										USHORT nPropId,
										const ::com::sun::star::uno::Any& rArgument,
										sal_Bool *pSuccess = NULL );

	static ::com::sun::star::uno::Any ExecuteOpenCommand( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent > xContent,
										const ::com::sun::star::uno::Any& rArgument,
										sal_Int32 nCmdId,
										::com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandEnvironment > xEnv,
										sal_Bool &rSuccess );

	static ::com::sun::star::uno::Any GetProperty( const String& rURL, USHORT nPropId );
	static ::com::sun::star::uno::Any GetProperty( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >, USHORT nPropId );
	static void                     SetProperty( const String& rURL, USHORT nPropId, const ::com::sun::star::uno::Any& rAny );
	static void                     SetProperty( ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent >,
												 USHORT nPropId, const ::com::sun::star::uno::Any& rAny  );
	static ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent > CreateContent( const String& rURL );
	static ::com::sun::star::uno::Reference < ::com::sun::star::ucb::XContent > CreateContent( const ::rtl::OUString& rURL );
};


}//end of namespace binfilter
#endif

