/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_outlundo.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:44:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <outl_pch.hxx>

#pragma hdrstop

#define _OUTLINER_CXX
#include <outliner.hxx>
#include <outlundo.hxx>
namespace binfilter {


//STRIP001 OutlinerUndoBase::OutlinerUndoBase( USHORT nId, Outliner* pOutliner )
//STRIP001 	: EditUndo( nId, NULL )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pOutliner, "Undo: Outliner?!" );
//STRIP001 	mpOutliner = pOutliner;
//STRIP001 }


//STRIP001 OutlinerUndoChangeDepth::OutlinerUndoChangeDepth( Outliner* pOutliner, USHORT nPara, USHORT nOldDepth, USHORT nNewDepth )
//STRIP001 	: OutlinerUndoBase( OLUNDO_DEPTH, pOutliner )
//STRIP001 {
//STRIP001 	mnPara = nPara;
//STRIP001 	mnOldDepth = nOldDepth;
//STRIP001 	mnNewDepth = nNewDepth;
//STRIP001 }

//STRIP001 void OutlinerUndoChangeDepth::Undo()
//STRIP001 {
//STRIP001 	GetOutliner()->ImplInitDepth( mnPara, mnOldDepth, FALSE );
//STRIP001 }

//STRIP001 void OutlinerUndoChangeDepth::Redo()
//STRIP001 {
//STRIP001 	GetOutliner()->ImplInitDepth( mnPara, mnNewDepth, FALSE );
//STRIP001 }

//STRIP001 void OutlinerUndoChangeDepth::Repeat()
//STRIP001 {
//STRIP001 	DBG_ERROR( "Repeat not implemented!" );
//STRIP001 }


//STRIP001 OutlinerUndoCheckPara::OutlinerUndoCheckPara( Outliner* pOutliner, USHORT nPara )
//STRIP001 	: OutlinerUndoBase( OLUNDO_DEPTH, pOutliner )
//STRIP001 {
//STRIP001 	mnPara = nPara;
//STRIP001 }

//STRIP001 void OutlinerUndoCheckPara::Undo()
//STRIP001 {
//STRIP001 	Paragraph* pPara = GetOutliner()->GetParagraph( mnPara );
//STRIP001 	pPara->Invalidate();
//STRIP001 	GetOutliner()->ImplCalcBulletText( mnPara, FALSE, FALSE );
//STRIP001 }

//STRIP001 void OutlinerUndoCheckPara::Redo()
//STRIP001 {
//STRIP001 	Paragraph* pPara = GetOutliner()->GetParagraph( mnPara );
//STRIP001 	pPara->Invalidate();
//STRIP001 	GetOutliner()->ImplCalcBulletText( mnPara, FALSE, FALSE );
//STRIP001 }

//STRIP001 void OutlinerUndoCheckPara::Repeat()
//STRIP001 {
//STRIP001 	DBG_ERROR( "Repeat not implemented!" );
//STRIP001 }

//STRIP001 DBG_NAME(OLUndoExpand)

//STRIP001 OLUndoExpand::OLUndoExpand(Outliner* pOut, USHORT nId )
//STRIP001 	: EditUndo( nId, 0 )
//STRIP001 {
//STRIP001 	DBG_CTOR(OLUndoExpand,0);
//STRIP001 	DBG_ASSERT(pOut,"Undo:No Outliner");
//STRIP001 	pOutliner = pOut;
//STRIP001 	nCount = 0;
//STRIP001 	pParas = 0;
//STRIP001 }


//STRIP001 OLUndoExpand::~OLUndoExpand()
//STRIP001 {
//STRIP001 	DBG_DTOR(OLUndoExpand,0);
//STRIP001 	delete pParas;
//STRIP001 }


//STRIP001 void OLUndoExpand::Restore( BOOL bUndo )
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(OLUndoExpand,0);
//STRIP001 	DBG_ASSERT(pOutliner,"Undo:No Outliner");
//STRIP001 	DBG_ASSERT(pOutliner->pEditEngine,"Outliner already deleted");
//STRIP001 	Paragraph* pPara;
//STRIP001 
//STRIP001 	BOOL bExpand = FALSE;
//STRIP001 	USHORT nId = GetId();
//STRIP001 	if((nId == OLUNDO_EXPAND && !bUndo) || (nId == OLUNDO_COLLAPSE && bUndo))
//STRIP001 		bExpand = TRUE;
//STRIP001 	if( !pParas )
//STRIP001 	{
//STRIP001 		pPara = pOutliner->GetParagraph( (ULONG)nCount );
//STRIP001 		if( bExpand )
//STRIP001 			pOutliner->Expand( pPara );
//STRIP001 		else
//STRIP001 			pOutliner->Collapse( pPara );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for( USHORT nIdx = 0; nIdx < nCount; nIdx++ )
//STRIP001 		{
//STRIP001 			pPara = pOutliner->GetParagraph( (ULONG)(pParas[nIdx]) );
//STRIP001 			if( bExpand )
//STRIP001 				pOutliner->Expand( pPara );
//STRIP001 			else
//STRIP001 				pOutliner->Collapse( pPara );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void OLUndoExpand::Undo()
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(OLUndoExpand,0);
//STRIP001 	Restore( TRUE );
//STRIP001 }


//STRIP001 void OLUndoExpand::Redo()
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(OLUndoExpand,0);
//STRIP001 	Restore( FALSE );
//STRIP001 }


//STRIP001 void OLUndoExpand::Repeat()
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(OLUndoExpand,0);
//STRIP001 	DBG_ERROR("Not implemented");
//STRIP001 }
}
