/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DataSeriesTreeHelper.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:39:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef CHART2_DATASERIESTREEHELPER_HXX
#define CHART2_DATASERIESTREEHELPER_HXX

#ifndef _COM_SUN_STAR_CHART2_XDATASERIES_HPP_
#include <com/sun/star/chart2/XDataSeries.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XDIAGRAM_HPP_
#include <com/sun/star/chart2/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_STACKMODE_HPP_
#include <com/sun/star/chart2/StackMode.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XCHARTTYPE_HPP_
#include <com/sun/star/chart2/XChartType.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XCHARTTYPEGROUP_HPP_
#include <com/sun/star/chart2/XChartTypeGroup.hpp>
#endif

#include <vector>

namespace chart
{
namespace helper
{

class DataSeriesTreeHelper
{
public:
    /** return all data series found in a diagram.
     */
    static ::com::sun::star::uno::Sequence<
        ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSeries > >
        getDataSeriesFromDiagram(
            const ::com::sun::star::uno::Reference<
                ::com::sun::star::chart2::XDiagram > & xDia );

    /** returns the number of series found in the nth chart-type group, where n
        is 0-based.
     */
    static sal_Int32 getNumberOfSeriesForChartTypeByIndex(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XDataSeriesTreeParent > & xTree,
        sal_Int32 _nGroupNumber = 0 );

    static ::com::sun::star::chart2::StackMode
        getStackMode( const ::com::sun::star::uno::Reference<
                          ::com::sun::star::chart2::XDataSeriesTreeParent > & xParent );

    static bool setStackMode(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XDataSeriesTreeParent > & xParent,
        ::com::sun::star::chart2::StackMode eMode );

    static ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XChartType >
        getChartTypeByIndex(
            const ::com::sun::star::uno::Reference<
                ::com::sun::star::chart2::XDataSeriesTreeParent > & xTree,
            sal_Int32 _nGroupNumber = 0 );

    static ::std::vector<
            ::com::sun::star::uno::Reference<
                    ::com::sun::star::chart2::XChartTypeGroup > > getChartTypes(
                        const ::com::sun::star::uno::Reference<
                            ::com::sun::star::chart2::XDataSeriesTreeParent > &
                        xTree );

private:
    // not implemented
	DataSeriesTreeHelper();
};

} //  namespace chart
} //  namespace helper

// CHART2_DATASERIESTREEHELPER_HXX
#endif
