/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appopt.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:02:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// header for SID_SCH_TP_DEFCOLORS
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
// header for SFX_APP
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include "schmod.hxx"
#include "schopt.hxx"
#include "tpappopt.hxx"

SfxItemSet*	 SchModule::CreateItemSet( USHORT nSlot )
{
	SchOptions* pOptions = GetSchOptions();
	SfxItemSet* pRet = new SfxItemSet( GetPool(),
									   CHATTR_DEFCOLORS, CHATTR_DEFCOLORS,
									   0 );

	pRet->Put( SchColorTableItem( CHATTR_DEFCOLORS, pOptions->GetDefaultColors() ) );

	return pRet;
}

void SchModule::ApplyItemSet( USHORT nSlot, const SfxItemSet& rSet )
{
	SchOptions* pOptions = GetSchOptions();

	const SfxPoolItem* pItem = NULL;

	if( rSet.GetItemState( CHATTR_DEFCOLORS, FALSE, &pItem ) == SFX_ITEM_SET )
	{
		((const SchColorTableItem*)pItem)->SetOptions( pOptions );
	}

	SfxViewFrame* pFrame = GetFrame();
	if( pFrame )
		pFrame->GetBindings().InvalidateAll( TRUE );
}

SfxTabPage*	 SchModule::CreateOptionsTabPage( USHORT nId, Window* pParent, const SfxItemSet& rSet )
{
	SfxTabPage* pRet = NULL;

	switch( nId )
	{
		case SID_SCH_TP_DEFCOLORS:
		case SID_GENERAL_OPTIONS:
			pRet = SchDefaultColorOptPage::Create( pParent, rSet );
			break;
	}

	DBG_ASSERT( pRet, "Chart:CreateTabPage: unknown slot id");

	return pRet;
}

