/*
 * ExecutePropertiesMethod.java
 *
 * Created on 28. Juli 2003, 16:37
 */
package com.sun.star.wizards.tutorial.executer;

import java.util.Vector;

import com.sun.star.beans.PropertyValue;
import com.sun.star.wizards.tutorial.executer.officeHelper.Desktop;
import com.sun.star.wizards.tutorial.executer.officeHelper.XControl;
import com.sun.star.wizards.tutorial.executer.officeHelper.XProperties;
import com.sun.star.wizards.tutorial.executer.officeHelper.XWindow;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class ExecutePropertiesMethod {
	public PropertyValue[] m_propertyValue = null;
	private Helper m_helper = null;

	/**
	 * Creates a new ExecutePropertiesMethod object.
	 *
	 * @param helper DOCUMENT ME!
	 */
	public ExecutePropertiesMethod(Helper helper) {
		m_helper = helper;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param propertyValue DOCUMENT ME!
	 *
	 * @throws com.sun.star.beans.UnknownPropertyException DOCUMENT ME!
	 * @throws com.sun.star.beans.PropertyVetoException DOCUMENT ME!
	 * @throws com.sun.star.lang.IllegalArgumentException DOCUMENT ME!
	 * @throws com.sun.star.lang.WrappedTargetException DOCUMENT ME!
	 */
	public void setPropertyValues(com.sun.star.beans.PropertyValue[] propertyValue) throws com.sun.star.beans.UnknownPropertyException, com.sun.star.beans.PropertyVetoException, com.sun.star.lang.IllegalArgumentException, com.sun.star.lang.WrappedTargetException {
		m_propertyValue = propertyValue;

		Object classIntance = null;
		String methodName = "";
		Vector params = new Vector();
		int leng = m_propertyValue.length;

		for (int i = 0; i < leng; i++) {
			PropertyValue propValue = (PropertyValue) m_propertyValue[i];

			if (propValue.Name.equals("DocumentTYP")) {
				String typ = (String) propValue.Value;

				classIntance = Desktop.createDocumentInstance(typ, m_helper);
			} else if (propValue.Name.equals("MethodName")) {
				methodName = (String) propValue.Value;
			} else if (propValue.Name.equals("Param")) {
				params.add(propValue.Value);
			}
		}

		if ((classIntance != null) && !methodName.equals("")) {
			instancePropertiesMethodExecute(classIntance, methodName, params);
		}
	}

	/**
	 * Get properties in form of an array
	 *
	 * @return Properties
	 */
	public PropertyValue[] getPropertyValues() {
		return m_propertyValue;
	}

	/**
	 * Search for proper interface that contains the given method's name. If this method
	 * were found, then execute this method with given params.
	 *
	 * @param classIntance can be any of the document types, such as DesktopMenu,
	 *        TextDocument and so on
	 * @param methodName method's name
	 * @param params for the method
	 */
	public void instancePropertiesMethodExecute(Object classIntance, String methodName, Vector params) {
		if (!xWindow((XWindow) classIntance, methodName, params)) {
			if (!xControl((XControl) classIntance, methodName, params)) {
				xProperties((XProperties) classIntance, methodName, params);
			}
		}
	}

	/**
	 * Search the method's name in XWindow interface.If the method were found, then
	 * execute the method with params.
	 *
	 * @param xmm is an instance of XWindow interface
	 * @param methodName method's name
	 * @param params for the method
	 *
	 * @return if found the method the result will be "true", otherwise "false"
	 */
	private boolean xWindow(XWindow xmm, String methodName, Vector params) {
		if (methodName.equals("windowToFront")) {
			xmm.windowToFront((String) params.get(0));

			return true;
		} else if (methodName.equals("printWindowsNames")) {
			xmm.printWindowsNames();

			return true;
		}

		return false;
	}

	/**
	 * Search the methode name in XControl interface.If found the methode then execute
	 * the methode with params.
	 *
	 * @param xmm
	 * @param methodName method Name
	 * @param params for the method
	 *
	 * @return result
	 */
	private boolean xControl(XControl xmm, String methodName, Vector params) {
		if (methodName.equals("setDelay")) {
			xmm.setDelay(getIntValue(params.get(0)), getIntValue(params.get(1)), getIntValue(params.get(2)), getIntValue(params.get(3)), getIntValue(params.get(4)));

			return true;
		} else if (methodName.equals("printSetDelayValues")) {
			xmm.printSetDelayValues();

			return true;
		} else if (methodName.equals("reset_Key_Mouse_Scroll_Delay")) {
			xmm.reset_Key_Mouse_Scroll_Delay();

			return true;
		} else if (methodName.equals("resetMousePosition")) {
			xmm.resetMousePosition();

			return true;
		} else if (methodName.equals("setMousePosition")) {
			xmm.setMousePosition(getIntValue(params.get(0)), getIntValue(params.get(1)));

			return true;
		} else if (methodName.equals("setMouseAnimate")) {
			xmm.setMouseAnimate(((Boolean) params.get(0)).booleanValue());

			return true;
		} else if (methodName.equals("printMouseAnimateStatus")) {
			xmm.printMouseAnimateStatus();

			return true;
		} else if (methodName.equals("mouseAnimate")) {
			xmm.mouseAnimate(getIntValue(params.get(0)), getIntValue(params.get(1)));

			return true;
		} else if (methodName.equals("moveMouse_Click")) {
			xmm.moveMouse_Click(getIntValue(params.get(0)), getIntValue(params.get(1)));

			return true;
		} else if (methodName.equals("key_Press_Release")) {
			xmm.key_Press_Release(getIntValue(params.get(0)));

			return true;
		}

		return false;
	}

	/**
	 * Search the methode name in XProperties interface.If found the methode then execute
	 * the methode with params.
	 *
	 * @param xmm
	 * @param methodName method Name
	 * @param params for the method
	 *
	 * @return result
	 */
	private boolean xProperties(XProperties xmm, String methodName, Vector params) {
		if (methodName.equals("printAllProperties")) {
			xmm.printAllProperties(getIntValue(params.get(0)), (String) params.get(1), (String) params.get(2));

			return true;
		} else if (methodName.equals("writeAllProperties")) {
			xmm.writeAllProperties(getIntValue(params.get(0)), (String) params.get(1), (String) params.get(2), (String) params.get(3));

			return true;
		}

		return false;
	}

	/**
	 * Get the object's value, if the object is an instance of Integer, Short, Byte or
	 * String, otherwise -1.
	 *
	 * @param obj - awaiting one of the following: Integer, Short, Byte or String
	 *
	 * @return Int value of Object. Returned -1 in error case.
	 */
	private int getIntValue(Object obj) {
		return ExecuteMethod.getIntValue(obj);
	}
}
