/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpURLConnection.java,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:39:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.net.*;
import java.io.*;
import com.sun.star.ucb.*;

public class HelpURLConnection extends URLConnection {
	private final URL _helpURL;
	private final byte[] _doc;

	public HelpURLConnection(URL _starURL, byte[] doc) {
		super(_starURL);
		setDoInput(true);
		connected = true;
		_helpURL = _starURL;
		_doc = doc;
	}

	public void connect() throws IOException {
		System.out.println("trying to connect to help");
	}

	public InputStream getInputStream() {
		if (_doc != null)
			return new ByteArrayInputStream(_doc);

		HelpURLParameter aParameter = null;
		try {
			aParameter = new HelpURLParameter(_helpURL);
		} catch (IllegalIdentifierException e) {
		}

		return aParameter.getInputFromDisk();
	}
}
