/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/25 08:08:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// System - Includes -----------------------------------------------------

#pragma hdrstop


// INCLUDE ---------------------------------------------------------------

#include "undoblk.hxx"
#include "docsh.hxx"
#include "olinetab.hxx"
#include "globstr.hrc"
#include "target.hxx"

#include "undoolk.hxx"              //! GetUndo ins Document verschieben!
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

TYPEINIT1(ScUndoWidthOrHeight,		SfxUndoAction);

// -----------------------------------------------------------------------



//
//		Spaltenbreiten oder Zeilenhoehen aendern
//

/*N*/ ScUndoWidthOrHeight::ScUndoWidthOrHeight( ScDocShell* pNewDocShell,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				USHORT nNewStart, USHORT nNewStartTab, USHORT nNewEnd, USHORT nNewEndTab,
/*N*/ 				ScDocument* pNewUndoDoc, USHORT nNewCnt, USHORT* pNewRanges,
/*N*/ 				ScOutlineTable* pNewUndoTab,
/*N*/ 				ScSizeMode eNewMode, USHORT nNewSizeTwips, BOOL bNewWidth ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	nStart( nNewStart ),
/*N*/ 	nEnd( nNewEnd ),
/*N*/ 	nStartTab( nNewStartTab ),
/*N*/ 	nEndTab( nNewEndTab ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	nRangeCnt( nNewCnt ),
/*N*/ 	pRanges( pNewRanges ),
/*N*/ 	pUndoTab( pNewUndoTab ),
/*N*/ 	eMode( eNewMode ),
/*N*/ 	nNewSize( nNewSizeTwips ),
/*N*/ 	bWidth( bNewWidth ),
/*N*/ 	pDrawUndo( NULL )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ }

/*N*/ __EXPORT ScUndoWidthOrHeight::~ScUndoWidthOrHeight()
/*N*/ {
/*N*/ 	delete[] pRanges;
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pUndoTab;
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

/*N*/ String __EXPORT ScUndoWidthOrHeight::GetComment() const
/*N*/ {
/*N*/ 	// [ "optimale " ] "Spaltenbreite" | "Zeilenhoehe"
/*N*/ 	return ( bWidth ?
/*N*/ 		( ( eMode == SC_SIZE_OPTIMAL )?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_OPTCOLWIDTH ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_COLWIDTH )
/*N*/ 		) :
/*N*/ 		( ( eMode == SC_SIZE_OPTIMAL )?
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_OPTROWHEIGHT ) :
/*N*/ 		ScGlobal::GetRscString( STR_UNDO_ROWHEIGHT )
/*N*/ 		) );
/*N*/ }

/*N*/ BOOL __EXPORT ScUndoWidthOrHeight::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }


}
