/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_diactrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:48:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
// auto strip #include <com/sun/star/presentation/FadeEffect.hpp>
// auto strip #endif

#include <bf_svx/dialogs.hrc>

#include "sdattr.hxx"
#include "strings.hrc"
 
#define _SD_DIACTRL_CXX
#include "diactrl.hxx"

// auto strip #include "sdresid.hxx"
#include "app.hrc"
#include "res_bmp.hrc"
 
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star;

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlDiaEffect, DiaEffectItem )
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlDiaPages,  SfxUInt16Item )

//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor fuer DiaEffectControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 DiaEffectControl::DiaEffectControl( Window* pParent, SfxBindings& rBdx, WinBits nStyle ) :
//STRIP001 		Window			( pParent, nStyle ),
//STRIP001 		rBindings		( rBdx ),
//STRIP001 		aFtDescr		( this, 0 ),
//STRIP001 		aLbEffect		( this, WinBits( WB_BORDER | WB_DROPDOWN ) )
//STRIP001 {
//STRIP001 	// Child-Windows (Controls) setzen
//STRIP001 	String  aStr( SdResId( STR_EFFECT ) );
//STRIP001 	long	nTextHeight = this->GetTextHeight();
//STRIP001 	Size	aSize( this->GetTextWidth( aStr )+6, nTextHeight+2 );
//STRIP001 
//STRIP001 
//STRIP001 	//Size	aSize( LogicToPixel( pParent->GetTextSize( aStr ), MAP_APPFONT ) );
//STRIP001 
//STRIP001 	aFtDescr.SetPosPixel( Point( 0, 4 ) );
//STRIP001 	aFtDescr.SetSizePixel( aSize ); //( 40, 14 ) );
//STRIP001 	aFtDescr.SetText( aStr );
//STRIP001 	aFtDescr.Show();
//STRIP001 
//STRIP001 	String aXStr; aXStr += sal_Unicode('X');
//STRIP001 	Size aXSize( this->GetTextWidth( aXStr ), nTextHeight );
//STRIP001 	aLbEffect.SetPosPixel( Point( aSize.Width(), 0 ) );
//STRIP001 	aLbEffect.SetSizePixel( Size( aXSize.Width() * 21, aXSize.Height() * 10 ) ); // 155/180
//STRIP001 	aLbEffect.Fill();
//STRIP001 	aLbEffect.SelectEffect( presentation::FadeEffect_NONE );
//STRIP001     aLbEffect.SetHelpId( SID_DIA_EFFECT );
//STRIP001 	aLbEffect.Show();
//STRIP001 
//STRIP001 	Size aDescSize = aFtDescr.GetSizePixel();
//STRIP001 	Size aAttrSize = aLbEffect.GetSizePixel();
//STRIP001 	Point aAttrPnt = aLbEffect.GetPosPixel();
//STRIP001 	SetSizePixel( Size( aAttrPnt.X() + aAttrSize.Width(),
//STRIP001 						Max( aAttrSize.Height(), aDescSize.Height() ) ) );
//STRIP001 
//STRIP001 	//SetSizePixel( Size( 210, 20 ) );
//STRIP001 	Show();
//STRIP001 
//STRIP001 	aLbEffect.SetSelectHdl( LINK( this, DiaEffectControl, SelectDiaEffectHdl ) );
//STRIP001 
//STRIP001 	SelectDiaEffectHdl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 DiaEffectControl::~DiaEffectControl()
//STRIP001 {
//STRIP001 }
//STRIP001 



//STRIP001 void DiaEffectControl::GetFocus (void)
//STRIP001 {
//STRIP001     Window::GetFocus();
//STRIP001     // Grab the focus to the slide effects control so that it can be
//STRIP001     // controlled with the keyboard.
//STRIP001     aLbEffect.GrabFocus();
//STRIP001 }




//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( DiaEffectControl, SelectDiaEffectHdl, void *, p )
//STRIP001 {
//STRIP001 	DiaEffectItem aDiaEffectItem( aLbEffect.GetSelectedEffect() );
//STRIP001 
//STRIP001 	if( p )
//STRIP001 		rBindings.GetDispatcher()->Execute( SID_DIA, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aDiaEffectItem, (void*) NULL, 0L );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlDiaSpeed, DiaSpeedItem )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor fuer DiaSpeedControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 DiaSpeedControl::DiaSpeedControl( Window* pParent, SfxBindings& rBdx, WinBits nStyle ) :
//STRIP001 		Window			( pParent, nStyle ),
//STRIP001 		rBindings		( rBdx ),
//STRIP001 		aLbSpeed		( this, WinBits( WB_BORDER | WB_DROPDOWN ) )
//STRIP001 {
//STRIP001 	String  aStrSlow( SdResId( STR_SLOW ) );
//STRIP001 	String  aStrMed(  SdResId( STR_MEDIUM ) );
//STRIP001 	String  aStrFast( SdResId( STR_FAST ) );
//STRIP001 	Size	aSize( this->GetTextWidth( aStrSlow ), this->GetTextHeight() );
//STRIP001 	if( this->GetTextWidth( aStrMed ) > aSize.Width() )
//STRIP001 		aSize.Width() = this->GetTextWidth( aStrMed );
//STRIP001 	if( this->GetTextWidth( aStrFast ) > aSize.Width() )
//STRIP001 		aSize.Width() = this->GetTextWidth( aStrFast );
//STRIP001 	aSize.Width() += 30; // Wegen DropDown-Button
//STRIP001 	aSize.Height() *= 5; // Anzahl Eintraege + ListBox (2)
//STRIP001 
//STRIP001 	// Child-Windows (Controls) setzen
//STRIP001 	//aLbSpeed.SetPosPixel( Point( 0, 0 ) );
//STRIP001 	aLbSpeed.SetSizePixel( aSize ); //( 90, 60 ) );
//STRIP001 	aLbSpeed.InsertEntry( aStrSlow );
//STRIP001 	aLbSpeed.InsertEntry( aStrMed );
//STRIP001 	aLbSpeed.InsertEntry( aStrFast );
//STRIP001 	aLbSpeed.SelectEntryPos( 0 );
//STRIP001     aLbSpeed.SetHelpId( SID_DIA_SPEED );
//STRIP001 	aLbSpeed.Show();
//STRIP001 
//STRIP001 	//SetSizePixel( Size( 95, 20 ) );
//STRIP001 	SetSizePixel( aLbSpeed.GetSizePixel() );
//STRIP001 	Show();
//STRIP001 
//STRIP001 	aLbSpeed.SetSelectHdl( LINK( this, DiaSpeedControl, SelectDiaSpeedHdl ) );
//STRIP001 
//STRIP001 	SelectDiaSpeedHdl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 DiaSpeedControl::~DiaSpeedControl()
//STRIP001 {
//STRIP001 }
//STRIP001 



//STRIP001 void DiaSpeedControl::GetFocus (void)
//STRIP001 {
//STRIP001     Window::GetFocus();
//STRIP001     // Grab the focus to the slide speed control so that it can be
//STRIP001     // controlled with the keyboard.
//STRIP001     aLbSpeed.GrabFocus();
//STRIP001 }




//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( DiaSpeedControl, SelectDiaSpeedHdl, void *, p )
//STRIP001 {
//STRIP001 	FadeSpeed eFS = (FadeSpeed) aLbSpeed.GetSelectEntryPos();
//STRIP001 	DiaSpeedItem aDiaSpeedItem( eFS );
//STRIP001 
//STRIP001 	if( p )
//STRIP001 		rBindings.GetDispatcher()->Execute( 
//STRIP001 			SID_DIA, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aDiaSpeedItem, (void*) NULL, 0L );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlDiaAuto, DiaAutoItem )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor fuer DiaAutoControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 DiaAutoControl::DiaAutoControl( Window* pParent, SfxBindings& rBdx, WinBits nStyle ) :
//STRIP001 		Window			( pParent, nStyle ),
//STRIP001 		rBindings		( rBdx ),
//STRIP001 		aFtDescr		( this, 0 ),
//STRIP001 		aLbAuto 		( this, WinBits( WB_BORDER | WB_DROPDOWN ) )
//STRIP001 {
//STRIP001 	// Child-Windows (Controls) setzen
//STRIP001 	String  aStr( SdResId( STR_CHANGE ) );
//STRIP001 	Size	aSize( this->GetTextWidth( aStr )+6, this->GetTextHeight()+2 );
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	// Child-Windows (Controls) setzen
//STRIP001 	aFtDescr.SetPosPixel( Point( 0, 4 ) );
//STRIP001 	aFtDescr.SetSizePixel( aSize ); //( 55, 14 ) );
//STRIP001 	aFtDescr.SetText( aStr );
//STRIP001 	aFtDescr.Show();
//STRIP001 
//STRIP001 	// Listbox
//STRIP001 	String  aStrMan( SdResId( STR_MANUEL ) );
//STRIP001 	String	aStrSemi( SdResId( STR_SEMIAUTO ) );
//STRIP001 	String  aStrAuto( SdResId( STR_AUTO ) );
//STRIP001 	Size	aLbSize( this->GetTextWidth( aStrMan ), this->GetTextHeight() );
//STRIP001 	if( this->GetTextWidth( aStrAuto ) > aSize.Width() )
//STRIP001 		aLbSize.Width() = this->GetTextWidth( aStrAuto );
//STRIP001 	aLbSize.Width() += 30; // Wegen DropDown-Button
//STRIP001 	aLbSize.Height() *= 5; // Anzahl Eintraege + ListBox (2)
//STRIP001 
//STRIP001 	aLbAuto.SetPosPixel( Point( aSize.Width(), 0 ) );
//STRIP001 	aLbAuto.SetSizePixel( aLbSize ); //( 105, 52 ) );
//STRIP001 	aLbAuto.InsertEntry( aStrMan );
//STRIP001 	aLbAuto.InsertEntry( aStrSemi );
//STRIP001 	aLbAuto.InsertEntry( aStrAuto );
//STRIP001 	aLbAuto.SelectEntryPos( 0 );
//STRIP001     aLbAuto.SetHelpId( SID_DIA_AUTO );	
//STRIP001     aLbAuto.Show();
//STRIP001 
//STRIP001 	//SetSizePixel( Size( 175, 20 ) );
//STRIP001 	Size aDescSize = aFtDescr.GetSizePixel();
//STRIP001 	Size aAttrSize = aLbAuto.GetSizePixel();
//STRIP001 	Point aAttrPnt = aLbAuto.GetPosPixel();
//STRIP001 	SetSizePixel( Size( aAttrPnt.X() + aAttrSize.Width(),
//STRIP001 						Max( aAttrSize.Height(), aDescSize.Height() ) ) );
//STRIP001 	Show();
//STRIP001 
//STRIP001 	aLbAuto.SetSelectHdl( LINK( this, DiaAutoControl, SelectDiaAutoHdl ) );
//STRIP001 
//STRIP001 	SelectDiaAutoHdl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 DiaAutoControl::~DiaAutoControl()
//STRIP001 {
//STRIP001 }
//STRIP001 



//STRIP001 void DiaAutoControl::GetFocus (void)
//STRIP001 {
//STRIP001     Window::GetFocus();
//STRIP001     // Grab the focus to the slide auto transition control so that it can be
//STRIP001     // controlled with the keyboard.
//STRIP001     aLbAuto.GrabFocus();
//STRIP001 }




//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( DiaAutoControl, SelectDiaAutoHdl, void *, p )
//STRIP001 {
//STRIP001 	PresChange	eChange;
//STRIP001 	const ULONG	nPos = aLbAuto.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( !nPos )
//STRIP001 		eChange = PRESCHANGE_MANUAL;
//STRIP001 	else if( 1 == nPos )
//STRIP001 		eChange = PRESCHANGE_SEMIAUTO;
//STRIP001 	else
//STRIP001 		eChange = PRESCHANGE_AUTO;
//STRIP001 
//STRIP001 	DiaAutoItem aDiaAutoItem( eChange );
//STRIP001 
//STRIP001 /*
//STRIP001 	if( bAuto )
//STRIP001 	{
//STRIP001 	// Time-Control disablen
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 	// Time-Control enablen; ModifyHdl rufen
//STRIP001 	}
//STRIP001 */
//STRIP001 
//STRIP001 	if( p )
//STRIP001 		rBindings.GetDispatcher()->Execute( 
//STRIP001 			SID_DIA, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aDiaAutoItem, (void*) NULL, 0L );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SdTbxCtlDiaTime, DiaTimeItem )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor fuer DiaTimeControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 DiaTimeControl::DiaTimeControl( Window* pParent, SfxBindings& rBdx, WinBits nStyle ) :
//STRIP001 		TimeField	( pParent, nStyle ),
//STRIP001 		rBindings	( rBdx )		
//STRIP001 {
//STRIP001 	SetModifyHdl( LINK( this, DiaTimeControl, ModifyDiaTimeHdl ) );
//STRIP001 	SetGetFocusHdl( LINK( this, DiaTimeControl, GetFocusHdl ) );
//STRIP001 
//STRIP001 	UniString aStrTmp( RTL_CONSTASCII_STRINGPARAM( "00:00:00" ), RTL_TEXTENCODING_ASCII_US );
//STRIP001 	Size aSize( GetTextWidth( aStrTmp ) +30, GetTextHeight() +6 );
//STRIP001 
//STRIP001 
//STRIP001 	SetSizePixel( aSize ); //( 75, 20 ) );
//STRIP001 	SetFormat( TIMEF_SEC );
//STRIP001 	SetMin( 0L );
//STRIP001 	SetMax( Time( 12, 00, 00 ) );
//STRIP001 	SetDuration( TRUE );
//STRIP001 	Show();
//STRIP001 
//STRIP001 	ModifyDiaTimeHdl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* 2. Konstruktor fuer DiaTimeControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 DiaTimeControl::DiaTimeControl( Window* pParent, SfxBindings& rBdx, ResId nRId ) :
//STRIP001 		TimeField   	( pParent, nRId ),
//STRIP001 		rBindings		( rBdx )
//STRIP001 {
//STRIP001 	SetGetFocusHdl( LINK( this, DiaTimeControl, GetFocusHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 DiaTimeControl::~DiaTimeControl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( DiaTimeControl, ModifyDiaTimeHdl, void *, p )
//STRIP001 {
//STRIP001 	Time aTime = GetTime();
//STRIP001 	ULONG lTime = aTime.GetSec() + aTime.GetMin() * 60 + aTime.GetHour() * 3600;
//STRIP001 	DiaTimeItem aDiaTimeItem( lTime );
//STRIP001 
//STRIP001 	if( p )
//STRIP001 		rBindings.GetDispatcher()->Execute( 
//STRIP001 			SID_DIA, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aDiaTimeItem, (void*) NULL, 0L );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( DiaTimeControl, GetFocusHdl, void *, p )
//STRIP001 {
//STRIP001 	SetSelection( GetText().Len() );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( DiaTimeControl, GetFocusHdl, void *, p )
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void DiaTimeControl::Down()
//STRIP001 {
//STRIP001 	if( IsEmptyTime() )
//STRIP001 	{
//STRIP001 		SetTime( Time( 0, 0, 0 ) );
//STRIP001 		Reformat();
//STRIP001 		SetSelection( GetText().Len() );
//STRIP001 		Modify();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		TimeField::Down();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void DiaTimeControl::Up()
//STRIP001 {
//STRIP001 	if( IsEmptyTime() )
//STRIP001 	{
//STRIP001 		SetTime( Time( 0, 0, 0 ) );
//STRIP001 		Reformat();
//STRIP001 		SetSelection( GetText().Len() );
//STRIP001 	}
//STRIP001 	TimeField::Up();
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 // SdPagesField
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SdPagesField::SdPagesField( Window* pParent, SfxBindings& rBdx, WinBits nBits ) :
//STRIP001 	SvxMetricField	( pParent, rBdx, nBits ),
//STRIP001 	rBindings		( rBdx )
//STRIP001 {
//STRIP001 	String aStr( SdResId( STR_SLIDE_PLURAL ) );
//STRIP001 	SetCustomUnitText( aStr );
//STRIP001 
//STRIP001 	// Groesse setzen
//STRIP001 	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "XXX" ) );
//STRIP001 	Size aSize( GetTextWidth( aStr )+20, GetTextHeight()+6 );
//STRIP001 
//STRIP001 
//STRIP001 	SetSizePixel( aSize );
//STRIP001 
//STRIP001 	// Parameter des MetricFields setzen
//STRIP001 	SetUnit( FUNIT_CUSTOM );
//STRIP001 	SetMin( 1 );
//STRIP001 	SetFirst( 1 );
//STRIP001 	SetMax( 15 );
//STRIP001 	SetLast( 15 );
//STRIP001 	SetSpinSize( 1 );
//STRIP001 	SetDecimalDigits( 0 );
//STRIP001 	Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdPagesField::~SdPagesField()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPagesField::Update( const SfxUInt16Item* pItem )
//STRIP001 {
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = (long) pItem->GetValue();
//STRIP001 		SetValue( nValue );
//STRIP001 		if( nValue == 1 )
//STRIP001 			SetCustomUnitText( String( SdResId( STR_SLIDE_SINGULAR ) ) );
//STRIP001 		else
//STRIP001 			SetCustomUnitText( String( SdResId( STR_SLIDE_PLURAL ) ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetText( String() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPagesField::Modify()
//STRIP001 {
//STRIP001 	SfxUInt16Item aItem( SID_PAGES_PER_ROW, (UINT16) GetValue() );
//STRIP001 	rBindings.GetDispatcher()->Execute( 
//STRIP001 		SID_PAGES_PER_ROW, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L, 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 
//STRIP001 |*
//STRIP001 
//STRIP001 |* Klassen fuer DiaAttribute
//STRIP001 
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
SdTbxCtlDiaEffect::SdTbxCtlDiaEffect( USHORT nId, ToolBox& rTbx,
									SfxBindings& rBindings ) :
		SfxToolBoxControl( nId, rTbx, rBindings )
{DBG_BF_ASSERT(0, "STRIP");
}
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 void SdTbxCtlDiaEffect::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	// FadeEffecListBox vom Window (DiaEffectControl) holen
//STRIP001 	FadeEffectLB* pFadeEffectLB = (FadeEffectLB*) &( ( (DiaEffectControl*)
//STRIP001 				GetToolBox().GetItemWindow( SID_DIA_EFFECT ) )->aLbEffect );
//STRIP001 	if ( pFadeEffectLB )
//STRIP001 	{
//STRIP001 		if( pState )
//STRIP001 		{
//STRIP001 			pFadeEffectLB->Enable();
//STRIP001 			if ( IsInvalidItem( pState ) )
//STRIP001 			{
//STRIP001 				pFadeEffectLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				presentation::FadeEffect eFE = (presentation::FadeEffect) ( (const DiaEffectItem*) pState )->GetValue();
//STRIP001 				pFadeEffectLB->SelectEffect( eFE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pFadeEffectLB->Disable();
//STRIP001 			pFadeEffectLB->SetNoSelection();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 Window* SdTbxCtlDiaEffect::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	if( GetId() == SID_DIA_EFFECT )
//STRIP001 	{
//STRIP001 		return( new DiaEffectControl( pParent, GetBindings() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 /*************************************************************************/
//STRIP001 
SdTbxCtlDiaSpeed::SdTbxCtlDiaSpeed( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
	SfxToolBoxControl( nId, rTbx, rBindings )
{DBG_BF_ASSERT(0, "STRIP");
}
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 void SdTbxCtlDiaSpeed::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	// ListBox vom Window (DiaSpeedControl) holen
//STRIP001 	ListBox* pLB = (ListBox*) &( ( (DiaSpeedControl*)
//STRIP001 				GetToolBox().GetItemWindow( SID_DIA_SPEED ) )->aLbSpeed );
//STRIP001 	if ( pLB )
//STRIP001 	{
//STRIP001 		if( pState )
//STRIP001 		{
//STRIP001 			pLB->Enable();
//STRIP001 			if ( IsInvalidItem( pState ) )
//STRIP001 			{
//STRIP001 				pLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				FadeSpeed eFS = (FadeSpeed) ( (const DiaSpeedItem*) pState )->GetValue();
//STRIP001 				pLB->SelectEntryPos( eFS );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pLB->Disable();
//STRIP001 			pLB->SetNoSelection();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 Window* SdTbxCtlDiaSpeed::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	if( GetId() == SID_DIA_SPEED )
//STRIP001 	{
//STRIP001 		return( new DiaSpeedControl( pParent, GetBindings() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 /*************************************************************************/
//STRIP001 
SdTbxCtlDiaAuto::SdTbxCtlDiaAuto( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
		SfxToolBoxControl( nId, rTbx, rBindings )
{DBG_BF_ASSERT(0, "STRIP");
}
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 void SdTbxCtlDiaAuto::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	// ListBox vom Window (DiaAutoControl) holen
//STRIP001 	ListBox* pLB = (ListBox*) &( ( (DiaAutoControl*)
//STRIP001 				GetToolBox().GetItemWindow( SID_DIA_AUTO ) )->aLbAuto );
//STRIP001 	if ( pLB )
//STRIP001 	{
//STRIP001 		if( pState )
//STRIP001 		{
//STRIP001 			pLB->Enable();
//STRIP001 			if ( IsInvalidItem( pState ) )
//STRIP001 			{
//STRIP001 				pLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const PresChange eChange = ( (const DiaAutoItem*) pState )->GetValue();
//STRIP001 
//STRIP001 				if( eChange == PRESCHANGE_MANUAL )
//STRIP001 					pLB->SelectEntryPos( 0 ); // Manuell
//STRIP001 				else if( eChange == PRESCHANGE_SEMIAUTO )
//STRIP001 					pLB->SelectEntryPos( 1 ); // Halbautomatisch
//STRIP001 				else
//STRIP001 					pLB->SelectEntryPos( 2 ); // Automatisch
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pLB->Disable();
//STRIP001 			pLB->SetNoSelection();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 Window* SdTbxCtlDiaAuto::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	if( GetId() == SID_DIA_AUTO )
//STRIP001 	{
//STRIP001 		return( new DiaAutoControl( pParent, GetBindings() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 /*************************************************************************/
//STRIP001 
SdTbxCtlDiaTime::SdTbxCtlDiaTime( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings ) :
		SfxToolBoxControl( nId, rTbx, rBindings )
{DBG_BF_ASSERT(0, "STRIP");
}
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 void SdTbxCtlDiaTime::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	DiaTimeControl* pDTC = (DiaTimeControl*) GetToolBox().GetItemWindow( SID_DIA_TIME );
//STRIP001 
//STRIP001 	if ( pDTC )
//STRIP001 	{
//STRIP001 		if( pState )
//STRIP001 		{
//STRIP001 			pDTC->Enable();
//STRIP001 			if ( IsInvalidItem( pState ) )
//STRIP001 			{
//STRIP001 				pDTC->SetEmptyTime();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Selection* pSelection = NULL;
//STRIP001 				if( pDTC->HasChildPathFocus() )
//STRIP001 					pSelection = new Selection( pDTC->GetSelection() );
//STRIP001 
//STRIP001 				ULONG lTime = ( ( const DiaTimeItem* ) pState )->GetValue();
//STRIP001 				USHORT	nHour = (USHORT) ( lTime / 3600 );
//STRIP001 				USHORT	nMin  = (USHORT) ( ( lTime % 3600 ) / 60 );
//STRIP001 				USHORT	nSec  = (USHORT) ( ( lTime % 3600 ) % 60 );
//STRIP001 				Time aTime( nHour, nMin, nSec);
//STRIP001 
//STRIP001 				pDTC->SetTime( aTime );
//STRIP001 
//STRIP001 				if( pSelection )
//STRIP001 				{
//STRIP001 					pDTC->SetSelection( *pSelection );
//STRIP001 					delete pSelection;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pDTC->Disable();
//STRIP001 			pDTC->SetEmptyTime();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************/
//STRIP001 
//STRIP001 Window* SdTbxCtlDiaTime::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	if( GetId() == SID_DIA_TIME )
//STRIP001 	{
//STRIP001 		return( new DiaTimeControl( pParent, GetBindings(),
//STRIP001 				WinBits( WB_BORDER | WB_SPIN | WB_REPEAT ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SdTbxCtlDiaPages
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
SdTbxCtlDiaPages::SdTbxCtlDiaPages( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
	SfxToolBoxControl( nId, rTbx, rBind )//STRIP001 ,
//STRIP001 	rBindings( rBind )
{DBG_BF_ASSERT(0, "STRIP");
}
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SdTbxCtlDiaPages::~SdTbxCtlDiaPages()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SdTbxCtlDiaPages::StateChanged( USHORT nSID,
//STRIP001  				SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	SdPagesField* pFld = (SdPagesField*) GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pFld, "Window not found" );
//STRIP001 
//STRIP001 	if ( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pFld->Disable();
//STRIP001 		pFld->SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFld->Enable();
//STRIP001 
//STRIP001 		if ( eState == SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( pState->ISA(SfxUInt16Item), "falscher ItemType" )
//STRIP001 			pFld->Update( (const SfxUInt16Item*) pState );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pFld->Update( NULL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 Window* SdTbxCtlDiaPages::CreateItemWindow( Window* pParent )
//STRIP001 {
//STRIP001 	return new SdPagesField( pParent, rBindings );
//STRIP001 }



}
