/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fumorph.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:14:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XDEF_HXX
#include <bf_svx/xdef.hxx>
#endif

// auto strip #ifndef _SVX_FILLITEM_HXX //autogen
// auto strip #include <bf_svx/xfillit.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_XLINIIT_HXX //autogen
// auto strip #include <bf_svx/xlineit.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPOOL_HXX //autogen
// auto strip #include <bf_svx/svdpool.hxx>
// auto strip #endif
// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX //autogen
// auto strip #include <bf_svx/svdopath.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #include <bf_svx/eeitem.hxx>

#pragma hdrstop

// auto strip #include "sdview.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "morphdlg.hxx"
#include "strings.hrc"
// auto strip #include "sdresid.hxx"

#define _FUMORPH_PRIVATE
// auto strip #include "fumorph.hxx"
namespace binfilter {

#define  ITEMVALUE( ItemSet, Id, Cast ) ( ( (const Cast&) (ItemSet).Get( (Id) ) ).GetValue() )
//STRIP001 TYPEINIT1( FuMorph, FuPoor );
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // constructor
//STRIP001 //
//STRIP001 FuMorph::FuMorph(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
//STRIP001 	SdDrawDocument* pDoc, SfxRequest& rReq ) 
//STRIP001 :	FuPoor(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	const SdrMarkList&	rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 	if(rMarkList.GetMarkCount() == 2)
//STRIP001 	{
//STRIP001 		// Clones erzeugen
//STRIP001 		SdrObject*	pObj1 = rMarkList.GetMark(0)->GetObj();
//STRIP001 		SdrObject*	pObj2 = rMarkList.GetMark(1)->GetObj();
//STRIP001 		SdrObject*	pCloneObj1 = pObj1->Clone();
//STRIP001 		SdrObject*	pCloneObj2 = pObj2->Clone();
//STRIP001 
//STRIP001 		// Text am Clone loeschen, da wir sonst kein richtiges PathObj bekommen
//STRIP001 		pCloneObj1->SetOutlinerParaObject(NULL);
//STRIP001 		pCloneObj2->SetOutlinerParaObject(NULL);
//STRIP001 
//STRIP001 		// Path-Objekte erzeugen
//STRIP001 		SdrPathObj*	pPolyObj1 = (SdrPathObj*)pCloneObj1->ConvertToPolyObj(FALSE, FALSE);
//STRIP001 		SdrPathObj*	pPolyObj2 = (SdrPathObj*)pCloneObj2->ConvertToPolyObj(FALSE, FALSE);
//STRIP001 		SdMorphDlg aDlg((Window*)pWindow, pObj1, pObj2);
//STRIP001 
//STRIP001 		if(pPolyObj1 && pPolyObj2 && (aDlg.Execute() == RET_OK))
//STRIP001 		{
//STRIP001 			List aPolyPolyList3D;
//STRIP001 			PolyPolygon3D aPolyPoly1(pPolyObj1->GetPathPoly());
//STRIP001 			PolyPolygon3D aPolyPoly2(pPolyObj2->GetPathPoly());
//STRIP001 			PolyPolygon3D* pPolyPoly;
//STRIP001 
//STRIP001 			aDlg.SaveSettings();
//STRIP001 
//STRIP001 			// Morphing durchfuehren
//STRIP001 			if(aPolyPoly1.Count() && aPolyPoly2.Count())
//STRIP001 			{
//STRIP001 				aPolyPoly1.SetDirections();
//STRIP001 				aPolyPoly1.RemoveDoublePoints();
//STRIP001 				BOOL bIsClockwise1 = aPolyPoly1.IsClockwise();
//STRIP001 
//STRIP001 				aPolyPoly2.SetDirections();
//STRIP001 				aPolyPoly2.RemoveDoublePoints();
//STRIP001 				BOOL bIsClockwise2 = aPolyPoly2.IsClockwise();
//STRIP001 
//STRIP001 				// set same orientation
//STRIP001 				if(bIsClockwise1 != bIsClockwise2)
//STRIP001 					aPolyPoly2.FlipDirections();
//STRIP001 
//STRIP001 				// force same poly count
//STRIP001 				if(aPolyPoly1.Count() < aPolyPoly2.Count())
//STRIP001 					ImpAddPolys(aPolyPoly1, aPolyPoly2);
//STRIP001 				else if(aPolyPoly2.Count() < aPolyPoly1.Count())
//STRIP001 					ImpAddPolys(aPolyPoly2, aPolyPoly1);
//STRIP001 
//STRIP001 				// use orientation flag from dialog
//STRIP001 				if(!aDlg.IsOrientationFade())
//STRIP001 					aPolyPoly2.FlipDirections();
//STRIP001 
//STRIP001 				// force same point counts
//STRIP001 				for( USHORT a = 0; a < aPolyPoly1.Count(); a++ )
//STRIP001 				{
//STRIP001 					if(aPolyPoly1[ a].GetPointCount() < aPolyPoly2[ a].GetPointCount())
//STRIP001 						ImpEqualizePolyPointCount(aPolyPoly1[a], aPolyPoly2[a]);
//STRIP001 					else if(aPolyPoly2[a].GetPointCount() < aPolyPoly1[a].GetPointCount())
//STRIP001 						ImpEqualizePolyPointCount(aPolyPoly2[a], aPolyPoly1[a]);
//STRIP001 				}
//STRIP001 
//STRIP001 				if(ImpMorphPolygons(aPolyPoly1, aPolyPoly2, aDlg.GetFadeSteps(), aPolyPolyList3D))
//STRIP001 				{
//STRIP001 					String aString(pView->GetMarkDescription());
//STRIP001 
//STRIP001 					aString.Append(sal_Unicode(' '));
//STRIP001 					aString.Append(String(SdResId(STR_UNDO_MORPHING)));
//STRIP001 
//STRIP001 					pView->BegUndo(aString);
//STRIP001 					ImpInsertPolygons(aPolyPolyList3D, aDlg.IsAttributeFade(), pObj1, pObj2);
//STRIP001 					pView->EndUndo();
//STRIP001 				}
//STRIP001 
//STRIP001 				// erzeugte Polygone wieder loeschen
//STRIP001 				for(pPolyPoly = (PolyPolygon3D*)aPolyPolyList3D.First(); pPolyPoly; pPolyPoly = (PolyPolygon3D*)aPolyPolyList3D.Next())
//STRIP001 					delete pPolyPoly;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pCloneObj1;
//STRIP001 		delete pCloneObj2;
//STRIP001 
//STRIP001 		delete pPolyObj1;
//STRIP001 		delete pPolyObj2;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // make the point count of the polygons equal in adding points
//STRIP001 //
//STRIP001 void FuMorph::ImpEqualizePolyPointCount(Polygon3D& rSmall, const Polygon3D& rBig)
//STRIP001 {
//STRIP001 	// create poly with equal point count
//STRIP001 	const sal_uInt16 nCnt = rBig.GetPointCount();
//STRIP001 	Polygon3D aPoly1 = rSmall.GetExpandedPolygon(nCnt);
//STRIP001 
//STRIP001 	// create transformation for rBig to do the compare
//STRIP001 	Volume3D aSrcSize = rBig.GetPolySize();
//STRIP001 	Vector3D aSrcPos = (aSrcSize.MinVec() + aSrcSize.MaxVec()) / 2.0;
//STRIP001 	Volume3D aDstSize = rSmall.GetPolySize();
//STRIP001 	Vector3D aDstPos = (aDstSize.MinVec() + aDstSize.MaxVec()) / 2.0;
//STRIP001 	Matrix4D aTrans;
//STRIP001 	aTrans.Translate(-aSrcPos.X(), -aSrcPos.Y(), 0.0);
//STRIP001 	aTrans.Scale(
//STRIP001 		aDstSize.GetWidth()/aSrcSize.GetWidth(),
//STRIP001 		aDstSize.GetHeight()/aSrcSize.GetHeight(), 1.0);
//STRIP001 	aTrans.Translate(aDstPos.X(), aDstPos.Y(), 0.0);
//STRIP001 
//STRIP001 	// transpose points to have smooth linear blending
//STRIP001 	Polygon3D aPoly2(nCnt);
//STRIP001 	sal_uInt16 nInd = ImpGetNearestIndex(aPoly1, aTrans * rBig[0]);
//STRIP001 	for(sal_uInt16 a(0); a < nCnt; a++)
//STRIP001 		aPoly2[(a + nCnt - nInd) % nCnt] = aPoly1[a];
//STRIP001 
//STRIP001 	aPoly2.SetClosed(rBig.IsClosed());
//STRIP001 	rSmall = aPoly2;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 //
//STRIP001 sal_uInt16 FuMorph::ImpGetNearestIndex(const Polygon3D& rPoly, const Vector3D& rPos)
//STRIP001 {
//STRIP001 	double fMinDist;
//STRIP001 	sal_uInt16 nActInd;
//STRIP001 
//STRIP001 	for(sal_uInt16 a(0); a < rPoly.GetPointCount(); a++)
//STRIP001 	{
//STRIP001 		double fNewDist = (rPoly[a] - rPos).GetLength();
//STRIP001 		if(!a || fNewDist < fMinDist)
//STRIP001 		{
//STRIP001 			fMinDist = fNewDist;
//STRIP001 			nActInd = a;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nActInd;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // add to a point reduced polys until count is same
//STRIP001 //
//STRIP001 void FuMorph::ImpAddPolys(PolyPolygon3D& rSmaller, const PolyPolygon3D& rBigger)
//STRIP001 {
//STRIP001 	while(rSmaller.Count() < rBigger.Count())
//STRIP001 	{
//STRIP001 		const Polygon3D& rToBeCopied = rBigger[rSmaller.Count()];
//STRIP001 		Polygon3D aNewPoly(rToBeCopied.GetPointCount());
//STRIP001 		Volume3D aToBeCopiedPolySize = rToBeCopied.GetPolySize();
//STRIP001 		Vector3D aNewPoint = (aToBeCopiedPolySize.MinVec() + aToBeCopiedPolySize.MaxVec()) / 2.0;
//STRIP001 
//STRIP001 		Volume3D aSrcSize = rBigger[0].GetPolySize();
//STRIP001 		Vector3D aSrcPos = (aSrcSize.MinVec() + aSrcSize.MaxVec()) / 2.0;
//STRIP001 		Volume3D aDstSize = rSmaller[0].GetPolySize();
//STRIP001 		Vector3D aDstPos = (aDstSize.MinVec() + aDstSize.MaxVec()) / 2.0;
//STRIP001 		
//STRIP001 		aNewPoint = aNewPoint - aSrcPos + aDstPos;
//STRIP001 
//STRIP001 		for(sal_uInt16 a(0); a < rToBeCopied.GetPointCount(); a++)
//STRIP001 			aNewPoly[a] = aNewPoint;
//STRIP001 		
//STRIP001 		rSmaller.Insert(aNewPoly, POLYPOLY3D_APPEND);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // create group object with morphed polygons
//STRIP001 //
//STRIP001 void FuMorph::ImpInsertPolygons(List& rPolyPolyList3D, BOOL bAttributeFade,
//STRIP001 	const SdrObject* pObj1, const SdrObject* pObj2)
//STRIP001 {
//STRIP001 	Color				aStartFillCol;
//STRIP001 	Color				aEndFillCol;
//STRIP001 	Color				aStartLineCol;
//STRIP001 	Color				aEndLineCol;
//STRIP001 	long				nStartLineWidth;
//STRIP001 	long				nEndLineWidth;
//STRIP001 	SdrPageView*		pPageView = pView->GetPageViewPvNum( 0 );
//STRIP001 	SfxItemPool*		pPool = pObj1->GetItemPool();
//STRIP001 	SfxItemSet			aSet1( *pPool,SDRATTR_START,SDRATTR_NOTPERSIST_FIRST-1,EE_ITEMS_START,EE_ITEMS_END,0 );
//STRIP001 	SfxItemSet			aSet2( aSet1 );
//STRIP001 	BOOL				bLineColor = FALSE;
//STRIP001 	BOOL				bFillColor = FALSE;
//STRIP001 	BOOL				bLineWidth = FALSE;
//STRIP001 	BOOL				bIgnoreLine = FALSE;
//STRIP001 	BOOL				bIgnoreFill = FALSE;
//STRIP001 
//STRIP001 //-/	pObj1->TakeAttributes( aSet1, TRUE, FALSE );
//STRIP001 	aSet1.Put(pObj1->GetItemSet());
//STRIP001 
//STRIP001 //-/	pObj2->TakeAttributes( aSet2, TRUE, FALSE );
//STRIP001 	aSet2.Put(pObj2->GetItemSet());
//STRIP001 
//STRIP001 	const XLineStyle eLineStyle1 = ITEMVALUE( aSet1, XATTR_LINESTYLE, XLineStyleItem );
//STRIP001 	const XLineStyle eLineStyle2 = ITEMVALUE( aSet2, XATTR_LINESTYLE, XLineStyleItem );
//STRIP001 	const XFillStyle eFillStyle1 = ITEMVALUE( aSet1, XATTR_FILLSTYLE, XFillStyleItem );
//STRIP001 	const XFillStyle eFillStyle2 = ITEMVALUE( aSet2, XATTR_FILLSTYLE, XFillStyleItem );
//STRIP001 
//STRIP001 	if ( bAttributeFade )
//STRIP001 	{
//STRIP001 		if ( ( eLineStyle1 != XLINE_NONE ) && ( eLineStyle2 != XLINE_NONE ) )
//STRIP001 		{
//STRIP001 			bLineWidth = bLineColor = TRUE;
//STRIP001 
//STRIP001 			aStartLineCol = ITEMVALUE( aSet1, XATTR_LINECOLOR, XLineColorItem );
//STRIP001 			aEndLineCol = ITEMVALUE( aSet2, XATTR_LINECOLOR, XLineColorItem );
//STRIP001 
//STRIP001 			nStartLineWidth = ITEMVALUE( aSet1, XATTR_LINEWIDTH, XLineWidthItem );
//STRIP001 			nEndLineWidth = ITEMVALUE( aSet2, XATTR_LINEWIDTH, XLineWidthItem );
//STRIP001 		}
//STRIP001 		else if ( ( eLineStyle1 == XLINE_NONE ) && ( eLineStyle2 == XLINE_NONE ) )
//STRIP001 			bIgnoreLine = TRUE;
//STRIP001 
//STRIP001 		if ( ( eFillStyle1 == XFILL_SOLID ) && ( eFillStyle2 == XFILL_SOLID ) )
//STRIP001 		{
//STRIP001 			bFillColor = TRUE;
//STRIP001 			aStartFillCol = ITEMVALUE( aSet1, XATTR_FILLCOLOR, XFillColorItem );
//STRIP001 			aEndFillCol = ITEMVALUE( aSet2, XATTR_FILLCOLOR, XFillColorItem );
//STRIP001 		}
//STRIP001 		else if ( ( eFillStyle1 == XFILL_NONE ) && ( eFillStyle2 == XFILL_NONE ) )
//STRIP001 			bIgnoreFill = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pPageView )
//STRIP001 	{
//STRIP001 		SfxItemSet		aSet( aSet1 );
//STRIP001 		SdrObjGroup*	pObjGroup = new SdrObjGroup;
//STRIP001 		SdrObjList*		pObjList = pObjGroup->GetSubList();
//STRIP001 		const String	aEmptyStr;
//STRIP001 		const ULONG		nCount = rPolyPolyList3D.Count();
//STRIP001 		const double	fStep = 1. / ( nCount + 1 );
//STRIP001 		const double	fDelta = nEndLineWidth - nStartLineWidth;
//STRIP001 		double			fFactor = fStep;
//STRIP001 
//STRIP001 		aSet.Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001 		aSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 
//STRIP001 		for ( ULONG i = 0; i < nCount; i++, fFactor += fStep )
//STRIP001 		{
//STRIP001 			const PolyPolygon3D& rPolyPoly3D = *(PolyPolygon3D*)rPolyPolyList3D.GetObject(i);
//STRIP001 			SdrPathObj* pNewObj = new SdrPathObj(OBJ_POLY, rPolyPoly3D.GetXPolyPolygon());
//STRIP001 			B3dColor aLineCol, aFillCol;
//STRIP001 			aLineCol.CalcInBetween(aStartLineCol, aEndLineCol, fFactor);
//STRIP001 			aFillCol.CalcInBetween(aStartFillCol, aEndFillCol, fFactor);
//STRIP001 
//STRIP001 			// Linienfarbe
//STRIP001 			if ( bLineColor )
//STRIP001 				aSet.Put( XLineColorItem( aEmptyStr, aLineCol));
//STRIP001 			else if ( bIgnoreLine )
//STRIP001 				aSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 
//STRIP001 			// Fuellfarbe
//STRIP001 			if ( bFillColor )
//STRIP001 				aSet.Put( XFillColorItem( aEmptyStr, aFillCol));
//STRIP001 			else if ( bIgnoreFill )
//STRIP001 				aSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 			// Linienstaerke
//STRIP001 			if ( bLineWidth )
//STRIP001 				aSet.Put( XLineWidthItem( nStartLineWidth + (long) ( fFactor * fDelta + 0.5 ) ) );
//STRIP001 
//STRIP001 //-/			pNewObj->SetAttributes( aSet, FALSE );
//STRIP001 //-/			SdrBroadcastItemChange aItemChange(*pNewObj);
//STRIP001 			pNewObj->SetItemSetAndBroadcast(aSet);
//STRIP001 //-/			pNewObj->BroadcastItemChange(aItemChange);
//STRIP001 
//STRIP001 			pObjList->InsertObject( pNewObj, LIST_APPEND );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nCount )
//STRIP001 		{
//STRIP001 			pObjList->InsertObject( pObj1->Clone(), 0 );
//STRIP001 			pObjList->InsertObject( pObj2->Clone(), LIST_APPEND );
//STRIP001 			pView->DeleteMarked();
//STRIP001 			pView->InsertObject ( pObjGroup, *pPageView, SDRINSERT_SETDEFLAYER );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // create single morphed PolyPolygon
//STRIP001 //
//STRIP001 PolyPolygon3D* FuMorph::ImpCreateMorphedPolygon( 
//STRIP001 	const PolyPolygon3D& rPolyPolyStart, 
//STRIP001 	const PolyPolygon3D& rPolyPolyEnd,
//STRIP001 	const double fMorphingFactor)
//STRIP001 {
//STRIP001 	PolyPolygon3D* pNewPolyPolygon = new PolyPolygon3D();
//STRIP001 	const double fFactor = 1.0 - fMorphingFactor;
//STRIP001 
//STRIP001 	for(sal_uInt16 a(0); a < rPolyPolyStart.Count(); a++)
//STRIP001 	{
//STRIP001 		const Polygon3D& rPolyStart = rPolyPolyStart[a];
//STRIP001 		const Polygon3D& rPolyEnd = rPolyPolyEnd[a];
//STRIP001 		const sal_uInt16 nCount = rPolyStart.GetPointCount();
//STRIP001 		Polygon3D aNewPolygon(nCount);
//STRIP001 
//STRIP001 		for(sal_uInt16 b(0); b < nCount; b++)
//STRIP001 		{
//STRIP001 			const Vector3D& rPtStart = rPolyStart[b];
//STRIP001 			const Vector3D& rPtEnd = rPolyEnd[b];
//STRIP001 
//STRIP001 			aNewPolygon[b] = rPtEnd + ((rPtStart - rPtEnd) * fFactor);
//STRIP001 		}
//STRIP001 
//STRIP001 		aNewPolygon.SetClosed(rPolyStart.IsClosed() && rPolyEnd.IsClosed());
//STRIP001 
//STRIP001 		pNewPolyPolygon->Insert(aNewPolygon, POLYPOLY3D_APPEND);
//STRIP001 	}
//STRIP001 
//STRIP001 	return pNewPolyPolygon;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////////////
//STRIP001 // create morphed PolyPolygons
//STRIP001 //
//STRIP001 BOOL FuMorph::ImpMorphPolygons(
//STRIP001 	const PolyPolygon3D& rPolyPoly1, const PolyPolygon3D& rPolyPoly2,
//STRIP001 	const USHORT nSteps, List& rPolyPolyList3D)
//STRIP001 {
//STRIP001 	if(nSteps)
//STRIP001 	{
//STRIP001 		Volume3D aStartPolySize = rPolyPoly1.GetPolySize();
//STRIP001 		Vector3D aStartCenter = (aStartPolySize.MinVec() + aStartPolySize.MaxVec()) / 2.0;
//STRIP001 		Volume3D aEndPolySize = rPolyPoly2.GetPolySize();
//STRIP001 		Vector3D aEndCenter = (aEndPolySize.MinVec() + aEndPolySize.MaxVec()) / 2.0;
//STRIP001 		Vector3D aDelta = aEndCenter - aStartCenter;
//STRIP001 		const double fFactor = 1.0/(nSteps+1);
//STRIP001 		double fValue = 0.0;
//STRIP001 
//STRIP001 		for(sal_uInt16 i(0); i < nSteps; i++)
//STRIP001 		{
//STRIP001 			fValue += fFactor;
//STRIP001 			PolyPolygon3D* pNewPolyPoly3D = ImpCreateMorphedPolygon(rPolyPoly1, rPolyPoly2, fValue);
//STRIP001 
//STRIP001 			Volume3D aNewPolySize = pNewPolyPoly3D->GetPolySize();
//STRIP001 			Vector3D aNewS = (aNewPolySize.MinVec() + aNewPolySize.MaxVec()) / 2.0;
//STRIP001 			Vector3D aRealS = aStartCenter + (aDelta * fValue);
//STRIP001 			Matrix4D aTrans;
//STRIP001 			Vector3D aDiff = aRealS - aNewS;
//STRIP001 			aTrans.Translate(aDiff.X(), aDiff.Y(), aDiff.Z());
//STRIP001 			pNewPolyPoly3D->Transform(aTrans);
//STRIP001 			rPolyPolyList3D.Insert(pNewPolyPoly3D, LIST_APPEND);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }


}
