/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_shutdowniconw32.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:30:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef WNT

// Support Windows 95 too
#define WINVER 0x0400

//
// the systray icon is only available on windows
//

#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

#include "shutdownicon.hxx"
#include "app.hrc"
#include <shlobj.h>
#include <objidl.h>
#include <stdio.h>
#include <io.h>
#include <osl/thread.h>
#include <osl/file.hxx>

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XJOB_HPP_
#include <com/sun/star/task/XJob.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif
namespace binfilter {


using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::osl;


//STRIP001 #define LISTENER_WINDOWCLASS    "SO Listener Class"
//STRIP001 #define LISTENER_WINDOWNAME     "SO Listener Window"
//STRIP001 #define EXECUTER_WINDOWCLASS    "SO Executer Class"
//STRIP001 #define EXECUTER_WINDOWNAME     "SO Executer Window"
//STRIP001 #define KILLTRAY_MESSAGE		TEXT("SO KillTray")
//STRIP001 
//STRIP001 #define ID_QUICKSTART               1
//STRIP001 #define IDM_EXIT                    2
//STRIP001 #define IDM_OPEN                    3
//STRIP001 #define IDM_WRITER                  4
//STRIP001 #define IDM_CALC                    5
//STRIP001 #define IDM_IMPRESS                 6
//STRIP001 #define IDM_DRAW                    7
//STRIP001 #define IDM_TEMPLATE                8
//STRIP001 #define IDM_INSTALL                 9
//STRIP001 #define IDM_UNINSTALL               10
//STRIP001 
//STRIP001 
//STRIP001 #define WRITER_URL      "private:factory/swriter"
//STRIP001 #define CALC_URL        "private:factory/scalc"
//STRIP001 #define IMPRESS_URL     "private:factory/simpress"
//STRIP001 #define IMPRESS_WIZARD_URL     "private:factory/simpress?slot=10425"
//STRIP001 #define DRAW_URL        "private:factory/sdraw"
//STRIP001 #define MATH_URL        "private:factory/smath"
//STRIP001 
//STRIP001 #define ICON_SO_DEFAULT 				1
//STRIP001 #define ICON_TEXT_DOCUMENT				2
//STRIP001 #define ICON_TEXT_TEMPLATE				3
//STRIP001 #define ICON_SPREADSHEET_DOCUMENT		4
//STRIP001 #define ICON_SPREADSHEET_TEMPLATE		5
//STRIP001 #define ICON_DRAWING_DOCUMENT			6
//STRIP001 #define ICON_DRAWING_TEMPLATE			7
//STRIP001 #define ICON_PRESENTATION_DOCUMENT		8
//STRIP001 #define ICON_PRESENTATION_TEMPLATE		9
//STRIP001 #define ICON_PRESENTATION_COMPRESSED	10
//STRIP001 #define ICON_GLOBAL_DOCUMENT			11
//STRIP001 #define ICON_HTML_DOCUMENT				12
//STRIP001 #define ICON_CHART_DOCUMENT				13
//STRIP001 #define ICON_DATABASE_DOCUMENT			14
//STRIP001 #define ICON_MATH_DOCUMENT				15
//STRIP001 #define ICON_TEMPLATE					16
//STRIP001 #define ICON_MACROLIBRARY				17
//STRIP001 #define ICON_CONFIGURATION				18
//STRIP001 #define ICON_OPEN						19
//STRIP001 #define ICON_SETUP						500
//STRIP001 
//STRIP001 #define SFX_TASKBAR_NOTIFICATION    WM_USER+1
//STRIP001 
//STRIP001 static HWND aListenerWindow = NULL;
//STRIP001 static HWND aExecuterWindow = NULL;
//STRIP001 static BOOL	bModalMode = FALSE;
//STRIP001 
//STRIP001 static void OnMeasureItem(HWND hwnd, LPMEASUREITEMSTRUCT lpmis);
//STRIP001 static void OnDrawItem(HWND hwnd, LPDRAWITEMSTRUCT lpdis);
//STRIP001 
//STRIP001 typedef struct tagMYITEM
//STRIP001 {
//STRIP001     OUString text;
//STRIP001     UINT iconId;
//STRIP001 } MYITEM;
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static bool isNT()
//STRIP001 {
//STRIP001     static bool bInitialized    = false;
//STRIP001     static bool bWnt            = false;
//STRIP001 
//STRIP001     if( !bInitialized )
//STRIP001     {
//STRIP001         bInitialized = true;
//STRIP001 
//STRIP001 	    OSVERSIONINFO   aVerInfo;
//STRIP001 	    aVerInfo.dwOSVersionInfoSize = sizeof( aVerInfo );
//STRIP001 	    if ( GetVersionEx( &aVerInfo ) )
//STRIP001 	    {
//STRIP001 		    if ( aVerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
//STRIP001 			    bWnt = true;
//STRIP001 	    }
//STRIP001     }
//STRIP001     return bWnt;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static void addMenuItem( HMENU hMenu, UINT id, UINT iconId, OUString& text, int& pos, int bOwnerdraw )
//STRIP001 {
//STRIP001     MENUITEMINFOW mi;
//STRIP001     memset( &mi, 0, sizeof( MENUITEMINFOW ) );
//STRIP001 
//STRIP001     mi.cbSize = sizeof( MENUITEMINFOW );
//STRIP001     if( id == -1 )
//STRIP001     {
//STRIP001         mi.fMask=MIIM_TYPE;
//STRIP001         mi.fType=MFT_SEPARATOR;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         if( bOwnerdraw )
//STRIP001         {
//STRIP001             mi.fMask=MIIM_TYPE | MIIM_STATE | MIIM_ID | MIIM_DATA;
//STRIP001             mi.fType=MFT_OWNERDRAW;
//STRIP001             mi.fState=MFS_ENABLED;
//STRIP001             mi.wID = id;
//STRIP001 
//STRIP001             MYITEM *pMyItem = new MYITEM;
//STRIP001             pMyItem->text = text;
//STRIP001             pMyItem->iconId = iconId;
//STRIP001             mi.dwItemData = (DWORD) pMyItem;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             mi.fMask=MIIM_TYPE | MIIM_STATE | MIIM_ID | MIIM_DATA;
//STRIP001             mi.fType=MFT_STRING;
//STRIP001             mi.fState=MFS_ENABLED;
//STRIP001             mi.wID = id;
//STRIP001             mi.dwTypeData = (LPWSTR) text.getStr();
//STRIP001             mi.cch = text.getLength();
//STRIP001         }
//STRIP001 
//STRIP001 		if ( IDM_TEMPLATE == id )
//STRIP001 			mi.fState |= MFS_DEFAULT;
//STRIP001     }
//STRIP001 
//STRIP001     InsertMenuItemW( hMenu, pos++, TRUE, &mi );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static HMENU createSystrayMenu( )
//STRIP001 {
//STRIP001 	SvtModuleOptions	aModuleOptions;
//STRIP001 
//STRIP001     HMENU hMenu = CreatePopupMenu();
//STRIP001     int pos=0;
//STRIP001 
//STRIP001     ShutdownIcon *pShutdownIcon = ShutdownIcon::getInstance();
//STRIP001     OSL_ENSURE( pShutdownIcon, "ShutdownIcon instance empty!");
//STRIP001 
//STRIP001     if( !pShutdownIcon )
//STRIP001         return NULL;
//STRIP001 
//STRIP001 	if ( aModuleOptions.IsWriter() )
//STRIP001 		addMenuItem( hMenu, IDM_WRITER, ICON_TEXT_DOCUMENT,
//STRIP001 			pShutdownIcon->GetUrlDescription( OUString( RTL_CONSTASCII_USTRINGPARAM ( WRITER_URL ) ) ), pos, true );
//STRIP001 	if ( aModuleOptions.IsCalc() )
//STRIP001 		addMenuItem( hMenu, IDM_CALC, ICON_SPREADSHEET_DOCUMENT,
//STRIP001 			pShutdownIcon->GetUrlDescription( OUString( RTL_CONSTASCII_USTRINGPARAM ( CALC_URL ) ) ), pos, true );
//STRIP001 	if ( aModuleOptions.IsImpress() )
//STRIP001 		addMenuItem( hMenu, IDM_IMPRESS, ICON_PRESENTATION_DOCUMENT,
//STRIP001 			pShutdownIcon->GetUrlDescription( OUString( RTL_CONSTASCII_USTRINGPARAM ( IMPRESS_URL ) ) ), pos, true );
//STRIP001 	if ( aModuleOptions.IsDraw() )
//STRIP001 		addMenuItem( hMenu, IDM_DRAW, ICON_DRAWING_DOCUMENT,
//STRIP001 			pShutdownIcon->GetUrlDescription( OUString( RTL_CONSTASCII_USTRINGPARAM ( DRAW_URL ) ) ), pos, true );
//STRIP001     addMenuItem( hMenu, IDM_TEMPLATE, ICON_TEMPLATE,
//STRIP001         pShutdownIcon->GetResString( STR_QUICKSTART_FROMTEMPLATE ), pos, true);
//STRIP001     addMenuItem( hMenu, -1,         0, OUString(), pos, false );
//STRIP001     addMenuItem( hMenu, IDM_OPEN,   ICON_OPEN, pShutdownIcon->GetResString( STR_QUICKSTART_FILEOPEN ), pos, true );
//STRIP001     addMenuItem( hMenu, -1,         0, OUString(), pos, false );
//STRIP001     addMenuItem( hMenu, IDM_INSTALL,0, pShutdownIcon->GetResString( STR_QUICKSTART_PRELAUNCH ), pos, false );
//STRIP001     addMenuItem( hMenu, -1,         0, OUString(), pos, false );
//STRIP001     addMenuItem( hMenu, IDM_EXIT,   0, pShutdownIcon->GetResString( STR_QUICKSTART_EXIT ), pos, false );
//STRIP001 
//STRIP001     // indicate status of autostart folder
//STRIP001     CheckMenuItem( hMenu, IDM_INSTALL, MF_BYCOMMAND | (ShutdownIcon::GetAutostart() ? MF_CHECKED : MF_UNCHECKED) );
//STRIP001 
//STRIP001     return hMenu;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static void deleteSystrayMenu( HMENU hMenu )
//STRIP001 {
//STRIP001     if( !hMenu )
//STRIP001         return;
//STRIP001 
//STRIP001     MENUITEMINFOW mi;
//STRIP001     MYITEM *pMyItem;
//STRIP001     int pos=0;
//STRIP001     memset( &mi, 0, sizeof( mi ) );
//STRIP001     mi.cbSize = sizeof( mi );
//STRIP001     mi.fMask = MIIM_DATA;
//STRIP001 
//STRIP001     while( GetMenuItemInfoW( hMenu, pos++, true, &mi ) )
//STRIP001     {
//STRIP001         pMyItem = (MYITEM*) mi.dwItemData;
//STRIP001         if( pMyItem )
//STRIP001         {
//STRIP001             pMyItem->text = OUString();
//STRIP001             delete pMyItem;
//STRIP001         }
//STRIP001         mi.fMask = MIIM_DATA;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static void addTaskbarIcon( HWND hWnd )
//STRIP001 {
//STRIP001     OUString strTip;
//STRIP001     if( ShutdownIcon::getInstance() )
//STRIP001         strTip = ShutdownIcon::getInstance()->GetResString( STR_QUICKSTART_TIP );
//STRIP001 
//STRIP001     // add taskbar icon
//STRIP001     NOTIFYICONDATAA nid;
//STRIP001     nid.hIcon = (HICON)LoadImageA( GetModuleHandle( NULL ), MAKEINTRESOURCE( ICON_SO_DEFAULT ),
//STRIP001         IMAGE_ICON, GetSystemMetrics( SM_CXSMICON ), GetSystemMetrics( SM_CYSMICON ),
//STRIP001         LR_DEFAULTCOLOR | LR_SHARED );
//STRIP001 
//STRIP001     // better use unicode wrapper here ?
//STRIP001     strncpy( nid.szTip, ( OUStringToOString(strTip, osl_getThreadTextEncoding()).getStr() ), 64 );
//STRIP001 
//STRIP001     nid.cbSize              = sizeof(nid);
//STRIP001     nid.hWnd                = hWnd;
//STRIP001     nid.uID                 = ID_QUICKSTART;
//STRIP001     nid.uCallbackMessage    = SFX_TASKBAR_NOTIFICATION;
//STRIP001     nid.uFlags              = NIF_MESSAGE|NIF_TIP|NIF_ICON;
//STRIP001 
//STRIP001     Shell_NotifyIconA(NIM_ADD, &nid);
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 LRESULT CALLBACK listenerWndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
//STRIP001 {
//STRIP001     static HMENU popupMenu = NULL;
//STRIP001 
//STRIP001     static UINT s_uTaskbarRestart = 0;
//STRIP001     static UINT s_uMsgKillTray = 0;
//STRIP001 
//STRIP001     switch (uMsg)
//STRIP001     {
//STRIP001         case WM_NCCREATE:
//STRIP001             return TRUE;
//STRIP001         case WM_CREATE:
//STRIP001             {
//STRIP001                 // request notfication when taskbar is recreated
//STRIP001                 // we then have to add our icon again
//STRIP001                 s_uTaskbarRestart = RegisterWindowMessage(TEXT("TaskbarCreated"));
//STRIP001                 s_uMsgKillTray = RegisterWindowMessage( KILLTRAY_MESSAGE );
//STRIP001 
//STRIP001                 // create the menu
//STRIP001                 if( !popupMenu )
//STRIP001                     if( (popupMenu = createSystrayMenu( )) == NULL )
//STRIP001                         return -1;
//STRIP001 
//STRIP001                 // and the icon
//STRIP001                 addTaskbarIcon( hWnd );
//STRIP001 
//STRIP001                 // disable shutdown
//STRIP001                 ShutdownIcon::getInstance()->SetVeto( true );
//STRIP001 				ShutdownIcon::getInstance()->addTerminateListener();
//STRIP001             }
//STRIP001             return 0;
//STRIP001 
//STRIP001         case WM_MEASUREITEM:
//STRIP001             OnMeasureItem(hWnd, (LPMEASUREITEMSTRUCT) lParam);
//STRIP001             return TRUE;
//STRIP001 
//STRIP001         case WM_DRAWITEM:
//STRIP001             OnDrawItem(hWnd, (LPDRAWITEMSTRUCT) lParam);
//STRIP001             return TRUE;
//STRIP001 
//STRIP001         case SFX_TASKBAR_NOTIFICATION:
//STRIP001             switch( lParam )
//STRIP001             {
//STRIP001                 case WM_LBUTTONDBLCLK:
//STRIP001 					PostMessage( aExecuterWindow, WM_COMMAND, IDM_TEMPLATE, (LPARAM)hWnd );
//STRIP001                     break;
//STRIP001 
//STRIP001                 case WM_RBUTTONDOWN:
//STRIP001                 {
//STRIP001                     POINT pt;
//STRIP001                     GetCursorPos(&pt);
//STRIP001                     SetForegroundWindow( hWnd );
//STRIP001 
//STRIP001                     // update status before showing menu, could have been changed from option page
//STRIP001                     CheckMenuItem( popupMenu, IDM_INSTALL, MF_BYCOMMAND| (ShutdownIcon::GetAutostart() ? MF_CHECKED : MF_UNCHECKED) );
//STRIP001 
//STRIP001 					EnableMenuItem( popupMenu, IDM_EXIT, MF_BYCOMMAND | (bModalMode ? MF_GRAYED : MF_ENABLED) );
//STRIP001 					EnableMenuItem( popupMenu, IDM_OPEN, MF_BYCOMMAND | (bModalMode ? MF_GRAYED : MF_ENABLED) );
//STRIP001 					EnableMenuItem( popupMenu, IDM_TEMPLATE, MF_BYCOMMAND | (bModalMode ? MF_GRAYED : MF_ENABLED) );
//STRIP001 
//STRIP001                     int m = TrackPopupMenuEx( popupMenu, TPM_RETURNCMD|TPM_LEFTALIGN|TPM_RIGHTBUTTON,
//STRIP001                                               pt.x, pt.y, hWnd, NULL );
//STRIP001                     // BUGFIX: See Q135788 (PRB: Menus for Notification Icons Don't Work Correctly)
//STRIP001                     PostMessage( hWnd, NULL, 0, 0 );
//STRIP001                     switch( m )
//STRIP001                     {
//STRIP001                         case IDM_OPEN:
//STRIP001                         case IDM_WRITER:
//STRIP001                         case IDM_CALC:
//STRIP001                         case IDM_IMPRESS:
//STRIP001                         case IDM_DRAW:
//STRIP001                         case IDM_TEMPLATE:
//STRIP001 							break;
//STRIP001                         case IDM_INSTALL:
//STRIP001                             CheckMenuItem( popupMenu, IDM_INSTALL, MF_BYCOMMAND| (ShutdownIcon::GetAutostart() ? MF_CHECKED : MF_UNCHECKED) );
//STRIP001                             break;
//STRIP001                         case IDM_EXIT:
//STRIP001                             // delete taskbar icon
//STRIP001                             NOTIFYICONDATAA nid;
//STRIP001                             nid.cbSize=sizeof(NOTIFYICONDATA);
//STRIP001                             nid.hWnd = hWnd;
//STRIP001                             nid.uID = ID_QUICKSTART;
//STRIP001                             Shell_NotifyIconA(NIM_DELETE, &nid);
//STRIP001 
//STRIP001                             break;
//STRIP001                     }
//STRIP001 
//STRIP001 					PostMessage( aExecuterWindow, WM_COMMAND, m, (LPARAM)hWnd );
//STRIP001                 }
//STRIP001                 break;
//STRIP001             }
//STRIP001             break;
//STRIP001         case WM_DESTROY:
//STRIP001             deleteSystrayMenu( popupMenu );
//STRIP001 			// We don't need the Systray Thread anymore
//STRIP001 			PostQuitMessage( 0 );
//STRIP001             return DefWindowProc(hWnd, uMsg, wParam, lParam);
//STRIP001         default:
//STRIP001             if( uMsg == s_uTaskbarRestart )
//STRIP001             {
//STRIP001                 // re-create taskbar icon
//STRIP001                 addTaskbarIcon( hWnd );
//STRIP001             }
//STRIP001 			else if ( uMsg == s_uMsgKillTray )
//STRIP001 			{
//STRIP001                 // delete taskbar icon
//STRIP001                 NOTIFYICONDATAA nid;
//STRIP001                 nid.cbSize=sizeof(NOTIFYICONDATA);
//STRIP001                 nid.hWnd = hWnd;
//STRIP001                 nid.uID = ID_QUICKSTART;
//STRIP001                 Shell_NotifyIconA(NIM_DELETE, &nid);
//STRIP001 
//STRIP001 				PostMessage( aExecuterWindow, WM_COMMAND, IDM_EXIT, (LPARAM)hWnd );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				return DefWindowProc(hWnd, uMsg, wParam, lParam);
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 static sal_Bool checkOEM() {
//STRIP001     Reference<XMultiServiceFactory> rFactory =::legacy_binfilters::getLegacyProcessServiceFactory(); //STRIP002 ::comphelper::getProcessServiceFactory();
//STRIP001     Reference<XJob> rOemJob(rFactory->createInstance(
//STRIP001         OUString::createFromAscii("com.sun.star.office.OEMPreloadJob")),
//STRIP001         UNO_QUERY );
//STRIP001     Sequence<NamedValue> args;
//STRIP001     sal_Bool bResult = sal_False;
//STRIP001     if (rOemJob.is())
//STRIP001     {
//STRIP001         Any aResult = rOemJob->execute(args);
//STRIP001         aResult >>= bResult;
//STRIP001     	return bResult;
//STRIP001     } else bResult = sal_True;
//STRIP001 }

//STRIP001 LRESULT CALLBACK executerWndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
//STRIP001 {
//STRIP001     static HMENU popupMenu = NULL;
//STRIP001 
//STRIP001     switch (uMsg)
//STRIP001     {
//STRIP001         case WM_NCCREATE:
//STRIP001             return TRUE;
//STRIP001         case WM_CREATE:
//STRIP001             return 0;
//STRIP001 
//STRIP001         case WM_COMMAND:
//STRIP001             switch( LOWORD(wParam) )
//STRIP001             {
//STRIP001                 case IDM_OPEN:
//STRIP001 					if ( !bModalMode && checkOEM() )
//STRIP001 						ShutdownIcon::FileOpen();
//STRIP001                 break;
//STRIP001                 case IDM_WRITER:
//STRIP001                     if (checkOEM())
//STRIP001                     ShutdownIcon::OpenURL( OUString( RTL_CONSTASCII_USTRINGPARAM( WRITER_URL ) ), OUString( RTL_CONSTASCII_USTRINGPARAM( "_default" ) ) );
//STRIP001                 break;
//STRIP001                 case IDM_CALC:
//STRIP001                     if (checkOEM())
//STRIP001                     ShutdownIcon::OpenURL( OUString( RTL_CONSTASCII_USTRINGPARAM( CALC_URL ) ), OUString( RTL_CONSTASCII_USTRINGPARAM( "_default" ) ) );
//STRIP001                 break;
//STRIP001                 case IDM_IMPRESS:
//STRIP001                     if (checkOEM())
//STRIP001                     ShutdownIcon::OpenURL( OUString( RTL_CONSTASCII_USTRINGPARAM( IMPRESS_WIZARD_URL ) ), OUString( RTL_CONSTASCII_USTRINGPARAM( "_default" ) ) );
//STRIP001                 break;
//STRIP001                 case IDM_DRAW:
//STRIP001                     if (checkOEM())
//STRIP001                     ShutdownIcon::OpenURL( OUString( RTL_CONSTASCII_USTRINGPARAM( DRAW_URL ) ), OUString( RTL_CONSTASCII_USTRINGPARAM( "_default" ) ) );
//STRIP001                 break;
//STRIP001                 case IDM_TEMPLATE:
//STRIP001 					if ( !bModalMode && checkOEM())
//STRIP001 						ShutdownIcon::FromTemplate();
//STRIP001                 break;
//STRIP001                 case IDM_INSTALL:
//STRIP001                     ShutdownIcon::SetAutostart( !ShutdownIcon::GetAutostart() );
//STRIP001                     break;
//STRIP001                 case IDM_EXIT:
//STRIP001                     // remove listener and
//STRIP001                     //  terminate office if running in background
//STRIP001 					if ( !bModalMode )
//STRIP001 						ShutdownIcon::terminateDesktop();
//STRIP001                     break;
//STRIP001             }
//STRIP001 			break;
//STRIP001         case WM_DESTROY:
//STRIP001         default:
//STRIP001             return DefWindowProc(hWnd, uMsg, wParam, lParam);
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 
//STRIP001 DWORD WINAPI SystrayThread( LPVOID lpParam )
//STRIP001 {
//STRIP001 	aListenerWindow = CreateWindowExA(0,
//STRIP001         LISTENER_WINDOWCLASS,	    // registered class name
//STRIP001         LISTENER_WINDOWNAME,        // window name
//STRIP001         0,          				// window style
//STRIP001         CW_USEDEFAULT,			    // horizontal position of window
//STRIP001         CW_USEDEFAULT,			    // vertical position of window
//STRIP001         CW_USEDEFAULT,			    // window width
//STRIP001         CW_USEDEFAULT,			    // window height
//STRIP001         (HWND) NULL,	            // handle to parent or owner window
//STRIP001         NULL,						// menu handle or child identifier
//STRIP001         (HINSTANCE) GetModuleHandle( NULL ),    // handle to application instance
//STRIP001         NULL						// window-creation data
//STRIP001         );
//STRIP001 
//STRIP001 	MSG	msg;
//STRIP001 
//STRIP001 	while ( GetMessage( &msg, NULL, 0, 0 ) )
//STRIP001 	{
//STRIP001 		TranslateMessage( &msg );
//STRIP001 		DispatchMessage( &msg );
//STRIP001 	}
//STRIP001 
//STRIP001 	return msg.wParam; // Exit code of WM_QUIT
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void ShutdownIcon::initSystray()
//STRIP001 {
//STRIP001 
//STRIP001 	WNDCLASSEXA listenerClass;
//STRIP001     listenerClass.cbSize		= sizeof(WNDCLASSEX);
//STRIP001     listenerClass.style			= 0;
//STRIP001     listenerClass.lpfnWndProc	= listenerWndProc;
//STRIP001     listenerClass.cbClsExtra	= 0;
//STRIP001     listenerClass.cbWndExtra	= 0;
//STRIP001     listenerClass.hInstance		= (HINSTANCE) GetModuleHandle( NULL );
//STRIP001     listenerClass.hIcon			= NULL;
//STRIP001     listenerClass.hCursor		= NULL;
//STRIP001     listenerClass.hbrBackground	= NULL;
//STRIP001     listenerClass.lpszMenuName	= NULL;
//STRIP001     listenerClass.lpszClassName	= LISTENER_WINDOWCLASS;
//STRIP001     listenerClass.hIconSm	    = NULL;
//STRIP001 
//STRIP001 	RegisterClassExA(&listenerClass);
//STRIP001 
//STRIP001 	WNDCLASSEXA executerClass;
//STRIP001     executerClass.cbSize		= sizeof(WNDCLASSEX);
//STRIP001     executerClass.style			= 0;
//STRIP001     executerClass.lpfnWndProc	= executerWndProc;
//STRIP001     executerClass.cbClsExtra	= 0;
//STRIP001     executerClass.cbWndExtra	= 0;
//STRIP001     executerClass.hInstance		= (HINSTANCE) GetModuleHandle( NULL );
//STRIP001     executerClass.hIcon			= NULL;
//STRIP001     executerClass.hCursor		= NULL;
//STRIP001     executerClass.hbrBackground	= NULL;
//STRIP001     executerClass.lpszMenuName	= NULL;
//STRIP001     executerClass.lpszClassName	= EXECUTER_WINDOWCLASS;
//STRIP001     executerClass.hIconSm	    = NULL;
//STRIP001 
//STRIP001 	RegisterClassExA( &executerClass );
//STRIP001 
//STRIP001 	aExecuterWindow = CreateWindowExA(0,
//STRIP001         EXECUTER_WINDOWCLASS,	    // registered class name
//STRIP001         EXECUTER_WINDOWNAME,        // window name
//STRIP001         0,          				// window style
//STRIP001         CW_USEDEFAULT,			    // horizontal position of window
//STRIP001         CW_USEDEFAULT,			    // vertical position of window
//STRIP001         CW_USEDEFAULT,			    // window width
//STRIP001         CW_USEDEFAULT,			    // window height
//STRIP001         (HWND) NULL,	            // handle to parent or owner window
//STRIP001         NULL,						// menu handle or child identifier
//STRIP001         (HINSTANCE) GetModuleHandle( NULL ),    // handle to application instance
//STRIP001         NULL						// window-creation data
//STRIP001         );
//STRIP001 
//STRIP001 	DWORD	dwThreadId;
//STRIP001 	HANDLE	hThread = CreateThread( NULL, 0, SystrayThread, this, 0, &dwThreadId );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void ShutdownIcon::deInitSystray()
//STRIP001 {
//STRIP001     if( IsWindow( aListenerWindow ) )
//STRIP001     {
//STRIP001         DestroyWindow( aListenerWindow );
//STRIP001         aListenerWindow = NULL;
//STRIP001         DestroyWindow( aExecuterWindow );
//STRIP001         aExecuterWindow = NULL;
//STRIP001     }
//STRIP001     UnregisterClassA( LISTENER_WINDOWCLASS, GetModuleHandle( NULL ) );
//STRIP001     UnregisterClassA( EXECUTER_WINDOWCLASS, GetModuleHandle( NULL ) );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void ShutdownIcon::EnterModalMode()
//STRIP001 {
//STRIP001 	bModalMode = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void ShutdownIcon::LeaveModalMode()
//STRIP001 {
//STRIP001 	bModalMode = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void OnMeasureItem(HWND hwnd, LPMEASUREITEMSTRUCT lpmis)
//STRIP001 {
//STRIP001     MYITEM *pMyItem = (MYITEM *) lpmis->itemData;
//STRIP001     HDC hdc = GetDC(hwnd);
//STRIP001     SIZE size;
//STRIP001 
//STRIP001 	NONCLIENTMETRICS ncm;
//STRIP001 	memset(&ncm, 0, sizeof(ncm));
//STRIP001 	ncm.cbSize = sizeof(ncm);
//STRIP001 
//STRIP001 	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, (PVOID) &ncm, 0);
//STRIP001 
//STRIP001 	// Assume every menu item can be default and printed bold
//STRIP001 	ncm.lfMenuFont.lfWeight = FW_BOLD;
//STRIP001 
//STRIP001     HFONT hfntOld = (HFONT) SelectObject(hdc, (HFONT) CreateFontIndirect( &ncm.lfMenuFont ));
//STRIP001 
//STRIP001     GetTextExtentPoint32W(hdc, pMyItem->text.getStr(),
//STRIP001             pMyItem->text.getLength(), &size);
//STRIP001 
//STRIP001     lpmis->itemWidth = size.cx + 4 + GetSystemMetrics( SM_CXSMICON );
//STRIP001     lpmis->itemHeight = (size.cy > GetSystemMetrics( SM_CYSMICON )) ? size.cy : GetSystemMetrics( SM_CYSMICON );
//STRIP001     lpmis->itemHeight += 4;
//STRIP001 
//STRIP001     DeleteObject( SelectObject(hdc, hfntOld) );
//STRIP001     ReleaseDC(hwnd, hdc);
//STRIP001 }
//STRIP001 
//STRIP001 void OnDrawItem(HWND hwnd, LPDRAWITEMSTRUCT lpdis)
//STRIP001 {
//STRIP001     MYITEM *pMyItem = (MYITEM *) lpdis->itemData;
//STRIP001     COLORREF clrPrevText, clrPrevBkgnd;
//STRIP001     HFONT hfntOld;
//STRIP001     HBRUSH hbrOld;
//STRIP001     int x, y;
//STRIP001 	BOOL	fSelected = lpdis->itemState & ODS_SELECTED;
//STRIP001 	BOOL	fDisabled = lpdis->itemState & (ODS_DISABLED | ODS_GRAYED);
//STRIP001 
//STRIP001     // Set the appropriate foreground and background colors.
//STRIP001 
//STRIP001     RECT aRect = lpdis->rcItem;
//STRIP001 
//STRIP001     clrPrevBkgnd = SetBkColor( lpdis->hDC, GetSysColor(COLOR_MENU) );
//STRIP001 
//STRIP001 	if ( fDisabled )
//STRIP001         clrPrevText = SetTextColor( lpdis->hDC, GetSysColor( COLOR_GRAYTEXT ) );
//STRIP001 	else
//STRIP001         clrPrevText = SetTextColor( lpdis->hDC, GetSysColor( fSelected ? COLOR_HIGHLIGHTTEXT : COLOR_MENUTEXT ) );
//STRIP001 
//STRIP001 	if ( fSelected )
//STRIP001 		clrPrevBkgnd = SetBkColor( lpdis->hDC, GetSysColor(COLOR_HIGHLIGHT) );
//STRIP001 	else
//STRIP001 		clrPrevBkgnd = SetBkColor( lpdis->hDC, GetSysColor(COLOR_MENU) );
//STRIP001 
//STRIP001 	hbrOld = (HBRUSH)SelectObject( lpdis->hDC, CreateSolidBrush( GetBkColor( lpdis->hDC ) ) );
//STRIP001 
//STRIP001     // Fill background
//STRIP001     PatBlt(lpdis->hDC, aRect.left, aRect.top, aRect.right-aRect.left, aRect.bottom-aRect.top, PATCOPY);
//STRIP001 
//STRIP001     int height = aRect.bottom-aRect.top;
//STRIP001 
//STRIP001     x = aRect.left;
//STRIP001     y = aRect.top;
//STRIP001 
//STRIP001     int cx = GetSystemMetrics( SM_CXSMICON );
//STRIP001     int cy = GetSystemMetrics( SM_CYSMICON );
//STRIP001     HICON hIcon = (HICON) LoadImageA( GetModuleHandle( NULL ), MAKEINTRESOURCE( pMyItem->iconId ),
//STRIP001                                       IMAGE_ICON, cx, cy,
//STRIP001                                       LR_DEFAULTCOLOR | LR_SHARED );
//STRIP001 
//STRIP001     // DrawIconEx( lpdis->hDC, x, y+(height-cy)/2, hIcon, cx, cy, 0, NULL, DI_NORMAL );
//STRIP001 
//STRIP001 	HBRUSH hbrIcon = CreateSolidBrush( GetSysColor( COLOR_GRAYTEXT ) );
//STRIP001 
//STRIP001 	DrawStateW( lpdis->hDC, (HBRUSH)hbrIcon, (DRAWSTATEPROC)NULL, (LPARAM)hIcon, (WPARAM)0, x, y+(height-cy)/2, 0, 0, DST_ICON | (fDisabled ? (fSelected ? DSS_MONO : DSS_DISABLED) : DSS_NORMAL) );
//STRIP001 
//STRIP001 	DeleteObject( hbrIcon );
//STRIP001 
//STRIP001     x += cx + 4;    // space for icon
//STRIP001     aRect.left = x;
//STRIP001 
//STRIP001 	NONCLIENTMETRICS ncm;
//STRIP001 	memset(&ncm, 0, sizeof(ncm));
//STRIP001 	ncm.cbSize = sizeof(ncm);
//STRIP001 
//STRIP001 	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, (PVOID) &ncm, 0);
//STRIP001 
//STRIP001 	// Print default menu entry with bold font
//STRIP001 	if ( lpdis->itemState & ODS_DEFAULT )
//STRIP001 		ncm.lfMenuFont.lfWeight = FW_BOLD;
//STRIP001 
//STRIP001     hfntOld = (HFONT) SelectObject(lpdis->hDC, (HFONT) CreateFontIndirect( &ncm.lfMenuFont ));
//STRIP001 
//STRIP001 
//STRIP001 	SIZE	size;
//STRIP001 	GetTextExtentPointW( lpdis->hDC, pMyItem->text.getStr(), pMyItem->text.getLength(), &size );
//STRIP001 
//STRIP001 	DrawStateW( lpdis->hDC, (HBRUSH)NULL, (DRAWSTATEPROC)NULL, (LPARAM)pMyItem->text.getStr(), (WPARAM)0, aRect.left, aRect.top + (height - size.cy)/2, 0, 0, DST_TEXT | (fDisabled && !fSelected ? DSS_DISABLED : DSS_NORMAL) );
//STRIP001 
//STRIP001     // Restore the original font and colors.
//STRIP001     DeleteObject( SelectObject( lpdis->hDC, hbrOld ) );
//STRIP001     DeleteObject( SelectObject( lpdis->hDC, hfntOld) );
//STRIP001     SetTextColor(lpdis->hDC, clrPrevText);
//STRIP001     SetBkColor(lpdis->hDC, clrPrevBkgnd);
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------
//STRIP001 // code from setup2 project
//STRIP001 // -------------------------------
//STRIP001 
//STRIP001 void _SHFree( void *pv )
//STRIP001 {
//STRIP001 	IMalloc	*pMalloc;
//STRIP001 	if( NOERROR == SHGetMalloc(&pMalloc) )
//STRIP001 	{
//STRIP001 		pMalloc->Free( pv );
//STRIP001 		pMalloc->Release();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 #define ALLOC(type, n) ((type *) HeapAlloc(GetProcessHeap(), 0, sizeof(type) * n ))
//STRIP001 #define FREE(p) HeapFree(GetProcessHeap(), 0, p)
//STRIP001 
//STRIP001 static OUString _SHGetSpecialFolder( int nFolderID )
//STRIP001 {
//STRIP001 
//STRIP001 	LPITEMIDLIST	pidl;
//STRIP001 	HRESULT			hHdl = SHGetSpecialFolderLocation( NULL, nFolderID, &pidl );
//STRIP001 	OUString		aFolder;
//STRIP001 
//STRIP001 	if( hHdl == NOERROR )
//STRIP001 	{
//STRIP001 		WCHAR *lpFolderA;
//STRIP001 		lpFolderA = ALLOC( WCHAR, 16000 );
//STRIP001 
//STRIP001 		SHGetPathFromIDListW( pidl, lpFolderA );
//STRIP001 		aFolder = OUString( lpFolderA );
//STRIP001 
//STRIP001 		FREE( lpFolderA );
//STRIP001 		_SHFree( pidl );
//STRIP001 	}
//STRIP001 	return aFolder;
//STRIP001 }
//STRIP001 
//STRIP001 static OUString SHGetAutostartFolderName()
//STRIP001 {
//STRIP001 	return _SHGetSpecialFolder(CSIDL_STARTUP);
//STRIP001 }
//STRIP001 
//STRIP001 static HRESULT WINAPI SHCoCreateInstance( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknown, REFIID iid, LPVOID *ppv )
//STRIP001 {
//STRIP001 	HRESULT	hResult = E_NOTIMPL;
//STRIP001 	HMODULE	hModShell = GetModuleHandle( "SHELL32" );
//STRIP001 
//STRIP001 	if ( hModShell != NULL )
//STRIP001 	{
//STRIP001 		typedef	HRESULT (WINAPI *SHCoCreateInstance_PROC)( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknwon, REFIID iid, LPVOID *ppv );
//STRIP001 
//STRIP001 		SHCoCreateInstance_PROC	lpfnSHCoCreateInstance = (SHCoCreateInstance_PROC)GetProcAddress( hModShell, MAKEINTRESOURCE(102) );
//STRIP001 
//STRIP001 		if ( lpfnSHCoCreateInstance )
//STRIP001 			hResult = lpfnSHCoCreateInstance( lpszReserved, clsid, pUnkUnknown, iid, ppv );
//STRIP001 	}
//STRIP001 	return hResult;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL CreateShortcut( const OUString& rAbsObject, const OUString& rAbsObjectPath,
//STRIP001 	const OUString& rAbsShortcut, const OUString& rDescription, const OUString& rParameter )
//STRIP001 {
//STRIP001 	HRESULT hres;
//STRIP001 	IShellLink* psl;
//STRIP001 	CLSID clsid_ShellLink = CLSID_ShellLink;
//STRIP001 	CLSID clsid_IShellLink = IID_IShellLink;
//STRIP001 
//STRIP001 	hres = CoCreateInstance( clsid_ShellLink, NULL, CLSCTX_INPROC_SERVER,
//STRIP001 							 clsid_IShellLink, (void**)&psl );
//STRIP001 	if( FAILED(hres) )
//STRIP001 		hres = SHCoCreateInstance( NULL, clsid_ShellLink, NULL, clsid_IShellLink, (void**)&psl );
//STRIP001 
//STRIP001 	if( SUCCEEDED(hres) )
//STRIP001 	{
//STRIP001 		IPersistFile* ppf;
//STRIP001 		psl->SetPath( OUStringToOString(rAbsObject, osl_getThreadTextEncoding()).getStr() );
//STRIP001 		psl->SetWorkingDirectory( OUStringToOString(rAbsObjectPath, osl_getThreadTextEncoding()).getStr() );
//STRIP001 		psl->SetDescription( OUStringToOString(rDescription, osl_getThreadTextEncoding()).getStr() );
//STRIP001 		if( rParameter.getLength() )
//STRIP001 			psl->SetArguments( OUStringToOString(rParameter, osl_getThreadTextEncoding()).getStr() );
//STRIP001 
//STRIP001 		CLSID clsid_IPersistFile = IID_IPersistFile;
//STRIP001 		hres = psl->QueryInterface( clsid_IPersistFile, (void**)&ppf );
//STRIP001 
//STRIP001 		if( SUCCEEDED(hres) )
//STRIP001 		{
//STRIP001 			hres = ppf->Save( rAbsShortcut.getStr(), TRUE );
//STRIP001 			ppf->Release();
//STRIP001 		} else return FALSE;
//STRIP001 		psl->Release();
//STRIP001 	} else return FALSE;
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------
//STRIP001 // install/uninstall
//STRIP001 
//STRIP001 void ShutdownIcon::SetAutostartW32( const OUString& aShortcutName, bool bActivate )
//STRIP001 {
//STRIP001     OUString aShortcut(SHGetAutostartFolderName());
//STRIP001     aShortcut += OUString( RTL_CONSTASCII_USTRINGPARAM( "\\" ) );
//STRIP001     aShortcut += aShortcutName;
//STRIP001 
//STRIP001     if( bActivate )
//STRIP001     {
//STRIP001         wchar_t aPath[_MAX_PATH];
//STRIP001         if( isNT() )
//STRIP001         {
//STRIP001             GetModuleFileNameW( NULL, aPath, _MAX_PATH-1);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             char szPathA[_MAX_PATH];
//STRIP001             int len = GetModuleFileNameA( NULL, szPathA, _MAX_PATH-1);
//STRIP001 
//STRIP001 		    // calc the string wcstr len
//STRIP001 		    int nNeededWStrBuffSize = MultiByteToWideChar( CP_ACP, 0, szPathA, -1, NULL, 0 );
//STRIP001 
//STRIP001 		    // copy the string if necessary
//STRIP001 		    if ( nNeededWStrBuffSize > 0 )
//STRIP001 			    MultiByteToWideChar( CP_ACP, 0, szPathA, -1, aPath, nNeededWStrBuffSize );
//STRIP001 	    }
//STRIP001 
//STRIP001         OUString aOfficepath( aPath );
//STRIP001         int i = aOfficepath.lastIndexOf((sal_Char) '\\');
//STRIP001         if( i != -1 )
//STRIP001             aOfficepath = aOfficepath.copy(0, i);
//STRIP001 
//STRIP001         OUString quickstartExe(aOfficepath);
//STRIP001         quickstartExe += OUString( RTL_CONSTASCII_USTRINGPARAM( "\\quickstart.exe" ) );
//STRIP001 
//STRIP001         CreateShortcut( quickstartExe, aOfficepath, aShortcut, OUString(), OUString() );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         OUString aShortcutUrl;
//STRIP001         ::osl::File::getFileURLFromSystemPath( aShortcut, aShortcutUrl );
//STRIP001         ::osl::File::remove( aShortcutUrl );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 bool ShutdownIcon::GetAutostartW32( const OUString& aShortcutName )
//STRIP001 {
//STRIP001     OUString aShortcut(SHGetAutostartFolderName());
//STRIP001     aShortcut += OUString( RTL_CONSTASCII_USTRINGPARAM( "\\" ) );
//STRIP001     aShortcut += aShortcutName;
//STRIP001 
//STRIP001     OUString aShortcutUrl;
//STRIP001     File::getFileURLFromSystemPath( aShortcut, aShortcutUrl );
//STRIP001     File f( aShortcutUrl );
//STRIP001     File::RC error = f.open( OpenFlag_Read );
//STRIP001     if( error == File::E_None )
//STRIP001     {
//STRIP001         f.close();
//STRIP001         return true;
//STRIP001     }
//STRIP001     else
//STRIP001         return false;
//STRIP001 
//STRIP001 }
}
#endif // WNT



