/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mgetempl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:59:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIELD_HXX //autogen
// auto strip #include <vcl/field.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTYLE_HXX //autogen
// auto strip #include <svtools/style.hxx>
// auto strip #endif
#pragma hdrstop

// auto strip #include "styfitem.hxx"
// auto strip #include "styledlg.hxx"
// auto strip #include "app.hxx"
// auto strip #include "mgetempl.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "module.hxx"

#include "sfx.hrc"
#include "dialog.hrc"
#include "mgetempl.hrc"

#ifndef _SFX_STYLE_HRC
#include <svtools/style.hrc>
#endif
namespace binfilter {

// SfxManageStyleSheetPage -----------------------------------------------

//STRIP001 SfxManageStyleSheetPage::SfxManageStyleSheetPage( Window* pParent, const SfxItemSet& rAttrSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SfxResId( TP_MANAGE_STYLES ), rAttrSet ),
//STRIP001 
//STRIP001 	aNameFt		( this, ResId( FT_NAME ) ),
//STRIP001 	aNameEd		( this, ResId( ED_NAME ) ),
//STRIP001 	aAutoCB     ( this, ResId( CB_AUTO ) ),
//STRIP001 
//STRIP001 	aFollowFt	( this, ResId( FT_NEXT ) ),
//STRIP001 	aFollowLb	( this, ResId( LB_NEXT ) ),
//STRIP001 
//STRIP001 	aBaseFt		( this, ResId( FT_BASE ) ),
//STRIP001 	aBaseLb		( this, ResId( LB_BASE ) ),
//STRIP001 
//STRIP001 	aFilterFt	( this, ResId( FT_REGION ) ),
//STRIP001 	aFilterLb	( this, ResId( LB_REGION ) ),
//STRIP001 
//STRIP001 	aDescFt		( this, ResId( FT_DESC ) ),
//STRIP001 	aDescED		( this, ResId( ED_DESC ) ),
//STRIP001 	aDescGb		( this, ResId( GB_DESC ) ),
//STRIP001 
//STRIP001 	pStyle( &( (SfxStyleDialog*)pParent->GetParent() )->GetStyleSheet() ),
//STRIP001 
//STRIP001 	bModified	( FALSE ),
//STRIP001 	aName		( pStyle->GetName() ),
//STRIP001 	aFollow		( pStyle->GetFollow() ),
//STRIP001 	aParent		( pStyle->GetParent() ),
//STRIP001 	nFlags		( pStyle->GetMask() ),
//STRIP001 	pItem		( 0 )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor; initialisiert die ListBoxen mit den Vorlagen
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	if ( IsBackground() )
//STRIP001 		aDescED.SetBackground( GetBackground() );
//STRIP001 	FixedInfo* pInfo = new FixedInfo( this );
//STRIP001 	aDescED.SetFont( pInfo->GetFont() );
//STRIP001 	delete pInfo;
//STRIP001 
//STRIP001 	aDescED.Hide();
//STRIP001 	aDescFt.Show();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001     ResMgr* pResMgr = SFX_APP()->GetModule_Impl()->GetResMgr();
//STRIP001 	DBG_ASSERT( pResMgr, "kein ResMgr am Modul" );
//STRIP001 	pFamilies = new SfxStyleFamilies( ResId( DLG_STYLE_DESIGNER, pResMgr ) );
//STRIP001 
//STRIP001 	SfxStyleSheetBasePool* pPool = 0;
//STRIP001 	SfxObjectShell* pDocShell = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if ( pDocShell )
//STRIP001 		pPool = pDocShell->GetStyleSheetPool();
//STRIP001 	DBG_ASSERT( pPool, "kein Pool oder keine DocShell" );
//STRIP001 
//STRIP001 	if ( pPool )
//STRIP001 	{
//STRIP001 		pPool->SetSearchMask( pStyle->GetFamily() );
//STRIP001 		pPool->First();     // fuer SW - interne Liste updaten
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pStyle->GetName().Len() && pPool )
//STRIP001 	{
//STRIP001 		// NullString als Name -> Name generieren
//STRIP001 		String aNoName( SfxResId( STR_NONAME ) );
//STRIP001 		USHORT nNo = 1;
//STRIP001 		String aNo( aNoName );
//STRIP001 		aNoName += String::CreateFromInt32( nNo );
//STRIP001 		while ( pPool->Find( aNoName ) )
//STRIP001 		{
//STRIP001 			++nNo;
//STRIP001 			aNoName = aNo;
//STRIP001 			aNoName += String::CreateFromInt32( nNo );
//STRIP001 		}
//STRIP001 		pStyle->SetName( aNoName );
//STRIP001 		aName = aNoName;
//STRIP001 		aFollow = pStyle->GetFollow();
//STRIP001 		aParent = pStyle->GetParent();
//STRIP001 	}
//STRIP001 	aNameEd.SetText(pStyle->GetName());
//STRIP001 
//STRIP001 	if ( !pStyle->IsUserDefined() )
//STRIP001 		aNameEd.SetReadOnly();
//STRIP001 
//STRIP001 	if ( pStyle->HasFollowSupport() && pPool )
//STRIP001 	{
//STRIP001 		SfxStyleSheetBase* pPoolStyle = pPool->First();
//STRIP001 
//STRIP001 		while ( pPoolStyle )
//STRIP001 		{
//STRIP001 			aFollowLb.InsertEntry( pPoolStyle->GetName() );
//STRIP001 			pPoolStyle = pPool->Next();
//STRIP001 		}
//STRIP001 
//STRIP001 		// eine neue Vorlage ist noch nicht im Pool
//STRIP001 		if ( LISTBOX_ENTRY_NOTFOUND == aFollowLb.GetEntryPos( pStyle->GetName() ) )
//STRIP001 			aFollowLb.InsertEntry( pStyle->GetName() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFollowFt.Hide();
//STRIP001 		aFollowLb.Hide();
//STRIP001 
//STRIP001 		aFilterFt.SetPosPixel( aBaseFt.GetPosPixel() );
//STRIP001 		aFilterLb.SetPosPixel( aBaseLb.GetPosPixel() );
//STRIP001 
//STRIP001 		aBaseFt.SetPosPixel( aFollowFt.GetPosPixel() );
//STRIP001 		aBaseLb.SetPosPixel( aFollowLb.GetPosPixel() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pStyle->HasParentSupport() && pPool )
//STRIP001 	{
//STRIP001 		if ( pStyle->HasClearParentSupport() )
//STRIP001 			// die Basisvorlage darf auf NULL gesetzt werden
//STRIP001 			aBaseLb.InsertEntry( String( SfxResId( STR_NONE ) ) );
//STRIP001 
//STRIP001 		SfxStyleSheetBase* pPoolStyle = pPool->First();
//STRIP001 
//STRIP001 		while ( pPoolStyle )
//STRIP001 		{
//STRIP001 			const String aStr( pPoolStyle->GetName() );
//STRIP001 			// eigener Namen nicht als Basisvorlage
//STRIP001 			if ( aStr != aName )
//STRIP001 				aBaseLb.InsertEntry( aStr );
//STRIP001 			pPoolStyle = pPool->Next();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBaseFt.Disable();
//STRIP001 		aBaseLb.Disable();
//STRIP001 	}
//STRIP001 	USHORT nCount = pFamilies->Count();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		pItem = pFamilies->GetObject(i);
//STRIP001 
//STRIP001 		if ( pItem->GetFamily() == pStyle->GetFamily() )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nStyleFilterIdx = 0xffff;
//STRIP001 
//STRIP001 	if ( i < nCount )
//STRIP001 	{
//STRIP001 		// Filterflags
//STRIP001 		const SfxStyleFilter& rList = pItem->GetFilterList();
//STRIP001 		nCount = (USHORT)rList.Count();
//STRIP001 		USHORT nIdx = 0;
//STRIP001 		USHORT nMask = pStyle->GetMask() & ~SFXSTYLEBIT_USERDEF;
//STRIP001 
//STRIP001 		if ( !nMask )	// Benutzervorlage?
//STRIP001 			nMask = pStyle->GetMask();
//STRIP001 
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			SfxFilterTupel* pTupel = rList.GetObject(i);
//STRIP001 
//STRIP001 			if ( pTupel->nFlags != SFXSTYLEBIT_AUTO 	&&
//STRIP001 				 pTupel->nFlags != SFXSTYLEBIT_USED		&&
//STRIP001 //				 pTupel->nFlags != SFXSTYLEBIT_USERDEF	&&
//STRIP001 				 pTupel->nFlags != SFXSTYLEBIT_ALL )
//STRIP001 			{
//STRIP001 				aFilterLb.InsertEntry( pTupel->aName, nIdx );
//STRIP001 				aFilterLb.SetEntryData(nIdx, (void*)(long)i);
//STRIP001 
//STRIP001 				if ( ( pTupel->nFlags & nMask ) == nMask )
//STRIP001 					nStyleFilterIdx = nIdx;
//STRIP001 				++nIdx;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nStyleFilterIdx != 0xFFFF )
//STRIP001 			aFilterLb.SelectEntryPos( nStyleFilterIdx );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !aFilterLb.GetEntryCount() || !pStyle->IsUserDefined() )
//STRIP001 	{
//STRIP001 		pItem = 0;
//STRIP001 		aFilterFt.Disable();
//STRIP001 		aFilterLb.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aFilterLb.SaveValue();
//STRIP001 	SetDescriptionText_Impl();
//STRIP001 
//STRIP001 	if ( aFollowLb.IsEnabled() || aBaseLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		aNameEd.SetGetFocusHdl(
//STRIP001 			LINK( this, SfxManageStyleSheetPage, GetFocusHdl ) );
//STRIP001 		aNameEd.SetLoseFocusHdl(
//STRIP001 			LINK( this, SfxManageStyleSheetPage, LoseFocusHdl ) );
//STRIP001 	}
//STRIP001 	// ist es ein Style mit automatischem Update? (nur SW)
//STRIP001 	if(SFX_ITEM_SET == rAttrSet.GetItemState(SID_ATTR_AUTO_STYLE_UPDATE))
//STRIP001 	{
//STRIP001 		Size aSize = aNameEd.GetSizePixel();
//STRIP001 		aSize.Width() /= 2;
//STRIP001 		aNameEd.SetSizePixel(aSize);
//STRIP001 		aAutoCB.Show();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxManageStyleSheetPage::~SfxManageStyleSheetPage()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Destruktor; Freigabe der Daten
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	delete pFamilies;
//STRIP001 	pItem = 0;
//STRIP001 	pStyle = 0;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxManageStyleSheetPage::UpdateName_Impl( ListBox* pBox,
//STRIP001 											   const String& rNew )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Nach der "Anderung eines Vorlagennamens die ListBox pBox
//STRIP001 	aktualisieren
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	ListBox* pBox			ListBox, deren Eintr"age aktualisiert
//STRIP001 							werden sollen
//STRIP001 	const String& rNew		der neue Name
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( pBox->IsEnabled() )
//STRIP001 	{
//STRIP001 		// ist der aktuelle Eintrag, dessen Namen modifizieren wurde
//STRIP001 		const BOOL bSelect = pBox->GetSelectEntry() == aBuf;
//STRIP001 		pBox->RemoveEntry( aBuf );
//STRIP001 		pBox->InsertEntry( rNew );
//STRIP001 
//STRIP001 		if ( bSelect )
//STRIP001 			pBox->SelectEntry( rNew );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxManageStyleSheetPage::SetDescriptionText_Impl()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Attributbeschreibung setzen. daf"ur die eingestellte Metrik besorgen.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 	SfxMapUnit eUnit = SFX_MAPUNIT_CM;
//STRIP001 //    FieldUnit eFieldUnit = pSfxApp->GetOptions().GetMetric();
//STRIP001     FieldUnit eFieldUnit( FUNIT_CM );
//STRIP001 	SfxModule* pModule = pSfxApp->GetActiveModule();
//STRIP001 	if ( pModule )
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem = pModule->GetItem( SID_ATTR_METRIC );
//STRIP001 		if ( pItem )
//STRIP001 			eFieldUnit = (FieldUnit)( (SfxUInt16Item*)pItem )->GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( eFieldUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_MM:		eUnit = SFX_MAPUNIT_MM; break;
//STRIP001 
//STRIP001 		case FUNIT_CM:
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:		eUnit = SFX_MAPUNIT_CM; break;
//STRIP001 
//STRIP001 		case FUNIT_POINT:
//STRIP001 		case FUNIT_PICA:	eUnit = SFX_MAPUNIT_POINT; break;
//STRIP001 
//STRIP001 		case FUNIT_INCH:
//STRIP001 		case FUNIT_FOOT:
//STRIP001 		case FUNIT_MILE:	eUnit = SFX_MAPUNIT_INCH; break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERRORFILE( "not supported fieldunit" );
//STRIP001 	}
//STRIP001 	aDescFt.SetText( pStyle->GetDescription( eUnit ) );
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SfxManageStyleSheetPage, GetFocusHdl, Edit *, pEdit )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	StarView Handler; GetFocus-Handler des Edits mit dem Vorlagennamen.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	aBuf = pEdit->GetText().EraseLeadingChars();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxManageStyleSheetPage, GetFocusHdl, Edit *, pEdit )
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SfxManageStyleSheetPage, LoseFocusHdl, Edit *, pEdit )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	StarView Handler; LoseFocus-Handler des Edits mit dem Vorlagennamen.
//STRIP001 	Dieser aktualisiert ggf. die Listbox mit den Folgevorlagen.
//STRIP001 	In der Listbox mit den Basisvorlagen ist die aktuelle Vorlage
//STRIP001 	selbst nicht enthalten.
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const String aStr( pEdit->GetText().EraseLeadingChars() );
//STRIP001 	pEdit->SetText( aStr );
//STRIP001 	// ggf. Listbox der Basisvorlagen aktualisieren
//STRIP001 	if ( aStr != aBuf )
//STRIP001 		UpdateName_Impl( &aFollowLb, aStr );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxManageStyleSheetPage, LoseFocusHdl, Edit *, pEdit )
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SfxManageStyleSheetPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 
//STRIP001 	Handler f"ur das Setzen der (modifizierten) Daten. Wird aus
//STRIP001 	dem Ok des SfxTabDialog gerufen.
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	SfxItemSet &rAttrSet		das Set, das die Daten entgegennimmt.
//STRIP001 
//STRIP001 
//STRIP001 	[R"uckgabewert]
//STRIP001 
//STRIP001 	BOOL						TRUE:  es hat eine "Anderung der Daten
//STRIP001 									   stattgefunden
//STRIP001 								FALSE: es hat keine "Anderung der Daten
//STRIP001 									   stattgefunden
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<class SfxTabDialog>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const USHORT nFilterIdx = aFilterLb.GetSelectEntryPos();
//STRIP001 
//STRIP001 	// Filter setzen
//STRIP001 
//STRIP001 	if ( LISTBOX_ENTRY_NOTFOUND  != nFilterIdx 		&&
//STRIP001 		 nFilterIdx != aFilterLb.GetSavedValue() 	&&
//STRIP001 		 aFilterLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		bModified = TRUE;
//STRIP001 		DBG_ASSERT( pItem, "kein Item" );
//STRIP001 		// geht nur bei Benutzervorlagen
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 		USHORT nIdx = (USHORT)(long)aFilterLb.GetEntryData( nFilterIdx );
//STRIP001 		SfxFilterTupel* p = pItem->GetFilterList().GetObject( nIdx );
//STRIP001 #endif
//STRIP001 		USHORT nMask = pItem->GetFilterList().GetObject(
//STRIP001 			(USHORT)(long)aFilterLb.GetEntryData( nFilterIdx ) )->nFlags |
//STRIP001 			SFXSTYLEBIT_USERDEF;
//STRIP001 		pStyle->SetMask( nMask );
//STRIP001 	}
//STRIP001 	if(aAutoCB.IsVisible() &&
//STRIP001 		aAutoCB.IsChecked() != aAutoCB.GetSavedValue())
//STRIP001 	{
//STRIP001 		rSet.Put(SfxBoolItem(SID_ATTR_AUTO_STYLE_UPDATE, aAutoCB.IsChecked()));
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxManageStyleSheetPage::Reset( const SfxItemSet& rAttrSet )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 
//STRIP001 	Handler f"ur das Initialisieren der Seite mit den initialen Daten.
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	const SfxItemSet &rAttrSet		das Set mit den Daten
//STRIP001 
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<class SfxTabDialog>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	bModified = FALSE;
//STRIP001 	String sCmp( pStyle->GetName() );
//STRIP001 
//STRIP001 	if ( sCmp != aName )
//STRIP001 		pStyle->SetName( aName );
//STRIP001 	aNameEd.SetText( aName );
//STRIP001 
//STRIP001 	if ( aFollowLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		sCmp = pStyle->GetFollow();
//STRIP001 
//STRIP001 		if ( sCmp != aFollow )
//STRIP001 			pStyle->SetFollow( aFollow );
//STRIP001 
//STRIP001 		if ( !aFollow.Len() )
//STRIP001 			aFollowLb.SelectEntry( aName );
//STRIP001 		else
//STRIP001 			aFollowLb.SelectEntry( aFollow );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aBaseLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		sCmp = pStyle->GetParent();
//STRIP001 
//STRIP001 		if ( sCmp != aParent )
//STRIP001 			pStyle->SetParent( aParent );
//STRIP001 
//STRIP001 		if ( !aParent.Len() )
//STRIP001 			aBaseLb.SelectEntry( String( SfxResId( STR_NONE ) ) );
//STRIP001 		else
//STRIP001 			aBaseLb.SelectEntry( aParent );
//STRIP001 
//STRIP001 		if ( String( SfxResId( STR_STANDARD ) ) == aName )
//STRIP001 		{
//STRIP001 			// die Standardvorlage kann nicht verkn"upft werden
//STRIP001 			aBaseFt.Disable();
//STRIP001 			aBaseLb.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aFilterLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		USHORT nCmp = pStyle->GetMask();
//STRIP001 
//STRIP001 		if ( nCmp != nFlags )
//STRIP001 			pStyle->SetMask( nFlags );
//STRIP001 		aFilterLb.SelectEntryPos( aFilterLb.GetSavedValue() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SfxManageStyleSheetPage::Create( Window* pParent,
//STRIP001 											 const SfxItemSet &rAttrSet )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 
//STRIP001 	Factory f"ur das Erzeugen der Seite
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<class SfxTabDialog>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	return new SfxManageStyleSheetPage( pParent, rAttrSet );
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxManageStyleSheetPage::ActivatePage( const SfxItemSet& rSet)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	ActivatePage- Handler des SfxTabDialog; wird f"ur die Aktualisierung
//STRIP001 	des beschreibenden Textes verwendet, da sich dieser durch "Anderungen
//STRIP001 	der Daten anderer Seiten ge"andert haben kann.
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	const SfxItemSet&		das Set f"ur den Datenaustausch; wird
//STRIP001 							hier nicht verwendet.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxTabDialog::ActivatePage(const SfxItemSet &)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SetDescriptionText_Impl();
//STRIP001 
//STRIP001 	// ist es ein Style mit automatischem Update? (nur SW)
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET ==
//STRIP001 		 rSet.GetItemState( SID_ATTR_AUTO_STYLE_UPDATE, FALSE, &pItem ) )
//STRIP001 		aAutoCB.Check( ( (const SfxBoolItem*)pItem )->GetValue() );
//STRIP001 	aAutoCB.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 int SfxManageStyleSheetPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	DeactivatePage- Handler des SfxTabDialog; die Daten werden
//STRIP001 	an der Vorlage eingestellt, damit die richtige Vererbung
//STRIP001 	f"ur die anderen Seiten des Dialoges vorliegt.
//STRIP001 	Im Fehlerfall wird das Verlassen der Seite unterbunden.
//STRIP001 
//STRIP001 	[Parameter]
//STRIP001 
//STRIP001 	SfxItemSet*			das Set f"ur den Datenaustausch; wird hier nicht verwendet.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 
//STRIP001 	<SfxTabDialog::DeactivatePage(SfxItemSet*)>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	int nRet = SfxTabPage::LEAVE_PAGE;
//STRIP001 
//STRIP001 	if ( aNameEd.IsModified() )
//STRIP001 	{
//STRIP001 		// bei <Enter> wird kein LoseFocus() durch StarView ausgel"ost
//STRIP001 		if ( aNameEd.HasFocus() )
//STRIP001 			LoseFocusHdl( &aNameEd );
//STRIP001 
//STRIP001 		if ( !pStyle->SetName( aNameEd.GetText().EraseLeadingChars() ) )
//STRIP001 		{
//STRIP001 			InfoBox aBox( this, SfxResId( MSG_TABPAGE_INVALIDNAME ) );
//STRIP001 			aBox.Execute();
//STRIP001 			aNameEd.GrabFocus();
//STRIP001 			aNameEd.SetSelection( Selection( SELECTION_MIN, SELECTION_MAX ) );
//STRIP001 			return SfxTabPage::KEEP_PAGE;
//STRIP001 		}
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pStyle->HasFollowSupport() && aFollowLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		const String aFollow( aFollowLb.GetSelectEntry() );
//STRIP001 
//STRIP001 		if ( pStyle->GetFollow() != aFollow )
//STRIP001 		{
//STRIP001 			if ( !pStyle->SetFollow( aFollow ) )
//STRIP001 			{
//STRIP001 				InfoBox aBox( this, SfxResId( MSG_TABPAGE_INVALIDSTYLE ) );
//STRIP001 				aBox.Execute();
//STRIP001 				aFollowLb.GrabFocus();
//STRIP001 				return SfxTabPage::KEEP_PAGE;
//STRIP001 			}
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aBaseLb.IsEnabled() )
//STRIP001 	{
//STRIP001 		String aParent( aBaseLb.GetSelectEntry() );
//STRIP001 
//STRIP001 		if ( String( SfxResId( STR_NONE ) ) == aParent || aParent == pStyle->GetName() )
//STRIP001 			aParent.Erase();
//STRIP001 
//STRIP001 		if ( pStyle->GetParent() != aParent )
//STRIP001 		{
//STRIP001 			if ( !pStyle->SetParent( aParent ) )
//STRIP001 			{
//STRIP001 				InfoBox aBox( this, SfxResId( MSG_TABPAGE_INVALIDPARENT ) );
//STRIP001 				aBox.Execute();
//STRIP001 				aBaseLb.GrabFocus();
//STRIP001 				return SfxTabPage::KEEP_PAGE;
//STRIP001 			}
//STRIP001 			bModified = TRUE;
//STRIP001 			nRet |= (int)SfxTabPage::REFRESH_SET;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

}
