/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_langbox.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:53:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _COM_SUN_STAR_LINGUISTIC2_XLINGUSERVICEMANAGER_HDL_
#include <com/sun/star/linguistic2/XLinguServiceManager.hdl>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XAVAILABLELOCALES_HPP_
#include <com/sun/star/linguistic2/XAvailableLocales.hpp>
#endif
#ifndef _LINGUISTIC_MISC_HXX_
#include <bf_linguistic/misc.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include<rtl/ustring.hxx>
#endif

#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#pragma hdrstop

#ifndef _SVX_SCRIPTTYPEITEM_HXX
#include <scripttypeitem.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_LANGTAB_HXX
#include <langtab.hxx>
#endif
#include "langbox.hxx"
#include "langtab.hxx"
#include "dialmgr.hxx"
#include "dialogs.hrc"
#include "unolingu.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;
using namespace ::com::sun::star::uno;

//STRIP001 #define A2OU(x)		OUString::createFromAscii( x )

//========================================================================
//	list of languages for forbidden chars
//========================================================================

//STRIP001 static const LanguageType aForbiddenCharLang[] =
//STRIP001 {
//STRIP001 	LANGUAGE_CHINESE_TRADITIONAL,
//STRIP001 	LANGUAGE_CHINESE_SIMPLIFIED,
//STRIP001 	LANGUAGE_JAPANESE,
//STRIP001 	LANGUAGE_KOREAN
//STRIP001 };

//STRIP001 static const int nForbiddenCharLang = sizeof( aForbiddenCharLang ) / sizeof( aForbiddenCharLang[0] );


//STRIP001 static BOOL lcl_HasLanguage( const LanguageType *pLang, int nCount, LanguageType nLang )
//STRIP001 {
//STRIP001 	int i = -1;
//STRIP001 	if (pLang && nCount > 0)
//STRIP001 	{
//STRIP001 		for (i = 0;  i < nCount; ++i )
//STRIP001 		{
//STRIP001 			if (pLang[i] == nLang)
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return i >= 0  &&  i < nCount;
//STRIP001 }

//========================================================================
//	misc local helper functions
//========================================================================



//STRIP001 static Sequence< INT16 > lcl_LocaleSeqToLangSeq( Sequence< Locale > &rSeq )
//STRIP001 {
//STRIP001 	const Locale *pLocale = rSeq.getConstArray();
//STRIP001 	INT32 nCount = rSeq.getLength();
//STRIP001 
//STRIP001 	Sequence< INT16 >	aLangs( nCount );
//STRIP001 	INT16 *pLang = aLangs.getArray();
//STRIP001 	for (INT32 i = 0;  i < nCount;  ++i)
//STRIP001 	{
//STRIP001 		pLang[i] = SvxLocaleToLanguage( pLocale[i] );
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return aLangs;
//STRIP001 }


//STRIP001 static BOOL lcl_SeqHasLang( const Sequence< INT16 > & rLangSeq, INT16 nLang )
//STRIP001 {
//STRIP001 	INT32 i = -1;
//STRIP001 	INT32 nLen = rLangSeq.getLength();
//STRIP001 	if (nLen)
//STRIP001 	{
//STRIP001 		const INT16 *pLang = rLangSeq.getConstArray();
//STRIP001 		for (i = 0;  i < nLen;  ++i)
//STRIP001 		{
//STRIP001 			if (nLang == pLang[i])
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return i >= 0  &&  i < nLen;
//STRIP001 }

//========================================================================
//	class SvxLanguageBox
//========================================================================

//STRIP001 USHORT TypeToPos_Impl( LanguageType eType, const ListBox& rLb )
//STRIP001 {
//STRIP001 	USHORT	nPos   = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 	USHORT	nCount = rLb.GetEntryCount();
//STRIP001 
//STRIP001 	for ( USHORT i=0; nPos == LISTBOX_ENTRY_NOTFOUND && i<nCount; i++ )
//STRIP001 		if ( eType == LanguageType((ULONG)rLb.GetEntryData(i)) )
//STRIP001 			nPos = i;
//STRIP001 
//STRIP001 	return nPos;
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 SvxLanguageBox::SvxLanguageBox( Window* pParent, WinBits nWinStyle, BOOL bCheck ) :
//STRIP001     ListBox( pParent, nWinStyle ),
//STRIP001     m_pSpellUsedLang( NULL ),
//STRIP001     m_bWithCheckmark( bCheck )
//STRIP001 {
//STRIP001     Init();
//STRIP001 }
//------------------------------------------------------------------------
//STRIP001 SvxLanguageBox::SvxLanguageBox( Window* pParent, const ResId& rResId, BOOL bCheck ) :
//STRIP001 	ListBox( pParent, rResId ),
//STRIP001     m_pSpellUsedLang( NULL ),
//STRIP001 	m_bWithCheckmark( bCheck )
//STRIP001 {
//STRIP001     Init();
//STRIP001 }
//------------------------------------------------------------------------
//STRIP001 void SvxLanguageBox::Init()
//STRIP001 {
//STRIP001     m_pLangTable = new SvxLanguageTable;
//STRIP001 	m_aNotCheckedImage = Image( SVX_RES( RID_SVXIMG_NOTCHECKED ) );
//STRIP001     m_aCheckedImage = Image( SVX_RES( RID_SVXIMG_CHECKED ) );
//STRIP001     m_aCheckedImageHC = Image( SVX_RES( RID_SVXIMG_CHECKED_H ) );
//STRIP001 	m_aAllString			= String( SVX_RESSTR( RID_SVXSTR_LANGUAGE_ALL ) );
//STRIP001 	m_nLangList				= LANG_LIST_EMPTY;
//STRIP001 	m_bHasLangNone			= FALSE;
//STRIP001 	m_bLangNoneIsLangAll	= FALSE;
//STRIP001 
//STRIP001 	// display entries sorted
//STRIP001 	SetStyle( GetStyle() | WB_SORT );
//STRIP001 
//STRIP001 	if ( m_bWithCheckmark )
//STRIP001 	{
//STRIP001 		SvxLanguageTable aLangTable;
//STRIP001 		const USHORT nCount = aLangTable.GetEntryCount();
//STRIP001 		for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			LanguageType nLangType = aLangTable.GetTypeAtIndex( i );
//STRIP001 
//STRIP001 			BOOL bInsert = TRUE;
//STRIP001 			if ((LANGUAGE_DONTKNOW == nLangType)  ||
//STRIP001 				(LANGUAGE_SYSTEM   == nLangType)  ||
//STRIP001 				(LANGUAGE_USER1 <= nLangType  &&  nLangType <= LANGUAGE_USER9))
//STRIP001 			{
//STRIP001 				bInsert = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bInsert )
//STRIP001 				InsertLanguage( nLangType );
//STRIP001 		}
//STRIP001 		m_nLangList	= LANG_LIST_ALL;
//STRIP001 	}
//STRIP001 }
//------------------------------------------------------------------------

//STRIP001 SvxLanguageBox::~SvxLanguageBox()
//STRIP001 {
//STRIP001     delete m_pSpellUsedLang;
//STRIP001 	delete m_pLangTable;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT SvxLanguageBox::ImplInsertImgEntry( const String& rEntry, USHORT nPos, bool bChecked )
//STRIP001 {
//STRIP001     USHORT nRet = 0;
//STRIP001     if( !bChecked )
//STRIP001         nRet = InsertEntry( rEntry, m_aNotCheckedImage, nPos );
//STRIP001     else if( GetSettings().GetStyleSettings().GetFaceColor().IsDark() )
//STRIP001         nRet = InsertEntry( rEntry, m_aCheckedImageHC, nPos );
//STRIP001     else
//STRIP001         nRet = InsertEntry( rEntry, m_aCheckedImage, nPos );
//STRIP001     return nRet;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxLanguageBox::SetLanguageList( INT16 nLangList,
//STRIP001 		BOOL bHasLangNone, BOOL bLangNoneIsLangAll, BOOL bCheckSpellAvail )
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 
//STRIP001 	m_nLangList				= nLangList;
//STRIP001 	m_bHasLangNone			= bHasLangNone;
//STRIP001 	m_bLangNoneIsLangAll	= bLangNoneIsLangAll;
//STRIP001 	m_bWithCheckmark		= bCheckSpellAvail;
//STRIP001 
//STRIP001 	if ( LANG_LIST_EMPTY != nLangList )
//STRIP001 	{
//STRIP001 		Sequence< INT16 > aSpellAvailLang;
//STRIP001 		Sequence< INT16 > aHyphAvailLang;
//STRIP001 		Sequence< INT16 > aThesAvailLang;
//STRIP001         Sequence< INT16 > aSpellUsedLang;
//STRIP001         Sequence< INT16 > aHyphUsedLang;
//STRIP001         Sequence< INT16 > aThesUsedLang;
//STRIP001 		Reference< XAvailableLocales > xAvail( LinguMgr::GetLngSvcMgr(), UNO_QUERY );
//STRIP001 		if (xAvail.is())
//STRIP001 		{
//STRIP001 			Sequence< Locale > aTmp;
//STRIP001 
//STRIP001 			if (LANG_LIST_SPELL_AVAIL & nLangList)
//STRIP001 			{
//STRIP001 				aTmp = xAvail->getAvailableLocales( A2OU( SN_SPELLCHECKER ) );
//STRIP001 				aSpellAvailLang = lcl_LocaleSeqToLangSeq( aTmp );
//STRIP001 			}
//STRIP001 			if (LANG_LIST_HYPH_AVAIL  & nLangList)
//STRIP001 			{
//STRIP001 				aTmp = xAvail->getAvailableLocales( A2OU( SN_HYPHENATOR ) );
//STRIP001 				aHyphAvailLang = lcl_LocaleSeqToLangSeq( aTmp );
//STRIP001 			}
//STRIP001 			if (LANG_LIST_THES_AVAIL  & nLangList)
//STRIP001 			{
//STRIP001 				aTmp = xAvail->getAvailableLocales( A2OU( SN_THESAURUS ) );
//STRIP001 				aThesAvailLang = lcl_LocaleSeqToLangSeq( aTmp );
//STRIP001 			}
//STRIP001 		}
//STRIP001         if (LANG_LIST_SPELL_USED & nLangList)
//STRIP001         {
//STRIP001             Reference< XSpellChecker1 > xTmp1( SvxGetSpellChecker(), UNO_QUERY );
//STRIP001             if (xTmp1.is())
//STRIP001                 aSpellUsedLang = xTmp1->getLanguages();
//STRIP001         }
//STRIP001         if (LANG_LIST_HYPH_USED  & nLangList)
//STRIP001         {
//STRIP001             Reference< XHyphenator > xTmp( SvxGetHyphenator() );
//STRIP001             if (xTmp.is()) {
//STRIP001                 Sequence < Locale > aLocaleSequence( xTmp->getLocales() );
//STRIP001                 aHyphUsedLang = lcl_LocaleSeqToLangSeq( aLocaleSequence );
//STRIP001             }
//STRIP001         }
//STRIP001         if (LANG_LIST_THES_USED  & nLangList)
//STRIP001         {
//STRIP001             Reference< XThesaurus > xTmp( SvxGetThesaurus() );
//STRIP001             if (xTmp.is()) {
//STRIP001                 Sequence < Locale > aLocaleSequence( xTmp->getLocales() );
//STRIP001                 aThesUsedLang = lcl_LocaleSeqToLangSeq( aLocaleSequence );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		SvxLanguageTable aLangTable;
//STRIP001         ::com::sun::star::uno::Sequence< sal_uInt16 > xKnown;
//STRIP001         const sal_uInt16* pKnown;
//STRIP001         USHORT nCount;
//STRIP001         if ( nLangList & LANG_LIST_ONLY_KNOWN )
//STRIP001         {
//STRIP001             xKnown = LocaleDataWrapper::getInstalledLanguageTypes();
//STRIP001             pKnown = xKnown.getConstArray();
//STRIP001             nCount = (USHORT) xKnown.getLength();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             nCount = aLangTable.GetEntryCount();
//STRIP001             pKnown = NULL;
//STRIP001         }
//STRIP001 		for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001             LanguageType nLangType;
//STRIP001             if ( nLangList & LANG_LIST_ONLY_KNOWN )
//STRIP001                 nLangType = pKnown[i];
//STRIP001             else
//STRIP001                 nLangType = aLangTable.GetTypeAtIndex( i );
//STRIP001 			BOOL bInsert = FALSE;
//STRIP001 			if ( nLangType != LANGUAGE_DONTKNOW &&
//STRIP001 				 nLangType != LANGUAGE_SYSTEM   &&
//STRIP001 			     nLangType != LANGUAGE_NONE 	&&
//STRIP001 				!(LANGUAGE_USER1 <= nLangType  &&  nLangType <= LANGUAGE_USER9) )
//STRIP001 			{
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_ALL))
//STRIP001                     bInsert |= TRUE;
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_WESTERN))
//STRIP001                     bInsert |= SCRIPTTYPE_LATIN == SvtLanguageOptions::GetScriptTypeOfLanguage( nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_CTL))
//STRIP001                     bInsert |= SCRIPTTYPE_COMPLEX == SvtLanguageOptions::GetScriptTypeOfLanguage( nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_CJK))
//STRIP001                     bInsert |= SCRIPTTYPE_ASIAN == SvtLanguageOptions::GetScriptTypeOfLanguage( nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_FBD_CHARS))
//STRIP001                     bInsert |= lcl_HasLanguage( aForbiddenCharLang,
//STRIP001                                         nForbiddenCharLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_SPELL_AVAIL))
//STRIP001                     bInsert |= lcl_SeqHasLang( aSpellAvailLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_HYPH_AVAIL))
//STRIP001                     bInsert |= lcl_SeqHasLang( aHyphAvailLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_THES_AVAIL))
//STRIP001                     bInsert |= lcl_SeqHasLang( aThesAvailLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_SPELL_USED))
//STRIP001                     bInsert |= lcl_SeqHasLang( aSpellUsedLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_HYPH_USED))
//STRIP001                     bInsert |= lcl_SeqHasLang( aHyphUsedLang, nLangType );
//STRIP001                 if (!bInsert && (nLangList & LANG_LIST_THES_USED))
//STRIP001                     bInsert |= lcl_SeqHasLang( aThesUsedLang, nLangType );
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bInsert)
//STRIP001 				InsertLanguage( nLangType );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bHasLangNone)
//STRIP001 			InsertLanguage( LANGUAGE_NONE );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT SvxLanguageBox::InsertLanguage( const LanguageType nLangType, USHORT nPos )
//STRIP001 {
//STRIP001 	String aStrEntry = m_pLangTable->GetString( nLangType );
//STRIP001 	if (LANGUAGE_NONE == nLangType && m_bHasLangNone && m_bLangNoneIsLangAll)
//STRIP001 		aStrEntry = m_aAllString;
//STRIP001 
//STRIP001 	USHORT nAt = 0;
//STRIP001 	if ( m_bWithCheckmark )
//STRIP001 	{
//STRIP001         sal_Bool bFound = sal_False;
//STRIP001 
//STRIP001         if (!m_pSpellUsedLang)
//STRIP001         {
//STRIP001             Reference< XSpellChecker1 > xSpell( SvxGetSpellChecker(), UNO_QUERY );
//STRIP001             if ( xSpell.is() )
//STRIP001                 m_pSpellUsedLang = new Sequence< INT16 >( xSpell->getLanguages() );
//STRIP001         }
//STRIP001         bFound = m_pSpellUsedLang ?
//STRIP001                     lcl_SeqHasLang( *m_pSpellUsedLang, nLangType ) : FALSE;
//STRIP001 
//STRIP001         nAt = ImplInsertImgEntry( aStrEntry, nPos, bFound );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nAt = InsertEntry( aStrEntry, nPos );
//STRIP001 
//STRIP001 	SetEntryData( nAt, (void*)(ULONG)nLangType );
//STRIP001 	return nPos;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT SvxLanguageBox::InsertLanguage( const LanguageType nLangType,
//STRIP001         BOOL bCheckEntry, USHORT nPos )
//STRIP001 {
//STRIP001 	String aStrEntry = m_pLangTable->GetString( nLangType );
//STRIP001 	if (LANGUAGE_NONE == nLangType && m_bHasLangNone && m_bLangNoneIsLangAll)
//STRIP001 		aStrEntry = m_aAllString;
//STRIP001 
//STRIP001     USHORT nAt = ImplInsertImgEntry( aStrEntry, nPos, bCheckEntry );
//STRIP001 	SetEntryData( nAt, (void*)(ULONG)nLangType );
//STRIP001 
//STRIP001     return nPos;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxLanguageBox::RemoveLanguage( const LanguageType eLangType )
//STRIP001 {
//STRIP001 	USHORT nAt = TypeToPos_Impl( eLangType, *this );
//STRIP001 
//STRIP001 	if ( nAt != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		RemoveEntry( nAt );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 LanguageType SvxLanguageBox::GetSelectLanguage() const
//STRIP001 {
//STRIP001 	LanguageType eType	= LanguageType(LANGUAGE_DONTKNOW);
//STRIP001 	USHORT 		 nPos	= GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		return LanguageType( (ULONG)GetEntryData(nPos) );
//STRIP001 	else
//STRIP001 		return LanguageType( LANGUAGE_DONTKNOW );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxLanguageBox::SelectLanguage( const LanguageType eLangType, BOOL bSelect )
//STRIP001 {
//STRIP001 	USHORT nAt = TypeToPos_Impl( eLangType, *this );
//STRIP001 
//STRIP001 	if ( nAt != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		SelectEntryPos( nAt, bSelect );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL SvxLanguageBox::IsLanguageSelected( const LanguageType eLangType ) const
//STRIP001 {
//STRIP001 	USHORT nAt = TypeToPos_Impl( eLangType, *this );
//STRIP001 
//STRIP001 	if ( nAt != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		return IsEntryPosSelected( nAt );
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }

}
