/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: polytest.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: thb $ $Date: 2006/07/27 11:35:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// autogenerated file with codegen.pl

#include <cppunit/simpleheader.hxx>

#include <basegfx/vector/b2isize.hxx>
#include <basegfx/range/b2irange.hxx>
#include <basegfx/point/b2ipoint.hxx>
#include <basegfx/matrix/b2dhommatrix.hxx>
#include <basegfx/polygon/b2dpolygon.hxx>
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>

#include <basebmp/color.hxx>
#include <basebmp/scanlineformats.hxx>
#include <basebmp/bitmapdevice.hxx>
#include <basebmp/debug.hxx>
#include "tools.hxx"

#include <iostream>
#include <fstream>

using namespace ::basebmp;

namespace
{
/*
        std::ofstream output("32bpp_test.dump");
        debugDump( rDevice, output );
*/

class PolyTest : public CppUnit::TestFixture
{
private:
    BitmapDeviceSharedPtr mpDevice1bpp;
    BitmapDeviceSharedPtr mpDevice32bpp;

    void implTestEmpty(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( 
            aPoly,
            rtl::OUString::createFromAscii( 
                "m2 2 l7 7 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 0", 
                               countPixel( rDevice, aCol ) == 0);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD( 
            aPoly, 
            rtl::OUString::createFromAscii( 
            "m7 2 l-6 6 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 0(b)", 
                               countPixel( rDevice, aCol ) == 0);
    }

    void implTestHairline(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( 
            aPoly,
            rtl::OUString::createFromAscii( 
                "m2 2 h1 l7 7 h-1 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 7", 
                               countPixel( rDevice, aCol ) == 7);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD( 
            aPoly, 
            rtl::OUString::createFromAscii( 
            "m7 2 h-1 l-6 6 h1 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 6", 
                               countPixel( rDevice, aCol ) == 6);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD( 
            aPoly, 
            rtl::OUString::createFromAscii( 
            "m0 0 l7 7 h-1 l-5-7 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 3", 
                               countPixel( rDevice, aCol ) == 3);
    }

    void implTestPolyPoly(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m0 0 h7 v7 h-7 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m2 2 v3 h3 v-3 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 40", 
                               countPixel( rDevice, aCol ) == 40);
    }

    void implTestPolyPolyClip(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m0 0 h7 v7 h-7 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m2 2 v3 h3 v-3 z" ) );
        basegfx::B2DHomMatrix aMat;
        aMat.translate(-3,-3);
        aMat.rotate( 1.7 );
        aMat.translate(6,5);
        aPoly.transform(aMat);

        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 39", 
                               countPixel( rDevice, aCol ) == 39);

        BitmapDeviceSharedPtr pClippedDevice( 
            subsetBitmapDevice( rDevice,
                                basegfx::B2IRange(3,3,5,8) ));

        rDevice->clear(aBgCol);
        pClippedDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 7", 
                               countPixel( rDevice, aCol ) == 7);
    }

    void implTestPolyPolyCrissCross(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m0 0 v2 l10 2 v-2 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m10 6 v-2 l-10 2 v2 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m1 0 h1 v10 h-1 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m4 0 h1 v10 h-1 z" ) );
        basegfx::tools::importFromSvgD( aPoly, 
                                        ::rtl::OUString::createFromAscii( 
                                            "m8 0 h1 v10 h-1 z" ) );
        rDevice->fillPolyPolygon( 
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 46", 
                               countPixel( rDevice, aCol ) == 46);
    }


public:
    void setUp()
    {
        const basegfx::B2ISize aSize(10,10);
        mpDevice1bpp = createBitmapDevice( aSize,
                                           true,
                                           Format::ONE_BIT_MSB_PAL );
        mpDevice32bpp = createBitmapDevice( aSize,
                                            true,
                                            Format::THIRTYTWO_BIT_TC_MASK );
    }

    void testEmpty()
    {
        implTestEmpty( mpDevice1bpp );
        implTestEmpty( mpDevice32bpp );
    }

    void testHairline()
    {
        implTestHairline( mpDevice1bpp );
        implTestHairline( mpDevice32bpp );
    }
    
    void testPolyPoly()
    {
        implTestPolyPoly( mpDevice1bpp );
        implTestPolyPoly( mpDevice32bpp );
    }

    void testPolyPolyClip()
    {
        implTestPolyPolyClip(mpDevice1bpp);
        implTestPolyPolyClip(mpDevice32bpp);
    }

    void testPolyPolyCrissCross()
    {
        implTestPolyPolyCrissCross(mpDevice1bpp);
        implTestPolyPolyCrissCross(mpDevice32bpp);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(PolyTest);
    CPPUNIT_TEST(testEmpty);
    CPPUNIT_TEST(testHairline);
    CPPUNIT_TEST(testPolyPoly);
    CPPUNIT_TEST(testPolyPolyClip);
    CPPUNIT_TEST(testPolyPolyCrissCross);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(PolyTest, "PolyTest");
}


// -----------------------------------------------------------------------------

// this macro creates an empty function, which will called by the RegisterAllFunctions()
// to let the user the possibility to also register some functions by hand.
//NOADDITIONAL;

