
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
//import org.netbeans.modules.openoffice.wizard.nodes.utils.IdlUtilities;



public class InterfacePanel extends BasePanel
    implements DocumentListener, ChangeListener
{


    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField name;
    private JTextField base;
    
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle");
     
        
        
   public InterfacePanel()
    {
        initComponents();
        postInitComponents();
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public String getBase()
    {
        return base.getText().trim();
    }

    public void setBase(String s)
    {
        base.setText(s);
    }

    private void postInitComponents()
    {
        name.getDocument().addDocumentListener(this);
        base.getDocument().addDocumentListener(this);
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        name = new JTextField();
        base = new JTextField();
    
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(250, 90));
        jLabel1.setText(bundle.getString("TXT_ModuleName"));
        jLabel1.setLabelFor(name);
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 4, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel1, gridbagconstraints);
        jLabel2.setText(bundle.getString("TXT_BaseInterfaces"));
        jLabel2.setLabelFor(base);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(4, 8, 8, 8);
        gridbagconstraints.anchor = 17;
        add(jLabel2, gridbagconstraints);
        name.setPreferredSize(new Dimension(100, 16));
        name.setToolTipText(bundle.getString("TIP_Name"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 4, 4, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(name, gridbagconstraints);
        base.setPreferredSize(new Dimension(100, 16));
        base.setToolTipText(bundle.getString("TIP_BaseInterfaces"));
        
        // Set default base interface.
        base.setText( "com::sun::star::uno::XInterface" );
        
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 8, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(base, gridbagconstraints);
       }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void stateChanged(ChangeEvent changeevent)
    {
        checkState();
    }

    private void checkState()
    {
//        if(IdlUtilities.isValidIDLIdentifier(name.getText()))
//            enableOk();
//        else
//            disableOk();
    }


}
