/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XMLConsolidationContext.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: kz $ $Date: 2006/07/21 12:41:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



//___________________________________________________________________

#ifndef _SC_XMLCONSOLIDATIONCONTEXT_HXX
#include "XMLConsolidationContext.hxx"
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_RANGEUTL_HXX
#include "rangeutl.hxx"
#endif
#ifndef SC_XMLIMPRT_HXX
#include "xmlimprt.hxx"
#endif
#ifndef _SC_XMLCONVERTER_HXX
#include "XMLConverter.hxx"
#endif

#ifndef _XMLOFF_NMSPMAP_HXX
#include <xmloff/nmspmap.hxx>
#endif
#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace xmloff::token;


//___________________________________________________________________

ScXMLConsolidationContext::ScXMLConsolidationContext(
		ScXMLImport& rImport,
		USHORT nPrfx,
		const OUString& rLName,
		const uno::Reference< xml::sax::XAttributeList >& xAttrList ) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	eFunction( SUBTOTAL_FUNC_NONE ),
	bLinkToSource( sal_False ),
	bTargetAddr(sal_False)
{
	rImport.LockSolarMutex();
	if( !xAttrList.is() ) return;

	sal_Int16				nAttrCount		= xAttrList->getLength();
	const SvXMLTokenMap&	rAttrTokenMap	= GetScImport().GetConsolidationAttrTokenMap();

	for( sal_Int16 nIndex = 0; nIndex < nAttrCount; ++nIndex )
	{
		const rtl::OUString& sAttrName	(xAttrList->getNameByIndex( nIndex ));
		const rtl::OUString& sValue		(xAttrList->getValueByIndex( nIndex ));
		OUString aLocalName;
		USHORT nPrefix		= GetScImport().GetNamespaceMap().GetKeyByAttrName( sAttrName, &aLocalName );

		switch( rAttrTokenMap.Get( nPrefix, aLocalName ) )
		{
			case XML_TOK_CONSOLIDATION_ATTR_FUNCTION:
				eFunction = ScXMLConverter::GetSubTotalFuncFromString( sValue );
			break;
			case XML_TOK_CONSOLIDATION_ATTR_SOURCE_RANGES:
				sSourceList = sValue;
			break;
			case XML_TOK_CONSOLIDATION_ATTR_TARGET_ADDRESS:
				{
					sal_Int32 nOffset(0);
					bTargetAddr = ScXMLConverter::GetAddressFromString(
						aTargetAddr, sValue, GetScImport().GetDocument(), nOffset );
				}
				break;
			case XML_TOK_CONSOLIDATION_ATTR_USE_LABEL:
				sUseLabel = sValue;
			break;
			case XML_TOK_CONSOLIDATION_ATTR_LINK_TO_SOURCE:
				bLinkToSource = IsXMLToken(sValue, XML_TRUE);
			break;
		}
	}
}

ScXMLConsolidationContext::~ScXMLConsolidationContext()
{
}

SvXMLImportContext *ScXMLConsolidationContext::CreateChildContext(
		USHORT nPrefix,
		const OUString& rLName,
		const uno::Reference< xml::sax::XAttributeList>& xAttrList )
{
	return new SvXMLImportContext( GetImport(), nPrefix, rLName );
}

void ScXMLConsolidationContext::EndElement()
{
	if (bTargetAddr)
	{
		ScConsolidateParam aConsParam;
		aConsParam.nCol = aTargetAddr.Col();
		aConsParam.nRow = aTargetAddr.Row();
		aConsParam.nTab = aTargetAddr.Tab();
		aConsParam.eFunction = eFunction;

		sal_Bool bError = sal_False;
		USHORT nCount = (USHORT) Min( ScXMLConverter::GetTokenCount( sSourceList ), (sal_Int32)0xFFFF );
		ScArea** ppAreas = nCount ? new ScArea*[ nCount ] : NULL;
		if( ppAreas )
		{
			sal_Int32 nOffset = 0;
			USHORT nIndex;
			for( nIndex = 0; nIndex < nCount; ++nIndex )
			{
				ppAreas[ nIndex ] = new ScArea;
				if ( !ScXMLConverter::GetAreaFromString(
					*ppAreas[ nIndex ], sSourceList, GetScImport().GetDocument(), nOffset ) )
				{
					bError = sal_True;		//! handle error
				}
			}

			aConsParam.SetAreas( ppAreas, nCount );

			// array is copied in SetAreas
			for( nIndex = 0; nIndex < nCount; ++nIndex )
				delete ppAreas[nIndex];
			delete[] ppAreas;
		}

		aConsParam.bByCol = aConsParam.bByRow = FALSE;
		if( IsXMLToken(sUseLabel, XML_COLUMN ) )
			aConsParam.bByCol = TRUE;
		else if( IsXMLToken( sUseLabel, XML_ROW ) )
			aConsParam.bByRow = TRUE;
		else if( IsXMLToken( sUseLabel, XML_BOTH ) )
			aConsParam.bByCol = aConsParam.bByRow = TRUE;

		aConsParam.bReferenceData = bLinkToSource;

		ScDocument* pDoc = GetScImport().GetDocument();
		if( pDoc )
			pDoc->SetConsolidateDlgData( &aConsParam );
	}
	GetScImport().UnlockSolarMutex();
}

