/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtmodel.cxx,v $
 *
 *  $Revision: 1.75 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 12:36:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma optimize("e",off)

#pragma hdrstop

class SbxArray;

#ifndef _OUTLINER_HXX
#include <svx/svdoutl.hxx>
#endif

#include "itempool.hxx"

#ifndef _SVDPAGE_HXX
#include <svx/svdpage.hxx>
#endif

#include <svx/svdetc.hxx>

#ifndef _EEITEM_HXX
#include <svx/eeitem.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _ZFORLIST_HXX
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _SVDORECT_HXX
#include <svx/svdorect.hxx>
#endif
#ifndef _XLNCLIT_HXX
#include <svx/xlnclit.hxx>
#endif
#ifndef _XLNWTIT_HXX
#include <svx/xlnwtit.hxx>
#endif
#ifndef _XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif
#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

#ifndef _SVX_CHRTITEM_HXX
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTLEGENDPOS   SCHATTR_LEGEND_POS
#define ITEMID_CHARTDATADESCR   SCHATTR_DATADESCR_DESCR
#define ITEMID_LANGUAGE           EE_CHAR_LANGUAGE
#include <svx/chrtitem.hxx>
#endif

#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#include <svx/fontitem.hxx>
#include <svx/fhgtitem.hxx>
#include <svx/colritem.hxx>
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef INCLUDED_I18NPOOL_LANG_H
#include <i18npool/lang.h>
#endif

#ifndef _SVX_XLINEIT0_HXX
#include <svx/xlineit0.hxx>
#endif

// header for XHyphenator
#ifndef _COM_SUN_STAR_LINGUISTIC2_XHYPHENATOR_HPP_
#include <com/sun/star/linguistic2/XHyphenator.hpp>
#endif
// header for LinguMgr
#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
// header for class SvtLinguConfig
#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <svtools/lingucfg.hxx>
#endif
// header for getProcessServiceFactory
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif
#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#include "charttyp.hxx"

#include "float.h"


#include "pairs.hxx"
#include "stlpool.hxx"
#include "schresid.hxx"
#include "glob.hrc"

#include "datalog.hxx"
#include "chaxis.hxx"

#include "chtscene.hxx"
#include "svx/def3d.hxx"

#ifndef _SCH_DOCSHELL_HXX
#include "docshell.hxx"
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTDATACHANGEEVENT_HPP_
#include <com/sun/star/chart/ChartDataChangeEvent.hpp>
#endif
#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XLINGUSERVICEMANAGER_HPP_
#include <com/sun/star/linguistic2/XLinguServiceManager.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _SVX_LANGITEM_HXX
#include <svx/langitem.hxx>
#endif
#ifndef _XCEPTION_HXX_
#include <vos/xception.hxx>
#endif
#ifndef _UNDO_HXX
#include <svtools/undo.hxx>
#endif

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

/************************************************************************/

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

using namespace com::sun::star;

ChartModel::ChartModel( const String& rPalettePath, SfxObjectShell* pDocSh ) :
	pChartDataBuffered(NULL),
	pAutoPilot(NULL),//#46895#
	bClearDepth(FALSE),
	bNewOrLoadCompleted(FALSE),//aus SchChartDocument::
	nChartStatus( CHS_USER_QUERY ),
    SdrModel( rPalettePath, NULL, pDocSh ),
	aChartRect (Rectangle ()),
	aInitialSize (Size ()),
	bTextScalable (TRUE),
	bIsCopied (FALSE),
	bLegendVisible (TRUE),
	bShowAverage (FALSE),
	eErrorKind (CHERROR_NONE),
	eIndicate (CHINDICATE_NONE),
	eRegression (CHREGRESS_NONE),
	fIndicatePercent (0.0),
	fIndicateBigError (0.0),
	fIndicatePlus (0.0),
	fIndicateMinus (0.0),
	nSplineDepth (3),
	nGranularity (20),
	bSwitch3DColRow (FALSE), // FG: reiner Zwischenspeicher, damit die ChartScene das nicht als Parameter bekommt
							 //     ist immer gleich bSwitchRowCol, das aber wird durchs Chart als Parameter
							 //     durchgereicht.
	pChItemPool (new SchItemPool),
	pScene (0),
	aLightVec (new Vector3D (1, 1, 1)), // old: aLightVec (new Vector3D (0, 0, 1)),
	pChartData (0),
	fMinData (0.0),
	fMaxData (0.0),
	fAmbientIntensity(0.6),
	aAmbientColor(RGBColor(COL_WHITE)),
	fSpotIntensity (0.6),
	aSpotColor(RGBColor(COL_WHITE)),
	eChartStyle (CHSTYLE_2D_COLUMN),
	eOldChartStyle (CHSTYLE_3D_XYZSYMBOLS),
	pDefaultColors (0),
	nMarkLen (100),
	nPieHeight (20),
	pPieSegOfs (0),
	nPieSegCount (0),
	nXAngle (100), // old: nXAngle (200),
	nYAngle (250), // old: nYAngle (350),
	nZAngle (0),
	bCanRebuild (TRUE),
	bShowMainTitle (TRUE),
	aMainTitle (String ()),
	bShowSubTitle (FALSE),
	aSubTitle (String ()),
	bShowXAxisTitle (FALSE),
	aXAxisTitle (String ()),
	bShowYAxisTitle (FALSE),
	aYAxisTitle (String ()),
	bShowZAxisTitle (FALSE),
	aZAxisTitle (String ()),
	bShowXGridMain (TRUE),
	bShowXGridHelp (FALSE),
	bShowYGridMain (FALSE),
	bShowYGridHelp (FALSE),
	bShowZGridMain (FALSE),
	bShowZGridHelp (FALSE),
	eDataDescr (CHDESCR_NONE),
	bShowSym (FALSE),
	bSwitchData (TRUE),
	bNoBuildChart( FALSE ),
	bShouldBuildChart( TRUE ),
	bReadError (FALSE),
	mbIsInitialized(FALSE),
	pOwnNumFormatter(FALSE),
	pOutliner(NULL),
		// FG: nMoreData >=12
	bFormatXAxisTextInMultipleLinesIfNecessary (TRUE),
	bFormatYAxisTextInMultipleLinesIfNecessary (FALSE),
	bFormatZAxisTextInMultipleLinesIfNecessary (FALSE),
	bFormatLegendTextInMultipleLinesIfNecessary (TRUE),
		// FG: nMoreData >=13
	nXAxisTextMaximumNumberOfLines(2),
	nYAxisTextMaximumNumberOfLines(1),
	nZAxisTextMaximumNumberOfLines(1),
	nWidthOfFirstXAxisText (0),
	nWidthOfLastXAxisText (0),
	aTitleTopCenter(-1,-1),
	aSubTitleTopCenter(-1,-1),
	aDiagramRectangle(-1,-1,-1,-1),
	aLastDiagramRectangle(-1,-1,-1,-1),
	aLegendTopLeft(-1,-1),
	aTitleXAxisPosition (-1,-1),
	eAdjustXAxesTitle(CHADJUST_TOP_CENTER),
	aTitleYAxisPosition(-1,-1),
	eAdjustYAxesTitle(CHADJUST_TOP_CENTER),
	aTitleZAxisPosition (-1,-1),
	eAdjustZAxesTitle(CHADJUST_TOP_CENTER),
	bUseRelativePositionsForChartGroups(FALSE),
	bAdjustMarginsForLegend(TRUE),
	bAdjustMarginsForMainTitle(TRUE),
	bAdjustMarginsForSubTitle(TRUE),
	bAdjustMarginsForXAxisTitle(TRUE),
	bAdjustMarginsForYAxisTitle(TRUE),
	bAdjustMarginsForZAxisTitle(TRUE),
	bDiagramHasBeenMovedOrResized(FALSE),
	bMainTitleHasBeenMoved(FALSE),
	bSubTitleHasBeenMoved(FALSE),
	bLegendHasBeenMoved(FALSE),
	bXAxisTitleHasBeenMoved(FALSE),
	bYAxisTitleHasBeenMoved(FALSE),
	bZAxisTitleHasBeenMoved(FALSE),
	aInitialSizefor3d (-1,-1),    // FG: Zwischenspeicher fuer InitalSize (siehe chtmod3d.cxx, Position3DAxisTitles
	pTestTextObj(NULL),  //  FG: fuer GetHeightOfnRows, ein Dummy-Textpointer
	pLogBook(NULL),
	bShowDataDescr(TRUE),

	pDocShell(pDocSh), //aus SchChartDocument::
//  	bFreshLoaded (FALSE),
	m_nDefaultColorSet(0),  //#50037#
	nBarPercentWidth(100),   //#50116#
	nNumLinesInColChart(0),   //#50212#
	bAttrAutoStorage(FALSE),
	pChartRefOutDev(NULL),
	pChartXAxis(NULL),
	pChartYAxis(NULL),
	pChartZAxis(NULL),
	pChartBAxis(NULL),
	pChartAAxis(NULL),
//BFS03	pTmpXItems(NULL),
//BFS03	pTmpYItems(NULL),
//BFS03	pTmpZItems(NULL),
	pSdrObjList(NULL),
	eProjection(PR_PERSPECTIVE),
	bResizePie(TRUE),
	nPieRadius(0),
	pNumFormatter(NULL),
	nXLastNumFmt(-1),
	nYLastNumFmt(-1),
	nBLastNumFmt(-1),
	eLanguage( LANGUAGE_SYSTEM ),
	eLanguageCJK( LANGUAGE_SYSTEM ),
	eLanguageCTL( LANGUAGE_SYSTEM ),
    mpDocStor( NULL ),
	m_pUndoActionFromDraw(NULL),
	m_bDeleteUndoActionNotificationFromDraw(TRUE),
    m_bChangeNotificationsEnabled(true)
{
	SdrModel::SetNotifyUndoActionHdl(LINK( this, ChartModel, NotifyUndoActionHdl ));

    if( pDocSh != NULL )
    {
        // enable swapping of metafiles and bitmaps that
        // might be in a chart as additional objects
        SetSwapGraphics( TRUE );
    }

	aLightVec->Normalize ();

	SetScaleUnit(MAP_100TH_MM);
	SetScaleFraction(Fraction(1, 1));
	SetDefaultFontHeight(847);     // 24pt

	SfxItemPool* pPool = &GetItemPool();
	pPool->SetDefaultMetric(SFX_MAPUNIT_100TH_MM);
	pPool->SetPoolDefaultItem( SfxBoolItem(EE_PARA_HYPHENATE, TRUE) );
	pPool->SetPoolDefaultItem(Svx3DPercentDiagonalItem (5));

	pOwnNumFormatter = new SvNumberFormatter( ::comphelper::getProcessServiceFactory(),
											  LANGUAGE_SYSTEM );
	pOwnNumFormatter->ChangeStandardPrec( 15 );

	// append pool to end of pool chain
	for (;;)
	{
		SfxItemPool* pSecondary = pPool->GetSecondaryPool();
		if (!pSecondary)
			break;

		pPool = pSecondary;
	}

	pPool->SetSecondaryPool(pChItemPool);

	SfxItemPool* pMasterPool = &GetItemPool();
	pMasterPool->FreezeIdRanges();

	// get current language
	pOutliner = SdrMakeOutliner( OUTLINERMODE_TEXTOBJECT, this);
	SdrOutliner& rDrawOutliner = GetDrawOutliner();

	try
	{
        // set language properties
        SvtLinguConfig aLinguConfig;
        SvtLinguOptions aLinguOptions;

        if( aLinguConfig.GetOptions( aLinguOptions ) )
        {
            SetLanguage( aLinguOptions.nDefaultLanguage,     EE_CHAR_LANGUAGE );
            SetLanguage( aLinguOptions.nDefaultLanguage_CJK, EE_CHAR_LANGUAGE_CJK );
            SetLanguage( aLinguOptions.nDefaultLanguage_CTL, EE_CHAR_LANGUAGE_CTL );
        }

        // set hyphenator
        Reference< XHyphenator > xHyphenator( LinguMgr::GetHyphenator());
        if( xHyphenator.is() )
        {
            rDrawOutliner.SetHyphenator( xHyphenator );
            pOutliner->SetHyphenator( xHyphenator );
        }
    }
	catch( uno::Exception aEx )
	{
#ifdef DBG_UTIL
        // convert rtl::OUString => tools String => ByteString
        String aStr( aEx.Message );
        ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
        DBG_ERROR1( "LinguProperties threw exception: %s", aBStr.GetBuffer());
#endif
	}

	// init item sets for chart objects
	pTitleAttr          = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pMainTitleAttr      = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pSubTitleAttr       = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pXAxisTitleAttr     = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pYAxisTitleAttr     = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pZAxisTitleAttr     = new SfxItemSet(*pItemPool, nTitleWhichPairs);
	pAxisAttr           = new SfxItemSet(*pItemPool, nAllAxisWhichPairs);
	pGridAttr           = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pXGridMainAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pYGridMainAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pZGridMainAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pXGridHelpAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pYGridHelpAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pZGridHelpAttr      = new SfxItemSet(*pItemPool, nGridWhichPairs);
	pDiagramAreaAttr    = new SfxItemSet(*pItemPool, nDiagramAreaWhichPairs);
	pDiagramWallAttr    = new SfxItemSet(*pItemPool, nDiagramAreaWhichPairs);
	pDiagramFloorAttr   = new SfxItemSet(*pItemPool, nDiagramAreaWhichPairs);
	pLegendAttr         = new SfxItemSet(*pItemPool, nLegendWhichPairs);
	pChartAttr          = new SfxItemSet(*pItemPool, nChartWhichPairs);
	pDummyAttr          = new SfxItemSet(*pItemPool, nRowWhichPairs);

	pStockLineAttr		= new SfxItemSet(*pItemPool, nRowWhichPairs);
	pStockLossAttr		= new SfxItemSet(*pItemPool, nRowWhichPairs);
	pStockPlusAttr		= new SfxItemSet(*pItemPool, nRowWhichPairs);

	SdrPage* pPage = 0L;

	if(GetPageCount())
	{
		pPage = GetPage(0);
	}

	if (pPage) aInitialSize = pPage->GetSize();

	CreateDefaultColors ();
	eChartLinePoints[0] =
	eChartLinePoints[1] =
	eChartLinePoints[2] =
	eChartLinePoints[3] =
	eChartLinePoints[4] =
	eChartLinePoints[5] =
	eChartLinePoints[6] =
	eChartLinePoints[7] =
	eChartLinePoints[8] = 0;

	Font aLatinFont( OutputDevice::GetDefaultFont( DEFAULTFONT_LATIN_SPREADSHEET, GetLanguage( EE_CHAR_LANGUAGE ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItem( aLatinFont.GetFamily(), aLatinFont.GetName(), aLatinFont.GetStyleName(), aLatinFont.GetPitch(),
		                      aLatinFont.GetCharSet(), EE_CHAR_FONTINFO );

	Font aCJKFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CJK_SPREADSHEET, GetLanguage( EE_CHAR_LANGUAGE_CJK ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItemCJK( aCJKFont.GetFamily(), aCJKFont.GetName(), aCJKFont.GetStyleName(), aCJKFont.GetPitch(),
		                         aCJKFont.GetCharSet(), EE_CHAR_FONTINFO_CJK );

	Font aCTLFont( OutputDevice::GetDefaultFont( DEFAULTFONT_CTL_SPREADSHEET, GetLanguage( EE_CHAR_LANGUAGE_CTL ), DEFAULTFONT_FLAGS_ONLYONE ) );
	SvxFontItem aSvxFontItemCTL( aCTLFont.GetFamily(), aCTLFont.GetName(), aCTLFont.GetStyleName(), aCTLFont.GetPitch(),
		                         aCTLFont.GetCharSet(), EE_CHAR_FONTINFO_CTL );

	// main title
	pTitleAttr->Put(aSvxFontItem);
	pTitleAttr->Put(SvxFontHeightItem( 459, 100, EE_CHAR_FONTHEIGHT ));	// 13pt
	pTitleAttr->Put(aSvxFontItemCJK);
	pTitleAttr->Put(SvxFontHeightItem( 459, 100, EE_CHAR_FONTHEIGHT_CJK ));	// 13pt
	pTitleAttr->Put(aSvxFontItemCTL);
	pTitleAttr->Put(SvxFontHeightItem( 459, 100, EE_CHAR_FONTHEIGHT_CTL ));	// 13pt
    // the font color has 'automatic' as default that should not be overwritten
// 	pTitleAttr->Put(SvxColorItem(RGBColor(COL_BLACK)));
	pTitleAttr->Put(XLineStyleItem(XLINE_NONE));
	pTitleAttr->Put(XFillStyleItem(XFILL_NONE));
	pTitleAttr->Put(SvxChartTextOrientItem(CHTXTORIENT_AUTOMATIC));
	pMainTitleAttr->Put(*pTitleAttr);

	// sub title
	pTitleAttr->Put(SvxFontHeightItem( 388, 100, EE_CHAR_FONTHEIGHT ));	// 11pt
	pTitleAttr->Put(SvxFontHeightItem( 388, 100, EE_CHAR_FONTHEIGHT_CJK ));	// 11pt
	pTitleAttr->Put(SvxFontHeightItem( 388, 100, EE_CHAR_FONTHEIGHT_CTL ));	// 11pt
	pSubTitleAttr->Put(*pTitleAttr);

	// axis titles
	pTitleAttr->Put(SvxFontHeightItem( 318, 100, EE_CHAR_FONTHEIGHT ));	// 9pt
	pTitleAttr->Put(SvxFontHeightItem( 318, 100, EE_CHAR_FONTHEIGHT_CJK ));	// 9pt
	pTitleAttr->Put(SvxFontHeightItem( 318, 100, EE_CHAR_FONTHEIGHT_CTL ));	// 9pt
	pXAxisTitleAttr->Put(*pTitleAttr);
	pYAxisTitleAttr->Put(*pTitleAttr);
	pZAxisTitleAttr->Put(*pTitleAttr);

	// general axis attributies: are also set in class ChartAxis()
	// (BM) => deprecated and therefore removed here

    Color aAreaBackColor( RGBColor( COL_WHITE ));
	pDiagramAreaAttr->Put(XLineStyleItem(XLINE_NONE));
	pDiagramAreaAttr->Put(XFillColorItem(String(), aAreaBackColor));

    // set the page color (in a chart this is the color of the area)
    // at the outliner
    if( pOutliner )
        pOutliner->SetBackgroundColor( aAreaBackColor );

	pDiagramWallAttr->Put(XLineStyleItem(XLINE_NONE));
	pDiagramWallAttr->Put(XFillStyleItem(XFILL_NONE));

	pDiagramFloorAttr->Put(XLineStyleItem(XLINE_NONE));
	pDiagramFloorAttr->Put(XFillColorItem(String(), Color(153, 153, 153)));

	pLegendAttr->Put(aSvxFontItem);
	pLegendAttr->Put(aSvxFontItemCJK);
	pLegendAttr->Put(aSvxFontItemCTL);
	pLegendAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT ));	// 6pt #72012#
	pLegendAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT_CJK ));	// 6pt #72012#
	pLegendAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT_CTL ));	// 6pt #72012#
	pLegendAttr->Put(XFillStyleItem(XFILL_NONE));

	//Todo: ueberpruefen, ob noch korekkt, es wird der default-ChartTyp erzeugt und der
	//AttrSet in pChartAttr gesetzt
	ChartType aTyp((SvxChartStyle) CHSTYLE_2D_COLUMN);
	aTyp.GetAttrSet(pChartAttr);

	// the dummy attribute is (mainly!) used for data row defaults
	// so avoid setting (pool) default values here as fixed
	pDummyAttr->Put( aSvxFontItem );
	pDummyAttr->Put( aSvxFontItemCJK );
	pDummyAttr->Put( aSvxFontItemCTL );
	pDummyAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT ));	// 6pt #72012#
	pDummyAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT_CJK ));	// 6pt #72012#
	pDummyAttr->Put(SvxFontHeightItem( 212, 100, EE_CHAR_FONTHEIGHT_CTL ));	// 6pt #72012#

	// what are these needed for?
	pDummyAttr->Put (SfxInt32Item (SCHATTR_DUMMY0, (INT32) eChartStyle));
	pDummyAttr->Put (SfxInt32Item (SCHATTR_DUMMY1, 0));

	pStockLossAttr->Put(XFillColorItem(String(), RGBColor(COL_BLACK)));
	pStockPlusAttr->Put(XFillColorItem(String(), RGBColor(COL_WHITE)));

	// this test object is for calculating the text height in GetHeightOfnRows
	// (chtmode1.cxx) without creating a new object for each call.
	pTestTextObj = new SdrRectObj (OBJ_TEXT, Rectangle(0, 0, 10, 10) /*, aTestStr*/);

	//Aus SchChartDocument::
	SetStyleSheetPool(new SchStyleSheetPool(*pItemPool));
	((SdrOutliner*)pDrawOutliner)->SetStyleSheetPool((SfxStyleSheetPool*)pStyleSheetPool);
	pOutliner->SetStyleSheetPool((SfxStyleSheetPool*)pStyleSheetPool);

	// Layer anlegen

	SdrLayerAdmin& rLayerAdmin = GetLayerAdmin();
	rLayerAdmin.NewLayer( String( SchResId( STR_LAYOUT )));
	rLayerAdmin.NewLayer( String( SchResId( STR_CONTROLS )));


	//Wichtig! die Achsen muessen jetzt erstellt werden, dies darf erst nach dem
	//anlegen des ItemPools und der Defaults passieren!
	pChartXAxis = new ChartAxis( this, CHART_AXIS_X, CHAXIS_AXIS_X );
	pChartYAxis = new ChartAxis( this, CHART_AXIS_Y, CHAXIS_AXIS_Y );
	pChartZAxis = new ChartAxis( this, CHART_AXIS_Z, CHAXIS_AXIS_Z );
	pChartBAxis = new ChartAxis( this, CHART_AXIS_Y, CHAXIS_AXIS_B );
	pChartAAxis = new ChartAxis( this, CHART_AXIS_X, CHAXIS_AXIS_A );

	pChartYAxis->IfNoDataLookAt( CHAXIS_AXIS_B ); //Falls Achse nur ein Spiegelbild ist....
	pChartBAxis->IfNoDataLookAt( CHAXIS_AXIS_Y ); //d.h. keine eigenen Datenreihen besitzt

	aBarY1.Assign(this,pChartYAxis);
	aBarY2.Assign(this,pChartBAxis);

	pChartXAxis->SetAllAxisAttr(pAxisAttr);
	pChartYAxis->SetAllAxisAttr(pAxisAttr);
	pChartZAxis->SetAllAxisAttr(pAxisAttr);
	pChartAAxis->SetAllAxisAttr(pAxisAttr);
	pChartBAxis->SetAllAxisAttr(pAxisAttr);

	pChartXAxis->SetGridAttrList(pYGridMainAttr);//XGrid->YAchse :(  (u.U.)
	pChartYAxis->SetGridAttrList(pXGridMainAttr);

	SetNumberFormatter( pOwnNumFormatter );				// sets number formatter also for all axes

	long nTmp=pNumFormatter->GetStandardFormat(NUMBERFORMAT_NUMBER, LANGUAGE_SYSTEM);
	SetNumFmt(CHOBJID_DIAGRAM_X_AXIS,nTmp,FALSE);
	SetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,nTmp,FALSE);
	SetNumFmt(CHOBJID_DIAGRAM_Z_AXIS,nTmp,FALSE);
	SetNumFmt(CHOBJID_DIAGRAM_A_AXIS,nTmp,FALSE);
	SetNumFmt(CHOBJID_DIAGRAM_B_AXIS,nTmp,FALSE);

	pChartBAxis->ShowAxis(FALSE);
	pChartBAxis->ShowDescr(FALSE);
	pChartAAxis->ShowAxis(FALSE);
	pChartAAxis->ShowDescr(FALSE);

	pSdrObjList=new SdrObjList(this,NULL);

    // #99528# change auto-font color according to default diagram area
    PageColorChanged( *pDiagramAreaAttr );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/
void ChartModel::ClearItemSetLists()
{
	long i, nCount;

	nCount = aDataRowAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aDataRowAttrList.GetObject(i);
	aDataRowAttrList.Clear();

	nCount = aRegressAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aRegressAttrList.GetObject(i);
	aRegressAttrList.Clear();

	nCount = aDataPointAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aDataPointAttrList.GetObject(i);
	aDataPointAttrList.Clear();

	nCount = aSwitchDataPointAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aSwitchDataPointAttrList.GetObject(i);
	aSwitchDataPointAttrList.Clear();

	nCount =  aAverageAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aAverageAttrList.GetObject(i);
	aAverageAttrList.Clear();

	nCount =  aErrorAttrList.Count();
	for (i = 0 ; i < nCount; i++)
		delete aErrorAttrList.GetObject(i);
	aErrorAttrList.Clear();
}
ChartModel::~ChartModel()
{
//BFS03	if(pTmpXItems)
//BFS03		delete pTmpXItems;
//BFS03	if(pTmpYItems)
//BFS03		delete pTmpYItems;
//BFS03	if(pTmpZItems)
//BFS03		delete pTmpZItems;

	if(pChartRefOutDev)
		delete pChartRefOutDev;

	// #116168#
	ClearModel(sal_True);
	//Clear();//aus SchChartDocument::

	delete pTitleAttr;
	delete pMainTitleAttr;
	delete pSubTitleAttr;
	delete pXAxisTitleAttr;
	delete pYAxisTitleAttr;
	delete pZAxisTitleAttr;
	delete pAxisAttr;

	delete pChartXAxis;
	delete pChartYAxis;
	delete pChartZAxis;
	delete pChartAAxis;
	delete pChartBAxis;

	delete pGridAttr;
	delete pXGridMainAttr;
	delete pYGridMainAttr;
	delete pZGridMainAttr;
	delete pXGridHelpAttr;
	delete pYGridHelpAttr;
	delete pZGridHelpAttr;
	delete pDiagramAreaAttr;
	delete pDiagramWallAttr;
	delete pDiagramFloorAttr;
	delete pLegendAttr;
	delete pChartAttr;
	delete pDummyAttr;
	delete aLightVec;

	delete pStockLineAttr;
	delete pStockLossAttr;
	delete pStockPlusAttr;

	DestroyDefaultColors();
	delete pOutliner;
	ClearItemSetLists();

	// suche nach dem ChartPool in der Poolkette, loesche alle verbindungen
	// und vernichte den pool. vorgehen ist unabhaengig von der anzahl
	// der vorangehendem pools. [RB]
	SfxItemPool* pPool = &GetItemPool();

	for (;;)
	{
		SfxItemPool* pSecondary = pPool->GetSecondaryPool();
		if (pSecondary == pChItemPool)
		{
			pPool->SetSecondaryPool (NULL);
			break;
		}

		pPool = pSecondary;
	}

	delete pChItemPool;

	delete pOwnNumFormatter;

	delete[] pPieSegOfs;

	if(pChartData)
	{
		if(pChartData->DecreaseRefCount())
			delete pChartData;
		pChartData=NULL;
	}

	if (pTestTextObj != NULL) delete pTestTextObj;
	if (pLogBook) delete pLogBook;



	SdrObject *pObj;
	while(pSdrObjList->GetObjCount())
		if(pObj=pSdrObjList->RemoveObject(0))
			delete	pObj;
	delete pSdrObjList;

	if(m_pUndoActionFromDraw) delete m_pUndoActionFromDraw;
}
SdrObjList *ChartModel::GetSdrObjList()
{
	if(pSdrObjList)
	{
		SdrObject *pObj;
		while(pSdrObjList->GetObjCount())
			if(pObj=pSdrObjList->RemoveObject(0))
				delete	pObj;
	}

	ULONG nLegendHeight = ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight();

	SfxItemSet aSet(*pDummyAttr);
	aSet.ClearItem(SCHATTR_SYMBOL_BRUSH);
	aSet.ClearItem(SCHATTR_SYMBOL_SIZE);
	for(long n=0;n<CHART_NUM_SYMBOLS;n++)
	{
		aSet.Put(SfxInt32Item(SCHATTR_STYLE_SYMBOL,n));
		pSdrObjList->NbcInsertObject(CreateSymbol(Point(0,0),n,0,aSet,nLegendHeight,FALSE));
	}

	return pSdrObjList;
}
SdrObject *ChartModel::CreateDefaultSymbol(long nRow)
{
	ULONG nLegendHeight = ((SvxFontHeightItem &) pLegendAttr->Get (EE_CHAR_FONTHEIGHT)).GetHeight();
	SfxItemSet aSet(GetDataRowAttr(nRow));
	aSet.ClearItem(SCHATTR_STYLE_SYMBOL);
	aSet.ClearItem(SCHATTR_SYMBOL_BRUSH);
	aSet.ClearItem(SCHATTR_SYMBOL_SIZE);

	return CreateSymbol(Point(0,0),nRow,0,aSet,nLegendHeight,FALSE);
}
/*************************************************************************
|*
|* Das Logbuch dient zur ReAttributierung, nachdem die DataBrowseBox
|* aufgerufen und Daten hinzugefuegt wurden. Die BrowseBox setzt
|* eine
|*
\************************************************************************/
void ChartModel::SetDataLogBook(SchDataLogBook* pLog)
{
	if(pLogBook)
		delete pLogBook;
	pLogBook=pLog;
}


/*************************************************************************
|*
|* Chart-Datenstruktur auswechseln; bisherige wird ggf. geloescht;
|* Liefert TRUE, wenn die Chart-Datenstruktur gewechselt wurde.
|*
\************************************************************************/

BOOL ChartModel::ChangeChartData(SchMemChart& rData, BOOL bNewTitles,BOOL bDontBuild)
{
	if (pChartData == &rData) return FALSE;
	else
	{
		SetChartData(rData, bNewTitles);

		if( pDocShell &&
			pDocShell->ISA( SchChartDocShell ))
		{
			chart::ChartDataChangeEvent aEvent;
			aEvent.Type = chart::ChartDataChangeType_ALL;
			aEvent.StartColumn = 0;
			aEvent.EndColumn = 0;
			aEvent.StartRow = 0;
			aEvent.EndRow = 0;
			SAL_STATIC_CAST( SchChartDocShell*, pDocShell )->DataModified( aEvent );
		}

		if(!bDontBuild)
			BuildChart(FALSE);
		return TRUE;
	}
}

/*************************************************************************
|*
|* Datenzeilen in Reihen/Spalten umschalten;
|* Liefert bei Umschaltung TRUE
|*
\************************************************************************/

BOOL ChartModel::ChangeSwitchData(BOOL bSwitch)
{
	if (bSwitchData == bSwitch) return FALSE;
	else
	{
		bSwitchData = bSwitch;

#ifndef NO_56798_FIX //#56798# QuickFix 5.0-Final
		if( IsReal3D() )
		{
			bClearDepth=TRUE;
			long i,nORow=aDataRowAttrList.Count();
			for(i=0;i<nORow;i++)
//-/				aDataRowAttrList.GetObject(i)->ClearItem(SID_ATTR_3D_DEPTH);
				aDataRowAttrList.GetObject(i)->ClearItem(SDRATTR_3DOBJ_DEPTH);
			SfxItemSet	*	pAttributes;
			nORow=aDataPointAttrList.Count();
			for(i=0;i<nORow;i++)
			{
				pAttributes = aDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
					pAttributes->ClearItem(SDRATTR_3DOBJ_DEPTH);
			}
			nORow=aSwitchDataPointAttrList.Count();
			for(i=0;i<nORow;i++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
					pAttributes->ClearItem(SDRATTR_3DOBJ_DEPTH);
			}
		}
#endif

        // the number of series may change, so the attribute list
        // must be adapted
        InitDataAttrs();

		// BM: #68764#
		// if global data descriptions are on transfer them to new rows
		if( eDataDescr != CHDESCR_NONE )
		{
			ChangeDataDescr( eDataDescr, bShowSym, -1, FALSE );
		}

		BuildChart(FALSE);
		return TRUE;
	}
}




/**	@descr	Set up the line attributes of every data row.  This includes
		the line style, width, and color.  Style is set to solid, width to
		the minimal width (if the given mode is not SETLINES_COMPAT).
		The color depends on the given mode.
		If the chart is a stock chart then all the lines are simply switched
		off (by setting line style XLINE_NONE).  No other attributes are 
		modified.
	@param	nMode	Specifies the line color of each data row.
			SETLINES_COMPAT	and SETLINES_FILLCOLOR set the line color
				to the fill color.  SETLINES_COMPAT does not change line
				style nor width.
			SETLINES_REVERSE sets the fill color to the line color.
			SETLINES_BLACK sets the line color to black.
*/
void ChartModel::SetupLineColors( const long nMode, long nStartIndex ) //#54870#
{
	long	nRow,
			nRowCnt;
			
	//	The Row count depends (again) on wether the data set is transposed
	//	(switched) or not.  Because this returns the wrong value in case of 
	//	a pie chart, then we access the raw row count without regarding the
	//	transpose switch.
	if (IsPieChart())
		nRowCnt = GetColCount(); // ChartData()->GetRowCount();
	else
		nRowCnt = GetRowCount();

    long nUpperIndex = ::std::min( static_cast< ULONG >( nRowCnt ), aDataRowAttrList.Count() );

    if( nStartIndex < nUpperIndex )
    {
        if (HasStockLines())
        {
            //	Switch off lines for stock charts.
            for( nRow = nStartIndex; nRow < nUpperIndex; nRow++ )
                aDataRowAttrList.GetObject(nRow)->Put(XLineStyleItem(XLINE_NONE));
        }
        else
        {
            //	Initialize the item set that will be set to all data rows.
            //	If nMode==SETLINES_COMPAT initialization is skipped and only
            //	the line colors are set to the fill colors.
            SfxItemSet rAttr(GetItemPool(),XATTR_START,XATTR_END);
            if(nMode != SETLINES_COMPAT)
            {
                //	Default values represent a solid black line of minimal width.
                rAttr.Put(XLineStyleItem(XLINE_SOLID));
                rAttr.Put(XLineColorItem(String(),RGBColor(COL_BLACK)));
                rAttr.Put(XLineWidthItem (0));
            }

            //	Set the itemset rAttr to all data rows.  Depending on nMode it is first
            //	modified so that the line color is set to the fill color or the other
            //	way round.
            //	The for loop and switch statement changed places in order to not
            //	having to execute the switch statement in every iteration.
            switch(nMode)
            {
                case SETLINES_COMPAT:
                case SETLINES_FILLCOLOR:
                    //	Set the line colors to the former fill colors.
                    for( nRow = nStartIndex; nRow < nUpperIndex; nRow++ )
                        if(IsLine(nRow))
                        {
                            rAttr.Put(XLineColorItem(String(),
                                                     ((XFillColorItem &)GetDataRowAttr(nRow).Get(XATTR_FILLCOLOR)).
                                                     GetColorValue()));
                            aDataRowAttrList.GetObject(nRow)->Put(rAttr);
                        }
                    break;

                case SETLINES_REVERSE:
                    //	Set the fill colors to the former line colors.
                    for( nRow = nStartIndex; nRow < nUpperIndex; nRow++ )
                        if(IsLine(nRow))
                        {
                            rAttr.Put(XFillColorItem(String(),
                                                     ((XLineColorItem &)GetDataRowAttr(nRow).Get(XATTR_LINECOLOR)).
                                                     GetColorValue()));
                            aDataRowAttrList.GetObject(nRow)->Put(rAttr);
                        }
                    break;

                case SETLINES_BLACK:
                    //	Set the default values to all data rows.
                    for( nRow = nStartIndex; nRow < nUpperIndex; nRow++ )
                    {
                        aDataRowAttrList.GetObject(nRow)->Put(rAttr);
                    }
                    break;
            }
        }
	}	
}

/*************************************************************************
|*
|* Charttyp aendern;
|* Liefert bei neuem Charttyp TRUE.
|*
\************************************************************************/
// BM: src566b: ChangeChart doesn't execute BuildChart any more!
BOOL ChartModel::ChangeChart( SvxChartStyle eStyle, bool bSetDefaultAttr /* = true */ )
{
	if( eStyle == CHSTYLE_ADDIN )
	{
		eChartStyle = eStyle;
		return FALSE;
	}
	else if( eStyle == eChartStyle )
	{
		return FALSE;
	}
	else
	{
		// if chart style is reset disable addin
		if( ! GetChartStatusFlag( CHS_KEEP_ADDIN ))
		{
			mxChartAddIn = NULL;
		}

		bResizePie=TRUE;

		// OldChartStyle merken
		eOldChartStyle = eChartStyle;

		//########### Ab hier werden defaultwerte umgesetzt:######### :

		//Wenn Linien, aber nicht 3D, dann muss evtl. bei
		//Typwechsel die Linienfarbe neu defaultet werden!

		long nRefLine=0;//Bei StockChart 3,4 ist die erste Zeile keine Linie
		if(GetRowCount()>1)
			nRefLine=1;

        // #101164# a combi chart may contain lines for all but the first series
        if( eOldChartStyle == CHSTYLE_2D_LINE_COLUMN ||
            eOldChartStyle == CHSTYLE_2D_LINE_STACKEDCOLUMN )
            nRefLine = 0;

		BOOL bOldIsLine=IsLine(nRefLine)&& !Is3DChart();//#54870#//Verbund-Charts OK???
		BOOL bOldIsStock=HasStockLines();
		BOOL bOldIs3D=IsReal3D();
		BOOL bOldHadStockBars=HasStockBars();
		BOOL bOldXY = IsXYChart();
		BOOL bOldNet = IsNetChart();
        BOOL bOldPie = IsPieChart();
        BOOL bOldDonut = IsDonutChart();

		eChartStyle = eStyle;

		BOOL bNewIsLine=IsLine(nRefLine) && !Is3DChart();//#54870#
		BOOL bNewIs3D=IsReal3D();

        // data row attributes are used for data points in a piechart
        // therefore these need to be initialized correctly
        BOOL bMustInitDataAttrs = (bOldPie || IsPieChart() || IsDonutChart() || bOldDonut);

        if( eStyle == CHSTYLE_3D_PIE )
		{
			for( short i = 0; i < nPieSegCount; i++ )
				SetPieSegOfs( i, 0 );
		}

        if( bSetDefaultAttr )
        {
            // BM: use gray (15%) background (wall) for some charts
            if( HasDefaultGrayWall() != HasDefaultGrayWall( &eOldChartStyle ) )
            {
                if( HasDefaultGrayWall() )
                {
                    pDiagramWallAttr->Put( XFillStyleItem( XFILL_SOLID ));
                    pDiagramWallAttr->Put( XFillColorItem( String(), RGBColor( RGB_COLORDATA( 0xd9, 0xd9, 0xd9 ) )) );

                    pLegendAttr->Put( XFillStyleItem( XFILL_SOLID ));
                    pLegendAttr->Put( XFillColorItem( String(), RGBColor( RGB_COLORDATA( 0xd9, 0xd9, 0xd9 ) )) );
                }
                else
                {
                    pDiagramWallAttr->Put( XFillStyleItem( XFILL_NONE ));
                    pDiagramWallAttr->Put( XFillColorItem( String(), RGBColor( COL_WHITE )) );

                    pLegendAttr->Put( XFillStyleItem( XFILL_NONE ));
                    pLegendAttr->Put( XFillColorItem( String(), RGBColor( COL_WHITE )) );
                }
            }

            // BM: use gray (15%) background (area) for some charts
            if( HasDefaultGrayArea() != HasDefaultGrayArea( &eOldChartStyle ) )
            {
                if( HasDefaultGrayArea() )
                {
                    pDiagramAreaAttr->Put( XFillStyleItem( XFILL_SOLID ));
                    pDiagramAreaAttr->Put( XFillColorItem( String(), RGBColor( RGB_COLORDATA( 0xd9, 0xd9, 0xd9 ) )) );

                    pLegendAttr->Put( XFillStyleItem( XFILL_SOLID ));
                    pLegendAttr->Put( XFillColorItem( String(), RGBColor( RGB_COLORDATA( 0xd9, 0xd9, 0xd9 ) )) );
                }
                else
                {
                    pDiagramAreaAttr->Put( XFillColorItem( String(), RGBColor( COL_WHITE )) );

                    pLegendAttr->Put( XFillStyleItem( XFILL_NONE ));
                    pLegendAttr->Put( XFillColorItem( String(), RGBColor( COL_WHITE )) );
                }
            }
        }

        if(bNewIsLine != bOldIsLine)
		{
            // map old line colors to new fill colors
            if( bNewIsLine )
            {
                if( bOldPie )
                    // && GetRowCount() < GetColCount())
                {
                    InitDataAttrs();
                    bMustInitDataAttrs = FALSE;
                }
                SetupLineColors( SETLINES_COMPAT );
            }
            else
            {
                if( IsPieChart() )
                    // && GetRowCount() < GetColCount())
                {
                    InitDataAttrs();
                    bMustInitDataAttrs = FALSE;
                }
                // the chart style must be swapped to the old one
                // temporarily, so that IsLine() works correctly
//                  eChartStyle = eOldChartStyle;
                SetupLineColors( SETLINES_BLACK );
//                  eChartStyle = eStyle;
            }

		}

        if( bMustInitDataAttrs )
        {
            InitDataAttrs();
            bMustInitDataAttrs = FALSE;
        }

		if(bOldXY!=IsXYChart())
		{
			if(bOldXY)
				aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_Y));//wird evtl. unten geaendert, s.u. StockCharts
			else
				aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_X));

			CheckForNewAxisNumFormat();			// BM #59532#
		}


        long nRowCnt=aDataRowAttrList.Count();//=GetRowCount();
		if( (bOldIsStock && !HasStockLines()) || (bOldIs3D && !bNewIs3D) )
		{
			long n;

			for( n = 0; n < nRowCnt; n++ )
				aDataRowAttrList.GetObject(n)->Put(XLineStyleItem(XLINE_SOLID));
			long nColCnt=aDataPointAttrList.Count();
			SfxItemSet	*	pAttributes;
			for(n=0;n<nColCnt;n++)
			{
				pAttributes = aDataPointAttrList.GetObject(n);
				if (pAttributes != NULL)
					pAttributes->ClearItem(XATTR_LINESTYLE);
			}
			nColCnt=aSwitchDataPointAttrList.Count();
			for(n=0;n<nColCnt;n++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(n);
				if (pAttributes != NULL)
					pAttributes->ClearItem(XATTR_LINESTYLE);
			}
		}
		if(!bOldIsStock && HasStockLines() || (!bOldIs3D && bNewIs3D) )
		{
			long n;

			for( n = 0; n < nRowCnt; n++ )
				aDataRowAttrList.GetObject(n)->Put(XLineStyleItem(XLINE_NONE));
			long nColCnt=aDataPointAttrList.Count();
			SfxItemSet	*	pAttributes;
			for(n=0;n<nColCnt;n++)
			{
				pAttributes = aDataPointAttrList.GetObject(n);
				if (pAttributes != NULL)
					pAttributes->ClearItem(XATTR_LINESTYLE);
			}
			nColCnt=aSwitchDataPointAttrList.Count();
			for(n=0;n<nColCnt;n++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(n);
				if (pAttributes != NULL)
					pAttributes->ClearItem(XATTR_LINESTYLE);
			}
		}
		if(/*!bOldHadStockBars && */HasStockBars())//Hat Balken im Hintergrund (ab jetzt oder Typ 3 <-> 4, #65070#)
		{
			if(nRowCnt)
			{
				aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_Y));
				aDataRowAttrList.GetObject(0)->Put(XLineStyleItem(XLINE_SOLID));
			}
			for(long n=1;n<nRowCnt;n++)
				aDataRowAttrList.GetObject(n)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_SECONDARY_Y));
			pChartBAxis->ShowAxis(TRUE);
			pChartBAxis->ShowDescr(TRUE);
			SfxItemSet aSet(*pItemPool,SCHATTR_AXIS_AUTO_ORIGIN,SCHATTR_AXIS_AUTO_ORIGIN);
			aSet.Put(SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN,TRUE));
			pChartBAxis->SetAttributes(aSet);

            // #100923#
            SfxItemSet aSet2( *pItemPool, SCHATTR_AXIS_AUTO_ORIGIN, SCHATTR_AXIS_ORIGIN );
            aSet2.Put( SfxBoolItem( SCHATTR_AXIS_AUTO_ORIGIN, FALSE ));
			aSet2.Put( SvxDoubleItem( 0.0, SCHATTR_Y_AXIS_ORIGIN ));
            pChartYAxis->SetAttributes( aSet2 );
        }

		if(bOldHadStockBars && !HasStockBars())//hat jetzt keine Balken mehr
		{
			for(long n=0;n<nRowCnt;n++)
				aDataRowAttrList.GetObject(n)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_Y));
			if(IsXYChart())
				aDataRowAttrList.GetObject(0)->Put(SfxInt32Item(SCHATTR_AXIS,CHART_AXIS_PRIMARY_X));
			pChartBAxis->ShowAxis(FALSE);
			pChartBAxis->ShowDescr(FALSE);
		}

		// use default position if base type changed
		ChartType aOldType( eOldChartStyle );
		ChartType aNewType( eChartStyle );

		if( aOldType.GetBaseType() !=
			aNewType.GetBaseType() )
		{
			SetUseRelativePositions( FALSE );
		}

		Matrix4D aTmp;
		aSceneMatrix = aTmp;
		if(IsPieChart() && IsReal3D() )
		{
			aSceneMatrix.RotateX(-F_PI/3);
			if(pScene)
				pScene->NbcSetTransform(aSceneMatrix);
		}
		else if(pScene)
			pScene->NbcSetTransform(aSceneMatrix);


		if( IsReal3D()) //#56798# QuickFix 5.0-Final
		{
			bClearDepth=TRUE;
			ULONG	i, nORow=aDataRowAttrList.Count();
			for(i=0;i<nORow;i++)
			{
//-/				aDataRowAttrList.GetObject(i)->ClearItem(SID_ATTR_3D_DEPTH);
				aDataRowAttrList.GetObject(i)->ClearItem( SDRATTR_3DOBJ_DEPTH );
				aDataRowAttrList.GetObject(i)->Put( Svx3DDoubleSidedItem( TRUE ));

  				//if(eChartStyle == CHSTYLE_3D_STRIPE || eChartStyle==CHSTYLE_3D_PIE)
//-/					aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,TRUE));
//  				else
//-/					aDataRowAttrList.GetObject(i)->Put(SfxBoolItem(SID_ATTR_3D_DOUBLE_SIDED,FALSE));
//  					aDataRowAttrList.GetObject(i)->Put(Svx3DDoubleSidedItem(FALSE));
			}
			nORow=aDataPointAttrList.Count();
			SfxItemSet	*	pAttributes;
			for(i=0;i<nORow;i++)
			{
				pAttributes = aDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
				{
					pAttributes->ClearItem( SDRATTR_3DOBJ_DEPTH );
					pAttributes->ClearItem( SDRATTR_3DOBJ_DOUBLE_SIDED );
				}
			}
			nORow=aSwitchDataPointAttrList.Count();
			for(i=0;i<nORow;i++)
			{
				pAttributes = aSwitchDataPointAttrList.GetObject(i);
				if (pAttributes != NULL)
				{
					pAttributes->ClearItem( SDRATTR_3DOBJ_DEPTH );
					pAttributes->ClearItem( SDRATTR_3DOBJ_DOUBLE_SIDED );
				}
			}

			// switch off rounded edges for:
			// area charts
			Svx3DPercentDiagonalItem aItem(
  				(eStyle == CHSTYLE_3D_AREA || eStyle == CHSTYLE_3D_STACKEDAREA || eStyle == CHSTYLE_3D_PERCENTAREA ||
                    eStyle == CHSTYLE_3D_PIE )
  				? 0 : 5 );

			// item-set for whole chart used if item in series is not set
			pDummyAttr->Put( aItem );

  			for( i = 0; i < aDataRowAttrList.Count(); i++ )
  			{
				aDataRowAttrList.GetObject( i )->Put( aItem );
  			}
		}

		//	If set to xy-chart or certain stock chart variants then turn on
		//	automatic calculation of the origin for all y-axes as default.
		//	This affects the second y-axis even if it is not (yet) visible.
		//	This was previously done in the autopilot but belongs here
		//	because XML loading calls this method but not the autopilot.
		if (	IsXYChart()
			||	(eChartStyle == CHSTYLE_2D_STOCK_1)
			||	(eChartStyle == CHSTYLE_2D_STOCK_2))
		{
			SfxItemSet aAutoOrigin (*pItemPool, SCHATTR_AXIS_AUTO_ORIGIN, SCHATTR_AXIS_AUTO_ORIGIN);
			aAutoOrigin.Put (SfxBoolItem (SCHATTR_AXIS_AUTO_ORIGIN, TRUE));
			pChartYAxis->SetAttributes (aAutoOrigin);
			//	The second y-axis exists (pChartBAxis!=NULL) even if it is not
			//	visible.
			pChartBAxis->SetAttributes (aAutoOrigin);
		}
			
		SetUseRelativePositions(TRUE);// New arrangement (see SID_NEW_ARRANGEMENT)
		eOldChartStyle = eChartStyle;

		//	Set the number of data series that are displayed as lines to a fixed value.
		//	This is one for the combined chart types of columns/stacked columns and lines
		//	and zero for all other chart types.

        // #103682# this seems not to be necessary.  This method is called on
        // XML-import very early, when the data is 1x1 in size.  The number of
        // lines must be preserved until in the end the original size-data is
        // set.  In all other cases when this method is called, the chart-type
        // itself should handle a value that is too big or small. (Advantage: if
        // you change to bar with no lines and then back, you get the old
        // value).
// 		switch (eStyle)
// 		{
// 			case	CHSTYLE_2D_LINE_COLUMN:
// 			case	CHSTYLE_2D_LINE_STACKEDCOLUMN:
//                 {
//                     long nNumLines = GetNumLinesColChart();
//                     if( nNumLines < 1 ||
//                         nNumLines >= GetRowCount() )
//                         SetNumLinesColChart (1);
//                 }
// 				break;
				
// 			default:
// 				SetNumLinesColChart (0);
// 		}

        // #i33333# for non-combi charts the number of lines should be 0,
        // otherwise this value might be saved and used on reload (a simple bar
        // chart might become a combi-chart)
        if( eStyle != CHSTYLE_2D_LINE_STACKEDCOLUMN &&
            eStyle != CHSTYLE_2D_LINE_COLUMN )
            SetNumLinesColChart (0);

        // #104525# however the default for a combi-chart is one line.  So if
        // the setting is on 0, we have to change it to 1.
        if( ( eStyle == CHSTYLE_2D_LINE_COLUMN
              || eStyle == CHSTYLE_2D_LINE_STACKEDCOLUMN )
            && GetNumLinesColChart() == 0 )
        {
            SetNumLinesColChart( 1 );
        }

        // broadcast UIFeature chang
        // #85069# introduced because the 3d effect flyer has to be disabled for 2d charts
        Broadcast( SfxSimpleHint( SFX_HINT_MODECHANGED ));

		return TRUE;
	}
}

/*************************************************************************
|*
|*
\************************************************************************/

FASTBOOL ChartModel::IsReadOnly () const
{
	return FALSE;
}


/*************************************************************************
|*
|* Language setzen
|*
\************************************************************************/

void ChartModel::SetLanguage( const LanguageType eLang, const USHORT nId )
{
	BOOL bChanged = FALSE;

	if( nId == EE_CHAR_LANGUAGE && eLanguage != eLang )
	{
		eLanguage = eLang;
		bChanged = TRUE;
	}
	else if( nId == EE_CHAR_LANGUAGE_CJK && eLanguageCJK != eLang )
	{
		eLanguageCJK = eLang;
		bChanged = TRUE;
	}
	else if( nId == EE_CHAR_LANGUAGE_CTL && eLanguageCTL != eLang )
	{
		eLanguageCTL = eLang;
		bChanged = TRUE;
	}

	if( bChanged )
	{
		GetDrawOutliner().SetDefaultLanguage( eLang );
		pOutliner->SetDefaultLanguage( eLang );
		pItemPool->SetPoolDefaultItem( SvxLanguageItem( eLang, nId ) );
		SetChanged( bChanged );
	}
}


/*************************************************************************
|*
|* Return language
|*
\************************************************************************/

LanguageType ChartModel::GetLanguage( const USHORT nId ) const
{
	LanguageType eLangType = eLanguage;

	if( nId == EE_CHAR_LANGUAGE_CJK )
		eLangType = eLanguageCJK;
	else if( nId == EE_CHAR_LANGUAGE_CTL )
		eLangType = eLanguageCTL;

	return eLangType;
}

IMPL_LINK( ChartModel, NotifyUndoActionHdl, SfxUndoAction*, pUndo )
{
	DBG_ASSERT(!m_pUndoActionFromDraw, "New UndoAction from Draw received while elder is not handled yet");
	if(m_bDeleteUndoActionNotificationFromDraw)
	{
		if(pUndo)
			delete pUndo;
	}
	else
	{
		m_pUndoActionFromDraw = pUndo;
	}
	return 1;
}
