/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: grfflt.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 17:52:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GRFFLT_HXX
#define _SVX_GRFFLT_HXX

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_GROUP_HXX
#include <vcl/group.hxx>
#endif
#ifndef _SV_SALBTYPE_HXX
#include <vcl/salbtype.hxx>
#endif
#ifndef _GRFMGR_HXX
#include <goodies/grfmgr.hxx>
#endif

#ifndef _GRAPHCTL_HXX
#include "graphctl.hxx"
#endif
#ifndef _SVX_DLG_CTRL_HXX
#include "dlgctrl.hxx"
#endif
#ifndef _SVX_RECTENUM_HXX
#include "rectenum.hxx"
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

// ---------------
// - Error codes -
// ---------------

#define SVX_GRAPHICFILTER_ERRCODE_NONE				0x00000000
#define SVX_GRAPHICFILTER_UNSUPPORTED_GRAPHICTYPE	0x00000001
#define SVX_GRAPHICFILTER_UNSUPPORTED_SLOT			0x00000002

// --------------------
// - SvxGraphicFilter -
// --------------------

class SfxRequest;
class SfxItemSet;

class SVX_DLLPUBLIC SvxGraphicFilter
{
public:

	static ULONG	ExecuteGrfFilterSlot( SfxRequest& rReq, GraphicObject& rFilterObject );
	static void		DisableGraphicFilterSlots( SfxItemSet& rSet );
};
/* CHINA001 move to cuigrfflt.hxx
// -----------------------
// - GraphicFilterDialog -
// -----------------------

class GraphicFilterDialog : public ModalDialog
{
private:

	class PreviewWindow : public Control
	{
	private:
		
		GraphicObject	maGraphic;

		virtual void	Paint( const Rectangle& rRect );

	public:

						PreviewWindow( Window* pParent, const ResId& rResId );
						~PreviewWindow();

		void			SetGraphic( const Graphic& rGraphic );
	};

private:

	Timer			maTimer;
	Link			maModifyHdl;
	Graphic			maGraphic;
	double			mfScaleX;
	double			mfScaleY;
	Size			maSizePixel;
	PreviewWindow	maPreview;
	FixedLine		maFlParameter;
	OKButton		maBtnOK;
	CancelButton	maBtnCancel;
	HelpButton		maBtnHelp;

					DECL_LINK( ImplPreviewTimeoutHdl, Timer* pTimer );
					DECL_LINK( ImplModifyHdl, void* p );

protected:

	const Link&		GetModifyHdl() const { return maModifyHdl; }
	const Size&		GetGraphicSizePixel() const { return maSizePixel; }

public:				
					
					GraphicFilterDialog( Window* pParent, const ResId& rResId, const Graphic& rGraphic );
					~GraphicFilterDialog();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY ) = 0;
};

// -----------------------
// - GraphicFilterMosaic -
// -----------------------

class GraphicFilterMosaic : public GraphicFilterDialog
{
private:

	FixedText		maFtWidth;
	MetricField		maMtrWidth;
	FixedText		maFtHeight;
	MetricField		maMtrHeight;
	CheckBox		maCbxEdges;

public:

					GraphicFilterMosaic( Window* pParent, const Graphic& rGraphic,
										 USHORT nTileWidth, USHORT nTileHeight, BOOL bEnhanceEdges );
					~GraphicFilterMosaic();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
	USHORT			GetTileWidth() const { return maMtrWidth.GetValue(); }
	USHORT			GetTileHeight() const { return maMtrHeight.GetValue(); }
	BOOL			IsEnhanceEdges() const { return maCbxEdges.IsChecked(); }
};

// -------------------------
// - GraphicFilterSolarize -
// -------------------------

class GraphicFilterSolarize : public GraphicFilterDialog
{
private:

	FixedText		maFtThreshold;
	MetricField		maMtrThreshold;
	CheckBox		maCbxInvert;

public:

					GraphicFilterSolarize( Window* pParent, const Graphic& rGraphic,
										   BYTE nGreyThreshold, BOOL bInvert );
					~GraphicFilterSolarize();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
	BYTE			GetGreyThreshold() const { return( (BYTE) FRound( maMtrThreshold.GetValue() * 2.55 ) ); }
	BOOL			IsInvert() const { return maCbxInvert.IsChecked(); }
};

// ----------------------
// - GraphicFilterSepia -
// ----------------------

class GraphicFilterSepia : public GraphicFilterDialog
{
private:

	FixedText		maFtSepia;
	MetricField		maMtrSepia;

public:

					GraphicFilterSepia( Window* pParent, const Graphic& rGraphic,
										USHORT nSepiaPercent );
					~GraphicFilterSepia();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
	USHORT			GetSepiaPercent() const { return maMtrSepia.GetValue(); }
};

// -----------------------
// - GraphicFilterPoster -
// -----------------------

class GraphicFilterPoster : public GraphicFilterDialog
{
private:

	FixedText		maFtPoster;
	NumericField	maNumPoster;

public:

					GraphicFilterPoster( Window* pParent, const Graphic& rGraphic,
										 USHORT nPosterColorCount );
					~GraphicFilterPoster();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
	USHORT			GetPosterColorCount() const { return( (USHORT) maNumPoster.GetValue() ); }
};

// -----------------------
// - GraphicFilterEmboss -
// -----------------------

class GraphicFilterEmboss : public GraphicFilterDialog
{
private:

	class EmbossControl : public SvxRectCtl
	{
	private:

		Link			maModifyHdl;

		virtual void	MouseButtonDown( const MouseEvent& rEvt );

	public:

						EmbossControl( Window* pParent, const ResId& rResId, RECT_POINT eRectPoint ) : 
							SvxRectCtl( pParent, rResId ) { SetActualRP( eRectPoint ); }
	
		void			SetModifyHdl( const Link& rHdl ) { maModifyHdl = rHdl; }
	};

private:

	FixedText		maFtLight;
	EmbossControl	maCtlLight;

public:

					GraphicFilterEmboss( Window* pParent, const Graphic& rGraphic,
										 RECT_POINT eLightSource );
					~GraphicFilterEmboss();

	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
	RECT_POINT		GetLightSource() const { return maCtlLight.GetActualRP(); }
};
*/ //end of move to cuigrfflt.hxx
#endif
