/*
 * XFramework.java
 *
 * Created on 17. M?rz 2003, 14:43
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.awt.Rectangle;

import java.util.Vector;

import com.sun.star.awt.XExtendedToolkit;

/**
 * Framework coordinator interface.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XFramework {
    /**
     * Gets ExtendedToolkit
     *
     * @return ExtendedToolkit
     */
    public XExtendedToolkit getXExtendedToolkit();

    /**
     * Shows action frame
     *
     * @param reg Rectangle
     */
    public void showActionsFrame(Rectangle reg);

    /**
     * Shows step frame
     *
     * @param reg Rectangle
     */
    public void showStepFrame(Rectangle reg);

    /**
     * Shows tutorial creator
     *
     * @param reg Rectangle
     * @param name String
     */
    public void showTutorialCreator(Rectangle reg, String name);

    /**
     * Adds actions to step
     *
     * @param data
     */
    public void addActionstoStep(Vector data);

    /**
     * Gets connected document title
     *
     * @return connected document title
     */
    public String getConnectedDocumentTitle();

    /**
     * Gets connected document type
     *
     * @return connected document type
     */
    public String getConnectedDocumentTyp();
}
