/*
 * Spreadsheet.java
 *
 * Created on 27. September 2002, 09:21
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.table.XCell;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.FindInterfaces;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * Providing functionality for spreadsheets and spreadsheet text handling.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class Spreadsheet extends Components implements XCellTextCompact, XTabList {
    private Helper m_helper;
    private static Spreadsheet m_spreadsheet;

    static {
        new Spreadsheet();
    }

    /**
     * Creates a new Spreadsheet object.
     */
    public Spreadsheet() {
        m_spreadsheet = this;
    }

    /**
     * Creates a new Spreadsheet object.
     *
     * @param helper
     *
     * @throws java.lang.Exception
     * @throws Exception DOCUMENT ME!
     */
    public Spreadsheet(Helper helper) throws java.lang.Exception {
        if (helper == null) {
            throw new Exception("ERROR : Helper is not initialized.");
        }

        m_helper = helper;
    }

    /**
     * Get Helper
     *
     * @return Helper instance
     */
    public Helper getHelper() {
        return m_helper;
    }

    /**
     * Set Helper instance
     *
     * @param helper DOCUMENT ME!
     */
    public void setHelper(Helper helper) {
        m_helper = helper;
    }

    /**
     * Get implemented interfaces
     *
     * @return interfaces.
     */
    public static Hashtable getInterfaces() {
        return (FindInterfaces.getInterfaces(m_spreadsheet.getClass()));
    }

    //*******************************************************************
    //                                                                  *
    //                      insert TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Insert text.
     *
     * @param path object path
     * @param index insert index
     * @param insertText text
     */
    public void insertTexttoCell(String[] path, int index, String insertText) {
        XAccessibleContext child = child = getXAccessibleContext(path);
        insertCellTextHelper(child, index, insertText);
    }

    /**
     * Move mouse to accessibility object and insert text.
     *
     * @param path object path
     * @param index insert index
     * @param insertText text
     */
    public void moveMousetoCell_insertText(String[] path, int index, String insertText) {
        XAccessibleContext child = child = getXAccessibleContext(path);
        moveMouse_Click(child);
        insertCellTextHelper(child, index, insertText);
    }

    //*******************************************************************
    //                                                                  *
    //                      delete TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Delete text. To delete the whole text - startindex=0, endindex=-1
     *
     * @param path object path
     * @param startIndex text start index
     * @param endIndex text end index
     */
    public void deleteCellText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        deleteCellTextHelper(child, startIndex, endIndex);
    }

    /**
     * Move mouse to accessibility object and delete text. To delete the whole text -
     * startindex=0, endindex=-1
     *
     * @param path object path
     * @param startIndex text start index
     * @param endIndex text end index
     */
    public void moveMousetoCell_deleteText(String[] path, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        deleteCellTextHelper(child, startIndex, endIndex);
    }

    //*******************************************************************
    //                                                                  *
    //                      replace TEXT                                *
    //                                                                  *
    //*******************************************************************

    /**
     * Replace text.
     *
     * @param path object path
     * @param text text
     * @param replacement text
     */
    public void replaceCellText(String[] path, String text, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceCellTextHelper(child, text, replacement);
    }

    /**
     * Replace text. To replace the whole text - startindex=0, endindex=-1
     *
     * @param path object path
     * @param replacement start index
     * @param startIndex end index
     * @param endIndex DOCUMENT ME!
     */
    public void replaceCellText(String[] path, String replacement, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceCellTextHelper(child, startIndex, endIndex, replacement);
    }

    /**
     * Move mouse to object and replace text.
     *
     * @param path object path
     * @param text text
     * @param replacement text
     */
    public void moveMousetoCell_replaceText(String[] path, String text, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceCellTextHelper(child, text, replacement);
    }

    /**
     * Move mouse to accessibility object and replace text. To replace the whole text -
     * startindex=0, endindex=-1
     *
     * @param path object path
     * @param replacement start index
     * @param startIndex end index
     * @param endIndex DOCUMENT ME!
     */
    public void moveMousetoCell_replaceText(String[] path, String replacement, int startIndex, int endIndex) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceCellTextHelper(child, startIndex, endIndex, replacement);
    }

    //*******************************************************************
    //                                                                  *
    //                         set TEXT                                 *
    //                                                                  *
    //*******************************************************************

    /**
     * Set text
     *
     * @param path object path
     * @param replacement text
     */
    public void setCellText(String[] path, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        replaceCellTextHelper(child, 0, -1, replacement);
    }

    /**
     * Move mouse to accessibility object and set text
     *
     * @param path object path
     * @param replacement text
     */
    public void moveMousetoCell_setText(String[] path, String replacement) {
        XAccessibleContext child = getXAccessibleContext(path);
        moveMouse_Click(child);
        replaceCellTextHelper(child, 0, -1, replacement);
    }

    //*******************************************************************
    //                                                                  *
    //                   Privates Methods                               *
    //                                                                  *
    //*******************************************************************

    /**
     * Insert text helper.
     *
     * @param child child
     * @param index insert index
     * @param insertText text
     */
    private void insertCellTextHelper(XAccessibleContext child, int index, String insertText) {
        try {
            XCell xcell = getSelectedCell(child);

            if (xcell != null) {
                insertTexttoCell(xcell, insertText, index);
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Delete text helper.
     *
     * @param child child
     * @param startIndex text start index
     * @param endIndex text end index
     */
    private void deleteCellTextHelper(XAccessibleContext child, int startIndex, int endIndex) {
        try {
            XCell xcell = getSelectedCell(child);

            if (xcell != null) {
                deleteTextfromCell(xcell, startIndex, endIndex);
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Replace helper.
     *
     * @param child child
     * @param startIndex start index
     * @param endIndex end index
     * @param insertText text
     */
    private void replaceCellTextHelper(XAccessibleContext child, int startIndex, int endIndex, String insertText) {
        try {
            XCell xcell = getSelectedCell(child);

            if (xcell != null) {
                deleteTextfromCell(xcell, startIndex, endIndex);
                insertTexttoCell(xcell, insertText, startIndex);
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Replace helper.
     *
     * @param child child
     * @param searchText text
     * @param insertText insert text
     */
    private void replaceCellTextHelper(XAccessibleContext child, String searchText, String insertText) {
        try {
            XCell xcell = getSelectedCell(child);

            if (xcell != null) {
                String text = xcell.getFormula();

                if ((text != null) && (searchText != null) && !(searchText.equals(""))) {
                    int movePosition = text.length();
                    int index = text.indexOf(searchText);
                    movePosition = index + searchText.length();
                    deleteTextfromCell(xcell, index, movePosition);
                    insertTexttoCell(xcell, insertText, index);
                }
            }
        } catch (java.lang.Exception ex) {
        }
    }

    /**
     * Get selected cell.
     *
     * @param child child
     *
     * @return Cell
     *
     * @throws java.lang.Exception
     */
    private XCell getSelectedCell(XAccessibleContext child) throws java.lang.Exception {
        XCell xcell = null;

        if (child != null) {
            int childIndex = child.getAccessibleIndexInParent();
            XAccessibleSelection selection = AccessibilityTools.getXAccessibleSelection(child.getAccessibleParent());

            if (!selection.isAccessibleChildSelected(childIndex)) {
                selection.selectAccessibleChild(childIndex);
            }

            XInterface xObject = (XInterface) m_helper.getXModel().getCurrentSelection();

            if (xObject != null) {
                xcell = AccessibilityTools.getAccessibleCell(xObject);
            }
        }

        return xcell;
    }

    /**
     * Delete text from cell.
     *
     * @param xcell child
     * @param startIndex start index
     * @param endIndex end index
     *
     * @throws java.lang.Exception
     */
    private void deleteTextfromCell(XCell xcell, int startIndex, int endIndex) throws java.lang.Exception {
        String temp = xcell.getFormula();

        if ((startIndex == 0) && (endIndex == -1)) {
            int leng = temp.length();

            for (int i = 0; i <= leng; leng--) {
                temp = temp.substring(i, leng);
                xcell.setFormula(temp);
                sleep(getKeyDelay());
            }
        } else if ((temp != null) && (temp.length() > 0) && (startIndex > -1) && (endIndex > startIndex) && (endIndex <= temp.length())) {
            String sub = temp.substring(startIndex, endIndex);
            String offset1 = temp.substring(0, startIndex);
            String offset2 = temp.substring(endIndex, temp.length());

            while (sub.length() > 0) {
                sub = sub.substring(0, sub.length() - 1);
                xcell.setFormula(offset1 + sub + offset2);
                sleep(getKeyDelay());
            }
        }
    }

    /**
     * Insert text into cell.
     *
     * @param xcell child
     * @param insertText text
     * @param index index
     *
     * @throws java.lang.Exception D
     */
    private void insertTexttoCell(XCell xcell, String insertText, int index) throws java.lang.Exception {
        String temp = xcell.getFormula();

        if (temp != null) {
            if (index == -1) {
                index = temp.length();
            }

            if (index <= temp.length()) {
                String remain = temp.substring(index, temp.length());
                String body = temp.substring(0, index);

                for (int i = 0; i < insertText.length(); i++) {
                    body += insertText.charAt(i);
                    xcell.setFormula(body + remain);
                    sleep(getKeyDelay());
                }
            }
        }
    }
}
