/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_htmlcfg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 14:10:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
#endif

#ifndef _PARHTML_HXX //autogen
#include <svtools/parhtml.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif

#include <bf_sfx2/viewfrm.hxx>

#pragma hdrstop

#include "htmlcfg.hxx"
#include "app.hrc"
namespace binfilter {

// -----------------------------------------------------------------------
#define HTMLCFG_UNKNOWN_TAGS 			0x01
//#define HTMLCFG_STYLE_SHEETS 			0x02
//#define HTMLCFG_NETSCAPE3    			0x04
#define HTMLCFG_STAR_BASIC   			0x08
#define HTMLCFG_LOCAL_GRF   			0x10
#define HTMLCFG_PRINT_LAYOUT_EXTENSION 	0x20
#define HTMLCFG_IGNORE_FONT_FAMILY	 	0x40
#define HTMLCFG_IS_BASIC_WARNING		0x80

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;

#define C2U(cChar) OUString::createFromAscii(cChar)
/* -----------------------------23.11.00 11:39--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ struct HtmlOptions_Impl
/*N*/ {
/*N*/ 	sal_Int32 	nFlags;
/*N*/ 	sal_Int32 	nExportMode;
/*N*/ 	sal_Int32 	aFontSizeArr[HTML_FONT_COUNT];
/*N*/ 	sal_Int32 	eEncoding;
/*N*/     sal_Bool    bIsEncodingDefault;
/*N*/ 
/*N*/ 	HtmlOptions_Impl() :
/*N*/ 		nFlags(HTMLCFG_LOCAL_GRF|HTMLCFG_IS_BASIC_WARNING),
/*N*/ 		nExportMode(HTML_CFG_NS40),
/*N*/         eEncoding( gsl_getSystemTextEncoding() ),
/*N*/         bIsEncodingDefault(sal_True)
/*N*/ 	{
/*N*/ 		aFontSizeArr[0] = HTMLFONTSZ1_DFLT;
/*N*/ 		aFontSizeArr[1] = HTMLFONTSZ2_DFLT;
/*N*/ 		aFontSizeArr[2] = HTMLFONTSZ3_DFLT;
/*N*/ 		aFontSizeArr[3] = HTMLFONTSZ4_DFLT;
/*N*/ 		aFontSizeArr[4] = HTMLFONTSZ5_DFLT;
/*N*/ 		aFontSizeArr[5] = HTMLFONTSZ6_DFLT;
/*N*/ 		aFontSizeArr[6] = HTMLFONTSZ7_DFLT;
/*N*/ 	}
/*N*/ 
/*N*/ };

/* -----------------------------23.11.00 11:39--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ const Sequence<OUString>& OfaHtmlOptions::GetPropertyNames()
/*N*/ {
/*N*/ 	static Sequence<OUString> aNames;
/*N*/ 	if(!aNames.getLength())
/*N*/ 	{
/*N*/ 		static const char* aPropNames[] =
/*N*/ 		{
/*N*/ 			"Import/UnknownTag",					//  0
/*N*/ 			"Import/FontSetting",					//  1
/*N*/ 			"Import/FontSize/Size_1",				//  2
/*N*/ 			"Import/FontSize/Size_2",				//  3
/*N*/ 			"Import/FontSize/Size_3",				//  4
/*N*/ 			"Import/FontSize/Size_4",				//  5
/*N*/ 			"Import/FontSize/Size_5",				//  6
/*N*/ 			"Import/FontSize/Size_6",				//  7
/*N*/ 			"Import/FontSize/Size_7",				//  8
/*N*/ 			"Export/Browser",						//  9
/*N*/ 			"Export/Basic",							//  0
/*N*/ 			"Export/PrintLayout",					// 11
/*N*/ 			"Export/LocalGraphic",					// 12
/*N*/ 			"Export/Warning",    					// 13
/*N*/ 			"Export/Encoding"						// 14
/*N*/ 		};
/*N*/ 		const int nCount = sizeof(aPropNames) / sizeof(aPropNames[0]);
/*N*/ 		aNames.realloc(nCount);
/*N*/ 		OUString* pNames = aNames.getArray();
/*N*/ 		for(int i = 0; i < nCount; i++)
/*N*/ 			pNames[i] = C2U(aPropNames[i]);
/*N*/ 	}
/*N*/ 	return aNames;
/*N*/ }
// -----------------------------------------------------------------------
/*N*/ OfaHtmlOptions::OfaHtmlOptions() :
/*N*/ 	ConfigItem(C2U("Office.Common/Filter/HTML"))
/*N*/ {
/*N*/ 	pImp = new HtmlOptions_Impl;
/*N*/ 	const Sequence<OUString>& aNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == aNames.getLength())
/*N*/ 	{
/*N*/ 		pImp->nFlags = 0;
/*N*/ 		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				switch(nProp)
/*N*/ 				{
/*N*/ 					case  0:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_UNKNOWN_TAGS;
/*N*/ 					break;//"Import/UnknownTag",
/*N*/ 					case  1:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_IGNORE_FONT_FAMILY;
/*N*/ 					break;//"Import/FontSetting",
/*N*/ 					case  2: pValues[nProp] >>= pImp->aFontSizeArr[0]; break;//"Import/FontSize/Size_1",
/*N*/ 					case  3: pValues[nProp] >>= pImp->aFontSizeArr[1]; break;//"Import/FontSize/Size_2",
/*N*/ 					case  4: pValues[nProp] >>= pImp->aFontSizeArr[2]; break;//"Import/FontSize/Size_3",
/*N*/ 					case  5: pValues[nProp] >>= pImp->aFontSizeArr[3]; break;//"Import/FontSize/Size_4",
/*N*/ 					case  6: pValues[nProp] >>= pImp->aFontSizeArr[4]; break;//"Import/FontSize/Size_5",
/*N*/ 					case  7: pValues[nProp] >>= pImp->aFontSizeArr[5]; break;//"Import/FontSize/Size_6",
/*N*/ 					case  8: pValues[nProp] >>= pImp->aFontSizeArr[6]; break;//"Import/FontSize/Size_7",
/*N*/ 					case  9://"Export/Browser",
/*N*/ 						{
/*N*/ 							sal_Int32 nExpMode;
/*N*/ //							pValues[nProp] >>= pImp->nExportMode;
/*N*/ 							pValues[nProp] >>= nExpMode;
/*N*/ 							switch( nExpMode )
/*N*/ 							{
/*N*/ 								case 0:		nExpMode = HTML_CFG_HTML32;		break;
/*N*/ 								case 1:		nExpMode = HTML_CFG_MSIE_40;	break;
/*N*/ //								case 2:		nExpMode = HTML_CFG_NS30;		break;	depricated
/*N*/ 								case 3:		nExpMode = HTML_CFG_WRITER;		break;
/*N*/ 								case 4:		nExpMode = HTML_CFG_NS40;		break;
/*N*/ 								case 5:		nExpMode = HTML_CFG_MSIE_40_OLD;break;
/*N*/ 								default:	nExpMode = HTML_CFG_NS40;		break;
/*N*/ 							}
/*N*/ 
/*N*/ 							pImp->nExportMode = nExpMode;
/*N*/ 						}
/*N*/ 						break;
/*N*/ 					case 10:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_STAR_BASIC;
/*N*/ 					break;//"Export/Basic",
/*N*/ 					case 11:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							pImp->nFlags |= HTMLCFG_PRINT_LAYOUT_EXTENSION;
/*N*/ 					break;//"Export/PrintLayout",
/*N*/ 					case 12:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							pImp->nFlags |= HTMLCFG_LOCAL_GRF;
/*N*/ 					break;//"Export/LocalGraphic",
/*N*/ 					case 13:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							pImp->nFlags |= HTMLCFG_IS_BASIC_WARNING;
/*N*/ 					break;//"Export/Warning"
/*N*/ 
/*N*/                     case 14: pValues[nProp] >>= pImp->eEncoding;
/*?*/                              pImp->bIsEncodingDefault = sal_False;
/*N*/                     break;//"Export/Encoding"
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ OfaHtmlOptions::~OfaHtmlOptions()
/*N*/ {
/*N*/ 	delete pImp;
/*N*/ }
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------



// -----------------------------------------------------------------------



// -----------------------------------------------------------------------



// -----------------------------------------------------------------------



// -----------------------------------------------------------------------



// -----------------------------------------------------------------------



/*-----------------14.02.97 08.34-------------------

--------------------------------------------------*/

/*-----------------14.02.97 08.34-------------------

--------------------------------------------------*/

/*-----------------10/21/97 08:34am-----------------

--------------------------------------------------*/

/*N*/ BOOL 	OfaHtmlOptions::IsPrintLayoutExtension() const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*N*/ }
/*-----------------10/21/97 08:34am-----------------

--------------------------------------------------*/

/*-----------------10.07.98 10.02-------------------

--------------------------------------------------*/

/*-----------------10.07.98 10.02-------------------

--------------------------------------------------*/
/* -----------------05.02.99 09:03-------------------
 *
 * --------------------------------------------------*/
/* -----------------05.02.99 09:03-------------------
 *
 * --------------------------------------------------*/

/*-----------------19.02.2001 18:40-----------------
 *
 * --------------------------------------------------*/

/*-----------------19.02.2001 18:40-----------------
 *
 * --------------------------------------------------*/
/* -----------------------------15.08.2001 12:01------------------------------

 ---------------------------------------------------------------------------*/
}
