/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_csvcontrol.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:02:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif
#pragma hdrstop

// ============================================================================

#ifndef _SC_CSVCONTROL_HXX
#include "csvcontrol.hxx"
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SC_ACCESSIBLECSVCONTROL_HXX
#include "AccessibleCsvControl.hxx"
#endif
namespace binfilter {


// ============================================================================

/*N*/ ScCsvLayoutData::ScCsvLayoutData() :
/*N*/     mnPosCount( 1 ),
/*N*/     mnPosOffset( 0 ),
/*N*/     mnWinWidth( 1 ),
/*N*/     mnHdrWidth( 0 ),
/*N*/     mnCharWidth( 1 ),
/*N*/     mnLineCount( 1 ),
/*N*/     mnLineOffset( 0 ),
/*N*/     mnWinHeight( 1 ),
/*N*/     mnHdrHeight( 0 ),
/*N*/     mnLineHeight( 1 ),
/*N*/     mnPosCursor( CSV_POS_INVALID ),
/*N*/     mnColCursor( 0 ),
/*N*/     mnNoRepaint( 0 ),
/*N*/     mbAppRTL( !!Application::GetSettings().GetLayoutRTL() )
/*N*/ {
/*N*/ }



// ============================================================================

/*N*/ ScCsvControl::ScCsvControl( ScCsvControl& rParent ) :
/*N*/     Control( &rParent, WB_TABSTOP | WB_NODIALOGCONTROL ),
/*N*/     mrData( rParent.GetLayoutData() ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*N*/ ScCsvControl::ScCsvControl( Window* pParent, const ScCsvLayoutData& rData, WinBits nStyle ) :
/*N*/     Control( pParent, nStyle ),
/*N*/     mrData( rData ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*N*/ ScCsvControl::ScCsvControl( Window* pParent, const ScCsvLayoutData& rData, const ResId& rResId ) :
/*N*/     Control( pParent, rResId ),
/*N*/     mrData( rData ),
/*M*/     mpAccessible( NULL ),
/*N*/     mbValidGfx( false )
/*N*/ {
/*N*/ }

/*M*/ ScCsvControl::~ScCsvControl()
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->dispose();
/*M*/ }


// event handling -------------------------------------------------------------

/*M*/ void ScCsvControl::GetFocus()
/*M*/ {
/*M*/     Control::GetFocus();
/*M*/     AccSendFocusEvent( true );
/*M*/ }

/*M*/ void ScCsvControl::LoseFocus()
/*M*/ {
/*M*/     Control::LoseFocus();
/*M*/     AccSendFocusEvent( false );
/*M*/ }

/*M*/ void ScCsvControl::AccSendFocusEvent( bool bFocused )
/*M*/ {
/*M*/     if( mpAccessible )
/*M*/         mpAccessible->SendFocusEvent( bFocused );
/*M*/ }

}
