/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docsh.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:06:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef SC_DOCSHELL_HXX
#define SC_DOCSHELL_HXX


#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif

#ifndef _SFX_INTERNO_HXX //autogen
#include <bf_sfx2/interno.hxx>
#endif

#ifndef _SFX_OBJFAC_HXX //autogen
#include <bf_sfx2/docfac.hxx>
#endif

#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif


#ifndef SC_SCDLL_HXX
#include "scdll.hxx"
#endif

#include "document.hxx"
#include "shellids.hxx"
#include "refreshtimer.hxx"
class FontList;
class PrintDialog;
class SfxStyleSheetBasePool;
class SfxStyleSheetHint;
class INetURLObject;
class VirtualDevice;
namespace binfilter {

class ScEditEngineDefaulter;
struct ChartSelectionInfo;

class ScPaintItem;
class ScViewData;
class ScDocFunc;
class ScPivot;
class ScDrawLayer;
class ScTabViewShell;
class ScSbxDocHelper;
class ScAutoStyleList;
class ScRange;
class ScMarkData;
class ScPaintLockData;
class ScJobSetup;
class ScChangeAction;
class ScImportOptions;
class ScDocShellModificator;

//==================================================================

//enum ScDBFormat { SC_FORMAT_SDF, SC_FORMAT_DBF };

									// Extra-Flags fuer Repaint
#define SC_PF_LINES         1
#define SC_PF_TESTMERGE     2

class ScDocShell: public SfxObjectShell, public SfxInPlaceObject, public SfxListener
{
	static const sal_Char __FAR_DATA pStarCalcDoc[];
	static const sal_Char __FAR_DATA pStyleName[];

	ScDocument          aDocument;

	String				aDdeTextFmt;
	String				aConvFilterName; //@ #BugId	54198

	double				nPrtToScreenFactor;
	FontList*			pFontList;
	SfxUndoManager* 	pUndoManager;
	ScDocFunc*			pDocFunc;

	//SfxObjectCreateMode	eShellMode;

	BOOL				bIsInplace;			// wird von der View gesetzt
	BOOL				bHeaderOn;
	BOOL				bFooterOn;
	BOOL				bNoInformLost;
	BOOL				bIsEmpty;
	BOOL				bIsInUndo;
	BOOL				bDocumentModifiedPending;
	USHORT				nDocumentLock;
    sal_Int16           nCanUpdate;  // stores the UpdateDocMode from loading a document till update links
    BOOL                bUpdateEnabled;

	ScSbxDocHelper* 	pDocHelper;

	ScAutoStyleList*	pAutoStyleList;
	ScPaintLockData*	pPaintLockData;
	ScJobSetup*			pOldJobSetup;

	VirtualDevice*		pVirtualDevice_100th_mm;

    ScDocShellModificator* pModificator; // #109979#; is used to load XML (created in BeforeXMLLoading and destroyed in AfterXMLLoading)

    String              aUserData;      // #116578# loaded manually, as no view is created

	void			InitItems();
	void			InitOptions();
	void			ResetDrawObjectShell();

	BOOL			LoadCalc( SvStorage* pStor );
	BOOL			SaveCalc( SvStorage* pStor );
	BOOL			LoadXML( SfxMedium* pMedium, SvStorage* pStor );
	BOOL			SaveXML( SfxMedium* pMedium, SvStorage* pStor );
	void			UpdateAllRowHeights();

	void			RemoveUnknownObjects();



	void			LockPaint_Impl(BOOL bDoc);
	void			UnlockPaint_Impl(BOOL bDoc);
	void			LockDocument_Impl(USHORT nNew);
	void			UnlockDocument_Impl(USHORT nNew);

protected:

	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
						 const SfxHint& rHint, const TypeId& rHintType );

public:
					TYPEINFO();

					SFX_DECL_INTERFACE(SCID_DOC_SHELL);
					SFX_DECL_OBJECTFACTORY_DLL( ScDocShell, SC_DLL() );

					ScDocShell( const ScDocShell& rDocShell );
					ScDocShell( SfxObjectCreateMode eMode = SFX_CREATE_MODE_EMBEDDED );
					~ScDocShell();


	virtual SfxUndoManager*     GetUndoManager();

	virtual void	FillClass( SvGlobalName * pClassName,
							   ULONG * pFormat,
							   String * pAppName,
							   String * pFullTypeName,
							   String * pShortTypeName,
							   long nFileFormat = SOFFICE_FILEFORMAT_CURRENT ) const;

	virtual BOOL    InitNew( SvStorage * );
	virtual BOOL    Load( SvStorage * );
	virtual BOOL    ConvertFrom( SfxMedium &rMedium );
	virtual void    HandsOff();
	virtual BOOL    Save();
	virtual BOOL    SaveAs( SvStorage * pNewStor );

	virtual BOOL    SaveCompleted( SvStorage * pNewStor );		// SfxInPlaceObject
	virtual BOOL	DoSaveCompleted( SfxMedium * pNewStor);		// SfxObjectShell


	virtual void    SetVisArea( const Rectangle & rVisArea );
	virtual Rectangle GetVisArea( USHORT nAspect ) const;

	virtual Printer* GetDocumentPrinter();

	virtual void	SetModified( BOOL = TRUE );

	void			SetVisAreaOrSize( const Rectangle& rVisArea, BOOL bModifyStart );



	ScDocument*     GetDocument()	{ return &aDocument; }
	ScDocFunc&		GetDocFunc()	{ return *pDocFunc; }

	SfxPrinter*		GetPrinter();
	USHORT			SetPrinter( SfxPrinter* pNewPrinter, USHORT nDiffFlags = SFX_PRINTER_ALL );



	ScDrawLayer*	MakeDrawLayer();


	void			GetSbxState( SfxItemSet &rSet ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 void			GetSbxState( SfxItemSet &rSet );
	void			GetDrawObjState( SfxItemSet &rSet ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 void			GetDrawObjState( SfxItemSet &rSet );

	void            Execute( SfxRequest& rReq );
	void            GetState( SfxItemSet &rSet ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 void            GetState( SfxItemSet &rSet );
	void			GetStatePageStyle( SfxViewShell& rCaller, SfxItemSet& rSet, USHORT nCurTab );


                    /// Protect/unprotect ChangeTrack and return <TRUE/> if
                    /// protection was successfully changed.
                    /// If bJustQueryIfProtected==TRUE protection is not
                    /// changed and <TRUE/> is returned if not protected or
                    /// password was entered correctly.


	void			LoadStylesArgs( ScDocShell& rSource, BOOL bReplace, BOOL bCellStyles, BOOL bPageStyles );

	void			PageStyleModified( const String& rStyleName, BOOL bApi );

	void			NotifyStyle( const SfxStyleSheetHint& rHint );

	Window*			GetDialogParent();
	void			ErrorMessage( USHORT nGlobStrId );
	BOOL			IsEditable() const;

	BOOL			AdjustRowHeight( USHORT nStartRow, USHORT nEndRow, USHORT nTab );

	void			DoConsolidate( const ScConsolidateParam& rParam, BOOL bRecord = TRUE );
	void			UseScenario( USHORT nTab, const String& rName, BOOL bRecord = TRUE );
	USHORT			MakeScenario( USHORT nTab, const String& rName, const String& rComment,
									const Color& rColor, USHORT nFlags,
									ScMarkData& rMark, BOOL bRecord = TRUE );
	void			ModifyScenario( USHORT nTab, const String& rName, const String& rComment,
									const Color& rColor, USHORT nFlags );
	BOOL			MoveTable( USHORT nSrcTab, USHORT nDestTab, BOOL bCopy, BOOL bRecord );

	void			DoRecalc( BOOL bApi );
	void			DoHardRecalc( BOOL bApi );


	BOOL			IsOle();

	void			DBAreaDeleted( USHORT nTab, USHORT nX1, USHORT nY1, USHORT nX2, USHORT nY2 );
	ScDBData*		GetDBData( const ScRange& rMarked, ScGetDBMode eMode, BOOL bForceMark );

	void			UpdateLinks();			// Link-Eintraege aktuallisieren
	BOOL			ReloadTabLinks();		// Links ausfuehren (Inhalt aktualisieren)


	void            PostPaint( USHORT nStartCol, USHORT nStartRow, USHORT nStartTab,
							USHORT nEndCol, USHORT nEndRow, USHORT nEndTab, USHORT nPart,
							USHORT nExtFlags = 0 );
	void            PostPaint( const ScRange& rRange, USHORT nPart, USHORT nExtFlags = 0 );

	void            PostPaintCell( USHORT nCol, USHORT nRow, USHORT nTab );
	void            PostPaintGridAll();
	void            PostPaintExtras();

	void            PostDataChanged();

	void			SetDocumentModified( BOOL bIsModified = TRUE );
	void			SetDrawModified( BOOL bIsModified = TRUE );

	void			LockPaint();
	void			UnlockPaint();
	USHORT			GetLockCount() const;
	void			SetLockCount(USHORT nNew);

	void			LockDocument();
	void			UnlockDocument();


	virtual SfxStyleSheetBasePool*	GetStyleSheetPool();

	BOOL			IsEmpty() const;
	void			ResetEmpty();

	BOOL			IsInUndo() const				{ return bIsInUndo; }

	void			CalcOutputFactor();
	double			GetOutputFactor() const;


	const String& GetDdeTextFmt() const { return aDdeTextFmt; }

	SfxBindings*	GetViewBindings();

	ScTabViewShell* GetBestViewShell();
	ScSbxDocHelper* GetDocHelperObject() { return pDocHelper; }

	void			SetDocumentModifiedPending( BOOL bVal )
						{ bDocumentModifiedPending = bVal; }
	BOOL			IsDocumentModifiedPending() const
						{ return bDocumentModifiedPending; }

    BOOL            IsUpdateEnabled() const
                        { return bUpdateEnabled; }
    void            SetUpdateEnabled(BOOL bValue)
                        { bUpdateEnabled = bValue; }

	VirtualDevice*	GetVirtualDevice_100th_mm();

	static ScViewData* GetViewData();
	static USHORT	   GetCurTab();

	static String	GetOwnFilterName();
	static String	GetWebQueryFilterName();
	static String	GetAsciiFilterName();
	static String	GetLotusFilterName();
	static String	GetDBaseFilterName();
	static String	GetDifFilterName();
	static BOOL		HasAutomaticTableName( const String& rFilter );

	DECL_LINK( RefreshDBDataHdl, ScDBData* );

    void            BeforeXMLLoading();
    void            AfterXMLLoading(sal_Bool bRet);

    const String&   GetUserData() const { return aUserData; }   // #116578#
};

SO2_DECL_REF(ScDocShell)
SO2_IMPL_REF(ScDocShell)


// Vor Modifizierungen des Dokuments anlegen und danach zerstoeren.
// Merkt sich im Ctor AutoCalcShellDisabled und IdleDisabled, schaltet sie ab
// und stellt sie im Dtor wieder her, AutoCalcShellDisabled ggbf. auch vor
// einem ScDocShell SetDocumentModified.
// SetDocumentModified hierdran aufrufen statt an der ScDocShell.
// Im Dtor wird wenn ScDocShell bDocumentModifiedPending gesetzt ist und
// bAutoCalcShellDisabled nicht gesetzt ist ein SetDocumentModified gerufen.
class ScDocShellModificator
{
			ScDocShell&		rDocShell;
	ScRefreshTimerProtector	aProtector;
			BOOL			bAutoCalcShellDisabled;
			BOOL			bIdleDisabled;

							// not implemented
							ScDocShellModificator( const ScDocShellModificator& );
	ScDocShellModificator&	operator=( const ScDocShellModificator& );

public:
							ScDocShellModificator( ScDocShell& );
							~ScDocShellModificator();
			void			SetDocumentModified();
};



} //namespace binfilter
#endif


