/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_olinewin.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:12:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_TASKPANELIST_HXX
#include <vcl/taskpanelist.hxx>
#endif

#include "olinewin.hxx"
#include "bf_sc.hrc"

#ifndef _SV_SYSWIN_HXX
#include <vcl/syswin.hxx>
#endif

namespace binfilter {

// ============================================================================

const sal_Int32 SC_OL_BITMAPSIZE            = 12;
const sal_Int32 SC_OL_POSOFFSET             = 2;

const sal_uInt16 SC_OL_NOLEVEL              = 0xFFFF;
const sal_uInt16 SC_OL_HEADERENTRY          = 0xFFFF;

const sal_uInt16 SC_OL_IMAGE_PLUS           = 9;
const sal_uInt16 SC_OL_IMAGE_MINUS          = SC_OL_IMAGE_PLUS + 1;
const sal_uInt16 SC_OL_IMAGE_NOTPRESSED     = SC_OL_IMAGE_MINUS + 1;
const sal_uInt16 SC_OL_IMAGE_PRESSED        = SC_OL_IMAGE_NOTPRESSED + 1;


// ============================================================================

/*N*/ ScOutlineWindow::ScOutlineWindow( Window* pParent, ScOutlineMode eMode, ScViewData* pViewData, ScSplitPos eWhich ) :
/*N*/ 	Window( pParent ),
/*N*/     mrViewData( *pViewData ),
/*N*/     meWhich( eWhich ),
/*N*/     mbHoriz( eMode == SC_OUTLINE_HOR ),
/*N*/     mpSymbols( NULL ),
/*N*/     maLineColor( COL_BLACK ),
/*N*/     mnHeaderSize( 0 ),
/*N*/     mnHeaderPos( 0 ),
/*N*/     mnMainFirstPos( 0 ),
/*N*/     mnMainLastPos( 0 ),
/*N*/     mbMTActive( false ),
/*N*/     mbMTPressed( false ),
/*N*/     mnFocusLevel( 0 ),
/*N*/     mnFocusEntry( SC_OL_HEADERENTRY ),
/*N*/     mbDontDrawFocus( false )
/*N*/ {
/*N*/     EnableRTL( !mbHoriz ); // #107809# do not mirror (horizontal) column outline window
/*N*/     mbMirrorHdr = mbHoriz && Application::GetSettings().GetLayoutRTL();
/*N*/ 
/*N*/     InitSettings();
/*N*/     maFocusRect.SetEmpty();
/*N*/     SetHeaderSize( 0 );
/*N*/ 
/*N*/     // insert the window into task pane list for "F6 cycling"
/*N*/     if( SystemWindow* pSysWin = GetSystemWindow() )
/*N*/         if( TaskPaneList* pTaskPaneList = pSysWin->GetTaskPaneList() )
/*N*/             pTaskPaneList->AddWindow( this );
/*N*/ }

/*N*/ ScOutlineWindow::~ScOutlineWindow()
/*N*/ {
/*N*/     // remove the window from task pane list
/*N*/     if( SystemWindow* pSysWin = GetSystemWindow() )
/*N*/         if( TaskPaneList* pTaskPaneList = pSysWin->GetTaskPaneList() )
/*N*/             pTaskPaneList->RemoveWindow( this );
/*N*/ }

/*N*/ void ScOutlineWindow::SetHeaderSize( sal_Int32 nNewSize )
/*N*/ {
/*N*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bool bNew = (nNewSize != mnHeaderSize);
/*N*/ }

/*N*/ sal_Int32 ScOutlineWindow::GetDepthSize() const
/*N*/ {
    DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 sal_Int32 nSize = GetLevelCount() * SC_OL_BITMAPSIZE;
/*N*/ }





// internal -------------------------------------------------------------------

/*N*/ void ScOutlineWindow::InitSettings()
/*N*/ {
/*N*/     DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
/*N*/ }




























// drawing --------------------------------------------------------------------










// focus ----------------------------------------------------------------------

/** Increments or decrements a value and wraps at the specified limits.
    @return  true = value wrapped. */









// mouse ----------------------------------------------------------------------







// keyboard -------------------------------------------------------------------



// ============================================================================

}
