/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:07:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

//------------------------------------------------------------------

#if 0
#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVCONTNR_HXX
#define BASIC_NODIALOGS
#define _SFXMNUITEM_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SFXMNUITEM_HXX
#define _DLGCFG_HXX
#define _SFXMNUMGR_HXX
#define _SFXBASIC_HXX
#define _MODALDLG_HXX
#define _SFX_TEMPLDLG_HXX
#define _SFXSTBMGR_HXX
#define _SFXTBXMGR_HXX
#define _BASE_DLGS_HXX
#define _SFXIMGMGR_HXX
#define _SFXMNUMGR_HXX
#define _SFXSTBITEM_HXX
#define _SFXTBXCTRL_HXX
#define _PASSWD_HXX
//#define _SFXFILEDLG_HXX
//#define _SFXREQUEST_HXX
#define _SFXOBJFACE_HXX

#define _SDR_NOTRANSFORM
#define _SVDXOUT_HXX
#endif
///////////////////////////////////////////////////////////////////////////
// NODRAW.HXX
// Erweiterte Konstanten, um CLOKs mit SVDRAW.HXX zu vermeiden
// Die u.a. Aenderungen nehmen vorgeschlagene Konstante vorweg
///////////////////////////////////////////////////////////////////////////

#if 0
#define _SDR_NOTRANSFORM		// Transformationen, selten verwendet
#define _SDR_NOTOUCH			// Hit-Tests, selten verwendet

#define	_SDR_NOEXTDEV			// ExtOutputDevice
#define	_SDR_NOUNDO				// Undo-Objekte
#define _SDR_NOSURROGATEOBJ     // SdrObjSurrogate
#define _SDR_NOPAGEOBJ          // SdrPageObj
#define _SDR_NOVIRTOBJ          // SdrVirtObj
#define _SDR_NOGROUPOBJ         // SdrGroupObj
#define _SDR_NOTEXTOBJ          // SdrTextObj
#define _SDR_NOPATHOBJ          // SdrPathObj
#define _SDR_NOEDGEOBJ          // SdrEdgeObj
#define _SDR_NORECTOBJ          // SdrRectObj
#define _SDR_NOCAPTIONOBJ       // SdrCaptionObj
#define _SDR_NOCIRCLEOBJ        // SdrCircleObj
#define _SDR_NOGRAFOBJ          // SdrGrafObj
#define _SDR_NOOLE2OBJ          // SdrOle2Obj
#endif

// Dieses define entfernt die VCControls aus SI.HXX

#define _SI_HXX					// VCControls

////////////////////// Umsetzen der Standard-Defines //////////////////////

#ifdef _SDR_NOEXTDEV
	#define	_SDVXOUT_HXX
	#undef _SDR_NOEXTDEV
#endif

//#define _SVDDRAG_HXX		// SdrDragStat
#define _SVDPAGE_HXX        // SdrPage

#ifdef _SDR_NOSURROGATEOBJ
	#undef _SDR_NOSURROGATEOBJ
	#define _SVDSURO_HXX
#endif

#ifdef _SDR_NOPAGEOBJ
	#undef _SDR_NOPAGEOBJ
	#define _SVDOPAGE_HXX
#endif

#ifdef _SDR_NOVIRTOBJ
	#undef _SDR_NOVIRTOBJ
	#define _SVDOVIRT_HXX
#endif

#ifdef _SDR_NOGROUPOBJ
	#undef _SDR_NOGROUPOBJ
	#define _SVDOGRP_HXX
#endif

#ifdef _SDR_NOTEXTOBJ
	#undef _SDR_NOTEXTOBJ
	#define _SVDOTEXT_HXX
#endif

#ifdef _SDR_NOPATHOBJ
	#undef _SDR_NOPATHOBJ
	#define _SVDOPATH_HXX
#endif

#ifdef _SDR_NOEDGEOBJ
	#undef _SDR_NOEDGEOBJ
	#define _SVDOEDGE_HXX
#endif

#ifdef _SDR_NORECTOBJ
	#undef _SDR_NORECTOBJ
	#define _SVDORECT_HXX
#else
	#undef _SDVOTEXT_OBJ
#endif

#ifdef _SDR_NOCAPTIONOBJ
	#undef _SDR_NOCAPTIONOBJ
	#define _SVDCAPT_HXX
#endif

#ifdef _SDR_NOCIRCLEOBJ
	#undef _SDR_NOCIRCLEOBJ
	#define _SVDOCIRC_HXX
#endif

#ifdef _SDR_NOGRAFOBJ
	#undef _SDR_NOGRAFOBJ
	#define _SVDOGRAF_HXX
#else
	#undef _SVDOTEXT_HXX
	#undef _SVDORECT_HXX
#endif

#ifdef _SDR_NOOLE2OBJ
	#undef _SDR_NOOLE2OBJ
	#define _SVDOOLE2_HXX
#else
	#undef _SVDOTEXT_HXX
	#undef _SVDORECT_HXX
#endif

//#ifdef _SDR_NOVIEWS
//	#define _SVDDRAG_HXX
//#endif

////////////////////// Ende der SVDRAW-Modifikationen /////////////////////

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <bf_sfx2/bindings.hxx>
#include <rtl/logfile.hxx>

#include "tabvwsh.hxx"
#include "gridwin.hxx"
#include "olinewin.hxx"
#include "olinetab.hxx"
#include "tabsplit.hxx"
#include "colrowba.hxx"
#include "tabcont.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "drawview.hxx"
#include "docsh.hxx"
#include "viewuno.hxx"

#include <string>
#include <algorithm>

#define SPLIT_MARGIN	30
#define SC_ICONSIZE		36

#define SC_SCROLLBAR_MIN	30
#define SC_TABBAR_MIN		6

//	fuer Rad-Maus
#define SC_DELTA_ZOOM	10
namespace binfilter {

// STATIC DATA -----------------------------------------------------------


//==================================================================

//	Corner-Button

/*N*/ ScCornerButton::ScCornerButton( Window* pParent, ScViewData* pData, BOOL bAdditional ) :
/*N*/ 	Window( pParent, WinBits( 0 ) ),
/*N*/ 	pViewData( pData ),
/*N*/ 	bAdd( bAdditional )
/*N*/ {
/*N*/ 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
/*N*/ 	SetBackground( rStyleSettings.GetFaceColor() );
/*N*/ }

/*N*/ __EXPORT ScCornerButton::~ScCornerButton()
/*N*/ {
/*N*/ }


/*N*/ void ScCornerButton::StateChanged( StateChangedType nType )
/*N*/ {
/*N*/ 	Window::StateChanged( nType );
/*N*/ 
/*N*/ 	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
/*N*/ 	SetBackground( rStyleSettings.GetFaceColor() );
/*N*/ 	Invalidate();
/*N*/ }

// -----------------------------------------------------------------------



/*N*/ void __EXPORT ScCornerButton::Resize()
/*N*/ {
/*N*/ 	Invalidate();
/*N*/ }


//==================================================================

/*N*/ BOOL lcl_HasColOutline( const ScViewData& rViewData )
/*N*/ {
/*N*/ 	const ScOutlineTable* pTable = rViewData.GetDocument()->GetOutlineTable(rViewData.GetTabNo());
/*N*/ 	if (pTable)
/*N*/ 	{
/*N*/ 		const ScOutlineArray* pArray = pTable->GetColArray();
/*N*/ 		if ( pArray->GetDepth() > 0 )
/*N*/ 			return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

/*N*/ BOOL lcl_HasRowOutline( const ScViewData& rViewData )
/*N*/ {
/*N*/ 	const ScOutlineTable* pTable = rViewData.GetDocument()->GetOutlineTable(rViewData.GetTabNo());
/*N*/ 	if (pTable)
/*N*/ 	{
/*N*/ 		const ScOutlineArray* pArray = pTable->GetRowArray();
/*N*/ 		if ( pArray->GetDepth() > 0 )
/*N*/ 			return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

//==================================================================

//	Init und Konstruktoren
//	ScTabView::Init() in tabview5.cxx wegen out of keys


#define TABVIEW_INIT	\
			aFunctionSet( &aViewData ),										\
			aHdrFunc( &aViewData ),											\
		    aHScrollLeft( pFrameWin, WinBits( WB_HSCROLL | WB_DRAG ) ),		\
		    aHScrollRight( pFrameWin, WinBits( WB_HSCROLL | WB_DRAG ) ),	\
		    aVScrollTop( pFrameWin, WinBits( WB_VSCROLL | WB_DRAG ) ),		\
		    aVScrollBottom( pFrameWin, WinBits( WB_VSCROLL | WB_DRAG ) ),	\
			aCornerButton( pFrameWin, &aViewData, FALSE ),					\
			aTopButton( pFrameWin, &aViewData, TRUE ),						\
			aScrollBarBox( pFrameWin, WB_SIZEABLE ),						\
			pInputHintWindow( NULL ),										\
			pPageBreakData( NULL ),											\
			pHighlightRanges( NULL ),										\
		    bDragging( FALSE ),												\
			bIsBlockMode( FALSE ),											\
			bBlockNeg( FALSE ),												\
			bBlockCols( FALSE ),											\
			bBlockRows( FALSE ),											\
			nTipVisible( 0 ),												\
			pDrawView( NULL ),												\
			bDrawSelMode( FALSE ),											\
			bMinimized( FALSE ),											\
			pTimerWindow( NULL ),											\
			pSelEngine( NULL ),												\
			pHdrSelEng( NULL ),												\
			bInUpdateHeader( FALSE ),										\
			bInActivatePart( FALSE ),										\
			bInZoomUpdate( FALSE ),											\
			bMoveIsShift( FALSE ),											\
			bNewStartIfMarking( FALSE )


/*N*/ ScTabView::ScTabView( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell ) :
/*N*/ 			pFrameWin( pParent ),
/*N*/ 			aViewData( &rDocSh, pViewShell ),
/*N*/ 			eZoomType( SVX_ZOOM_PERCENT ),
/*N*/ 			TABVIEW_INIT
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabView::ScTabView" );
/*N*/ 
/*N*/ 	Init();
/*N*/ }

/*N*/ ScTabView::ScTabView( Window* pParent, const ScTabView& rScTabView, ScTabViewShell* pViewShell ) :
/*N*/ 			pFrameWin( pParent ),
/*N*/ 			aViewData( rScTabView.aViewData ),
/*N*/ 			eZoomType( rScTabView.eZoomType ),
/*N*/ 			TABVIEW_INIT
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabView::ScTabView" );
/*N*/ 
/*N*/ 	aViewData.SetViewShell( pViewShell );
/*N*/ 	Init();
/*N*/ 
/*N*/ 	UpdateShow();
/*N*/ 	if ( aViewData.GetActivePart() != SC_SPLIT_BOTTOMLEFT )
/*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->Show();
/*N*/ 
/*N*/ 	InvalidateSplit();
/*N*/ }

/*N*/ void ScTabView::InitScrollBar( ScrollBar& rScrollBar, long nMaxVal )
/*N*/ {
/*N*/ 	rScrollBar.SetRange( Range( 0, nMaxVal ) );
/*N*/ 	rScrollBar.SetLineSize( 1 );
/*N*/ 	rScrollBar.SetPageSize( 1 );				// wird getrennt abgefragt
/*N*/ 	rScrollBar.SetVisibleSize( 10 );			// wird bei Resize neu gesetzt
/*N*/ 
/*N*/ 	rScrollBar.SetScrollHdl( LINK(this, ScTabView, ScrollHdl) );
/*N*/ 	rScrollBar.SetEndScrollHdl( LINK(this, ScTabView, EndScrollHdl) );
/*N*/ }

//	Scroll-Timer



IMPL_LINK( ScTabView, TimerHdl, Timer*, pTimer )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
	return 0;
}

// --- Resize ---------------------------------------------------------------------

/*N*/ void ScTabView::DoResize( const Point& rOffset, const Size& rSize, BOOL bInner )
/*N*/ {
/*N*/ 	HideListBox();
/*N*/ 
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	BOOL bVScroll	 = aViewData.IsVScrollMode();
/*N*/ 	BOOL bHScroll	 = aViewData.IsHScrollMode();
/*N*/ 	BOOL bTabControl = aViewData.IsTabMode();
/*N*/ 	BOOL bHeaders	 = aViewData.IsHeaderMode();
/*N*/ 	BOOL bOutlMode	 = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	 = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	 = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 
/*N*/ 	//	Scrollbar-Einstellungen koennen vom Sfx ueberschrieben werden:
/*N*/ 	SfxScrollingMode eMode = aViewData.GetViewShell()->GetScrollingMode();
/*N*/ 	if ( eMode == SCROLLING_NO )
/*N*/ 		bHScroll = bVScroll = FALSE;
/*N*/ 	else if ( eMode == SCROLLING_YES || eMode == SCROLLING_AUTO )	//! Auto ???
/*N*/ 		bHScroll = bVScroll = TRUE;
/*N*/ 
/*N*/ 	if ( aViewData.GetDocShell()->IsPreview() )
/*N*/ 		bHScroll = bVScroll = bTabControl = bHeaders = bOutlMode = bHOutline = bVOutline = FALSE;
/*N*/ 
/*N*/ 	long nBarX = 0;
/*N*/ 	long nBarY = 0;
/*N*/ 	long nOutlineX;
/*N*/ 	long nOutlineY;
/*N*/ 	long nOutPosX;
/*N*/ 	long nOutPosY;
/*N*/ 
/*N*/ 	long nPosX = rOffset.X();
/*N*/ 	long nPosY = rOffset.Y();
/*N*/ 	long nSizeX = rSize.Width();
/*N*/ 	long nSizeY = rSize.Height();
/*N*/ 	long nSize1;
/*N*/ 
/*N*/ 	bMinimized = ( nSizeX<=SC_ICONSIZE || nSizeY<=SC_ICONSIZE );
/*N*/ 	if ( bMinimized )
/*N*/ 		return;
/*N*/ 		  
/*N*/ 	long nSplitSizeX = SPLIT_HANDLE_SIZE;
/*N*/ 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
/*N*/ 		nSplitSizeX = 1;
/*N*/ 	long nSplitSizeY = SPLIT_HANDLE_SIZE;
/*N*/ 	if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
/*?*/ 		nSplitSizeY = 1;
/*?*/ 
/*N*/ 	const long nOverlap = 0;	// ScrollBar::GetWindowOverlapPixel();
/*N*/ 
/*N*/ 	aBorderPos = rOffset;
/*N*/ 	aFrameSize = rSize;
/*N*/ 
/*N*/ 	if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*?*/ 		if ( aViewData.GetHSplitPos() > nSizeX - SPLIT_MARGIN )
/*?*/ 		{
/*?*/ 			aViewData.SetHSplitMode( SC_SPLIT_NONE );
/*?*/ 			if ( WhichH( aViewData.GetActivePart() ) == SC_SPLIT_RIGHT )
/*?*/  			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 			ActivatePart( SC_SPLIT_BOTTOMLEFT );
/*?*/ 			InvalidateSplit();
/*?*/ //			UpdateShow();
/*?*/ 		}
/*N*/ 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*?*/ 		if ( aViewData.GetVSplitPos() > nSizeY - SPLIT_MARGIN )
/*?*/ 		{
/*?*/ 			aViewData.SetVSplitMode( SC_SPLIT_NONE );
/*?*/ 			if ( WhichV( aViewData.GetActivePart() ) == SC_SPLIT_TOP )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	ActivatePart( SC_SPLIT_BOTTOMLEFT );
/*?*/ 			InvalidateSplit();
/*?*/ //			UpdateShow();
/*N*/ 		}
/*N*/ 
/*N*/ 	UpdateShow();
/*N*/ 
/*N*/ 	if (bHScroll || bVScroll)		// Scrollbars horizontal oder vertikal
/*N*/ 	{
/*N*/ 		long nScrollBarSize = pFrameWin->GetSettings().GetStyleSettings().GetScrollBarSize();
/*N*/ 		if (bVScroll)
/*N*/ 		{
/*N*/ //			nBarX = aVScrollBottom.GetSizePixel().Width();
/*N*/ 			nBarX = nScrollBarSize;
/*N*/ 			nSizeX -= nBarX - nOverlap;
/*N*/ 		}
/*N*/ 		if (bHScroll)
/*N*/ 		{
/*N*/ //			nBarY = aHScrollLeft.GetSizePixel().Height();
/*N*/ 			nBarY = nScrollBarSize;
/*N*/ 			nSizeY -= nBarY - nOverlap;
/*N*/ 		}
/*N*/ 
/*N*/ 		//	Fenster rechts unten
/*N*/ 		aScrollBarBox.SetPosSizePixel( Point( nPosX+nSizeX, nPosY+nSizeY ), Size( nBarX, nBarY ) );
/*N*/ 
/*N*/ 		if (bHScroll)								// Scrollbars horizontal
/*N*/ 		{
/*N*/ 			long nSizeLt;			// linker Scrollbar
/*N*/ 			long nSizeRt;			// rechter Scrollbar
/*N*/ 			long nSizeSp;			// Splitter
/*N*/ 
/*N*/ 			switch (aViewData.GetHSplitMode())
/*N*/ 			{
/*N*/ 				case SC_SPLIT_NONE:
/*N*/ 					nSizeSp = nSplitSizeX;
/*N*/ 					nSizeLt = nSizeX - nSizeSp + nOverlap;			// Ecke ueberdecken
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_NORMAL:
/*N*/ 					nSizeSp = nSplitSizeX;
/*N*/ 					nSizeLt = aViewData.GetHSplitPos();
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_FIX:
/*N*/ 					nSizeSp = 0;
/*N*/ 					nSizeLt = 0;
/*N*/ 					break;
/*N*/ 			}
/*N*/ 			nSizeRt = nSizeX - nSizeLt - nSizeSp;
/*N*/ 
/*N*/ 			long nTabSize = 0;
/*N*/ 			if (bTabControl)
/*N*/ 			{
/*N*/ 				nTabSize = pTabControl->GetSizePixel().Width()-nOverlap;
/*N*/ 
/*N*/ 				if ( aViewData.GetHSplitMode() != SC_SPLIT_FIX )	// bei linkem Scrollbar
/*N*/ 				{
/*N*/ 					if (nTabSize > nSizeLt-SC_SCROLLBAR_MIN) nTabSize = nSizeLt-SC_SCROLLBAR_MIN;
/*N*/ 					if (nTabSize < SC_TABBAR_MIN) nTabSize = SC_TABBAR_MIN;
/*N*/ 					nSizeLt -= nTabSize;
/*N*/ 				}
/*N*/ 				else												// bei rechtem Scrollbar
/*N*/ 				{
/*N*/ 					if (nTabSize > nSizeRt-SC_SCROLLBAR_MIN) nTabSize = nSizeRt-SC_SCROLLBAR_MIN;
/*N*/ 					if (nTabSize < SC_TABBAR_MIN) nTabSize = SC_TABBAR_MIN;
/*N*/ 					nSizeRt -= nTabSize;
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			pTabControl->SetPosSizePixel( Point(nPosX-nOverlap, nPosY+nSizeY),
/*N*/ 												Size(nTabSize+nOverlap, nBarY) );
/*N*/ 
/*N*/ 			aHScrollLeft.SetPosSizePixel( Point(nPosX+nTabSize-nOverlap, nPosY+nSizeY),
/*N*/ 												Size(nSizeLt+2*nOverlap, nBarY) );
/*N*/ 			pHSplitter->SetPosPixel( Point( nPosX+nTabSize+nSizeLt, nPosY+nSizeY ) );
/*N*/ 			aHScrollRight.SetPosSizePixel( Point(nPosX+nTabSize+nSizeLt+nSizeSp-nOverlap,
/*N*/ 													nPosY+nSizeY),
/*N*/ 											Size(nSizeRt+2*nOverlap, nBarY) );
/*N*/ 
/*N*/ 			pHSplitter->SetSizePixel( Size( nSizeSp, nBarY ) );
/*N*/ 			//	SetDragRectPixel ist unten
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bVScroll)								// Scrollbars vertikal
/*N*/ 		{
/*N*/ 			long nSizeUp;			// oberer Scrollbar
/*N*/ 			long nSizeSp;			// Splitter
/*N*/ 			long nSizeDn;			// unterer Scrollbar
/*N*/ 
/*N*/ 			switch (aViewData.GetVSplitMode())
/*N*/ 			{
/*N*/ 				case SC_SPLIT_NONE:
/*N*/ 					nSizeUp = 0;
/*N*/ 					nSizeSp = nSplitSizeY;
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_NORMAL:
/*N*/ 					nSizeUp = aViewData.GetVSplitPos();
/*N*/ 					nSizeSp = nSplitSizeY;
/*N*/ 					break;
/*N*/ 				case SC_SPLIT_FIX:
/*N*/ 					nSizeUp = 0;
/*N*/ 					nSizeSp = 0;
/*N*/ 					break;
/*N*/ 			}
/*N*/ 			nSizeDn = nSizeY - nSizeUp - nSizeSp;
/*N*/ 
/*N*/ 			aVScrollTop.SetPosSizePixel( Point(nPosX+nSizeX, nPosY-nOverlap),
/*N*/ 											Size(nBarX,nSizeUp+2*nOverlap) );
/*N*/ 			pVSplitter->SetPosPixel( Point( nPosX+nSizeX, nPosY+nSizeUp ) );
/*N*/ 			aVScrollBottom.SetPosSizePixel( Point(nPosX+nSizeX,
/*N*/ 												nPosY+nSizeUp+nSizeSp-nOverlap),
/*N*/ 											Size(nBarX, nSizeDn+2*nOverlap) );
/*N*/ 
/*N*/ 			pVSplitter->SetSizePixel( Size( nBarX, nSizeSp ) );
/*N*/ 			//	SetDragRectPixel ist unten
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	SetDragRectPixel auch ohne Scrollbars etc., wenn schon gesplittet ist
/*N*/ 	if ( bHScroll || aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 		pHSplitter->SetDragRectPixel(
/*N*/ 			Rectangle( nPosX, nPosY, nPosX+nSizeX, nPosY+nSizeY ), pFrameWin );
/*N*/ 	if ( bVScroll || aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 		pVSplitter->SetDragRectPixel(
/*N*/ 			Rectangle( nPosX, nPosY, nPosX+nSizeX, nPosY+nSizeY ), pFrameWin );
/*N*/ 
/*N*/ 	if (bTabControl && ! bHScroll )
/*N*/ 	{
/*?*/ 		nBarY = aHScrollLeft.GetSizePixel().Height();
/*?*/ 		nBarX = aVScrollBottom.GetSizePixel().Width();
/*?*/ 
/*?*/ 		nSize1 = nSizeX + nOverlap;
/*?*/ 
/*?*/ 		long nTabSize = nSize1;
/*?*/ 		if (nTabSize < 0) nTabSize = 0;
/*?*/ 
/*?*/ 		pTabControl->SetPosSizePixel( Point(nPosX-nOverlap, nPosY+nSizeY-nBarY),
/*?*/ 										Size(nTabSize+nOverlap, nBarY) );
/*?*/ 		nSizeY -= nBarY - nOverlap;
/*?*/ 		aScrollBarBox.SetPosSizePixel( Point( nPosX+nSizeX, nPosY+nSizeY ), Size( nBarX, nBarY ) );
/*?*/ 
/*?*/ 		if( bVScroll )
/*?*/ 		{
/*?*/ 			Size aVScrSize = aVScrollBottom.GetSizePixel();
/*?*/ 			aVScrSize.Height() -= nBarY;
/*?*/ 			aVScrollBottom.SetSizePixel( aVScrSize );
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	nOutPosX = nPosX;
/*N*/ 	nOutPosY = nPosY;
/*N*/ 
/*N*/ 	// Outline-Controls
/*N*/ 	if (bVOutline && pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 	{
/*N*/ 		nOutlineX = pRowOutline[SC_SPLIT_BOTTOM]->GetDepthSize();
/*N*/ 		nSizeX -= nOutlineX;
/*N*/ 		nPosX += nOutlineX;
/*N*/ 	}
/*N*/ 	if (bHOutline && pColOutline[SC_SPLIT_LEFT])
/*N*/ 	{
/*?*/ 		nOutlineY = pColOutline[SC_SPLIT_LEFT]->GetDepthSize();
/*?*/ 		nSizeY -= nOutlineY;
/*?*/ 		nPosY += nOutlineY;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		nBarX = pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
/*N*/ 		nBarY = pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
/*N*/ 		nSizeX -= nBarX;
/*N*/ 		nSizeY -= nBarY;
/*N*/ 		nPosX += nBarX;
/*N*/ 		nPosY += nBarY;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nBarX = nBarY = 0;
/*N*/ 
/*N*/ 		//
/*N*/ 		//		Splitter auswerten
/*N*/ 		//
/*N*/ 
/*N*/ 	long nLeftSize   = nSizeX;
/*N*/ 	long nRightSize  = 0;
/*N*/ 	long nTopSize	 = 0;
/*N*/ 	long nBottomSize = nSizeY;
/*N*/ 	long nSplitPosX  = nPosX;
/*N*/ 	long nSplitPosY  = nPosY;
/*N*/ 
/*N*/ 	if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 	{
/*?*/ 		long nSplitHeight = rSize.Height();
/*?*/ 		if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
/*?*/ 		{
/*?*/ 			//	Fixier-Splitter nicht mit Scrollbar/TabBar ueberlappen lassen
/*?*/ 			if ( bHScroll )
/*?*/ 				nSplitHeight -= aHScrollLeft.GetSizePixel().Height();
/*?*/ 			else if ( bTabControl && pTabControl )
/*?*/ 				nSplitHeight -= pTabControl->GetSizePixel().Height();
/*?*/ 		}
/*?*/ 		nSplitPosX = aViewData.GetHSplitPos();
/*?*/ 		pHSplitter->SetPosSizePixel(
/*?*/ 			Point( nSplitPosX, nOutPosY ), Size( nSplitSizeX, nSplitHeight ) );
/*?*/ 		nLeftSize = nSplitPosX - nPosX;
/*?*/ 		nSplitPosX += nSplitSizeX;
/*?*/ 		nRightSize = nSizeX - nLeftSize - nSplitSizeX;
/*N*/ 	}
/*N*/ 	if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 	{
/*?*/		long nSplitWidth = rSize.Width();
/*?*/		if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX && bVScroll )
/*?*/			nSplitWidth -= aVScrollBottom.GetSizePixel().Width();
/*?*/		nSplitPosY = aViewData.GetVSplitPos();
/*?*/		pVSplitter->SetPosSizePixel(
/*?*/			Point( nOutPosX, nSplitPosY ), Size( nSplitWidth, nSplitSizeY ) );
/*?*/		nTopSize = nSplitPosY - nPosY;
/*?*/		nSplitPosY += nSplitSizeY;
/*?*/		nBottomSize = nSizeY - nTopSize - nSplitSizeY;
/*N*/	}
/*N*/ 
/*N*/ 	//	ShowHide fuer pColOutline / pRowOutline passiert in UpdateShow
/*N*/ 
/*N*/ 	if (bHOutline)								// Outline-Controls
/*N*/ 	{
/*?*/ 		if (pColOutline[SC_SPLIT_LEFT])
/*?*/ 		{
/*?*/ 			pColOutline[SC_SPLIT_LEFT]->SetHeaderSize( (USHORT) nBarX );
/*?*/ 			pColOutline[SC_SPLIT_LEFT]->SetPosSizePixel(
/*?*/ 					Point(nPosX-nBarX,nOutPosY), Size(nLeftSize+nBarX,nOutlineY) );
/*?*/ 		}
/*?*/ 		if (pColOutline[SC_SPLIT_RIGHT])
/*?*/ 			pColOutline[SC_SPLIT_RIGHT]->SetPosSizePixel(
/*?*/ 					Point(nSplitPosX,nOutPosY), Size(nRightSize,nOutlineY) );
/*N*/ 	}
/*N*/ 	if (bVOutline)
/*N*/ 	{
/*N*/ 		if (nTopSize)
/*N*/ 		{
/*?*/ 			if (pRowOutline[SC_SPLIT_TOP] && pRowOutline[SC_SPLIT_BOTTOM])
/*?*/ 			{
/*?*/ 				pRowOutline[SC_SPLIT_TOP]->SetHeaderSize( (USHORT) nBarY );
/*?*/ 				pRowOutline[SC_SPLIT_TOP]->SetPosSizePixel(
/*?*/ 						Point(nOutPosX,nPosY-nBarY), Size(nOutlineX,nTopSize+nBarY) );
/*?*/ 				pRowOutline[SC_SPLIT_BOTTOM]->SetHeaderSize( 0 );
/*?*/ 				pRowOutline[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*?*/ 						Point(nOutPosX,nSplitPosY), Size(nOutlineX,nBottomSize) );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else if (pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 		{
/*N*/ 			pRowOutline[SC_SPLIT_BOTTOM]->SetHeaderSize( (USHORT) nBarY );
/*N*/ 			pRowOutline[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*N*/ 					Point(nOutPosX,nSplitPosY-nBarY), Size(nOutlineX,nBottomSize+nBarY) );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (bHOutline && bVOutline)
/*N*/ 	{
/*?*/ 		aTopButton.SetPosSizePixel( Point(nOutPosX,nOutPosY), Size(nOutlineX,nOutlineY) );
/*?*/ 		aTopButton.Show();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aTopButton.Hide();
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		pColBar[SC_SPLIT_LEFT]->SetPosSizePixel(
/*N*/ 			Point(nPosX,nPosY-nBarY), Size(nLeftSize,nBarY) );
/*N*/ 		if (pColBar[SC_SPLIT_RIGHT])
/*N*/ 			pColBar[SC_SPLIT_RIGHT]->SetPosSizePixel(
/*?*/ 				Point(nSplitPosX,nPosY-nBarY), Size(nRightSize,nBarY) );
/*N*/ 
/*N*/ 		if (pRowBar[SC_SPLIT_TOP])
/*N*/ 			pRowBar[SC_SPLIT_TOP]->SetPosSizePixel(
/*?*/ 				Point(nPosX-nBarX,nPosY), Size(nBarX,nTopSize) );
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->SetPosSizePixel(
/*N*/ 			Point(nPosX-nBarX,nSplitPosY), Size(nBarX,nBottomSize) );
/*N*/ 
/*N*/ 		aCornerButton.SetPosSizePixel( Point(nPosX-nBarX,nPosY-nBarY), Size(nBarX,nBarY) );
/*N*/ 		aCornerButton.Show();
/*N*/ 		pColBar[SC_SPLIT_LEFT]->Show();
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->Show();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aCornerButton.Hide();
/*N*/ 		pColBar[SC_SPLIT_LEFT]->Hide();			// immer da
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->Hide();
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 											// Grid-Windows
/*N*/ 
/*N*/ 	if (bInner)
/*N*/  	{
/*?*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->SetPosPixel( Point(nPosX,nSplitPosY) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pGridWin[SC_SPLIT_BOTTOMLEFT]->SetPosSizePixel(
/*N*/ 			Point(nPosX,nSplitPosY), Size(nLeftSize,nBottomSize) );
/*N*/ 		if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_BOTTOMRIGHT]->SetPosSizePixel(
/*N*/ 				Point(nSplitPosX,nSplitPosY), Size(nRightSize,nBottomSize) );
/*N*/ 		if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_TOPLEFT]->SetPosSizePixel(
/*N*/ 				Point(nPosX,nPosY), Size(nLeftSize,nTopSize) );
/*N*/ 		if ( aViewData.GetHSplitMode() != SC_SPLIT_NONE && aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 			pGridWin[SC_SPLIT_TOPRIGHT]->SetPosSizePixel(
/*N*/ 				Point(nSplitPosX,nPosY), Size(nRightSize,nTopSize) );
/*N*/ 	}
/*N*/ 
/*N*/ 				//
/*N*/ 				//	Scrollbars updaten
/*N*/ 				//
/*N*/ 
/*N*/ 	if (!bInUpdateHeader)
/*N*/ 	{
/*N*/ 		UpdateScrollBars();		// Scrollbars nicht beim Scrollen neu setzen
/*N*/ 		UpdateHeaderWidth();
/*N*/ 
/*N*/ 		InterpretVisible();		// #69343# have everything calculated before painting
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHasHint)
/*N*/ 		TestHintWindow();		// neu positionieren
/*N*/ 
/*N*/ 	UpdateVarZoom();	//	update variable zoom types (after resizing GridWindows)
/*M*/ 
/*N*/ }

/*N*/ void ScTabView::UpdateVarZoom()
/*N*/ {
/*N*/ 	//	update variable zoom types
/*N*/ 
/*N*/ 	if ( eZoomType != SVX_ZOOM_PERCENT && !bInZoomUpdate )
/*N*/ 	{
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bInZoomUpdate = TRUE;
/*N*/	}
/*N*/ }

/*N*/ void ScTabView::UpdateFixPos()
/*N*/ {
/*N*/ 	BOOL bResize = FALSE;
/*N*/ 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixX())
/*N*/ 	if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixY())
/*N*/ 	if (bResize)
/*?*/ 		RepeatResize(FALSE);
/*N*/ }

/*N*/ void ScTabView::RepeatResize( BOOL bUpdateFix )
/*N*/ {
/*N*/ 	if ( bUpdateFix )
/*N*/ 	{
/*N*/ 		if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			aViewData.UpdateFixX();
/*N*/ 		if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			aViewData.UpdateFixY();
/*N*/ 	}
/*N*/ 
/*N*/ 	DoResize( aBorderPos, aFrameSize );
/*N*/ 
/*N*/ 	//!	Border muss neu gesetzt werden ???
/*N*/ }

/*N*/ void ScTabView::GetBorderSize( SvBorder& rBorder, const Size& rSize )
/*N*/ {
/*N*/ 	BOOL bScrollBars = aViewData.IsVScrollMode();
/*N*/ 	BOOL bTabControl = aViewData.IsTabMode();
/*N*/ 	BOOL bHeaders	 = aViewData.IsHeaderMode();
/*N*/ 	BOOL bOutlMode	 = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	 = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	 = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 
/*N*/ 	rBorder = SvBorder();
/*N*/ 
/*N*/ 	if (bScrollBars)							// Scrollbars horizontal oder vertikal
/*N*/ 	{
/*N*/ 		rBorder.Right()  += aVScrollBottom.GetSizePixel().Width();
/*N*/ 		rBorder.Bottom() += aHScrollLeft.GetSizePixel().Height();
/*N*/ 	}
/*N*/ 
/*N*/ 	// Outline-Controls
/*N*/ 	if (bVOutline && pRowOutline[SC_SPLIT_BOTTOM])
/*N*/ 		rBorder.Left() += pRowOutline[SC_SPLIT_BOTTOM]->GetDepthSize();
/*N*/ 	if (bHOutline && pColOutline[SC_SPLIT_LEFT])
/*N*/ 		rBorder.Top()  += pColOutline[SC_SPLIT_LEFT]->GetDepthSize();
/*N*/ 
/*N*/ 	if (bHeaders)								// Spalten/Zeilen-Header
/*N*/ 	{
/*N*/ 		rBorder.Left() += pRowBar[SC_SPLIT_BOTTOM]->GetSizePixel().Width();
/*N*/ 		rBorder.Top()  += pColBar[SC_SPLIT_LEFT]->GetSizePixel().Height();
/*N*/ 	}
/*N*/ }

IMPL_LINK( ScTabView, TabBarResize, void*, EMPTY_ARG )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
	return 0;
}

/*N*/ Window* ScTabView::GetActiveWin()
/*N*/ {
/*N*/ 	ScSplitPos ePos = aViewData.GetActivePart();
/*N*/ 	DBG_ASSERT(pGridWin[ePos],"kein aktives Fenster");
/*N*/ 	return pGridWin[ePos];
/*N*/ }

/*N*/ Window* ScTabView::GetWindowByPos( ScSplitPos ePos )
/*N*/ {
/*N*/ 	return pGridWin[ePos];
/*N*/ }


/*	ScSplitPos ePos = aViewData.GetActivePart();
	if (pGridWin[ePos])
		pGridWin[ePos]->SetPointer( rPointer );
*/








// ---  Scroll-Bars  --------------------------------------------------------


IMPL_LINK( ScTabView, EndScrollHdl, ScrollBar*, pScroll )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
	return 0;
}

IMPL_LINK( ScTabView, ScrollHdl, ScrollBar*, pScroll )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
	return 0;
}

/*N*/ void ScTabView::ScrollX( long nDeltaX, ScHSplitPos eWhich, BOOL bUpdBars )
/*N*/ {
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	USHORT nOldX = aViewData.GetPosX(eWhich);
/*N*/ 	short nNewX = ((short) nOldX) + (short) nDeltaX;
/*N*/ 	if ( nNewX < 0 )
/*N*/ 	{
/*N*/ 		nDeltaX -= nNewX;
/*N*/ 		nNewX = 0;
/*N*/ 	}
/*N*/ 	if ( nNewX > MAXCOL )
/*N*/ 	{
/*N*/ 		nDeltaX -= nNewX - MAXCOL;
/*N*/ 		nNewX = MAXCOL;
/*N*/ 	}
/*N*/ 
/*N*/ 	short nDir = ( nDeltaX > 0 ) ? 1 : -1;
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	while ( ( pDoc->GetColFlags( nNewX, nTab ) & CR_HIDDEN ) &&
/*N*/ 			nNewX+nDir >= 0 && nNewX+nDir <= MAXCOL )
/*N*/ 		nNewX += nDir;
/*N*/ 
/*N*/ 	//	Fixierung
/*N*/ 
/*N*/ 	if (aViewData.GetHSplitMode() == SC_SPLIT_FIX)
/*N*/ 	{
/*N*/ 		if (eWhich == SC_SPLIT_LEFT)
/*N*/ 			nNewX = (short) nOldX;								// links immer stehenlassen
/*N*/ 		else
/*N*/ 		{
/*N*/ 			short nFixX = (short)aViewData.GetFixPosX();
/*N*/ 			if (nNewX < nFixX)
/*N*/ 				nNewX = nFixX;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (nNewX == (short) nOldX)
/*N*/ 		return;
/*N*/ 
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	HideAllCursors();
/*N*/ }

/*N*/ void ScTabView::ScrollY( long nDeltaY, ScVSplitPos eWhich, BOOL bUpdBars )
/*N*/ {
/*N*/ 	BOOL bHasHint = ( pInputHintWindow != NULL );
/*N*/ 	if (bHasHint)
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 		RemoveHintWindow();
/*N*/ 
/*N*/ 	USHORT nOldY = aViewData.GetPosY(eWhich);
/*N*/ 	short nNewY = ((short) nOldY) + (short) nDeltaY;
/*N*/ 	if ( nNewY < 0 )
/*N*/ 	{
/*N*/ 		nDeltaY -= nNewY;
/*N*/ 		nNewY = 0;
/*N*/ 	}
/*N*/ 	if ( nNewY > MAXROW )
/*N*/ 	{
/*N*/ 		nDeltaY -= nNewY - MAXROW;
/*N*/ 		nNewY = MAXROW;
/*N*/ 	}
/*N*/ 
/*N*/ 	short nDir = ( nDeltaY > 0 ) ? 1 : -1;
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	while ( ( pDoc->GetRowFlags( nNewY, nTab ) & CR_HIDDEN ) &&
/*N*/ 			nNewY+nDir >= 0 && nNewY+nDir <= MAXROW )
/*N*/ 		nNewY += nDir;
/*N*/ 
/*N*/ 	//	Fixierung
/*N*/ 
/*N*/ 	if (aViewData.GetVSplitMode() == SC_SPLIT_FIX)
/*N*/ 	{
/*N*/ 		if (eWhich == SC_SPLIT_TOP)
/*N*/ 			nNewY = (short) nOldY;								// oben immer stehenlassen
/*N*/ 		else
/*N*/ 		{
/*N*/ 			short nFixY = (short)aViewData.GetFixPosY();
/*N*/ 			if (nNewY < nFixY)
/*N*/ 				nNewY = nFixY;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (nNewY == (short) nOldY)
/*N*/ 		return;
/*N*/ 
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	HideAllCursors();
/*N*/ }



/*N*/ void ScTabView::UpdateHeaderWidth( const ScVSplitPos* pWhich, const USHORT* pPosY )
/*N*/ {
/*N*/ 	if ( !pRowBar[SC_SPLIT_BOTTOM] || MAXROW < 10000 )
/*N*/ 		return;
/*N*/ 
/*N*/ 	USHORT nEndPos = MAXROW;
/*N*/ 	if ( !aViewData.GetViewShell()->GetViewFrame()->ISA(SfxInPlaceFrame) )
/*N*/ 	{
/*N*/ 		//	fuer OLE Inplace immer MAXROW
/*N*/ 
/*N*/ 		if ( pWhich && *pWhich == SC_SPLIT_BOTTOM && pPosY )
/*N*/ 			nEndPos = *pPosY;
/*N*/ 		else
/*N*/ 			nEndPos = aViewData.GetPosY( SC_SPLIT_BOTTOM );
/*N*/ 		nEndPos += aViewData.CellsAtY( nEndPos, 1, SC_SPLIT_BOTTOM, SC_SIZE_NONE );	// VisibleCellsY
/*N*/ 		if (nEndPos > MAXROW)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			nEndPos = lcl_LastVisible( aViewData );
/*N*/ 
/*N*/ 		if ( aViewData.GetVSplitMode() != SC_SPLIT_NONE )
/*N*/ 		{
/*?*/ 			USHORT nTopEnd;
/*?*/ 			if ( pWhich && *pWhich == SC_SPLIT_TOP && pPosY )
/*?*/ 				nTopEnd = *pPosY;
/*?*/ 			else
/*?*/ 				nTopEnd = aViewData.GetPosY( SC_SPLIT_TOP );
/*?*/ 			nTopEnd += aViewData.CellsAtY( nTopEnd, 1, SC_SPLIT_TOP, SC_SIZE_NONE );// VisibleCellsY
/*?*/ 			if (nTopEnd > MAXROW)
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				nTopEnd = lcl_LastVisible( aViewData );
/*?*/ 
/*?*/ 			if ( nTopEnd > nEndPos )
/*?*/ 				nEndPos = nTopEnd;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	long nSmall = pRowBar[SC_SPLIT_BOTTOM]->GetSmallWidth();
/*N*/ 	long nBig   = pRowBar[SC_SPLIT_BOTTOM]->GetBigWidth();
/*N*/ 	long nDiff  = nBig - nSmall;
/*N*/ 
/*N*/ 	if (nEndPos>10000)
/*N*/ 		nEndPos = 10000;
/*N*/ 	else if (nEndPos<1)		// avoid extra step at 0 (when only one row is visible)
/*N*/ 		nEndPos = 1;
/*N*/ 	long nWidth = nBig - ( 10000 - nEndPos ) * nDiff / 10000;
/*N*/ 
/*N*/ 	if ( nWidth != pRowBar[SC_SPLIT_BOTTOM]->GetWidth() && !bInUpdateHeader )
/*N*/ 	{
/*N*/ 		bInUpdateHeader = TRUE;
/*N*/ 
/*N*/ 		pRowBar[SC_SPLIT_BOTTOM]->SetWidth( nWidth );
/*N*/ 		if (pRowBar[SC_SPLIT_TOP])
/*?*/ 			pRowBar[SC_SPLIT_TOP]->SetWidth( nWidth );
/*N*/ 
/*N*/ 		RepeatResize();
/*N*/ 
/*N*/ 		// auf VCL gibt's Update ohne Ende (jedes Update gilt fuer alle Fenster)
/*N*/ 		//aCornerButton.Update();		// der bekommt sonst nie ein Update
/*N*/ 
/*N*/ 		bInUpdateHeader = FALSE;
/*N*/ 	}
/*N*/ }

/*N*/ inline void ShowHide( Window* pWin, BOOL bShow )
/*N*/ {
/*N*/ 	DBG_ASSERT(pWin || !bShow, "Fenster ist nicht da");
/*N*/ 	if (pWin)
/*N*/ 		pWin->Show(bShow);
/*N*/ }

/*N*/ void ScTabView::UpdateShow()
/*N*/ {
/*N*/ 	BOOL bHScrollMode = aViewData.IsHScrollMode();
/*N*/ 	BOOL bVScrollMode = aViewData.IsVScrollMode();
/*N*/ 	BOOL bTabMode	  = aViewData.IsTabMode();
/*N*/ 	BOOL bOutlMode	  = aViewData.IsOutlineMode();
/*N*/ 	BOOL bHOutline	  = bOutlMode && lcl_HasColOutline(aViewData);
/*N*/ 	BOOL bVOutline	  = bOutlMode && lcl_HasRowOutline(aViewData);
/*N*/ 	BOOL bHeader	  = aViewData.IsHeaderMode();
/*N*/ 
/*N*/ 	BOOL bShowH = ( aViewData.GetHSplitMode() != SC_SPLIT_NONE );
/*N*/ 	BOOL bShowV = ( aViewData.GetVSplitMode() != SC_SPLIT_NONE );
/*N*/ 
/*N*/ 	//	Scrollbar-Einstellungen koennen vom Sfx ueberschrieben werden:
/*N*/ 	SfxScrollingMode eMode = aViewData.GetViewShell()->GetScrollingMode();
/*N*/ 	if ( eMode == SCROLLING_NO )
/*?*/ 		bHScrollMode = bVScrollMode = FALSE;
/*N*/ 	else if ( eMode == SCROLLING_YES || eMode == SCROLLING_AUTO )	//! Auto ???
/*?*/ 		bHScrollMode = bVScrollMode = TRUE;
/*N*/ 
/*N*/ 	if ( aViewData.GetDocShell()->IsPreview() )
/*?*/ 		bHScrollMode = bVScrollMode = bTabMode = bHeader = bOutlMode = bHOutline = bVOutline = FALSE;
/*N*/ 
/*N*/ 		//
/*N*/ 		//	Windows anlegen
/*N*/ 		//
/*N*/ 
/*N*/ 	if (bShowH && !pGridWin[SC_SPLIT_BOTTOMRIGHT])
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pGridWin[SC_SPLIT_BOTTOMRIGHT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_BOTTOMRIGHT );
/*N*/ 	}
/*N*/ 	if (bShowV && !pGridWin[SC_SPLIT_TOPLEFT])
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pGridWin[SC_SPLIT_TOPLEFT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_TOPLEFT );
/*N*/ 	}
/*N*/ 	if (bShowH && bShowV && !pGridWin[SC_SPLIT_TOPRIGHT])
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pGridWin[SC_SPLIT_TOPRIGHT] = new ScGridWindow( pFrameWin, &aViewData, SC_SPLIT_TOPRIGHT );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHOutline && !pColOutline[SC_SPLIT_LEFT])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pColOutline[SC_SPLIT_LEFT] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_HOR, &aViewData, SC_SPLIT_BOTTOMLEFT );
/*N*/ 	if (bShowH && bHOutline && !pColOutline[SC_SPLIT_RIGHT])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pColOutline[SC_SPLIT_RIGHT] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_HOR, &aViewData, SC_SPLIT_BOTTOMRIGHT );
/*N*/ 
/*N*/ 	if (bVOutline && !pRowOutline[SC_SPLIT_BOTTOM])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pRowOutline[SC_SPLIT_BOTTOM] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_VER, &aViewData, SC_SPLIT_BOTTOMLEFT );
/*N*/ 	if (bShowV && bVOutline && !pRowOutline[SC_SPLIT_TOP])
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pRowOutline[SC_SPLIT_TOP] = new ScOutlineWindow( pFrameWin, SC_OUTLINE_VER, &aViewData, SC_SPLIT_TOPLEFT );
/*N*/ 
/*N*/ 	if (bShowH && bHeader && !pColBar[SC_SPLIT_RIGHT])
/*N*/ 		pColBar[SC_SPLIT_RIGHT] = new ScColBar( pFrameWin, &aViewData, SC_SPLIT_RIGHT,
/*N*/ 												&aHdrFunc, pHdrSelEng );
/*N*/ 	if (bShowV && bHeader && !pRowBar[SC_SPLIT_TOP])
/*N*/ 		pRowBar[SC_SPLIT_TOP] = new ScRowBar( pFrameWin, &aViewData, SC_SPLIT_TOP,
/*N*/ 												&aHdrFunc, pHdrSelEng );
/*N*/ 
/*N*/ 		//
/*N*/ 		//	Windows anzeigen
/*N*/ 		//
/*N*/ 
/*N*/ 	ShowHide( &aHScrollLeft, bHScrollMode );
/*N*/ 	ShowHide( &aHScrollRight, bShowH && bHScrollMode );
/*N*/ 	ShowHide( &aVScrollBottom, bVScrollMode );
/*N*/ 	ShowHide( &aVScrollTop, bShowV && bVScrollMode );
/*N*/ 	ShowHide( &aScrollBarBox, bVScrollMode || bHScrollMode );
/*N*/ 
/*N*/ 	ShowHide( pHSplitter, bHScrollMode || bShowH );			// immer angelegt
/*N*/ 	ShowHide( pVSplitter, bVScrollMode || bShowV );
/*N*/ 	ShowHide( pTabControl, bTabMode );
/*N*/ 
/*N*/ 													// ab hier dynamisch angelegte
/*N*/ 
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_BOTTOMRIGHT], bShowH );
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_TOPLEFT], bShowV );
/*N*/ 	ShowHide( pGridWin[SC_SPLIT_TOPRIGHT], bShowH && bShowV );
/*N*/ 
/*N*/ 	ShowHide( pColOutline[SC_SPLIT_LEFT], bHOutline );
/*N*/ 	ShowHide( pColOutline[SC_SPLIT_RIGHT], bShowH && bHOutline );
/*N*/ 
/*N*/ 	ShowHide( pRowOutline[SC_SPLIT_BOTTOM], bVOutline );
/*N*/ 	ShowHide( pRowOutline[SC_SPLIT_TOP], bShowV && bVOutline );
/*N*/ 
/*N*/ 	ShowHide( pColBar[SC_SPLIT_RIGHT], bShowH && bHeader );
/*N*/ 	ShowHide( pRowBar[SC_SPLIT_TOP], bShowV && bHeader );
/*N*/ 
/*N*/ 
/*N*/ 	//!	neue Gridwindows eintragen
/*N*/ }

// ---  Splitter  --------------------------------------------------------

IMPL_LINK( ScTabView, SplitHdl, Splitter*, pSplitter )
{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
	return 0;
}





/*N*/ USHORT ScTabView::GetLockedModifiers() const
/*N*/ {
/*N*/ 	return pSelEngine->GetLockedModifiers();
/*N*/ }




/*N*/ void ScTabView::FreezeSplitters( BOOL bFreeze )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void ScTabView::RemoveSplit()
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DoHSplit( 0 );
/*N*/ }


/*N*/ void ScTabView::SplitAtPixel( const Point& rPixel, BOOL bHor, BOOL bVer )		// fuer API
/*N*/ {
/*N*/ 	//	Pixel ist auf die ganze View bezogen, nicht auf das erste GridWin
/*N*/ 
/*N*/ 	if (bHor)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 	if (bVer)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ 	RepeatResize();
/*N*/ }

/*N*/ void ScTabView::InvalidateSplit()
/*N*/ {
/*N*/ 	SfxBindings& rBindings = aViewData.GetBindings();
/*N*/ 	rBindings.Invalidate( SID_WINDOW_SPLIT );
/*N*/ 	rBindings.Invalidate( SID_WINDOW_FIX );
/*N*/ 
/*N*/ 	pHSplitter->SetFixed( aViewData.GetHSplitMode() == SC_SPLIT_FIX );
/*N*/ 	pVSplitter->SetFixed( aViewData.GetVSplitMode() == SC_SPLIT_FIX );
/*N*/ }

/*N*/ void ScTabView::SetNewVisArea()
/*N*/ {
/*N*/ 	//	#63854# fuer die Controls muss bei VisAreaChanged der Draw-MapMode eingestellt sein
/*N*/ 	//	(auch wenn ansonsten der Edit-MapMode gesetzt ist)
/*N*/ 	MapMode aOldMode[4];
/*N*/ 	MapMode aDrawMode[4];
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 		{
/*N*/ 			aOldMode[i] = pGridWin[i]->GetMapMode();
/*N*/ 			aDrawMode[i] = pGridWin[i]->GetDrawMapMode();
/*N*/ 			if (aDrawMode[i] != aOldMode[i])
/*?*/ 				pGridWin[i]->SetMapMode(aDrawMode[i]);
/*N*/ 		}
/*N*/ 
/*N*/ 	Window* pActive = pGridWin[aViewData.GetActivePart()];
/*N*/ 	if (pActive)
/*N*/ 		aViewData.GetViewShell()->VisAreaChanged(
/*N*/ 			pActive->PixelToLogic(Rectangle(Point(),pActive->GetOutputSizePixel())) );
/*N*/ 	if (pDrawView)
/*N*/ 		pDrawView->VisAreaChanged();	// kein Window uebergeben -> alle Fenster
/*N*/ 
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && aDrawMode[i] != aOldMode[i])
/*?*/ 			pGridWin[i]->SetMapMode(aOldMode[i]);
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = aViewData.GetViewShell()->GetViewFrame();
/*N*/ 	if (pViewFrame)
/*N*/ 	{
/*N*/ 		SfxFrame* pFrame = pViewFrame->GetFrame();
/*N*/ 		if (pFrame)
/*N*/ 		{
/*N*/ 			::com::sun::star::uno::Reference< ::com::sun::star::frame::XController> xController = pFrame->GetController();
/*N*/ 			if (xController.is())
/*N*/ 			{
/*?*/ 				ScTabViewObj* pImp = ScTabViewObj::getImplementation( xController );
/*?*/ 				if (pImp)
/*?*/ 					pImp->VisAreaChanged();
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if (aViewData.GetViewShell()->HasAccessibilityObjects())
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_VISAREACHANGED));
/*N*/ }





}
