/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview2.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 17:07:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#define ITEMID_FIELD EE_FEATURE_FIELD

#include <bf_sfx2/childwin.hxx>

#include "tabvwsh.hxx"
#include "docsh.hxx"
#include "gridwin.hxx"
#include "bf_sc.hrc"
#include "colrowba.hxx"
#include "globstr.hrc"
namespace binfilter {

#define SC_BLOCKMODE_NONE		0
#define SC_BLOCKMODE_NORMAL		1
#define SC_BLOCKMODE_OWN		2



//
//          Markier - Funktionen
//



/*N*/ void ScTabView::InitOwnBlockMode()
/*N*/ {
/*N*/ 	if (!bIsBlockMode)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	}
/*N*/ }


/*N*/ void ScTabView::DoneBlockMode( BOOL bContinue )            // Default FALSE
/*N*/ {
/*N*/ 	//	Wenn zwischen Tabellen- und Header SelectionEngine gewechselt wird,
/*N*/ 	//	wird evtl. DeselectAll gerufen, weil die andere Engine keinen Anker hat.
/*N*/ 	//	Mit bMoveIsShift wird verhindert, dass dann die Selektion aufgehoben wird.
/*N*/ 
/*N*/ 	if (bIsBlockMode && !bMoveIsShift)
/*N*/ 	{
/*N*/ 		ScMarkData& rMark = aViewData.GetMarkData();
/*N*/ 		BOOL bFlag = rMark.GetMarkingFlag();
/*N*/ 		rMark.SetMarking(FALSE);
/*N*/ 
/*N*/ 		if (bBlockNeg && !bContinue)
/*N*/ 			rMark.MarkToMulti();
/*N*/ 
/*N*/ 		if (bContinue)
/*N*/ 			rMark.MarkToMulti();
/*N*/ 		else
/*N*/ 		{
/*N*/ 			//	Die Tabelle kann an dieser Stelle ungueltig sein, weil DoneBlockMode
/*N*/ 			//	aus SetTabNo aufgerufen wird
/*N*/ 			//	(z.B. wenn die aktuelle Tabelle von einer anderen View aus geloescht wird)
/*N*/ 
/*N*/ 			USHORT nTab = aViewData.GetTabNo();
/*N*/ 			ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 			if ( pDoc->HasTable(nTab) )
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 				PaintBlock( TRUE );								// TRUE -> Block loeschen
/*N*/ 			else
/*N*/ 				rMark.ResetMark();
/*N*/ 		}
/*N*/ //		bIsBlockMode = FALSE;
/*N*/ 		bIsBlockMode = SC_BLOCKMODE_NONE;			//! Variable umbenennen!
/*N*/ 
/*N*/ 		rMark.SetMarking(bFlag);
/*N*/ 		rMark.SetMarkNegative(FALSE);
/*N*/ 	}
/*N*/ }


//!
//!	PaintBlock in zwei Methoden aufteilen: RepaintBlock und RemoveBlock o.ae.
//!






//	wird z.B. gerufen, wenn sich das View-Fenster verschiebt:

/*N*/ void ScTabView::StopMarking()
/*N*/ {
/*N*/ 	ScSplitPos eActive = aViewData.GetActivePart();
/*N*/ 	if (pGridWin[eActive])
/*N*/ 		pGridWin[eActive]->StopMarking();
/*N*/ 
/*N*/ 	ScHSplitPos eH = WhichH(eActive);
/*N*/ 	if (pColBar[eH])
/*N*/ 		pColBar[eH]->StopMarking();
/*N*/ 
/*N*/ 	ScVSplitPos eV = WhichV(eActive);
/*N*/ 	if (pRowBar[eV])
/*N*/ 		pRowBar[eV]->StopMarking();
/*N*/ }

/*N*/ void ScTabView::HideNoteMarker()
/*N*/ {
/*N*/ 	for (USHORT i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && pGridWin[i]->IsVisible())
/*N*/ 			pGridWin[i]->HideNoteMarker();
/*N*/ }


/*N*/ void ScTabView::ErrorMessage( USHORT nGlobStrId )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 StopMarking();		// falls per Focus aus MouseButtonDown aufgerufen
/*?*/ 
/*N*/ }





}
