/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsha.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:17:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#define _ZFORLIST_DECLARE_TABLE
#include "scitems.hxx"
#include <svtools/slstitm.hxx>
#include <svtools/stritem.hxx>
#include <svtools/whiter.hxx>
#include <svtools/zformat.hxx>
#include <bf_sfx2/dispatch.hxx>

#include "attrib.hxx"
#include "patattr.hxx"
#include "cell.hxx"             // Input Status Edit-Zellen
#include "globstr.hrc"
#include "scmod.hxx"
#include "inputhdl.hxx"
#include "inputwin.hxx"
#include "docsh.hxx"
#include "appoptio.hxx"
#include "bf_sc.hrc"
#include "stlpool.hxx"
#include "tabvwsh.hxx"
#include "dwfunctr.hxx"

#ifndef _SFX_SRCHDEFS_HXX_
#include <bf_sfx2/srchdefs.hxx>
#endif

namespace binfilter {



/*N*/ BOOL ScTabViewShell::GetFunction( String& rFuncStr )
/*N*/ {
/*N*/ 	String aStr;
/*N*/ 
/*N*/ 	ScSubTotalFunc eFunc = (ScSubTotalFunc) SC_MOD()->GetAppOptions().GetStatusFunc();
/*N*/ 
/*N*/ 	USHORT nGlobStrId = 0;
/*N*/ 	switch (eFunc)
/*N*/ 	{
/*N*/ 		case SUBTOTAL_FUNC_AVE:	 nGlobStrId = STR_FUN_TEXT_AVG; break;
/*N*/ 		case SUBTOTAL_FUNC_CNT:	 nGlobStrId = STR_FUN_TEXT_COUNT; break;
/*N*/ 		case SUBTOTAL_FUNC_CNT2: nGlobStrId = STR_FUN_TEXT_COUNT2; break;
/*N*/ 		case SUBTOTAL_FUNC_MAX:	 nGlobStrId = STR_FUN_TEXT_MAX; break;
/*N*/ 		case SUBTOTAL_FUNC_MIN:	 nGlobStrId = STR_FUN_TEXT_MIN; break;
/*N*/ 		case SUBTOTAL_FUNC_SUM:	 nGlobStrId = STR_FUN_TEXT_SUM; break;
/*N*/ 	}
/*N*/ 	if (nGlobStrId)
/*N*/ 	{
/*N*/ 		ScViewData* pViewData	= GetViewData();
/*N*/ 		ScDocument* pDoc		= pViewData->GetDocument();
/*N*/ 		ScMarkData& rMark		= pViewData->GetMarkData();
/*N*/ 		USHORT		nPosX		= pViewData->GetCurX();
/*N*/ 		USHORT		nPosY		= pViewData->GetCurY();
/*N*/ 		USHORT		nTab		= pViewData->GetTabNo();
/*N*/ 
/*N*/ 		aStr = ScGlobal::GetRscString(nGlobStrId);
/*N*/ 		aStr += '=';
/*N*/ 
/*N*/ 		//	Anzahl im Standardformat, die anderen nach Cursorposition
/*N*/ 		sal_uInt32 nNumFmt = 0;
/*N*/ 		SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*N*/ 		if ( eFunc != SUBTOTAL_FUNC_CNT && eFunc != SUBTOTAL_FUNC_CNT2 )
/*N*/ 		{
/*N*/ 			//	Zahlformat aus Attributen oder Formel
/*N*/ 			pDoc->GetNumberFormat( nPosX, nPosY, nTab, nNumFmt );
/*N*/ 			if ( (nNumFmt % SV_COUNTRY_LANGUAGE_OFFSET) == 0 )
/*N*/ 			{
/*N*/ 				ScBaseCell* pCell;
/*N*/ 				pDoc->GetCell( nPosX, nPosY, nTab, pCell );
/*N*/ 				if (pCell && pCell->GetCellType() == CELLTYPE_FORMULA)
/*?*/ 					nNumFmt = ((ScFormulaCell*)pCell)->GetStandardFormat(
/*?*/ 						*pFormatter, nNumFmt );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		ScAddress aCursor( nPosX, nPosY, nTab );
/*N*/ 		double nVal;
/*N*/ 		if ( pDoc->GetSelectionFunction( eFunc, aCursor, rMark, nVal ) )
/*N*/ 		{
/*N*/ 			String aValStr;
/*N*/ 			Color* pDummy;
/*N*/ 			pFormatter->GetOutputString( nVal, nNumFmt, aValStr, &pDummy );
/*N*/ 			aStr += aValStr;
/*N*/ 		}
/*N*/ 
/*N*/ 		rFuncStr = aStr;
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }



//	Funktionen, die je nach Selektion disabled sind
//	Default:
//		SID_DELETE,
//		SID_DELETE_CONTENTS,
//		FID_DELETE_CELL
//		FID_VALIDATION


/*N*/ void __EXPORT ScTabViewShell::GetState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocument* pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark		= pViewData->GetMarkData();
/*N*/ 	USHORT		nPosX		= pViewData->GetCurX();
/*N*/ 	USHORT		nPosY		= pViewData->GetCurY();
/*N*/ 	USHORT		nTab		= pViewData->GetTabNo();
/*N*/ 	USHORT		nMyId		= 0;
/*N*/ 
/*N*/ 	SfxViewFrame* pThisFrame = GetViewFrame();
/*N*/ 	BOOL bOle = pThisFrame->ISA(SfxInPlaceFrame);
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	USHORT nTabSelCount = rMark.GetSelectCount();
/*N*/ 
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*?*/ 			case FID_CHG_COMMENT:
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_DELETE_PRINTAREA:
/*N*/ 				if ( nTabSelCount > 1 )
/*N*/ 				{
/*?*/ 					BOOL bHas = FALSE;
/*?*/ 					for (USHORT i=0; i<nTabCount; i++)
/*?*/ 						if (rMark.GetTableSelect(i) && pDoc->GetPrintRangeCount(i) )
/*?*/ 							bHas = TRUE;
/*?*/ 					if (!bHas)
/*?*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				else if ( !pDoc->GetPrintRangeCount( nTab ) )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_STATUS_PAGESTYLE:
/*N*/ 			case SID_HFEDIT:
/*N*/ 				GetViewData()->GetDocShell()->GetStatePageStyle( *this, rSet, nTab );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_SEARCH_ITEM:
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 rSet.Put( ScGlobal::GetSearchItem() );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_SEARCH_OPTIONS:
/*?*/ 				{
/*?*/ 					USHORT nOptions = 0xffff;		// alles erlaubt
/*?*/ 													// wenn ReadOnly, kein Ersetzen:
/*?*/ 					if (GetViewData()->GetDocShell()->IsReadOnly())
/*?*/ 						nOptions &= ~( SEARCH_OPTIONS_REPLACE | SEARCH_OPTIONS_REPLACE_ALL );
/*?*/ 					rSet.Put( SfxUInt16Item( nWhich, nOptions ) );
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_CURRENTCELL:
/*N*/ 				{
/*N*/ 					ScAddress aScAddress( GetViewData()->GetCurX(), GetViewData()->GetCurY(), 0 );
/*N*/ 					String	aAddr;
/*N*/ 					aScAddress.Format( aAddr, SCA_ABS );
/*N*/ 					SfxStringItem	aPosItem( SID_CURRENTCELL, aAddr );
/*N*/ 
/*N*/ 					rSet.Put( aPosItem );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_CURRENTTAB:
/*N*/ 				//	Tabelle fuer Basic ist 1-basiert
/*N*/ 				rSet.Put( SfxUInt16Item( nWhich, GetViewData()->GetTabNo() + 1 ) );
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SID_CURRENTDOC:
/*N*/ 				rSet.Put( SfxStringItem( nWhich, GetViewData()->GetDocShell()->GetTitle() ) );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_TOGGLEINPUTLINE:
/*?*/ 				{
/*?*/ 					USHORT nId = ScInputWindowWrapper::GetChildWindowId();
/*?*/ 
/*?*/ 					if ( pThisFrame->KnowsChildWindow( nId ) )
/*?*/ 					{
/*?*/ 						SfxChildWindow* pWnd = pThisFrame->GetChildWindow( nId );
/*?*/ 						rSet.Put( SfxBoolItem( nWhich, pWnd ? TRUE : FALSE ) );
/*?*/ 					}
/*?*/ 					else
/*?*/ 						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_DEL_MANUALBREAKS:
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (!pDoc->HasManualBreaks(nTab))
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_RESET_PRINTZOOM:
/*?*/ 				{
/*?*/ 					//	disablen, wenn schon Default eingestellt
/*?*/ 
/*?*/ 					ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*?*/ 					ScDocument* pDoc = pDocSh->GetDocument();
/*?*/ 					USHORT nTab = GetViewData()->GetTabNo();
/*?*/ 					String aStyleName = pDoc->GetPageStyle( nTab );
/*?*/ 					ScStyleSheetPool* pStylePool = pDoc->GetStyleSheetPool();
/*?*/ 					SfxStyleSheetBase* pStyleSheet = pStylePool->Find( aStyleName,
/*?*/ 													SFX_STYLE_FAMILY_PAGE );
/*?*/ 					DBG_ASSERT( pStyleSheet, "PageStyle not found" );
/*?*/ 					if ( pStyleSheet )
/*?*/ 					{
/*?*/ 						SfxItemSet& rStyleSet = pStyleSheet->GetItemSet();
/*?*/ 						USHORT nScale = ((const SfxUInt16Item&)
/*?*/ 											rStyleSet.Get(ATTR_PAGE_SCALE)).GetValue();
/*?*/ 						USHORT nPages = ((const SfxUInt16Item&)
/*?*/ 											rStyleSet.Get(ATTR_PAGE_SCALETOPAGES)).GetValue();
/*?*/ 						if ( nScale == 100 && nPages == 0 )
/*?*/ 							rSet.DisableItem( nWhich );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case FID_SCALE:
/*N*/ 			case SID_ATTR_ZOOM:
/*N*/ 				if ( bOle )
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					const Fraction& rOldY = GetViewData()->GetZoomY();
/*N*/ 					USHORT nZoom = (USHORT)(( rOldY.GetNumerator() * 100 )
/*N*/ 												/ rOldY.GetDenominator());
/*N*/ 					rSet.Put( SvxZoomItem( SVX_ZOOM_PERCENT, nZoom, nWhich ) );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_TOGGLESYNTAX:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich, GetViewData()->IsSyntaxMode()));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_TOGGLEHEADERS:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich, GetViewData()->IsHeaderMode()));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_PAGEBREAKMODE:
/*?*/ 				if ( bOle )
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				else
/*?*/ 					rSet.Put(SfxBoolItem(nWhich, GetViewData()->IsPagebreakMode()));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_FUNCTION_BOX:
/*?*/ 				nMyId = ScFunctionChildWindow::GetChildWindowId();
/*?*/ 				rSet.Put(SfxBoolItem(FID_FUNCTION_BOX, pThisFrame->HasChildWindow(nMyId)));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_PROTECT_DOC:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich, pDoc->IsDocProtected()));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_PROTECT_TABLE:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich, pDoc->IsTabProtected(nTab)));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_AUTO_OUTLINE:
/*M*/ 				{
/*M*/ 					if (pDoc->GetChangeTrack()!=NULL || GetViewData()->IsMultiMarked())
/*M*/ 					{
/*M*/ 						rSet.DisableItem( nWhich );
/*M*/ 					}
/*M*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_OUTLINE_DELETEALL:
/*?*/ 				{
/*?*/ 					ScDocument* pDoc = GetViewData()->GetDocument();
/*?*/ 					USHORT nOlTab = GetViewData()->GetTabNo();
/*?*/ 					ScOutlineTable* pOlTable = pDoc->GetOutlineTable( nOlTab );
/*?*/ 					if (pOlTable == NULL)
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_WINDOW_SPLIT:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich,
/*?*/ 							pViewData->GetHSplitMode() == SC_SPLIT_NORMAL ||
/*?*/ 							pViewData->GetVSplitMode() == SC_SPLIT_NORMAL ));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_WINDOW_FIX:
/*?*/ 				rSet.Put(SfxBoolItem(nWhich,
/*?*/ 							pViewData->GetHSplitMode() == SC_SPLIT_FIX ||
/*?*/ 							pViewData->GetVSplitMode() == SC_SPLIT_FIX ));
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_CHG_SHOW:
/*?*/ 				{
/*?*/ 					if(pDoc->GetChangeTrack()==NULL)
/*?*/ 								rSet.DisableItem( nWhich);
/*?*/ 				}
/*?*/ 				break;
/*?*/ 			case FID_CHG_ACCEPT:
/*?*/ 				{
/*?*/ 					rSet.Put(SfxBoolItem(FID_CHG_ACCEPT,
/*?*/ 							pThisFrame->HasChildWindow(FID_CHG_ACCEPT)));
/*?*/ 					if(pDoc->GetChangeTrack()==NULL)
/*?*/ 					{
/*?*/ 						if ( !pThisFrame->HasChildWindow(FID_CHG_ACCEPT) )
/*?*/ 						{
/*?*/ 							rSet.DisableItem( nWhich);
/*?*/ 						}
/*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*N*/ 
/*N*/ 			case SID_FORMATPAGE:
/*N*/ 				//!	bei geschuetzten Tabellen ???
/*N*/ 				if (GetViewData()->GetDocShell()->IsReadOnly())
/*?*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case SID_PRINTPREVIEW:
/*?*/ 				// #58924# Toggle-Slot braucht einen State
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, FALSE ) );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_READONLY_MODE:
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, GetViewData()->GetDocShell()->IsReadOnly() ) );
/*?*/ 				break;
/*?*/ 
/*N*/ 		} // switch ( nWitch )
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	} // while ( nWitch )
/*N*/ }

//------------------------------------------------------------------

//------------------------------------------------------------------

//------------------------------------------------------------------

/*N*/ void ScTabViewShell::UpdateInputHandler( BOOL bForce /* = FALSE */, BOOL bStopEditing /* = TRUE */ )
/*N*/ {
/*N*/ 	ScInputHandler* pHdl = pInputHandler ? pInputHandler : SC_MOD()->GetInputHdl();
/*N*/ 
/*N*/ 	if ( pHdl )
/*N*/ 	{
/*N*/ 		String					aString;
/*N*/ 		const EditTextObject*	pObject 	= NULL;
/*N*/ 		ScViewData*				pViewData	= GetViewData();
/*N*/ 		ScDocument*				pDoc		= pViewData->GetDocument();
/*N*/ 		CellType				eType;
/*N*/ 		USHORT					nPosX		= pViewData->GetCurX();
/*N*/ 		USHORT					nPosY		= pViewData->GetCurY();
/*N*/ 		USHORT					nTab		= pViewData->GetTabNo();
/*N*/ 		USHORT					nStartTab	= 0;
/*N*/ 		USHORT					nEndTab 	= 0;
/*N*/ 		USHORT					nStartCol	= 0;
/*N*/ 		USHORT					nStartRow	= 0;
/*N*/ 		USHORT					nEndCol 	= 0;
/*N*/ 		USHORT					nEndRow 	= 0;
/*N*/ 
/*N*/ 		pViewData->GetSimpleArea( nStartCol, nStartRow, nStartTab,
/*N*/ 								  nEndCol,   nEndRow,   nEndTab );
/*N*/ 
/*N*/ 		PutInOrder( nStartCol, nEndCol );
/*N*/ 		PutInOrder( nStartRow, nEndRow );
/*N*/ 		PutInOrder( nStartTab, nEndTab );
/*N*/ 
/*N*/ 		BOOL bHideFormula = FALSE;
/*N*/ 		BOOL bHideAll	  = FALSE;
/*N*/ 
/*N*/ 		if (pDoc->IsTabProtected(nTab))
/*N*/ 		{
/*N*/ 			const ScProtectionAttr* pProt = (const ScProtectionAttr*)
/*N*/ 											pDoc->GetAttr( nPosX,nPosY,nTab,
/*N*/ 														   ATTR_PROTECTION);
/*?*/ 			bHideFormula = pProt->GetHideFormula();
/*?*/ 			bHideAll	 = pProt->GetHideCell();
/*N*/ 		}
/*N*/ 
/*N*/ 		if (!bHideAll)
/*N*/ 		{
/*N*/ 			pDoc->GetCellType( nPosX, nPosY, nTab, eType );
/*N*/ 			if (eType == CELLTYPE_FORMULA)
/*N*/ 			{
/*N*/ 				if (!bHideFormula)
/*N*/ 					pDoc->GetFormula( nPosX, nPosY, nTab, aString );
/*N*/ 			}
/*N*/ 			else if (eType == CELLTYPE_EDIT)
/*N*/ 			{
/*?*/ 				ScBaseCell* pCell;
/*?*/ 				pDoc->GetCell( nPosX, nPosY, nTab, pCell );
/*?*/ 				((ScEditCell*)pCell)->GetData( pObject );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				pDoc->GetInputString( nPosX, nPosY, nTab, aString );
/*N*/ 				if (eType == CELLTYPE_STRING)
/*N*/ 				{
/*N*/ 					//	Bei Bedarf ein ' vorneweg, damit der String nicht ungewollt
/*N*/ 					//	als Zahl interpretiert wird, und um dem Benutzer zu zeigen,
/*N*/ 					//	dass es ein String ist (#35060#).
/*N*/ 					//!	Auch bei Zahlformat "Text"? -> dann beim Editieren wegnehmen
/*N*/ 
/*?*/ 					SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*?*/ 					sal_uInt32 nNumFmt;
/*?*/ 					pDoc->GetNumberFormat( nPosX, nPosY, nTab, nNumFmt );
/*?*/ 					double fDummy;
/*?*/ 					if ( pFormatter->IsNumberFormat(aString, nNumFmt, fDummy) )
/*?*/ 						aString.Insert('\'',0);
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		ScInputHdlState	aState( ScAddress( nPosX,	  nPosY, 	 nTab ),
/*N*/ 								ScAddress( nStartCol, nStartRow, nTab ),
/*N*/ 								ScAddress( nEndCol,	  nEndRow,   nTab ),
/*N*/ 								aString,
/*N*/ 								pObject );
/*N*/ 
/*N*/ 		//	if using the view's local input handler, this view can always be set
/*N*/ 		//	as current view inside NotifyChange.
/*N*/ 		ScTabViewShell* pSourceSh = pInputHandler ? this : NULL;
/*N*/ 
/*N*/ 		pHdl->NotifyChange( &aState, bForce, pSourceSh, bStopEditing );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*N*/ 	rBindings.Invalidate( SID_STATUS_SUM );			// immer zusammen mit Eingabezeile
/*N*/ 	rBindings.Invalidate( SID_ATTR_SIZE );
/*N*/ }

//------------------------------------------------------------------


/*N*/ void __EXPORT ScTabViewShell::GetSaveState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	SfxShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	while( nWhich )
/*N*/ 	{
/*N*/ 		// Status von der DocShell holen
/*N*/ 		pDocSh->GetSlotState( nWhich, NULL, &rSet );
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------


/*N*/ void ScTabViewShell::GetUndoState(SfxItemSet &rSet)
/*N*/ {
/*N*/     SfxShell* pSh = GetViewData()->GetDispatcher().GetShell(0);
/*N*/     SfxUndoManager* pUndoMgr = pSh->GetUndoManager();
/*N*/ 
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch (nWhich)
/*N*/ 		{
/*?*/ 			case SID_GETUNDOSTRINGS:
/*?*/ 			case SID_GETREDOSTRINGS:
/*?*/ 				{
/*?*/ 					SfxStringListItem aStrLst( nWhich );
/*?*/ 					if ( pUndoMgr )
/*?*/ 					{
/*?*/ 						List* pList = aStrLst.GetList();
/*?*/ 						BOOL bIsUndo = ( nWhich == SID_GETUNDOSTRINGS );
/*?*/ 						USHORT nCount = bIsUndo ? pUndoMgr->GetUndoActionCount() : pUndoMgr->GetRedoActionCount();
/*?*/ 						for (USHORT i=0; i<nCount; i++)
/*?*/ 							pList->Insert( new String( bIsUndo ? pUndoMgr->GetUndoActionComment(i) :
/*?*/ 															     pUndoMgr->GetRedoActionComment(i) ),
/*?*/ 										   LIST_APPEND );
/*?*/ 					}
/*?*/ 					rSet.Put( aStrLst );
/*?*/ 				}
/*?*/ 				break;
/*N*/ 			default:
/*N*/ 				// get state from sfx view frame
/*N*/ 				GetViewFrame()->GetSlotState( nWhich, NULL, &rSet );
/*N*/ 		}
/*N*/ 
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }


//------------------------------------------------------------------






}
