/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fupoor.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:47:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS

#ifndef _SV_SELENG_HXX //autogen
#include <vcl/seleng.hxx>
#endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif


#pragma hdrstop

// Fuer SvxChooseControlEnum
//#define _BASIDESH_HXX
//#define _TBXCTL_HXX
//#include <basicsh.hxx>
//#include <svxids.hrc>

#include "schview.hxx"
#include "chwindow.hxx"
#include "fupoor.hxx"
namespace binfilter {



/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchFuPoor::SchFuPoor(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
/*N*/ 					 ChartModel* pDoc, SfxRequest& rReq) :
/*N*/ 	pViewShell(pViewSh),
/*N*/ 	pWindow(pWin),
/*N*/ 	pView(pView),
/*N*/ 	pChDoc(pDoc),
/*N*/ 	nSlotId(rReq.GetSlot()),
/*N*/ 	pDialog(NULL),
/*N*/ 	bIsInDragMode(FALSE),
/*N*/ 	bFirstMouseMove(FALSE)
/*N*/ {
/*N*/ 	nSlotValue   = 0;
/*N*/ 	pMarkedObj   = 0;
/*N*/ 	pMarkedObjId = 0;
/*N*/ 	nMarkedID    = 0;
/*N*/ 
/*N*/ 	const SfxItemSet* pSet = rReq.GetArgs();
/*N*/ 	if (pSet)
/*N*/ 	{
/*N*/ 		if (pSet->GetItemState(nSlotId) == SFX_ITEM_SET)
/*N*/ 		{
/*?*/ 			const SfxPoolItem& rItem = pSet->Get(nSlotId);
/*?*/ 			if( rItem.ISA(SfxAllEnumItem))
/*?*/ 				nSlotValue = ((const SfxAllEnumItem&)rItem).GetValue();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	aDragTimer.SetTimeoutHdl(LINK(this, SchFuPoor, DragHdl));
/*N*/ 	aDragTimer.SetTimeout(SELENG_DRAGDROP_TIMEOUT);
/*N*/ 
/*N*/ 	if (pView->GetMarkList().GetMarkCount() >= 1)
/*N*/ 	{
/*?*/ 		pMarkedObj   = pView->GetMarkList().GetMark(0)->GetObj();
/*?*/ 		pMarkedObjId = GetObjectId(*pMarkedObj);
/*?*/ 		if (pMarkedObjId) nMarkedID = pMarkedObjId->GetObjId();
/*?*/ 
/*?*/ 		if (nMarkedID == CHOBJID_DIAGRAM) nMarkedID = CHOBJID_DIAGRAM_WALL;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuPoor::~SchFuPoor()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 
/*N*/ 	delete pDialog;
/*N*/ }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuPoor::Activate()
/*N*/ {
/*N*/ 	if (pDialog)
/*?*/ 		pDialog->Show();
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void SchFuPoor::Deactivate()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 
/*N*/ 	if (pDialog)
/*?*/ 		pDialog->Hide();
/*N*/ 
/*N*/ 	if (pWindow)
/*N*/ 		pWindow->ReleaseMouse();
/*N*/ }

//	SFX_APP()->SetHelpText(aStr);


/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/


/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/


/*************************************************************************
|*
|* Timer-Handler fuer Drag&Drop
|*
\************************************************************************/

/*N*/ IMPL_LINK( SchFuPoor, DragHdl, Timer *, pTimer )
/*N*/ {
/*N*/ 	return 0;
/*N*/ }

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Handler fuer Mausbewegung
|*
\************************************************************************/


/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/


/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/


/*************************************************************************
|*
|* Alle 3DCubes einzeln selektieren:
|*
\************************************************************************/

}
