/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_chwindow.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:00:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop



#ifndef _ZFORLIST_HXX //autogen wg. SvNumberFormatter
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#endif

#include "chwindow.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "schhids.h"

#include "strings.hrc"		// for QuickHelp Strings
#include "glob.hrc"

namespace binfilter {

#define QUICK_HELP_TOLERANCE	  2		// in pixels

/************************************************************************/

#define MIN_ZOOM	10
#define MAX_ZOOM	650


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SchWindow::SchWindow( Window* pParent ) :
/*N*/ 		DropTargetHelper( pParent ),
/*N*/ 		Window( pParent, WinBits( WB_CLIPCHILDREN )),
/*N*/ 		pViewShell( NULL ),
/*N*/ 		aWinPos( 0, 0 ),
/*N*/ 		aViewOrigin( 0,  0),
/*N*/ 		aViewSize( 1000, 1000 )
/*N*/ {
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	aMap.SetMapUnit(MAP_100TH_MM);
/*N*/ 	SetMapMode(aMap);
/*N*/ 
/*N*/ 	Color aWhiteColor( COL_WHITE );
/*N*/ 	SetBackground ( aWhiteColor );
/*N*/ 
/*N*/ 	// adjust contrast mode initially
/*N*/ 	bool bUseContrast = GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/     SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
/*N*/ 
/*N*/ 	// Hilfe-ID setzen
/*N*/ 	SetHelpId( HID_SCH_WIN_DOCUMENT );
/*N*/ 	SetUniqueId( HID_SCH_WIN_DOCUMENT );
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchWindow::~SchWindow()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Die Haelfte des Sichtbaren Bereich eines anderen Fensters darstellen
|*
\************************************************************************/


/*************************************************************************
|*
|* Paint event
|*
\************************************************************************/


/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/


/*************************************************************************
|*
|* Command event
|*
\************************************************************************/


/*************************************************************************
|*
|* den eigentlichen Zoomfaktor in Prozent setzen; protected, wird
|* nur intern benutzt
|*
\************************************************************************/

/*N*/ long SchWindow::SetZoomFactor(long nZoom)
/*N*/ {
/*N*/ 	if (nZoom > MAX_ZOOM)
/*N*/ 		nZoom = MAX_ZOOM;
/*N*/ 	if (nZoom < MIN_ZOOM)
/*N*/ 		nZoom = MIN_ZOOM;
/*N*/ 
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	aMap.SetScaleX(Fraction(nZoom, 100));
/*N*/ 	aMap.SetScaleY(Fraction(nZoom, 100));
/*N*/ 	SetMapMode(aMap);
/*N*/ 	return nZoom;
/*N*/ }

/*************************************************************************
|*
|* Zoomfaktor in Prozent setzen und Darstellungsbereich um den
|* Zoom-Mittelpunkt zentrieren
|*
\************************************************************************/

/*N*/ void SchWindow::SetZoom(long nZoom)
/*N*/ {
/*N*/ 	if (nZoom > MAX_ZOOM)
/*N*/ 		nZoom = MAX_ZOOM;
/*N*/ 	if (nZoom < MIN_ZOOM)
/*N*/ 		nZoom = MIN_ZOOM;
/*N*/ 
/*N*/ 	Size aSize = PixelToLogic(GetSizePixel());
/*N*/ 	long nW = aSize.Width()  * GetZoom() / nZoom;
/*N*/ 	long nH = aSize.Height() * GetZoom() / nZoom;
/*N*/ 	aWinPos.X() += (aSize.Width()  - nW) / 2;
/*N*/ 	aWinPos.Y() += (aSize.Height() - nH) / 2;
/*N*/ 	SetZoomFactor(nZoom);
/*N*/ }

/*************************************************************************
|*
|* Fensterposition und Zoomfaktor nach uebergebenem Rechteck setzen
|* obere linke Ecke des Rechtecks muss relativ zur linken oberen
|* Ecke des Fensters angegeben werden; gibt den berechneten Zoom-
|* faktor zurueck
|*
\************************************************************************/


/*************************************************************************
|*
|* Neuen MapMode-Origin berechnen und setzen
|*
\************************************************************************/



/*************************************************************************
|*
|* DataChanged
|*
\************************************************************************/



// for quick help






// ========================================
// DropTargetHelper for drag and drop
// ========================================


// ----------------------------------------



// UNO stuff follows here

using namespace ::com::sun::star;
using namespace ::com::sun::star::accessibility;

// ____________ get accessibility object for document root node ____________


}
