/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sddll1.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:14:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <svtools/moduleoptions.hxx>

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "drtxtob.hxx"
#include "drbezob.hxx"
#include "drglueob.hxx"
#include "drgrfob.hxx"
#include "drstdob.hxx"
#include "grstdob.hxx"
#include "outlnvsh.hxx"
#include "slidvish.hxx"
#include "presvish.hxx"
#include "prvwshll.hxx"
#include "grviewsh.hxx"
#include "grdocsh.hxx"
#include "app.hrc"
namespace binfilter {



/*************************************************************************
|*
|* Register all Factorys
|*
\************************************************************************/


/*N*/ void SdDLL::RegisterFactorys()
/*N*/ {
/*N*/ 	if (SvtModuleOptions().IsImpress())
/*N*/ 	{
/*N*/ 		// Impress
/*N*/ 		SdDrawViewShell::RegisterFactory(1);
/*N*/ 		SdSlideViewShell::RegisterFactory(2);
/*N*/ 		SdOutlineViewShell::RegisterFactory(3);
/*N*/ 		SdPresViewShell::RegisterFactory(4);
/*N*/ 		SdPreviewViewShell::RegisterFactory(5);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (SvtModuleOptions().IsDraw()) {
/*N*/ 		// Draw
/*N*/ 		SdGraphicViewShell::RegisterFactory(1);
/*N*/ 
/*N*/         // #93468# Need preview view also for draw documents
/*N*/ 		SdPreviewViewShell::RegisterFactory(5);
/*N*/ 	}
/*N*/ }



/*************************************************************************
|*
|* Register all Interfaces
|*
\************************************************************************/


/*N*/ void SdDLL::RegisterInterfaces()
/*N*/ {
/*N*/ 	// Modul
/*N*/ 	SfxModule* pMod = SD_MOD();
/*N*/ 	SdModule::RegisterInterface(pMod);
/*N*/ 
/*N*/ 	// DocShells
/*N*/ 	SdDrawDocShell::RegisterInterface(pMod);
/*N*/ 	SdGraphicDocShell::RegisterInterface(pMod);
/*N*/ 
/*N*/ 	// Impress ViewShells
/*N*/ 	SdDrawViewShell::RegisterInterface(pMod);
/*N*/ 	SdSlideViewShell::RegisterInterface(pMod);
/*N*/ 	SdOutlineViewShell::RegisterInterface(pMod);
/*N*/ 	SdPresViewShell::RegisterInterface(pMod);
/*N*/ 	SdPreviewViewShell::RegisterInterface(pMod);
/*N*/ 
/*N*/ 	// Draw ViewShell
/*N*/ 	SdGraphicViewShell::RegisterInterface(pMod);
/*N*/ 
/*N*/ 	// Impress ObjectShells
/*N*/ 	SdDrawStdObjectBar::RegisterInterface(pMod);
/*N*/ 	SdDrawBezierObjectBar::RegisterInterface(pMod);
/*N*/ 	SdDrawGluePointsObjectBar::RegisterInterface(pMod);
/*N*/ 	SdDrawTextObjectBar::RegisterInterface(pMod);
/*N*/ 	SdDrawGrafObjectBar::RegisterInterface(pMod);
/*N*/ 
/*N*/ 	// Draw ObjectShell
/*N*/ 	SdGraphicStdObjectBar::RegisterInterface(pMod);
/*N*/ }
}
