/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fusel.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:21:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#include <bf_svx/svxids.hrc>

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#define ITEMID_FIELD	EE_FEATURE_FIELD

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

#include "fusel.hxx"
#include "sdview.hxx"
#include "drviewsh.hxx"

// #108981#
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( FuSelection, FuDraw );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ FuSelection::FuSelection(SdViewShell*	  pViewSh,
/*N*/ 						 SdWindow*		  pWin,
/*N*/ 						 SdView*		  pView,
/*N*/ 						 SdDrawDocument*  pDoc,
/*N*/ 						 SfxRequest&	  rReq) :
/*N*/ 	FuDraw(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	bTempRotation(FALSE),
/*N*/     bHideAndAnimate(FALSE),
/*N*/     bSelectionChanged(FALSE),
/*N*/     pHdl(NULL),
/*N*/     bSuppressChangesOfSelection(FALSE),
/*N*/     bMirrorSide0(FALSE),
/*N*/     nEditMode(SID_BEZIER_MOVE),
/*N*/     pSound(NULL),
/*N*/     pWaterCanCandidate(NULL)
/*N*/ {
/*N*/     // Objektbar auswaehlen
/*N*/     SelectionHasChanged();
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuSelection::~FuSelection()
/*N*/ {
/*N*/ 	HPUX_DTOR_BUG;
/*N*/     pView->UnmarkAllPoints();
/*N*/     pView->ShowMirrored();
/*N*/     pView->ResetCreationActive();
/*N*/     delete pSound;
/*N*/     pSound = NULL;

/*N*/ 	if ( pView->GetDragMode() != SDRDRAG_MOVE )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

        /******************************************************************
        * KEIN BEZIER_EDITOR
        ******************************************************************/
            /******************************************************************
            * Wenn 3D-Rotationskoerper erstellt werden sollen, jetzt
            * die Erstellung beenden
            ******************************************************************/
        /**********************************************************************
        * BEZIER-EDITOR
        **********************************************************************/
            /******************************************************************
            * Handle draggen
            ******************************************************************/
            /******************************************************************
            * Klebepunkt selektieren
            ******************************************************************/
            /******************************************************************
            * Objekt verschieben
            ******************************************************************/
            /******************************************************************
            * Klebepunkt selektieren
            ******************************************************************/
            /******************************************************************
            * Objekt selektieren oder draggen
            ******************************************************************/
                /**************************************************************
                * Klebepunkt selektieren
                **************************************************************/
                /**************************************************************
                * Objekt selektieren
                **************************************************************/

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

        /**********************************************************************
        * KEIN BEZIER_EDITOR
        **********************************************************************/
            /******************************************************************
            * Objekt wurde verschoben
            ******************************************************************/
                    /*********************************************************
                    * Wenn 3D-Rotationskoerper erstellt werden sollen, jetzt
                    * die Erstellung beenden
                    **********************************************************/
        /**********************************************************************
        * BEZIER_EDITOR
        **********************************************************************/

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/



/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void FuSelection::Activate()
/*N*/ {
/*N*/ 	SdrDragMode eMode;
/*N*/     pView->ResetCreationActive();
/*N*/ 	pView->SetEditMode(SDREDITMODE_EDIT);
/*N*/ 
/*N*/ 	switch( nSlotId )
/*N*/ 	{
/*N*/ 		case SID_OBJECT_ROTATE:
/*N*/ 		{
/*?*/ 			// (gemapter) Slot wird explizit auf Rotate gesetzt #31052#
/*?*/ 			if( pViewShell->ISA( SdDrawViewShell) )
/*?*/ 			{
/*?*/ 				USHORT* pSlotArray = ( (SdDrawViewShell*) pViewShell )->GetSlotArray();
/*?*/ 				pSlotArray[ 1 ] = SID_OBJECT_ROTATE;
/*?*/ 			}
/*?*/ 
/*?*/ 			eMode = SDRDRAG_ROTATE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_MIRROR:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_MIRROR;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_TRANSPARENCE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_TRANSPARENCE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_GRADIENT:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_GRADIENT;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_SHEAR:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_SHEAR;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_ROTATE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_ROTATE);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_SLANT:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_SLANT);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_STRETCH:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_STRETCH);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_CONVERT_TO_3D_LATHE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_MIRROR;
/*?*/             bSuppressChangesOfSelection = TRUE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 
/*?*/             if (!pView->IsCreationActive())
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     pView->Start3DCreation();
/*?*/ 
/*?*/             bSuppressChangesOfSelection = FALSE;
/*?*/         }
/*?*/         break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			eMode = SDRDRAG_MOVE;
/*N*/ 
/*N*/ 			if ( pView->GetDragMode() != eMode )
/*N*/ 				pView->SetDragMode(eMode);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (nSlotId != SID_OBJECT_ROTATE)
/*N*/ 	{
/*N*/ 		bTempRotation = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	FuDraw::Activate();
/*N*/ }



/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void FuSelection::Deactivate()
/*N*/ {
/*N*/ 	FuDraw::Deactivate();
/*N*/ }


/*************************************************************************
|*
|* Selektion hat sich geaendert
|*
\************************************************************************/

/*N*/ void FuSelection::SelectionHasChanged()
/*N*/ {
/*N*/     bSelectionChanged = TRUE;
/*N*/ 
/*N*/     FuDraw::SelectionHasChanged();
/*N*/ 
/*N*/     if ((pView->IsCreationActive() && !bSuppressChangesOfSelection))
/*?*/     {
        // Wechsel Rotationskoerper -> Selektion
/*?*/         pView->ShowMirrored();
/*?*/         pView->ResetCreationActive();
/*?*/         nSlotId = SID_OBJECT_SELECT;
/*?*/         Activate();
/*?*/     }

    /**************************************************************************
    * ObjectBar einschalten
    **************************************************************************/
/*N*/     USHORT nObjBarId;
/*N*/ 
/*N*/     if (pView->GetContext() == SDRCONTEXT_POINTEDIT)
/*N*/         nObjBarId = RID_BEZIER_TOOLBOX;
/*N*/     else if (pView->GetContext() == SDRCONTEXT_GRAPHIC)
/*N*/         nObjBarId = RID_DRAW_GRAF_TOOLBOX;
/*N*/ 	else
/*N*/ 		nObjBarId = RID_DRAW_OBJ_TOOLBOX;
/*N*/ 
/*N*/     pViewShell->SwitchObjectBar(nObjBarId);
/*N*/ }


/*************************************************************************
|*
|* Aktuellen Bezier-Editmodus setzen
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/



/*************************************************************************
|*
|* Animation oder Interaktion ausfuehren
|*
\************************************************************************/

	        /**********************************************************
	        * Animations-Objekt in der Mitte getroffen -> Interaktion
	        **********************************************************/
	    	/**********************************************************
	    	* Effekt-Objekt in der Mitte getroffen -> Effekt abspielen
	    	**********************************************************/



/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/




}
