/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:41:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _ZOOMITEM_HXX
#include <bf_svx/zoomitem.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif



#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif



#define ITEMID_FIELD	EE_FEATURE_FIELD


#ifndef _SVDOATTR_HXX //autogen
#include <bf_svx/svdoattr.hxx>
#endif

#pragma hdrstop

#include "app.hrc"
#include "glob.hrc"
#include "helpids.h"
#include "drawview.hxx"
#include "sdwindow.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdpage.hxx"
#include "sdresid.hxx"
#include "grviewsh.hxx"
#include "fuslshow.hxx"

// #90356#
#ifndef _SD_OPTSITEM_HXX
#include "optsitem.hxx"
#endif
namespace binfilter {

/*************************************************************************
|*
|* modal dialog for #90356#
|*
\************************************************************************/



/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemporary(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// Waehrend einer Native-Diashow wird nichts ausgefuehrt!
/*?*/ 	if (pFuSlideShow && !pFuSlideShow->IsLivePresentation() &&
/*?*/ 		rReq.GetSlot() != SID_NAVIGATOR)
/*?*/ 	{
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		pFuActual->Deactivate();
/*N*/ 
/*N*/ 		if (pFuActual != pFuOld)
/*N*/ 		{
/*N*/ 			delete pFuActual;
/*N*/ 		}
/*N*/ 
/*N*/ 		pFuActual = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	// Slot wird gemapped (ToolboxImages/-Slots)
/*N*/ 	MapSlot( nSId );
/*N*/ 
/*N*/ 	switch ( nSId )
/*N*/ 	{
/*?*/ 		// Flaechen und Linien-Attribute:
/*?*/ 		// Sollten (wie StateMethode) eine eigene
/*?*/ 		// Execute-Methode besitzen
/*?*/ 		case SID_ATTR_FILL_STYLE:
/*?*/ 		case SID_ATTR_FILL_COLOR:
/*?*/ 		case SID_ATTR_FILL_GRADIENT:
/*?*/ 		case SID_ATTR_FILL_HATCH:
/*?*/ 		case SID_ATTR_FILL_BITMAP:
/*?*/ 		case SID_ATTR_FILL_SHADOW:
/*?*/ 
/*?*/ 		case SID_ATTR_LINE_STYLE:
/*?*/ 		case SID_ATTR_LINE_DASH:
/*?*/ 		case SID_ATTR_LINE_WIDTH:
/*?*/ 		case SID_ATTR_LINE_COLOR:
/*?*/ 		case SID_ATTR_LINEEND_STYLE:
/*?*/ 
/*?*/ 		case SID_ATTR_TEXT_FITTOSIZE:
/*?*/ 		{
/*?*/ 			if( rReq.GetArgs() )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BOOL bMergeUndo = FALSE;
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				switch( rReq.GetSlot() )
/*?*/ 				{
/*?*/ 					case SID_ATTR_FILL_SHADOW:
/*?*/ 					case SID_ATTR_FILL_STYLE:
/*?*/ 					case SID_ATTR_FILL_COLOR:
/*?*/ 					case SID_ATTR_FILL_GRADIENT:
/*?*/ 					case SID_ATTR_FILL_HATCH:
/*?*/ 					case SID_ATTR_FILL_BITMAP:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_ATTRIBUTES_AREA, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 					case SID_ATTR_LINE_STYLE:
/*?*/ 					case SID_ATTR_LINE_DASH:
/*?*/ 					case SID_ATTR_LINE_WIDTH:
/*?*/ 					case SID_ATTR_LINE_COLOR:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_ATTRIBUTES_LINE, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 					case SID_ATTR_TEXT_FITTOSIZE:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_TEXTATTR_DLG, SFX_CALLMODE_ASYNCHRON );
/*?*/ 						break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_HYPHENATION:
/*?*/ 		{
/*?*/ 			// const SfxPoolItem* pItem = rReq.GetArg( SID_HYPHENATION );
/*?*/ 			//  ^-- Soll so nicht benutzt werden (Defaults sind falsch) !
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG( rReq, pItem, SfxBoolItem, SID_HYPHENATION, FALSE);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERTPAGE:
/*?*/ 		case SID_INSERTPAGE_QUICK:
/*?*/ 		case SID_DUPLICATE_PAGE:
/*?*/ 		            {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 CreateOrDuplicatePage (rReq);
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MODIFYPAGE:
/*?*/ 		{
/*?*/ 			if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES ||
/*?*/ 				(ePageKind==PK_HANDOUT && eEditMode==EM_MASTERPAGE) )
/*?*/ 			{
/*?*/ 				if ( pDrView->IsTextEdit() )
/*?*/ 				{
/*?*/ 					pDrView->EndTextEdit();
/*?*/ 				}
/*?*/ 
/*?*/ 				USHORT nPage = aTabControl.GetCurPageId() - 1;
/*?*/ 				pActualPage = pDoc->GetSdPage(nPage, ePageKind);
/*?*/ 				SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
/*?*/ 				BYTE aBckgrnd = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRND)), FALSE);
/*?*/ 				BYTE aBckgrndObj = rLayerAdmin.GetLayerID(String(SdResId(STR_LAYER_BCKGRNDOBJ)), FALSE);
/*?*/ 				USHORT nPos = 0;
/*?*/ 				SetOfByte aVisibleLayers = pActualPage->GetMasterPageVisibleLayers(nPos);
/*?*/ 				BOOL bHandoutMode = FALSE;
/*?*/ 				SdPage* pHandoutMPage = NULL;
/*?*/ 				String aNewName;
/*?*/ 
/*?*/ 				// #95981#
/*?*/ 				String aOldName;
/*?*/ 
/*?*/ 				AutoLayout aNewAutoLayout;
/*?*/ 
/*?*/ 				// #95981#
/*?*/ 				AutoLayout aOldAutoLayout;
/*?*/ 				
/*?*/ 				BOOL bBVisible;
/*?*/ 				BOOL bBObjsVisible;
/*?*/ 				const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 
/*?*/ 				if (!pArgs || pArgs->Count() == 1 || pArgs->Count() == 2 )
/*?*/ 				{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					SfxItemSet aAttrSet( GetPool(), ATTR_PAGE_START, ATTR_PAGE_END );
/*?*/ 				}
/*?*/ 				else if (pArgs->Count() == 4)
/*?*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pNewName, SfxStringItem, ID_VAL_PAGENAME, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pNewAutoLayout, SfxUInt32Item, ID_VAL_WHATLAYOUT, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pBVisible, SfxBoolItem, ID_VAL_ISPAGEBACK, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pBObjsVisible, SfxBoolItem, ID_VAL_ISPAGEOBJ, FALSE);
/*?*/ 
/*?*/ 					if (CHECK_RANGE (AUTOLAYOUT_TITLE, (AutoLayout) pNewAutoLayout->GetValue (), AUTOLAYOUT_HANDOUT6))
/*?*/ 					{
/*?*/ 						aNewName		= pNewName->GetValue ();
/*?*/ 						aNewAutoLayout = (AutoLayout) pNewAutoLayout->GetValue ();
/*?*/ 						bBVisible		= pBVisible->GetValue ();
/*?*/ 						bBObjsVisible	= pBObjsVisible->GetValue ();
/*?*/ 					}
/*?*/ 					else
/*?*/ 					{
/*?*/ 						StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 						rReq.Ignore ();
/*?*/ 						Cancel ();
/*?*/ 						break;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 					rReq.Ignore ();
/*?*/ 					Cancel ();
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 				SdPage* pUndoPage =
/*?*/ 							bHandoutMode ? pHandoutMPage : pActualPage;
/*?*/ 
/*?*/ 				// #67720#
/*?*/ 				SfxUndoManager* pUndoManager = pDocSh->GetUndoManager();
/*?*/ 				DBG_ASSERT(pUndoManager, "No UNDO MANAGER ?!?");
/*?*/ 
/*?*/ 				// #90356#
/*?*/ 				sal_uInt16 nActionCount(pUndoManager->GetUndoActionCount());
/*?*/ 				sal_Bool bContinue(sal_True);
/*?*/ 
/*?*/ 				if(nActionCount)
/*?*/ 				{
/*?*/ 					// #90356# get SdOptions
/*?*/ 					SdOptions* pOptions = SD_MOD()->GetSdOptions(pDoc->GetDocumentType());
/*?*/ 					sal_Bool bShowDialog(pOptions->IsShowUndoDeleteWarning());
/*?*/ 
/*?*/ 					// #95981# If only name is changed do not show
/*?*/ 					// ImpUndoDeleteWarning dialog
/*?*/ 					if(bShowDialog)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 					}
/*?*/ 
/*?*/ 					if(bShowDialog)
/*?*/ 					{
						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 						// ask user if he wants to loose UNDO stack
/*?*/ 					}
/*?*/ 				}
/*?*/ 
/*?*/ 				if(bContinue)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ModifyPageUndoAction* pAction = new ModifyPageUndoAction(
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_RENAMEPAGE:
/*?*/         {
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES )
/*?*/         }
/*?*/         break;
/*?*/ 
/*?*/         case SID_RENAMEPAGE_QUICK:
/*?*/ 		{
/*?*/ 			if (ePageKind==PK_STANDARD || ePageKind==PK_NOTES )
/*?*/ 			{
/*?*/ 				if ( pDrView->IsTextEdit() )
/*?*/ 				{
/*?*/ 					pDrView->EndTextEdit();
/*?*/ 				}
/*?*/ 
/*?*/ 				aTabControl.StartEditMode( aTabControl.GetCurPageId() );
/*?*/ 			}
/*?*/ 
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PAGESIZE :  // entweder dieses (kein menueeintrag o. ae. !!)
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 3)
/*?*/ 				{
						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					SFX_REQUEST_ARG (rReq, pWidth, SfxUInt32Item, ID_VAL_PAGEWIDTH, FALSE);
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_PAGEMARGIN :  // oder dieses (kein menueeintrag o. ae. !!)
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 5)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG (rReq, pLeft, SfxUInt32Item, ID_VAL_PAGELEFT, FALSE);
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_ZOOMING :	// kein Menueintrag, sondern aus dem Zoomdialog generiert
/*?*/ 		{
/*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 
/*?*/ 			if (pArgs)
/*?*/ 				if (pArgs->Count () == 1)
/*?*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pScale, SfxUInt32Item, ID_VAL_ZOOM, FALSE);
/*?*/ 					if (CHECK_RANGE (10, pScale->GetValue (), 1000))
/*?*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SetZoom (pScale->GetValue ());
/*?*/ 					}
/*?*/ 					else StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 
/*?*/ 					rReq.Ignore ();
/*?*/ 					break;
/*?*/ 				}
/*?*/ 
/*?*/ 			StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_ATTR_ZOOM:
/*?*/ 		{
/*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
/*?*/ 			bZoomOnPage = FALSE;
/*?*/ 
/*?*/ 			if ( pArgs )
/*?*/ 			{
/*?*/ 				SvxZoomType eZT = ( ( const SvxZoomItem& ) pArgs->
/*?*/ 											Get( SID_ATTR_ZOOM ) ).GetType();
/*?*/ 				switch( eZT )
/*?*/ 				{
/*?*/ 					case SVX_ZOOM_PERCENT:
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SetZoom( (long) ( ( const SvxZoomItem& ) pArgs->
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_OPTIMAL:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_ALL,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_PAGEWIDTH:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE_WIDTH,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 
/*?*/ 					case SVX_ZOOM_WHOLEPAGE:
/*?*/ 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE,
/*?*/ 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 						break;
/*?*/ 				}
/*?*/ 				rReq.Ignore ();
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuScale( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CHANGEBEZIER:
/*?*/ 		case SID_CHANGEPOLYGON:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
/*?*/ 			break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_CONTOUR:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
/*?*/ 			break;
/*?*/ 
/*?*/ 		case SID_CONVERT_TO_METAFILE:
/*?*/ 		case SID_CONVERT_TO_BITMAP:
/*?*/ 		{
            // End text edit mode when it is active because the metafile or
            // bitmap that will be created does not support it.
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001             if ( pDrView->IsTextEdit() )
		}
/*?*/ 
/*?*/ 		Cancel();
/*?*/ 
/*?*/ 		rReq.Done ();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SET_DEFAULT:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxItemSet* pSet = NULL;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_SNAPITEM:
/*?*/ 		{
/*?*/ 			SdrPageView* pPV;
/*?*/ 			Point	aMPos = pWindow->PixelToLogic( aMousePos );
/*?*/ 			USHORT	nHitLog = (USHORT) pWindow->PixelToLogic( Size( HITPIX, 0 ) ).Width();
/*?*/ 			USHORT	nHelpLine;
/*?*/ 
/*?*/ 			bMousePosFreezed = FALSE;
/*?*/ 
/*?*/ 			if( pDrView->PickHelpLine( aMPos, nHitLog, *pWindow, nHelpLine, pPV) )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pPV->DeleteHelpLine( nHelpLine );
/*?*/ 			}
/*?*/ 			Cancel();
/*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_PAGE:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DeleteActualPage();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DELETE_LAYER:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DeleteActualLayer();
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ORIGINAL_SIZE:
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->SetMarkedOriginalSize();
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			// switch Anweisung wegen CLOOKS aufgeteilt. Alle case-Anweisungen die
/*N*/ 			// eine Fu???? -Funktion aufrufen, sind in die Methode FuTemp01 (drviews8)
/*N*/ 			// gewandert.
/*N*/ 			FuTemp01(rReq);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		pFuActual->Activate();
/*N*/ 	}
/*N*/ }




/** This method consists basically of three parts:
    1. Process the arguments of the SFX request.
    2. Use the model to create a new page or duplicate an existing one.
    3. Update the tab control and switch to the new page.
*/
}
