/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsi.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:43:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_COLOR			ATTR_ANIMATION_COLOR
#include "sdattr.hxx"
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif


#ifndef _SVX_F3DCHILD_HXX
#include <bf_svx/f3dchild.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <bf_svx/dialogs.hrc>
#endif


#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"

#include "drviewsh.hxx"
#include "docshell.hxx"
#include "effect.hxx"
//#include "3dchld.hxx"
//#include "3dfloat.hxx"
#include "drawview.hxx"
namespace binfilter {

using namespace ::com::sun::star;

#define ATTR_MISSING    0       // Attribut nicht verfuegbar
#define ATTR_MIXED      1       // Attribut uneindeutig (bei Mehrfachselektion)
#define ATTR_SET        2       // Attribut eindeutig

#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()

/*************************************************************************
|*
|* SfxRequests fuer EffekteWindow bearbeiten
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ExecEffectWin( SfxRequest& rReq )
/*N*/ {
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_EFFECT_INIT:
/*?*/ 		{
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			USHORT nId = SdEffectChildWindow::GetChildWindowId();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EFFECT_STATE:
/*?*/ 		{
/*?*/ 			UpdateEffectWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EFFECT_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFromEffectWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		// Diawechsel-Window
/*?*/ 		case SID_SLIDE_CHANGE_STATE:
/*?*/ 		{
/*?*/ 			UpdateSlideChangeWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SLIDE_CHANGE_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFromSlideChangeWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_INIT:
/*?*/ 		{
/*?*/ 			USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*?*/ 			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*?*/ 			if( pWindow )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		case SID_3D_STATE:
/*N*/ 		{
/*N*/ 			Update3DWindow();
/*N*/ 		}
/*N*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFrom3DWindow();
/*?*/ 		}
/*?*/ 		break;
/*N*/ 
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Statuswerte fuer EffekteWindow zurueckgeben
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::GetEffectWinState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	UINT32 nState = EFFECT_STATE_NONE;
/*N*/ 
/*N*/ 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*N*/ 	ULONG nCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	if( nCount > 0 )
/*N*/ 	{
/*?*/ 		nState |= EFFECT_COUNT;
/*?*/ 
/*?*/ 		// Genau zwei Objekte ? -> Pfadeffekt moeglich ?
/*?*/ 		if( nCount == 2 )
/*?*/ 		{
/*?*/ 			SdrObject* pObject1 = rMarkList.GetMark(0)->GetObj();
/*?*/ 			SdrObject* pObject2 = rMarkList.GetMark(1)->GetObj();
/*?*/ 			SdrObjKind eKind1   = (SdrObjKind)pObject1->GetObjIdentifier();
/*?*/ 			SdrObjKind eKind2   = (SdrObjKind)pObject2->GetObjIdentifier();
/*?*/ 			//SdAnimationInfo* pInfo1 = pDoc->GetAnimationInfo(pObject1);
/*?*/ 			//SdAnimationInfo* pInfo2 = pDoc->GetAnimationInfo(pObject2);
/*?*/ 			//SdAnimationInfo* pInfo  = NULL;
/*?*/ 
/*?*/ 			if( ( ( pObject1->GetObjInventor() == SdrInventor &&
/*?*/ 				  ( eKind1 == OBJ_LINE) || (eKind1 == OBJ_PLIN) || (eKind1 == OBJ_PATHLINE) ) ||
/*?*/ 				  ( pObject2->GetObjInventor() == SdrInventor &&
/*?*/ 				  ( eKind2 == OBJ_LINE) || (eKind2 == OBJ_PLIN) || (eKind2 == OBJ_PATHLINE) ) ) &&
/*?*/ 				( pObject1->GetUpGroup() == pObject2->GetUpGroup() ) )
/*?*/ 			{
/*?*/ 				nState |= EFFECT_PATH;
/*?*/ 			}
/*?*/ 		}
/*?*/ 	}
/*N*/ 	rSet.Put( SfxUInt32Item( SID_EFFECT_STATE, nState ) );
/*N*/ }

/*************************************************************************
|*
|* EffekteWindow updaten
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateEffectWindow()
/*N*/ {
/*N*/ 	USHORT nId = SdEffectChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		SdEffectWin* pEffectWin = (SdEffectWin*) pWindow->GetWindow();
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Vom EffekteWindow zuweisen
|*
\************************************************************************/


/*************************************************************************
|*
|* 3D - Assign / Update
|*
\************************************************************************/
/*N*/ void SdDrawViewShell::Update3DWindow()
/*N*/ {
/*N*/ 	USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*) pWindow->GetWindow();
/*N*/ 	}
/*N*/ }

/*----------------------------------------------------------------------------*/

#pragma optimize ( "", off )


#pragma optimize ( "", on )


}
