/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdview.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:46:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _E3D_OBJ3D_HXX
#include <bf_svx/obj3d.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SVDOGRAF_HXX
#include <bf_svx/svdograf.hxx>
#endif

#include <bf_svx/dialogs.hrc>

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
#include "sdview.hxx"
#include "drawdoc.hxx"
#include "glob.hrc"
#include "sdresid.hxx"
namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif

TYPEINIT1( SdView, FmFormView );

/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

/*N*/ SdView::SdView(SdDrawDocument* pDrawDoc, OutputDevice* pOutDev,
/*N*/ 			   SdViewShell* pViewShell)
/*N*/   : FmFormView(pDrawDoc, pOutDev),
/*N*/ 	pDoc(pDrawDoc),
/*N*/ 	pDocSh( pDrawDoc->GetDocSh() ),
/*N*/ 	pViewSh(pViewShell),
/*N*/ 	pDragSrcMarkList(NULL),
/*N*/ 	nDragSrcPgNum(SDRPAGE_NOTFOUND),
/*N*/ 	pDropMarkerObj(NULL),
/*N*/ 	pDropMarker(NULL),
/*N*/ 	pLockedRedraws(NULL),
/*N*/ 	nLockRedrawSmph(0),
/*N*/ 	nAction(DND_ACTION_NONE),
/*N*/ 	bIsDropAllowed(TRUE)
/*N*/ {
/*N*/ 	EnableExtendedKeyInputDispatcher(FALSE);
/*N*/ 	EnableExtendedMouseEventDispatcher(FALSE);
/*N*/ 	EnableExtendedCommandEventDispatcher(FALSE);
/*N*/ 
/*N*/ 	SetUseIncompatiblePathCreateInterface(FALSE);
/*N*/ 	SetMarkHdlWhenTextEdit(TRUE);
/*N*/ 	EnableTextEditOnObjectsWithoutTextIfTextTool(TRUE);
/*N*/ 
/*N*/ 	SetMinMoveDistancePixel(2);
/*N*/ 	SetHitTolerancePixel(2);
/*N*/ 	SetMeasureLayer(String(SdResId(STR_LAYER_MEASURELINES)));
/*N*/ 
/*N*/ 	// Timer fuer verzoegertes Drop (muss fuer MAC sein)
/*N*/ 	aDropErrorTimer.SetTimeoutHdl( LINK(this, SdView, DropErrorHdl) );
/*N*/ 	aDropErrorTimer.SetTimeout(50);
/*N*/ 	aDropInsertFileTimer.SetTimeoutHdl( LINK(this, SdView, DropInsertFileHdl) );
/*N*/ 	aDropInsertFileTimer.SetTimeout(50);
/*N*/ }

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

/*N*/ SdView::~SdView()
/*N*/ {
/*N*/ 	// release content of selection clipboard, if we own the content
/*N*/     UpdateSelectionClipboard( TRUE );
/*N*/ 
/*N*/ 	aDropErrorTimer.Stop();
/*N*/ 	aDropInsertFileTimer.Stop();
/*N*/ 
/*N*/ 	delete pDropMarker;
/*N*/ 
/*N*/ 	while (GetWin(0))
/*N*/ 	{
/*N*/ 		// Alle angemeldeten OutDevs entfernen
/*N*/ 		DelWin(GetWin(0));
/*N*/ 	}

	// gespeicherte Redraws loeschen
/*N*/ 	if (pLockedRedraws)
/*N*/ 	{
/*?*/ 		SdViewRedrawRec* pRec = (SdViewRedrawRec*)pLockedRedraws->First();
/*?*/ 		while (pRec)
/*?*/ 		{
/*?*/ 			delete pRec;
/*?*/ 			pRec = (SdViewRedrawRec*)pLockedRedraws->Next();
/*?*/ 		}
/*?*/ 		delete pLockedRedraws;
/*?*/ 	}
/*N*/ }


/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird an die View weitergeleitet
|*
\************************************************************************/



/*************************************************************************
|*
|* Selektion hat sich geaendert
|*
\************************************************************************/

/*N*/ void SdView::MarkListHasChanged()
/*N*/ {
/*N*/ 	FmFormView::MarkListHasChanged();
/*N*/ }


/*************************************************************************
|*
|* Attribute setzen
|*
\************************************************************************/



/*************************************************************************
|*
|* Attribute holen
|*
\************************************************************************/



/*************************************************************************
|*
|* Ist ein Praesentationsobjekt selektiert?
|*
\************************************************************************/


/*************************************************************************
|*
|* Alles selektieren
|*
\************************************************************************/



/*************************************************************************
|*
|* Dokument hat sich geaendert
|*
\************************************************************************/

/*N*/ void SdView::ModelHasChanged()
/*N*/ {
/*N*/ 	// Erst SdrView benachrichtigen
/*N*/ 	FmFormView::ModelHasChanged();
/*N*/ }

/*************************************************************************
|*
|* StyleSheet setzen
|*
\************************************************************************/



/*************************************************************************
|*
|* Texteingabe beginnen
|*
\************************************************************************/


/*************************************************************************
|*
|* Texteingabe beenden
|*
\************************************************************************/



/*************************************************************************
|*
|* Originalgroesse der markierten Objekte setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* virt. Device mit Seiteninhalt erzeugen, Device gehoert dem Caller
|*
\************************************************************************/

    /* #103186# following change undone:

      revision 1.168 (old cvs)
      date: 1996/02/27 17:57:10;  author: SB;  state: Exp;  lines: +14 -5
      CreatePageVDev(): Einschraenkung auf Seitengrenzen

      reason:

      > SdrPageView:
      > // rReg bezieht sich auf's OutDev, nicht auf die Page
      > void InitRedraw( ... );
    */

    // temporary for gcc



/*************************************************************************
|*
|* OLE-Obj am Client connecten
|*
\************************************************************************/


/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ BOOL SdView::IsMorphingAllowed() const
/*N*/ {
/*N*/ 	const SdrMarkList&	rMarkList = GetMarkList();
/*N*/ 	BOOL				bRet = FALSE;
/*N*/ 
/*N*/ 	if ( rMarkList.GetMarkCount() == 2 )
/*N*/ 	{
/*?*/ 		const SdrObject*	pObj1 = rMarkList.GetMark( 0 )->GetObj();
/*?*/ 		const SdrObject*	pObj2 = rMarkList.GetMark( 1 )->GetObj();
/*?*/ 		const UINT16		nKind1 = pObj1->GetObjIdentifier();
/*?*/ 		const UINT16		nKind2 = pObj2->GetObjIdentifier();
/*?*/ 
/*?*/ 		if ( ( nKind1 != OBJ_TEXT && nKind2 != OBJ_TEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_TITLETEXT && nKind2 != OBJ_TITLETEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_OUTLINETEXT && nKind2 != OBJ_OUTLINETEXT ) &&
/*?*/ 			 ( nKind1 != OBJ_GRUP && nKind2 != OBJ_GRUP ) &&
/*?*/ 			 ( nKind1 != OBJ_LINE && nKind2 != OBJ_LINE ) &&
/*?*/ 			 ( nKind1 != OBJ_PLIN && nKind2 != OBJ_PLIN ) &&
/*?*/ 			 ( nKind1 != OBJ_PATHLINE && nKind2 != OBJ_PATHLINE ) &&
/*?*/ 			 ( nKind1 != OBJ_FREELINE && nKind2 != OBJ_FREELINE ) &&
/*?*/ 			 ( nKind1 != OBJ_PATHPLIN && nKind2 != OBJ_PATHPLIN ) &&
/*?*/ 			 ( nKind1 != OBJ_MEASURE && nKind2 != OBJ_MEASURE ) &&
/*?*/ 			 ( nKind1 != OBJ_EDGE && nKind2 != OBJ_EDGE ) &&
/*?*/ 			 ( nKind1 != OBJ_GRAF && nKind2 != OBJ_GRAF ) &&
/*?*/ 			 ( nKind1 != OBJ_OLE2 && nKind2 != OBJ_OLE2 ) &&
/*?*/ 			 ( nKind1 != OBJ_CAPTION && nKind2 !=  OBJ_CAPTION ) &&
/*?*/ 			 !pObj1->ISA( E3dObject) && !pObj2->ISA( E3dObject) )
/*?*/ 		{
/*?*/ 			SfxItemSet		aSet1( pDoc->GetPool(), XATTR_FILLSTYLE, XATTR_FILLSTYLE );
/*?*/ 			SfxItemSet		aSet2( pDoc->GetPool(), XATTR_FILLSTYLE, XATTR_FILLSTYLE );
/*?*/ 
/*?*/ //-/			pObj1->TakeAttributes( aSet1, TRUE, FALSE );
/*?*/ 			aSet1.Put(pObj1->GetItemSet());
/*?*/ 
/*?*/ //-/			pObj2->TakeAttributes( aSet2, TRUE, FALSE );
/*?*/ 			aSet2.Put(pObj2->GetItemSet());
/*?*/ 
/*?*/ 			const XFillStyle	eFillStyle1 = ( (const XFillStyleItem&) aSet1.Get( XATTR_FILLSTYLE ) ).GetValue();
/*?*/ 			const XFillStyle	eFillStyle2 = ( (const XFillStyleItem&) aSet2.Get( XATTR_FILLSTYLE ) ).GetValue();
/*?*/ 
/*?*/ 			if( ( eFillStyle1 == XFILL_NONE || eFillStyle1 == XFILL_SOLID ) &&
/*?*/ 				( eFillStyle2 == XFILL_NONE || eFillStyle2 == XFILL_SOLID ) )
/*?*/ 				bRet = TRUE;
/*?*/ 		}
/*?*/ 	}
/*?*/ 
/*N*/ 	return bRet;
/*N*/ }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ BOOL SdView::IsVectorizeAllowed() const
/*N*/ {
/*N*/ 	const SdrMarkList&	rMarkList = GetMarkList();
/*N*/ 	BOOL				bRet = FALSE;
/*N*/ 
/*N*/ 	if( rMarkList.GetMarkCount() == 1 )
/*N*/ 	{
/*?*/ 		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
/*?*/ 
/*?*/ 		if( pObj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP )
/*?*/ 			bRet = TRUE;
/*?*/ 	}
/*N*/ 
/*N*/ 	return bRet;
/*N*/ }

}
