/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_workwin.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:00:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "topfrm.hxx"
#include "arrdecl.hxx"
#include "dispatch.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "tbxchild.hxx"
#include "tbxconf.hxx"
#include "dockwin.hxx"
#include "viewsh.hxx"
#include "ipenv.hxx"
#include "splitwin.hxx"
#include "sfxresid.hxx"
#include <vcl/taskpanelist.hxx>

#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif

namespace binfilter {

/*N*/ DBG_NAME(SfxWorkWindow)

/*N*/ SV_IMPL_OBJARR( SfxObjectBarArr_Impl, SfxObjectBar_Impl );

//====================================================================
// Sortiert die Children nach ihrem Alignment
// Reihenfolge entspricht der im enum SfxChildAlignment (->CHILDWIN.HXX).
//

// Hilfe, um die "Anderungen am Alignment kompatibal zu machen!

/*?*/ BOOL IsAppWorkWinToolbox_Impl( USHORT nPos )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*N*/ USHORT TbxMatch( USHORT nPos )
/*N*/ {
/*N*/ 	switch ( nPos )
/*N*/ 	{
/*N*/ 		case SFX_OBJECTBAR_APPLICATION :
/*N*/ 			return 0;
/*N*/ 			break;
/*N*/ 		case SFX_OBJECTBAR_OPTIONS:
/*N*/ 			return 1;
/*N*/ 			break;
/*N*/ 		case SFX_OBJECTBAR_MACRO:
/*N*/ 			return 2;
/*N*/ 			break;
/*N*/ 		case SFX_OBJECTBAR_OBJECT:
/*N*/ 			return 3;
/*N*/ 			break;
/*N*/ 		case SFX_OBJECTBAR_TOOLS:
/*N*/ 			return 4;
/*N*/ 			break;
/*N*/ 		case SFX_OBJECTBAR_FULLSCREEN:
/*N*/ 		case SFX_OBJECTBAR_COMMONTASK:
/*N*/         case SFX_OBJECTBAR_RECORDING:
/*N*/ 			return nPos+1;
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			return nPos;
/*N*/ 			break;
/*N*/ 	}
/*N*/ }

/*N*/ USHORT ChildAlignValue(SfxChildAlignment eAlign)
/*N*/ {
/*N*/ 	USHORT ret = 17;
/*N*/ 
/*N*/ 	switch (eAlign)
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_HIGHESTTOP:
/*N*/ 			ret = 1;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 			ret = 2;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_FIRSTLEFT:
/*N*/ 			ret = 3;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_LASTRIGHT:
/*N*/ 			ret = 4;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 			ret = 5;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 			ret = 6;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 			ret = 7;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_LASTLEFT:
/*N*/ 			ret = 8;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 			ret = 9;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 			ret = 10;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOOLBOXTOP:
/*N*/ 			ret = 11;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOOLBOXBOTTOM:
/*N*/ 			ret = 12;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_LOWESTTOP:
/*N*/ 			ret = 13;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 			ret = 14;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOOLBOXLEFT:
/*N*/ 			ret = 15;
/*N*/ 			break;
/*N*/ 		case SFX_ALIGN_TOOLBOXRIGHT:
/*N*/ 			ret = 16;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	return ret;
/*N*/ }


/*N*/ void SfxWorkWindow::Sort_Impl()
/*N*/ {
/*N*/ 	aSortedList.Remove(0, aSortedList.Count());
/*N*/ 	for (USHORT i=0; i<pChilds->Count(); i++)
/*N*/ 	{
/*N*/ 		SfxChild_Impl *pCli = (*pChilds)[i];
/*N*/ 		if (pCli)
/*N*/ 		{
/*N*/ 			USHORT k;
/*N*/ 			for (k=0; k<aSortedList.Count(); k++)
/*N*/ //				if ( (*pChilds)[aSortedList[k]]->eAlign > pCli->eAlign )
/*N*/ 				if (ChildAlignValue((*pChilds)[aSortedList[k]]->eAlign) >
/*N*/ 					ChildAlignValue(pCli->eAlign))
/*N*/ 					break;
/*N*/ 			aSortedList.Insert (i,k);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	bSorted = TRUE;
/*N*/ }


//====================================================================
// ctor f"ur workwin eines Frames

/*N*/ SfxFrameWorkWin_Impl::SfxFrameWorkWin_Impl( Window *pWin, SfxFrame *pFrm )
/*N*/     : SfxWorkWindow(
/*N*/         pWin,
/*N*/         pFrm->GetCurrentViewFrame()->GetBindings(),
/*N*/         pFrm->GetParentFrame() ? pFrm->GetParentFrame()->GetWorkWindow_Impl() : NULL )
/*N*/ 	, pFrame( pFrm )
/*N*/ {
/*N*/ 	pConfigShell = pFrm->GetCurrentViewFrame();
/*N*/ 
/*N*/ 	// Die ben"otigten SplitWindows (je eins f"ur jede Seite) werden erzeugt
/*N*/ 	for ( USHORT n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		// Die SplitWindows sind direkte ChildWindows des WorkWindows und enthalten
/*N*/ 		// die angedockten Fenster.
/*N*/ 
/*N*/ 		SfxChildAlignment eAlign =
/*N*/ 						( n == SFX_SPLITWINDOWS_LEFT ? SFX_ALIGN_LEFT :
/*N*/ 							n == SFX_SPLITWINDOWS_RIGHT ? SFX_ALIGN_RIGHT :
/*N*/ 							n == SFX_SPLITWINDOWS_TOP ? SFX_ALIGN_TOP :
/*N*/ 								SFX_ALIGN_BOTTOM );
/*N*/ 		SfxSplitWindow *pWin = new SfxSplitWindow(pWorkWin, eAlign, this, pParent==0 );
/*N*/ 		pSplit[n] = pWin;
/*N*/ 	}
/*N*/ 
/*N*/ 	nOrigMode = SFX_VISIBILITY_CLIENT;
/*N*/ 	nUpdateMode = SFX_VISIBILITY_STANDARD;
/*N*/ }

//====================================================================
// ctor f"ur workwin eines InPlaceObjects.

/*?*/ SfxIPWorkWin_Impl::SfxIPWorkWin_Impl( WorkWindow *pWin, SfxBindings& rB,
/*?*/ 						SfxInPlaceEnv_Impl *pE) :
/*?*/ 	SfxWorkWindow(pWin, rB),
/*?*/ 	pEnv(pE)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//====================================================================
// ctor der Basisklasse

/*N*/ SfxWorkWindow::SfxWorkWindow( Window *pWin, SfxBindings& rB, SfxWorkWindow* pParentWorkwin ) :
/*N*/ 	pWorkWin (pWin),
/*N*/ 	pParent( pParentWorkwin ),
/*N*/ 	bSorted( TRUE ),
/*N*/ 	pBindings(&rB),
/*N*/ 	bDockingAllowed(TRUE),
/*N*/ 	bAllChildsVisible(TRUE),
/*N*/ 	nChilds( 0 ),
/*N*/ 	nOrigMode( 0 ),
/*N*/ 	pConfigShell( 0 ),
/*N*/     pActiveChild( 0 ),
/*N*/     bIsFullScreen( FALSE )
/*N*/ {
/*N*/ 	DBG_CTOR(SfxWorkWindow, 0);
/*N*/ 	DBG_ASSERT (pBindings, "Keine Bindings!");
/*N*/ 
/*N*/ 	pBindings->SetWorkWindow_Impl( this );
/*N*/ 
/*N*/ 	pChildWins = new SfxChildWindows_Impl;
/*N*/ 	pChilds = new SfxChildList_Impl;
/*N*/ 
/*N*/ 	// F"ur die ObjectBars wird ein fester Platz in der ChildList reserviert,
/*N*/ 	// damit sie immer in einer definierten Reihenfolge kommen.
/*N*/ 	SfxChild_Impl* pChild=0;
/*N*/ 	for (USHORT n=0; n < SFX_OBJECTBAR_MAX; ++n)
/*N*/ 		pChilds->Insert(0,pChild);
/*N*/ }

//====================================================================
// dtor

/*N*/ SfxWorkWindow::~SfxWorkWindow()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxWorkWindow, 0);
/*N*/ 
/*N*/ 	// SplitWindows l"oschen
/*N*/     for ( USHORT n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		SfxSplitWindow *p = pSplit[n];
/*N*/ 		if (p->GetWindowCount())
/*?*/ 			ReleaseChild_Impl(*p);
/*N*/         delete p;
/*N*/ 	}
/*N*/ 
/*N*/ 	// Hilfsstruktur f"ur Child-Windows l"oschen
/*N*/ 	DBG_ASSERT( pChilds->Count() == 0, "dangling childs" );
/*N*/ 	delete pChilds;
/*N*/ 	delete pChildWins;
/*N*/ }

/*N*/ SystemWindow* SfxWorkWindow::GetTopWindow() const
/*N*/ {
/*N*/     Window* pRet = pWorkWin;
/*N*/     while ( pRet && !pRet->IsSystemWindow() )
/*N*/         pRet = pRet->GetParent();
/*N*/     return (SystemWindow*) pRet;
/*N*/ }



//--------------------------------------------------------------------
// Hilfsmethode zum Freigeben der Childlisten. Wenn danach nicht der dtor
// aufgerufen wird, sondern weiter gearbeitet wird, mu\s wie im ctor von
// SfxWorkWindow noch Platz f"ur die Objectbars und SplitWindows reserviert
// werden.

/*N*/ void SfxWorkWindow::DeleteControllers_Impl()
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 
/*N*/ 	// SplitWindows locken (d.h. Resize-Reaktion an den
/*N*/ 	// DockingWindows unterdr"ucken)
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		SfxSplitWindow *p = pSplit[n];
/*N*/ 		if (p->GetWindowCount())
/*N*/ 			p->Lock();
/*N*/ 	}
/*N*/ 
/*N*/ 	// Child-Windows l"oschen
/*N*/ 	USHORT nCount = pChildWins->Count();
/*N*/ 	for ( n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/ 		SfxChildWin_Impl* pCW = (*pChildWins)[n];
/*N*/ 		SfxChildWindow *pChild = pCW->pWin;
/*N*/ 		if (pChild)
/*N*/ 		{
/*
			BOOL bTask = ( pCW->aInfo.nFlags & SFX_CHILDWIN_TASK ) != 0;
			pCW->aInfo = pChild->GetInfo();
			if ( bTask )
				pCW->aInfo.nFlags |= SFX_CHILDWIN_TASK;
			SaveStatus_Impl(pChild, pCW->aInfo);
*/
/*N*/ 			pChild->Hide();
/*N*/ 
/*N*/ 			// Wenn das ChildWindow ein direktes Childfenster ist und nicht
/*N*/ 			// in einem SplitWindow liegt, am WorkWindow abmelden.
/*N*/ 			// Nach TH ist eine Abmeldung am Splitwindow nicht erforderlich,
/*N*/ 			// wenn dieses auch gleich mit zerst"ort wird (s.u.).
/*N*/ 			if (pCW->pCli)
/*N*/ 				ReleaseChild_Impl(*pChild->GetWindow());
/*N*/ 			pCW->pWin = 0;
/*N*/ 			pWorkWin->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( pChild->GetWindow() );
/*N*/ 			pChild->Destroy();
/*N*/ 		}
/*N*/ 		delete pCW->pControl;
/*N*/ 		delete pCW;
/*N*/ 	}
/*N*/ 
/*N*/ 	pChildWins->Remove((USHORT)0, nCount);
/*N*/ 
/*N*/ 	// StatusBar l"oschen
/*N*/ 	if ( aStatBar.pStatusBar )
/*N*/ 	{
/*N*/ 		StatusBar *pBar = aStatBar.pStatusBar->GetStatusBar();
/*N*/ 		aStatBar.pStatusBar->StoreConfig();
/*N*/ 		ReleaseChild_Impl( *pBar );
/*N*/ 		DELETEZ( aStatBar.pStatusBar );
/*N*/ 		delete pBar;
/*N*/ 	}
/*N*/ 
/*N*/ 	// ObjectBars l"oschen( zuletzt, damit pChilds nicht tote Pointer enh"alt )
/*N*/ 	for (n=0; n<SFX_OBJECTBAR_MAX; n++)
/*N*/ 	{
/*N*/         delete (*pChilds)[TbxMatch(n)];
/*N*/ 
/*N*/ 		// Nicht jede Position mu\s belegt sein
/*N*/ 		SfxToolBoxManager *pTbx = aObjBars[n].pTbx;
/*N*/ 		if (pTbx)
/*N*/ 		{
/*N*/ 			// Release siehe unten
/*N*/ 			pTbx->StoreConfig();
/*N*/ 			pWorkWin->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( &pTbx->GetToolBox() );
/*N*/ 			delete(pTbx);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// ObjectBars werden alle auf einmal released, da sie einen
/*N*/ 	// festen zusammenh"angenden  Bereich im Array pChilds belegen
/*N*/ 	pChilds->Remove(0, SFX_OBJECTBAR_MAX);
/*N*/     bSorted = FALSE;
/*N*/ 
/*N*/ 	nChilds = 0;
/*N*/ }

//====================================================================
// Virtuelle Methode zum Anordnen der Childfenster.

/*?*/ void SfxWorkWindow::ArrangeChilds_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP");
/*?*/ }

//====================================================================
// Virtuelle Methode zum Anordnen der Childfenster. Bei InPlaceObjects
// steht daf"ur als Fl"ache das Rectangle zur Verf"ugung, das am
// InPlaceClient als TopOuterRect abgefragt werden kann. Diese wird
// durch den von Arrange_Impl() errechneten SvBorder verringert.


//====================================================================
// Virtuelle Methode zum Anordnen der Childfenster. Bei einer Task
// steht daf"ur als Fl"ache die OutputSize des TaskWindows zur Verf"ugung.
// Sie wird durch den von Arrange_Impl() errechneten SvBorder verringert.

/*N*/ void SfxFrameWorkWin_Impl::ArrangeChilds_Impl()
/*N*/ {
/*N*/ 	if ( pFrame->IsClosing_Impl() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	aClientArea = GetTopRect_Impl();
/*N*/     if ( aClientArea.IsEmpty() )
/*N*/         return;
/*N*/ 
/*N*/ 	SvBorder aBorder;
/*N*/ 	if ( nChilds )
/*N*/         aBorder = Arrange_Impl();
/*N*/ 
/*N*/ 	// Wenn das aktuelle Dokument der Applikation einen IPClient enth"alt, mu\s
/*N*/ 	// dem dazugeh"origen Objekt durch SetTopToolFramePixel der zur Verf"ugung
/*N*/ 	// stehende Platz zugeteilt werden. Das Objekt zeigt dann seine UITools an
/*N*/ 	// und setzt den App-Border(->SfxInPlaceEnv_Impl::ArrangeChilds_Impl()).
/*N*/ 	// Anderenfalls wird hier direkt der AppBorder gesetzt, um evtl. den Border
/*N*/ 	// zu "uberschreiben, den bisher ein Objekt aus einem anderen Dokument
/*N*/ 	// gesetzt hatte.
/*N*/ 	// Das Objekt setzt, wenn es seine UI-Tools wegnimmt, den SetAppBorder nicht,
/*N*/ 	// damit kein ObjectBar-Zappeln entsteht.
/*N*/ 	// (->SfxInPlaceEnv_Impl::ArrangeChilds_Impl())
/*N*/     SfxInPlaceClient *pClient = 0;
/*N*/     SfxViewFrame *pF = pFrame->GetCurrentViewFrame();
/*N*/     if ( pF && pF->GetViewShell() )
/*N*/         pClient = pF->GetViewShell()->GetIPClient();
/*N*/ 
/*N*/     if ( pClient )
/*?*/         pClient->GetEnv()->SetTopToolFramePixel( aBorder );
/*N*/     else
/*N*/         pFrame->SetToolSpaceBorderPixel_Impl( aBorder );
/*N*/ 
/*N*/     ArrangeAutoHideWindows( NULL );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SvBorder SfxWorkWindow::Arrange_Impl()

/*	[Beschreibung]

	Diese Methode ordnet alle sichtbaren ChildFenster so an, da\s die angedockten
	Fenster nach der Sorierreihenfolge von au\sen nach innen aneinander
	gesetzt werden. Wenn ein an sich sichtbares Fenster nicht mehr in die
	noch freie ClientArea pa\st, wird es auf "nicht sichtbar" gesetzt.

*/
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 
/*N*/ 	aClientArea = GetTopRect_Impl();
/*N*/     aUpperClientArea = aClientArea;
/*N*/ 
/*N*/     SvBorder aBorder;
/*N*/     if ( !nChilds )
/*N*/         return aBorder;
/*N*/ 
/*N*/ 	if (!bSorted)
/*N*/ 		Sort_Impl();
/*N*/ 
/*N*/     Point aPos;
/*N*/     Size aSize;
/*N*/     Rectangle aTmp( aClientArea );
/*N*/ 
/*N*/ 	for ( USHORT n=0; n<aSortedList.Count(); ++n )
/*N*/ 	{
/*N*/ 		SfxChild_Impl* pCli = (*pChilds)[aSortedList[n]];
/*N*/         if ( !pCli->pWin )
/*N*/             continue;
/*N*/ 
/*N*/ 		// Zun"achst nehmen wir an, da\s das Fenster Platz hat
/*N*/ 		pCli->nVisible |= CHILD_FITS_IN;
/*N*/ 
/*N*/ 		// Nicht sichtbare Fenster "uberspringen
/*N*/ 		if (pCli->nVisible != CHILD_VISIBLE)
/*N*/ 			continue;
/*N*/ 
/*N*/ 		if ( pCli->bResize )
/*N*/ 			aSize = pCli->aSize;
/*N*/ 		else
/*N*/ 			aSize = pCli->pWin->GetSizePixel();
/*N*/ 
/*N*/ 		SvBorder aTemp = aBorder;
/*N*/ 		BOOL bAllowHiding = TRUE;
/*N*/ 		switch ( pCli->eAlign )
/*N*/ 		{
/*N*/ 			case SFX_ALIGN_HIGHESTTOP:
/*N*/ 			case SFX_ALIGN_TOP:
/*N*/ 			case SFX_ALIGN_TOOLBOXTOP:
/*N*/ 			case SFX_ALIGN_LOWESTTOP:
/*N*/ 				aSize.Width() = aTmp.GetWidth();
/*N*/ 				if ( pCli->pWin->GetType() == WINDOW_SPLITWINDOW )
/*N*/ 					aSize = ((SplitWindow *)(pCli->pWin))->CalcLayoutSizePixel( aSize );
/*N*/ 				bAllowHiding = FALSE;
/*N*/ 				aBorder.Top() += aSize.Height();
/*N*/ 				aPos = aTmp.TopLeft();
/*N*/ 				aTmp.Top() += aSize.Height();
/*N*/ 				if ( pCli->eAlign == SFX_ALIGN_HIGHESTTOP )
/*N*/ 					aUpperClientArea.Top() += aSize.Height();
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 			case SFX_ALIGN_BOTTOM:
/*N*/ 			case SFX_ALIGN_TOOLBOXBOTTOM:
/*N*/ 			case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 				aSize.Width() = aTmp.GetWidth();
/*N*/ 				if ( pCli->pWin->GetType() == WINDOW_SPLITWINDOW )
/*N*/ 					aSize = ((SplitWindow *)(pCli->pWin))->CalcLayoutSizePixel( aSize );
/*N*/ 				aBorder.Bottom() += aSize.Height();
/*N*/ 				aPos = aTmp.BottomLeft();
/*N*/ 				aPos.Y() -= (aSize.Height()-1);
/*N*/ 				aTmp.Bottom() -= aSize.Height();
/*N*/ 				if ( pCli->eAlign == SFX_ALIGN_LOWESTBOTTOM )
/*N*/ 					aUpperClientArea.Bottom() -= aSize.Height();
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SFX_ALIGN_FIRSTLEFT:
/*N*/ 			case SFX_ALIGN_LEFT:
/*N*/ 			case SFX_ALIGN_LASTLEFT:
/*N*/ 			case SFX_ALIGN_TOOLBOXLEFT:
/*N*/ 				aSize.Height() = aTmp.GetHeight();
/*N*/ 				if ( pCli->pWin->GetType() == WINDOW_SPLITWINDOW )
/*?*/ 					aSize = ((SplitWindow *)(pCli->pWin))->CalcLayoutSizePixel( aSize );
/*N*/ 				bAllowHiding = FALSE;
/*N*/ 				aBorder.Left() += aSize.Width();
/*N*/ 				aPos = aTmp.TopLeft();
/*N*/ 				aTmp.Left() += aSize.Width();
/*N*/ 				if ( pCli->eAlign != SFX_ALIGN_TOOLBOXLEFT )
/*?*/ 					aUpperClientArea.Left() += aSize.Width();
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 			case SFX_ALIGN_RIGHT:
/*N*/ 			case SFX_ALIGN_LASTRIGHT:
/*N*/ 			case SFX_ALIGN_TOOLBOXRIGHT:
/*?*/ 				aSize.Height() = aTmp.GetHeight();
/*?*/ 				if ( pCli->pWin->GetType() == WINDOW_SPLITWINDOW )
/*?*/ 					aSize = ((SplitWindow *)(pCli->pWin))->CalcLayoutSizePixel( aSize );
/*?*/ 				aBorder.Right() += aSize.Width();
/*?*/ 				aPos = aTmp.TopRight();
/*?*/ 				aPos.X() -= (aSize.Width()-1);
/*?*/ 				aTmp.Right() -= aSize.Width();
/*?*/                 if ( pCli->eAlign != SFX_ALIGN_TOOLBOXRIGHT )
/*?*/ 					aUpperClientArea.Right() -= aSize.Width();
/*?*/ 				break;
/*N*/ 
/*N*/ 			default:
/*N*/ 				pCli->aSize = pCli->pWin->GetSizePixel();
/*N*/ 				pCli->bResize = FALSE;
/*N*/ 				continue;
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		pCli->pWin->SetPosSizePixel( aPos, aSize );
/*N*/ 		pCli->bResize = FALSE;
/*N*/ 		pCli->aSize = aSize;
/*N*/ 		if( bAllowHiding && !RequestTopToolSpacePixel_Impl( aBorder ) )
/*N*/ 		{
/*?*/ 			pCli->nVisible ^= CHILD_FITS_IN;
/*?*/ 			aBorder = aTemp;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     if ( aClientArea.GetWidth() >= aBorder.Left() + aBorder.Right() )
/*N*/ 	{
/*N*/         aClientArea.Left() += aBorder.Left();
/*N*/         aClientArea.Right() -= aBorder.Right();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/         aBorder.Left() = aClientArea.Left();
/*?*/         aBorder.Right() = aClientArea.Right();
/*?*/         aClientArea.Right() = aClientArea.Left() = aTmp.Left();
/*N*/ 	}
/*N*/ 
/*N*/     if ( aClientArea.GetHeight() >= aBorder.Top() + aBorder.Bottom() )
/*N*/ 	{
/*N*/         aClientArea.Top() += aBorder.Top();
/*N*/         aClientArea.Bottom() -= aBorder.Bottom();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/         aBorder.Top() = aClientArea.Top();
/*N*/         aBorder.Bottom() = aClientArea.Bottom();
/*N*/         aClientArea.Top() = aClientArea.Bottom() = aTmp.Top();
/*N*/ 	}
/*N*/ 
/*N*/     return IsDockingAllowed() ? aBorder : SvBorder();
/*N*/ }

//--------------------------------------------------------------------
// Close-Handler: die Konfiguration der ChildWindows wird gespeichert.
//


/*N*/ BOOL SfxWorkWindow::PrepareClose_Impl()
/*N*/ {
/*N*/ 	for (USHORT n=0; n<pChildWins->Count(); n++)
/*N*/ 	{
/*N*/ 		SfxChildWin_Impl *pCW  = (*pChildWins)[n];
/*N*/ 		SfxChildWindow *pChild = pCW->pWin;
/*N*/ 		if ( pChild && !pChild->QueryClose() )
/*N*/ 			return FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return TRUE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxChild_Impl* SfxWorkWindow::RegisterChild_Impl( Window& rWindow,
/*N*/ 					SfxChildAlignment eAlign, BOOL bCanGetFocus )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 	DBG_ASSERT( pChilds->Count() < 255, "too many childs" );
/*N*/ 	DBG_ASSERT( SfxChildAlignValid(eAlign), "invalid align" );
/*N*/ 	DBG_ASSERT( !FindChild_Impl(rWindow), "child registered more than once" );
/*N*/ 
/*N*/ 
/*N*/ 	if ( rWindow.GetParent() != pWorkWin )
/*?*/ 		rWindow.SetParent( pWorkWin );
/*N*/ 
/*N*/ 	SfxChild_Impl *pChild = new SfxChild_Impl(rWindow, rWindow.GetSizePixel(),
/*N*/ 									eAlign, rWindow.IsVisible());
/*N*/ 	pChild->bCanGetFocus = bCanGetFocus;
/*N*/ 
/*N*/ 	pChilds->Insert(pChilds->Count(), pChild);
/*N*/ 	bSorted = FALSE;
/*N*/ 	nChilds++;
/*N*/ 	return (*pChilds)[pChilds->Count()-1];
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ void SfxWorkWindow::ReleaseChild_Impl( Window& rWindow )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 	DBG_ASSERT( pChilds, "releasing unregistered child" );
/*N*/ 
/*N*/ 	SfxChild_Impl *pChild = 0;
/*N*/ 	USHORT nCount = pChilds->Count();
/*N*/ 	USHORT nPos;
/*N*/ 	for ( nPos = 0; nPos < nCount; ++nPos )
/*N*/ 	{
/*N*/ 		pChild = (*pChilds)[nPos];
/*N*/ 		if ( pChild )
/*N*/ 		  if ( pChild->pWin == &rWindow )
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nPos < nCount )
/*N*/ 	{
/*N*/ 		bSorted = FALSE;
/*N*/ 		nChilds--;
/*N*/ 		pChilds->Remove(nPos);
/*N*/ 		delete pChild;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		DBG_ERROR( "releasing unregistered child" );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxChild_Impl* SfxWorkWindow::FindChild_Impl( const Window& rWindow ) const
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 
/*N*/ 	SfxChild_Impl *pChild = 0;
/*N*/ 	USHORT nCount = pChilds->Count();
/*N*/ 	for ( USHORT nPos = 0; nPos < nCount; ++nPos )
/*N*/ 	{
/*N*/ 		pChild = (*pChilds)[nPos];
/*N*/ 		if ( pChild )
/*N*/ 		  if ( pChild->pWin == &rWindow )
/*N*/ 			return pChild;
/*N*/ 	}
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxWorkWindow::ShowChilds_Impl()
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxWorkWindow, 0);
/*N*/ 
/*N*/     if ( !pWorkWin->IsReallyVisible() && !pWorkWin->IsReallyShown() )
/*N*/         return;
/*N*/ 
/*N*/ 	SfxChild_Impl *pCli = 0;
/*N*/ 	for ( USHORT nPos = 0; nPos < pChilds->Count(); ++nPos )
/*N*/ 	{
/*N*/ 		pCli = (*pChilds)[nPos];
/*N*/ 		if (pCli && pCli->pWin)
/*N*/ 		{
/*N*/             if ( CHILD_VISIBLE == (pCli->nVisible & CHILD_VISIBLE) )
/*N*/ 			{
/*N*/ 				USHORT nFlags = pCli->bSetFocus ? 0 : SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE;
/*N*/                 switch ( pCli->pWin->GetType() )
/*N*/ 				{
/*N*/ 					case RSC_DOCKINGWINDOW :
/*N*/                         ((DockingWindow*)pCli->pWin)->Show( TRUE, nFlags );
/*N*/ 						break;
/*N*/ 					case RSC_TOOLBOX :
/*N*/                         ((ToolBox*)pCli->pWin)->Show( TRUE, nFlags );
/*N*/ 						break;
/*N*/ 					case RSC_SPLITWINDOW :
/*?*/                         ((SplitWindow*)pCli->pWin)->Show( TRUE, nFlags );
/*N*/ 						break;
/*N*/ 					default:
/*N*/                         pCli->pWin->Show( TRUE, nFlags );
/*N*/ 						break;
/*N*/ 				}
/*N*/ 
/*N*/ 				pCli->bSetFocus = FALSE;
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				switch ( pCli->pWin->GetType() )
/*N*/ 				{
/*N*/ 					case RSC_DOCKINGWINDOW :
/*N*/ 					case RSC_TOOLBOX :
/*?*/ 						((DockingWindow*)pCli->pWin)->Hide();
/*N*/ 						break;
/*N*/ 					default:
/*N*/ 						pCli->pWin->Hide();
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------


//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::ResetObjectBars_Impl()
/*N*/ {
/*N*/ 	USHORT n;
/*N*/ 	for ( n = 0; n < SFX_OBJECTBAR_MAX; ++n )
/*N*/ 	{
/*N*/ 		aObjBars[n].nId = 0;
/*N*/ 		aObjBarLists[n].aArr.Remove(0, aObjBarLists[n].aArr.Count() );
/*N*/ 		aObjBarLists[n].nAct = 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	for ( n = 0; n < pChildWins->Count(); ++n )
/*N*/ 		(*pChildWins)[n]->nId = 0;
/*N*/ 
/*N*/ //	if ( pParent )
/*N*/ //		pParent->ResetObjectBars_Impl();
/*N*/ }



//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::SetObjectBar_Impl( USHORT nPos, const ResId& rResId,
/*N*/ 			SfxInterface* pIFace, const String *pName)
/*N*/ {
/*N*/ 	DBG_ASSERT( (nPos & SFX_POSITION_MASK) < SFX_OBJECTBAR_MAX,
/*N*/ 				"object bar position overflow" );
/*N*/ 
/*N*/ 	USHORT nRealPos = nPos & SFX_POSITION_MASK;
/*N*/ 	if ( pParent && IsAppWorkWinToolbox_Impl( nRealPos ) )
/*N*/ 	{
/*?*/ 		pParent->SetObjectBar_Impl( nPos, rResId, pIFace, pName );
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxObjectBar_Impl& rObjBar = aObjBars[nRealPos];
/*N*/ 	rObjBar.pIFace = pIFace;
/*N*/ 	rObjBar.nId = rResId.GetId();
/*N*/ 	rObjBar.pResMgr = rResId.GetResMgr();
/*N*/ 	rObjBar.nMode = (nPos & SFX_VISIBILITY_MASK);
/*N*/ 	if (pName)
/*N*/ 		rObjBar.aName = *pName;
/*N*/ 	else
/*?*/ 		rObjBar.aName.Erase();
/*N*/ 
/*N*/ 	SfxObjectBarArr_Impl& rArr = aObjBarLists[nRealPos].aArr;
/*N*/ 	for ( USHORT n=0; n<rArr.Count(); n++ )
/*N*/ 	{
/*N*/ 		if ( rArr[n].nId == rObjBar.nId )
/*N*/ 		{
/*?*/ 			aObjBarLists[nRealPos].nAct = n;
/*?*/ 			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	rArr.Insert( rObjBar, 0 );
/*N*/ }

//------------------------------------------------------------------------


//------------------------------------------------------------------------

/*N*/ BOOL SfxWorkWindow::IsVisible_Impl( USHORT nMode ) const
/*N*/ {
/*N*/ 	switch( nUpdateMode )
/*N*/ 	{
/*N*/ 		case SFX_VISIBILITY_STANDARD:
/*N*/ 			return TRUE;
/*N*/ 		case SFX_VISIBILITY_UNVISIBLE:
/*N*/ 			return FALSE;
/*?*/ 		case SFX_VISIBILITY_PLUGSERVER:
/*?*/ 		case SFX_VISIBILITY_PLUGCLIENT:
/*?*/ 		case SFX_VISIBILITY_CLIENT:
/*?*/ 		case SFX_VISIBILITY_SERVER:
/*?*/ 			return !!(nMode & nUpdateMode);
/*?*/ 		default:
/*?*/ 			return !!(nMode & nOrigMode ) ||
/*?*/ 				nOrigMode == SFX_VISIBILITY_STANDARD;
/*N*/ 	}
/*N*/ }


//------------------------------------------------------------------------
/*N*/ void SfxFrameWorkWin_Impl::UpdateObjectBars_Impl()
/*N*/ {
/*N*/     if ( pFrame->IsClosing_Impl() )
/*N*/         return;
/*N*/ 
/*N*/ 	SfxWorkWindow *pWork = pParent;
/*N*/ 	while ( pWork )
/*N*/ 	{
/*?*/ 		pWork->SfxWorkWindow::UpdateObjectBars_Impl();
/*?*/ 		pWork = pWork->GetParent_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxWorkWindow::UpdateObjectBars_Impl();
/*N*/ 
/*N*/ //	if ( pTask->IsActive() )
/*N*/ 	{
/*N*/ 		pWork = pParent;
/*N*/ 		while ( pWork )
/*N*/ 		{
/*?*/ 			pWork->ArrangeChilds_Impl();
/*?*/ 			pWork = pWork->GetParent_Impl();
/*N*/ 		}
/*N*/ 
/*N*/ 		ArrangeChilds_Impl();
/*N*/ 
/*N*/ 		pWork = pParent;
/*N*/ 		while ( pWork )
/*N*/ 		{
/*?*/ 			pWork->ShowChilds_Impl();
/*?*/ 			pWork = pWork->GetParent_Impl();
/*N*/ 		}
/*N*/ 
/*N*/ 		ShowChilds_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( aStatBar.pStatusBar )
/*N*/ 	{
/*N*/ 		StatusBar *pBar = aStatBar.pStatusBar->GetStatusBar();
/*N*/ //        pBar->SetBottomBorder( FALSE );
/*N*/ 		pBar->SetPosSizePixel( 0, 0, 0, pBar->CalcWindowSizePixel().Height(), WINDOW_POSSIZE_HEIGHT );
/*N*/ 		ArrangeChilds_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	ShowChilds_Impl();
/*N*/ }

/*?*/ void SfxIPWorkWin_Impl::UpdateObjectBars_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ SfxStatusBarManager* SfxWorkWindow::GetStatusBarManager_Impl()
/*N*/ {
/*N*/ 	return aStatBar.pStatusBar;
/*N*/ }

//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::UpdateObjectBars_Impl()
/*N*/ {
/*N*/ 	// SplitWindows locken (d.h. Resize-Reaktion an den
/*N*/ 	// DockingWindows unterdr"ucken)
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		SfxSplitWindow *p = pSplit[n];
/*N*/ 		if (p->GetWindowCount())
/*N*/ 			p->Lock();
/*N*/ 	}
/*N*/ 
/*N*/ 	// was man so "ofters braucht, merkt man sich (spart Code und Laufzeit)
/*N*/ 	SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxToolBoxConfig *pTbxCfg = GetBindings().GetToolBoxConfig();
/*N*/ 
/*N*/ 	// "uber alle Toolbox-Positionen iterieren
/*N*/ 	for ( n = 0; n < SFX_OBJECTBAR_MAX; ++n )
/*N*/ 	{
/*N*/         SfxChild_Impl *&rpCli = (*pChilds)[TbxMatch(n)];
/*N*/ 
/*N*/ 		// Toolbox und/oder Id an der Position 'n'
/*N*/ 		USHORT nId = aObjBars[n].nId;
/*N*/ 		SfxToolBoxManager *&rpTbx = aObjBars[n].pTbx;
/*N*/ 		FASTBOOL bToolBoxVisible = pTbxCfg->IsToolBoxPositionVisible(n);
/*N*/ 
/*N*/ 		// die Modi bestimmen, f"ur die die ToolBox gilt
/*N*/ 		USHORT nTbxMode = aObjBars[n].nMode;
/*N*/ 		FASTBOOL bFullScreenTbx = SFX_VISIBILITY_FULLSCREEN ==
/*N*/ 					( nTbxMode & SFX_VISIBILITY_FULLSCREEN );
/*N*/ 		nTbxMode &= ~SFX_VISIBILITY_FULLSCREEN;
/*N*/ 		nTbxMode &= ~SFX_VISIBILITY_VIEWER;
/*N*/ 
/*N*/ 		// wird in diesem Kontext eine ToolBox gefordert?
/*N*/ 		FASTBOOL bModesMatching = nUpdateMode && ( nTbxMode & nUpdateMode) == nUpdateMode;
/*N*/ 		if ( nId != 0 && bToolBoxVisible == TRUE &&
/*N*/              ( ( bModesMatching && !bIsFullScreen ) ||
/*N*/                ( bIsFullScreen && bFullScreenTbx ) ) )
/*N*/ 		{
/*N*/ 			// keine oder falsche Toolbox an der Position 'n' vorhanden?
/*N*/ 			if ( !rpTbx || ( rpTbx && rpTbx->GetType() != nId ) )
/*N*/ 			{
/*N*/ 				// (falsche) Toolbox vorhanden?
/*N*/ 				if (rpTbx)
/*N*/ 				{
/*?*/ 					// dann Toolbox-Inhalt autauschen
/*?*/ 					rpTbx = new SfxToolBoxManager(
/*?*/ 									ResId( aObjBars[n].nId,
/*?*/ 										   aObjBars[n].pResMgr ),
/*?*/ 									aObjBars[n].pIFace,
/*?*/ 									aObjBars[n].aName,
/*?*/ 									rpTbx, pConfigShell);
/*?*/ 					rpCli->pWin = &rpTbx->GetToolBox();
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*N*/ 					// sonst Toolbox neu erzeugen
/*N*/ 					rpTbx = new SfxToolBoxManager( pWorkWin,
/*N*/ 									GetBindings(),
/*N*/ 									ResId( aObjBars[n].nId,
/*N*/ 										   aObjBars[n].pResMgr ),
/*N*/ 									aObjBars[n].pIFace,
/*N*/ 									n, pConfigShell );
/*N*/ 
/*N*/ 					rpTbx->Initialize();
/*N*/                     SfxToolbox& rTbx = (SfxToolbox&) rpTbx->GetToolBox();
/*N*/                     if ( !rpCli )
/*N*/                     {
/*N*/                         rpCli = new SfxChild_Impl( rTbx, Size(),
/*N*/                                 rTbx.IsFloatingMode() ? SFX_ALIGN_NOALIGNMENT : rTbx.GetAlignment(), TRUE );
/*N*/                     }
/*N*/                     else
/*N*/                     {
/*N*/                         rpCli->pWin = &rTbx;
/*N*/                     }
/*N*/ 
/*N*/ 					bSorted = FALSE;
/*N*/ 					nChilds++;
/*N*/                 }
/*N*/ 
/*N*/ 				// make toolbar keyboard accessible
/*N*/ 				pWorkWin->GetSystemWindow()->GetTaskPaneList()->AddWindow( &rpTbx->GetToolBox() );
/*N*/ 
/*N*/                 ToolBox& rTbx = rpTbx->GetToolBox();
/*N*/                 rTbx.SetText(aObjBars[n].aName);
/*N*/                 if ( rTbx.IsFloatingMode() )
/*?*/                     rpCli->aSize = rTbx.GetFloatingWindow()->GetSizePixel();
/*N*/                 else
/*N*/                 {
/*N*/                     rpCli->bResize = TRUE;
/*N*/                     rpCli->aSize = rTbx.GetSizePixel();
/*N*/                 }
/*N*/ 
/*N*/ 				// Schnelles Statusupdate wirkt optisch besser
/*N*/ 				rpTbx->UpdateControls_Impl();
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				ToolBox& rTbx = rpTbx->GetToolBox();
/*N*/ 				BOOL bWasFloating = rTbx.IsFloatingMode();
/*N*/ 				rpTbx->Reconfigure_Impl( pTbxCfg );
/*N*/ 				rTbx.SetText(aObjBars[n].aName);
/*N*/ 				String aNext;
/*N*/ 				rpTbx->GetNextToolBox_Impl( &aNext );
/*N*/ 				rTbx.SetNextToolBox( aNext );
/*N*/ 
/*N*/ 				if ( bWasFloating && !rTbx.IsFloatingMode() )
/*N*/ 				{
/*N*/ 					// Toolbox einer nicht aktiven Task wurde angedockt und
/*N*/ 					// jetzt wurde sie wieder aktiviert.
/*N*/ 					// Falls angedockte Toolboxen sichtbar sein sollen, mu\s
/*N*/ 					// sie geshowed werden, da sie vorher in HidePopups
/*N*/ 					// gehidet wurde
/*?*/ 					if ( IsDockingAllowed() && bAllChildsVisible )
/*?*/                         rpCli->nVisible |= CHILD_ACTIVE;
/*?*/                     if ( CHILD_VISIBLE == (rpCli->nVisible & CHILD_VISIBLE) )
/*?*/                         rTbx.Show( TRUE, SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE );
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			// ggf. Toolbox an dieser Position l"oschen
/*N*/ 			if (rpTbx)
/*N*/ 			{
/*?*/ 				rpTbx->StoreConfig();
/*?*/ 				pWorkWin->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( rpCli->pWin );
/*?*/                 rpCli->pWin = 0;
/*?*/ 				SfxToolBoxManager *p = rpTbx;
/*?*/ 				rpTbx = 0;
/*?*/ 				p->Delete();
/*?*/ 				bSorted = FALSE;
/*?*/ 				nChilds--;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( rpTbx && !IsDockingAllowed() )
/*N*/ 		{
/*N*/ 			// Presentation mode
/*?*/ 			if ( !rpTbx->GetToolBox().IsFloatingMode() )
/*?*/ 			{
/*?*/ 				// keine angedockten Toolboxen
/*?*/ 				pWorkWin->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( rpCli->pWin );
/*?*/                 rpCli->pWin = 0;
/*?*/ 				SfxToolBoxManager *p = rpTbx;
/*?*/ 				rpTbx = 0;
/*?*/ 				p->Delete();
/*?*/ 				bSorted = FALSE;
/*?*/ 				nChilds--;
/*?*/ 			}
/*?*/ 			else if( !bAllChildsVisible )
/*?*/ 				// angedockte Toolboxen bis zum Livemodus hiden
/*?*/                 rpCli->nVisible &= ~CHILD_ACTIVE;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	UpdateChildWindows_Impl();
/*N*/ 
/*N*/ 	// SplitWindows wieder ent-locken
/*N*/ 	for ( n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		SfxSplitWindow *p = pSplit[n];
/*N*/ 		if (p->GetWindowCount())
/*N*/ 			p->Lock(FALSE);
/*N*/ 	}
/*N*/ 
/*N*/ 	UpdateStatusBar_Impl();
/*N*/ }

/*N*/ void SfxWorkWindow::UpdateChildWindows_Impl()
/*N*/ {
/*N*/ 	// alle vorhandenen oder in den Kontext gekommenen ChildWindows
/*N*/ 	for ( USHORT n=0; n<pChildWins->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxChildWin_Impl *pCW = (*pChildWins)[n];
/*N*/ 		SfxChildWindow *pChildWin = pCW->pWin;
/*N*/ 		BOOL bCreate = FALSE;
/*N*/ 		if ( pCW->nId && !pCW->bDisabled  && IsVisible_Impl( pCW->nVisibility ) )
/*N*/ 		{
/*N*/ 			// Im Kontext ist ein geeignetes ChildWindow erlaubt;
/*N*/ 			// ist es auch eingeschaltet ?
/*N*/ 			if ( pChildWin == 0 && pCW->bCreate )
/*N*/ 			{
/*N*/                 if ( !IsDockingAllowed() || bIsFullScreen )
/*N*/ 				{
/*N*/ 					// im PresentationMode oder FullScreen nur FloatingWindows
/*N*/ 					SfxChildAlignment eAlign;
/*?*/						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 					if ( pCW->aInfo.GetExtraData_Impl( &eAlign ) )
/*N*/ 				}
/*N*/ 				else
/*N*/ 					bCreate = TRUE;
/*N*/ 
/*N*/ 				// Momentan kein Fenster da, aber es ist eingeschaltet; Fenster
/*N*/ 				// und ggf. Context erzeugen
/*N*/ 				if ( bCreate )
/*N*/ 					CreateChildWin_Impl( pCW, FALSE );
/*N*/ 
/*N*/ 				if ( !bAllChildsVisible )
/*N*/ 				{
/*?*/ 					if ( pCW->pCli )
/*?*/ 						pCW->pCli->nVisible &= ~CHILD_ACTIVE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			else if ( pChildWin )
/*N*/ 			{
/*N*/ 				// Fenster existiert schon; soll es auch sichtbar sein ?
/*N*/                 if ( ( !bIsFullScreen || pChildWin->GetAlignment() == SFX_ALIGN_NOALIGNMENT ) && bAllChildsVisible )
/*N*/ 				{
/*N*/ 					// Updatemode ist kompatibel; auf jeden Fall wieder einschalten
/*N*/ 					bCreate = TRUE;
/*N*/ 					if ( pCW->pCli )
/*N*/ 					{
/*N*/ 						// Fenster ist direktes Child
/*N*/ 						if ( bAllChildsVisible && ( IsDockingAllowed() || pCW->pCli->eAlign == SFX_ALIGN_NOALIGNMENT ) )
/*N*/                             pCW->pCli->nVisible |= CHILD_NOT_HIDDEN;
/*N*/ 					}
/*N*/ 					else if ( pCW->bCreate && IsDockingAllowed() )
/*N*/ 						// Fenster liegt in einem SplitWindow
/*N*/ 						((SfxDockingWindow*)pChildWin->GetWindow())->Reappear_Impl();
/*N*/ 
/*N*/ 					if ( pCW->nInterfaceId != pChildWin->GetContextId() )
/*?*/					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 						pChildWin->CreateContext( pCW->nInterfaceId, GetBindings() );
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pChildWin && !bCreate )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void SfxWorkWindow::CreateChildWin_Impl( SfxChildWin_Impl *pCW, BOOL bSetFocus )
/*N*/ {
/*N*/ 	if ( pCW->aInfo.bVisible != 42 )
/*N*/ 		pCW->aInfo.bVisible = TRUE;
/*N*/ 
/*N*/     SfxChildWindow *pChildWin = SfxChildWindow::CreateChildWindow( pCW->nId, pWorkWin, &GetBindings(), pCW->aInfo);
/*N*/ 	if (pChildWin)
/*N*/ 	{
/*?*/ 		if ( bSetFocus )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 bSetFocus = pChildWin->WantsFocus();
/*N*/ 		pChildWin->SetWorkWindow_Impl( this );
/*N*/ #if 0
/*N*/ 		// Enable-Status richtig setzen
/*N*/ 		pChildWin->GetWindow()->EnableInput( pCW->bEnable &&
/*N*/             ( pWorkWin->IsInputEnabled() /* || pChildWin->GetAlignment() == SFX_ALIGN_NOALIGNMENT */ ) );
/*N*/ #endif
/*N*/ 		// Zumindest der ExtraString wird beim Auswerten ver"andert, also neu holen
/*N*/ 		BOOL bTask = ( pCW->aInfo.nFlags & SFX_CHILDWIN_TASK ) != 0;
/*N*/         SfxChildWinInfo aInfo = pChildWin->GetInfo();
/*N*/         pCW->aInfo.aExtraString = aInfo.aExtraString;
/*N*/         pCW->aInfo.bVisible = aInfo.bVisible;
/*N*/         pCW->aInfo.nFlags = aInfo.nFlags;
/*N*/ 		if ( bTask )
/*N*/ 			pCW->aInfo.nFlags |= SFX_CHILDWIN_TASK;
/*N*/ 
/*N*/ 		// Nein !! Sonst kann man keine Fenster defaultmaessig ausschalten ( Partwindow! )
/*N*/ //		pCW->aInfo.bVisible = TRUE;
/*N*/ 
/*N*/ 		// Erzeugung war erfolgreich
/*N*/ 		GetBindings().Invalidate(pCW->nId);
/*N*/ 
/*N*/ 		USHORT nPos = pChildWin->GetPosition();
/*N*/ 		if (nPos != CHILDWIN_NOPOS)
/*N*/ 		{
/*?*/ 			DBG_ASSERT(nPos < SFX_OBJECTBAR_MAX, "Illegal objectbar position!");
/*?*/ 			if ((*pChilds)[TbxMatch(nPos)])// &&
/*?*/ //							  pChildWin->GetAlignment() == (*pChilds)[nPos]->eAlign )
/*?*/ 			{
/*?*/ 				// ChildWindow ersetzt ObjectBar
/*?*/ 				(*pChilds)[TbxMatch(nPos)]->nVisible ^= CHILD_NOT_HIDDEN;
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		// make childwin keyboard accessible
/*N*/ 		pWorkWin->GetSystemWindow()->GetTaskPaneList()->AddWindow( pChildWin->GetWindow() );
/*N*/ 
/*N*/ 		pCW->pWin = pChildWin;
/*N*/ 
/*N*/ 		if ( pChildWin->GetAlignment() == SFX_ALIGN_NOALIGNMENT || pChildWin->GetWindow()->GetParent() == pWorkWin)
/*N*/ 		{
/*N*/ 			// Das Fenster ist entweder nicht angedockt oder au\serhalb
/*N*/ 			// eines SplitWindows angedockt und mu\s daher explizit als
/*N*/ 			// Child registriert werden
/*N*/ 			pCW->pCli = RegisterChild_Impl(*(pChildWin->GetWindow()), pChildWin->GetAlignment(), pChildWin->CanGetFocus());
/*N*/ 			pCW->pCli->nVisible = CHILD_VISIBLE;
/*N*/             if ( pChildWin->GetAlignment() != SFX_ALIGN_NOALIGNMENT && bIsFullScreen )
/*?*/ 				pCW->pCli->nVisible ^= CHILD_ACTIVE;
/*N*/ 			pCW->pCli->bSetFocus = bSetFocus;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			// Ein angedocktes Fenster, dessen Parent nicht das WorkWindow ist,
/*N*/ 			// mu\s in einem SplitWindow liegen und daher nicht explizit
/*N*/ 			// registriert werden.
/*N*/ 			// Das passiert aber schon bei der Initialisierung des
/*N*/ 			// SfxDockingWindows!
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pCW->nInterfaceId != pChildWin->GetContextId() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pChildWin->CreateContext( pCW->nInterfaceId, GetBindings() );
/*N*/ 
/*N*/ 		// Information in der INI-Datei sichern
/*N*/ 		SaveStatus_Impl(pChildWin, pCW->aInfo);
/*N*/ 	}
/*N*/ }


/*N*/ void SfxWorkWindow::ResetStatusBar_Impl()
/*N*/ {
/*N*/ 	aStatBar.nId = 0;
/*N*/ 	aStatBar.pShell = NULL;
/*N*/ 	aStatBar.pBindings = NULL;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxWorkWindow::SetStatusBar_Impl( const ResId& rResId, SfxShell *pSh, SfxBindings& rBindings )
/*N*/ {
/*N*/ 	if ( rResId.GetId() )
/*N*/ 	{
/*N*/ 		aStatBar.nId = rResId.GetId();
/*N*/ 		aStatBar.pShell = pSh;
/*N*/ 		aStatBar.pBindings = &rBindings;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxWorkWindow::SetTempStatusBar_Impl( BOOL bSet )
/*N*/ {
/*N*/ 	if ( aStatBar.bTemp != bSet )
/*N*/ 	{
/*N*/ 		BOOL bOn = FALSE;
/*N*/         SfxToolBoxConfig *pTbxCfg = GetBindings().GetToolBoxConfig();
/*N*/         BOOL bReset = FALSE;
/*N*/         if ( bSet && !aStatBar.nId )
/*N*/         {
/*N*/             bReset = TRUE;
/*N*/             SetStatusBar_Impl( SfxResId(SFX_ITEMTYPE_STATBAR), SFX_APP(), GetBindings() );
/*N*/         }
/*N*/ 
/*N*/         if ( aStatBar.nId && aStatBar.bOn && !bIsFullScreen && ( !pTbxCfg || pTbxCfg->IsStatusBarVisible() ) )
/*N*/ 			bOn = TRUE;
/*N*/ 
/*N*/ 		aStatBar.bTemp = bSet;
/*N*/         if ( !bOn || bReset || (!bSet && aStatBar.nId ) )
/*N*/ 		{
/*N*/ 			if ( aStatBar.pStatusBar && !aStatBar.pStatusBar->GetBindings_Impl() )
/*N*/ 			{
/*N*/ 				DBG_ERROR( "Kaputte Statusbar-Bindings!" );
/*N*/ 				return;
/*N*/ 			}
/*N*/ 
/*N*/ 			// Nur was tun, wenn die Temp-Einstellung wirklich was bewirkt
/*N*/ 			UpdateStatusBar_Impl();
/*N*/ 			ArrangeChilds_Impl();
/*N*/ 
/*N*/ 			if ( aStatBar.pStatusBar )
/*N*/ 			{
/*N*/ 				StatusBar *pBar = aStatBar.pStatusBar->GetStatusBar();
/*N*/ 				pBar->SetBottomBorder( TRUE );
/*N*/ 				pBar->SetPosSizePixel( 0, 0, 0, pBar->CalcWindowSizePixel().Height(), WINDOW_POSSIZE_HEIGHT );
/*N*/ 				ArrangeChilds_Impl();
/*N*/ 			}
/*N*/ 
/*N*/ 			ShowChilds_Impl();
/*N*/ 		}
/*N*/ 
/*N*/         if ( bReset )
/*N*/             ResetStatusBar_Impl();
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::UpdateStatusBar_Impl()
/*N*/ {
/*N*/ 	// Die aktuelle Statusleiste
/*N*/ 	StatusBar *pBar = NULL;
/*N*/     SfxToolBoxConfig *pTbxCfg = GetBindings().GetToolBoxConfig();
/*N*/ 
/*N*/ 	// Falls schon eine StatusBar existiert: ist es die gew"unschte?
/*N*/ 	USHORT nActId = 0;
/*N*/ 	if ( aStatBar.pStatusBar )
/*N*/ 	{
/*N*/ 		pBar = aStatBar.pStatusBar->GetStatusBar();
/*N*/ 		nActId = aStatBar.pStatusBar->GetType();
/*N*/ 	}
/*N*/ 
/*N*/     if ( nActId && aStatBar.bTemp )
/*N*/         return;
/*N*/ 
/*N*/ 	// keine Statusleiste, wenn keine Id gew"unscht oder bei FullScreenView
/*N*/ 	// oder wenn ausgeschaltet
/*N*/ 	if ( aStatBar.nId && IsDockingAllowed() &&
/*N*/             ( aStatBar.bOn && !bIsFullScreen && ( !pTbxCfg || pTbxCfg->IsStatusBarVisible() ) || aStatBar.bTemp ) )
/*N*/ 	{
/*N*/ 		if ( aStatBar.nId != nActId || aStatBar.pStatusBar && aStatBar.pStatusBar->GetBindings_Impl() != aStatBar.pBindings )
/*N*/ 		{
/*N*/ 			// Id hat sich ge"andert, also passenden Statusbarmanager erzeugen,
/*N*/ 			// dieser "ubernimmt die aktuelle Statusleiste;
/*N*/ 			if ( aStatBar.pStatusBar )
/*N*/ 			{
/*N*/ 				// Der Manager erzeugt die Statusleiste nur, er zerst"ort sie
/*N*/ 				// nicht !
/*?*/ 				aStatBar.pStatusBar->StoreConfig();
/*?*/ 				DELETEZ( aStatBar.pStatusBar );
/*N*/ 			}
/*N*/ 
/*N*/ 			aStatBar.pStatusBar = new SfxStatusBarManager(
/*N*/                 GetWindow(),
/*N*/                 *aStatBar.pBindings,
/*N*/                 aStatBar.pShell,
/*N*/                 aStatBar.pBindings->GetConfigManager( aStatBar.nId ),
/*N*/                 aStatBar.nId, pBar );
/*N*/ 
/*N*/ 			if ( !pBar )
/*N*/ 			{
/*N*/ 				pBar = aStatBar.pStatusBar->GetStatusBar();
/*N*/ 				RegisterChild_Impl( *pBar, SFX_ALIGN_LOWESTBOTTOM );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if ( nActId )
/*N*/ 	{
/*N*/ 		// Aktuelle StatusBar vernichten
/*N*/ 		// Der Manager erzeugt die Statusleiste nur, er zerst"ort sie
/*N*/ 		// nicht !
/*N*/ 		aStatBar.pStatusBar->StoreConfig();
/*N*/ 		ReleaseChild_Impl( *pBar );
/*N*/ 		DELETEZ( aStatBar.pStatusBar );
/*N*/ 		DELETEZ( pBar );
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------



//------------------------------------------------------------------------
/*N*/ void SfxWorkWindow::HidePopups_Impl(BOOL bHide, BOOL bParent, USHORT nId )
/*N*/ {
/*N*/     if ( nId && pChilds->Count() )
/*N*/ 	{
/*N*/ 		for ( USHORT n = 0; n < SFX_OBJECTBAR_MAX; ++n )
/*N*/ 		{
/*N*/             SfxChild_Impl *pCli = (*pChilds)[TbxMatch(n)];
/*N*/             if ( pCli && pCli->eAlign == SFX_ALIGN_NOALIGNMENT )
/*N*/ 			{
/*?*/                 BOOL bHasTbx = ( aObjBars[n].pTbx != 0 );
/*?*/ 				if (bHide)
/*?*/ 				{
/*?*/ 					pCli->nVisible &= ~CHILD_ACTIVE;
/*?*/                     if ( bHasTbx )
/*?*/                         aObjBars[n].pTbx->GetToolBox().Hide();
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					pCli->nVisible |= CHILD_ACTIVE;
/*?*/                     if ( bHasTbx && CHILD_VISIBLE == (pCli->nVisible & CHILD_VISIBLE) )
/*?*/                         aObjBars[n].pTbx->GetToolBox().Show( TRUE, SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE );
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	for ( USHORT n = 0; n < pChildWins->Count(); ++n )
/*N*/ 	{
/*N*/ 		SfxChildWindow *pCW = (*pChildWins)[n]->pWin;
/*N*/ 		if (pCW && pCW->GetAlignment() == SFX_ALIGN_NOALIGNMENT && pCW->GetType() != nId)
/*N*/ 		{
/*N*/ 			Window *pWin = pCW->GetWindow();
/*N*/ 			SfxChild_Impl *pChild = FindChild_Impl(*pWin);
/*N*/ 			if (bHide)
/*N*/ 			{
/*N*/ 				pChild->nVisible &= ~CHILD_ACTIVE;
/*N*/ 				pCW->Hide();
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				pChild->nVisible |= CHILD_ACTIVE;
/*N*/ 				if ( CHILD_VISIBLE == (pChild->nVisible & CHILD_VISIBLE) )
/*N*/                     pCW->Show( SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bParent && pParent )
/*?*/ 		pParent->HidePopups_Impl( bHide, bParent, nId );
/*N*/ }

//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::ConfigChild_Impl(SfxChildIdentifier eChild,
/*N*/ 			SfxDockingConfig eConfig, USHORT nId)
/*N*/ {
/*N*/ 	SfxDockingWindow* pDockWin=0;
/*N*/ 	SfxToolbox *pBox=0;
/*N*/ 	USHORT nPos = USHRT_MAX;
/*N*/ 	Window *pWin=0;
/*N*/ 	SfxChildWin_Impl *pCW = 0;
/*N*/ 
/*N*/     if ( eChild == SFX_CHILDWIN_OBJECTBAR )
/*N*/ 	{
/*N*/         // configure toolbar
/*N*/ 		USHORT n;
/*N*/ 		for (n=0; n<SFX_OBJECTBAR_MAX; n++)
/*N*/ 		{
/*N*/ 			if (aObjBars[n].nId == nId && aObjBars[n].pTbx)
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/         DBG_ASSERT( pParent || n<SFX_OBJECTBAR_MAX, "Unknown toolbox!" );
/*N*/ 		if (n>=SFX_OBJECTBAR_MAX)
/*N*/ 		{
/*?*/ 			if (pParent)
/*?*/ 				pParent->ConfigChild_Impl( eChild, eConfig, nId );
/*?*/ 			return;
/*N*/ 		}
/*N*/ 
/*N*/ 		pWin = pBox = (SfxToolbox*) &aObjBars[n].pTbx->GetToolBox();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/         // configure direct childwindow
/*N*/ 		for (USHORT n=0; n<pChildWins->Count(); n++)
/*N*/ 		{
/*N*/ 			pCW = (*pChildWins)[n];
/*N*/ 			SfxChildWindow *pChild = pCW->pWin;
/*N*/             if ( pChild )
/*N*/ 			{
/*N*/                 if ( pChild->GetType() == nId )
/*N*/ 				{
/*N*/                     if ( pChild->GetWindow()->GetType() == RSC_DOCKINGWINDOW )
/*N*/                         // it's a DockingWindow
/*N*/                         pDockWin = (SfxDockingWindow*) pChild->GetWindow();
/*N*/                     else
/*N*/                         // FloatingWindow or ModelessDialog
/*?*/                         pWin = pChild->GetWindow();
/*N*/ 					break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pDockWin )
/*N*/ 		{
/*N*/             if ( eChild == SFX_CHILDWIN_DOCKINGWINDOW || pDockWin->GetAlignment() == SFX_ALIGN_NOALIGNMENT )
/*N*/ 			{
/*N*/ 				if ( eChild == SFX_CHILDWIN_SPLITWINDOW && eConfig == SFX_TOGGLEFLOATMODE)
/*N*/ 				{
/*N*/                     // DockingWindow was dragged out of a SplitWindow
/*?*/                     pCW->pCli = RegisterChild_Impl(*pDockWin, pDockWin->GetAlignment(), pCW->pWin->CanGetFocus());
/*?*/ 					pCW->pCli->nVisible = CHILD_VISIBLE;
/*N*/ 				}
/*N*/ 
/*N*/ 				pWin = pDockWin;
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*?*/ 				SfxSplitWindow *pSplitWin = GetSplitWindow_Impl(pDockWin->GetAlignment());
/*?*/ 
/*?*/                 // configure DockingWindow inside a SplitWindow
/*?*/ 				if ( eConfig == SFX_TOGGLEFLOATMODE)
/*?*/ 				{
/*?*/                     // DockingWindow was dragged into a SplitWindow
/*?*/ 					pCW->pCli = 0;
/*?*/ 					ReleaseChild_Impl(*pDockWin);
/*?*/ 				}
/*?*/ 
/*?*/ 				pWin = pSplitWin->GetSplitWindow();
/*?*/ 				if ( pSplitWin->GetWindowCount() == 1 )
/*?*/                     ((SplitWindow*)pWin)->Show( TRUE, SHOW_NOFOCUSCHANGE | SHOW_NOACTIVATE );
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/         DBG_ASSERT( pCW, "Unknown window!" );
/*N*/         if ( !pCW && pParent )
/*N*/ 		{
/*?*/ 			pParent->ConfigChild_Impl( eChild, eConfig, nId );
/*?*/ 			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     if ( !bSorted )
/*N*/         // windows may have been registered and released without an update until now
/*N*/ 		Sort_Impl();
/*N*/ 
/*N*/ 	SfxChild_Impl *pChild = 0;
/*N*/ 	USHORT n;
/*N*/ 	for ( n=0; n<aSortedList.Count(); ++n )
/*N*/ 	{
/*N*/ 		pChild = (*pChilds)[aSortedList[n]];
/*N*/ 		if ( pChild )
/*N*/ 			if ( pChild->pWin == pWin )
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/     if ( n < aSortedList.Count() )
/*N*/         // sometimes called while toggeling float mode
/*N*/         nPos = aSortedList[n];
/*N*/ 
/*N*/ 	switch ( eConfig )
/*N*/ 	{
/*N*/ 		case SFX_SETDOCKINGRECTS :
/*N*/ 		{
/*?*/             if ( nPos == USHRT_MAX )
/*?*/                 return;
/*?*/ 
/*?*/ 			SfxChild_Impl *pChild = (*pChilds)[nPos];
/*?*/ 			Rectangle aOuterRect( GetTopRect_Impl() );
/*?*/             aOuterRect.SetPos( pWorkWin->OutputToScreenPixel( aOuterRect.TopLeft() ));
/*?*/             Rectangle aInnerRect( aOuterRect );
/*?*/ 			BOOL bTbx = (eChild == SFX_CHILDWIN_OBJECTBAR);
/*?*/ 
/*?*/ 			// Das gerade betroffene Fenster wird bei der Berechnung des
/*?*/ 			// inneren Rechtecks mit eingeschlossen!
/*?*/ 			for ( USHORT m=0; m<aSortedList.Count(); ++m )
/*?*/ 			{
/*?*/ 				USHORT n=aSortedList[m];
/*?*/ 				SfxChild_Impl* pCli = (*pChilds)[n];
/*?*/ 
/*?*/                 if ( pCli && pCli->nVisible == CHILD_VISIBLE && pCli->pWin )
/*?*/ 				{
/*?*/ 					switch ( pCli->eAlign )
/*?*/ 					{
/*?*/ 						case SFX_ALIGN_TOP:
/*?*/ 							// Objekt-Toolboxen kommen immer zuletzt
/*?*/ 							//if ( bTbx || n <= nPos)
/*?*/ 								aInnerRect.Top() += pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_TOOLBOXTOP:
/*?*/ 							// Toolbox geht nur vor, wenn nicht h"ohere Position
/*?*/ 							if ( bTbx && n <= nPos)
/*?*/ 								aInnerRect.Top() += pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_HIGHESTTOP:
/*?*/ 							// Geht immer vor
/*?*/ 							aInnerRect.Top() += pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_LOWESTTOP:
/*?*/ 							// Wird nur mitgez"ahlt, wenn es das aktuelle Fenster ist
/*?*/ 							if ( n == nPos )
/*?*/ 								aInnerRect.Top() += pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_BOTTOM:
/*?*/ 							// Objekt-Toolboxen kommen immer zuletzt
/*?*/ 							//if ( bTbx || n <= nPos)
/*?*/ 								aInnerRect.Bottom() -= pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_TOOLBOXBOTTOM:
/*?*/ 							// Toolbox geht nur vor, wenn nicht h"ohere Position
/*?*/ 							if ( bTbx && n <= nPos)
/*?*/ 								aInnerRect.Bottom() -= pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_LOWESTBOTTOM:
/*?*/ 							// Geht immer vor
/*?*/ 							aInnerRect.Bottom() -= pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_HIGHESTBOTTOM:
/*?*/ 							// Wird nur mitgez"ahlt, wenn es das aktuelle Fenster ist
/*?*/ 							if ( n == nPos )
/*?*/ 								aInnerRect.Bottom() -= pCli->aSize.Height();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_LEFT:
/*?*/ 							// Toolboxen kommen immer zuletzt
/*?*/ 							//if (bTbx || n <= nPos)
/*?*/ 								aInnerRect.Left() += pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_TOOLBOXLEFT:
/*?*/ 							// Toolboxen kommen immer zuletzt
/*?*/ 							if (bTbx && n <= nPos)
/*?*/ 								aInnerRect.Left() += pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_FIRSTLEFT:
/*?*/ 							// Geht immer vor
/*?*/ 							aInnerRect.Left() += pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_LASTLEFT:
/*?*/ 							// Wird nur mitgez"ahlt, wenn es das aktuelle Fenster ist
/*?*/ 							if (n == nPos)
/*?*/ 								aInnerRect.Left() += pCli->aSize.Width();
/*?*/ 
/*?*/ 						case SFX_ALIGN_RIGHT:
/*?*/ 							// Toolboxen kommen immer zuletzt
/*?*/ 							//if (bTbx || n <= nPos)
/*?*/ 								aInnerRect.Right() -= pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_TOOLBOXRIGHT:
/*?*/ 							// Toolboxen kommen immer zuletzt
/*?*/ 							if (bTbx && n <= nPos)
/*?*/ 								aInnerRect.Right() -= pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_FIRSTRIGHT:
/*?*/ 							// Wird nur mitgez"ahlt, wenn es das aktuelle Fenster ist
/*?*/ 							if (n == nPos)
/*?*/ 								aInnerRect.Right() -= pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						case SFX_ALIGN_LASTRIGHT:
/*?*/ 							// Geht immer vor
/*?*/ 							aInnerRect.Right() -= pCli->aSize.Width();
/*?*/ 							break;
/*?*/ 
/*?*/ 						default:
/*?*/ 							break;
/*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/             if ( pBox )
/*?*/ 				pBox->SetDockingRects(aOuterRect, aInnerRect);
/*?*/ 			else
/*?*/ 				pDockWin->SetDockingRects(aOuterRect, aInnerRect);
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		case SFX_MOVEDOCKINGWINDOW :
/*N*/ 		case SFX_ALIGNDOCKINGWINDOW :
/*N*/ 		case SFX_TOGGLEFLOATMODE:
/*N*/ 		{
/*N*/             if ( nPos == USHRT_MAX && !pCW )
/*N*/                 return;
/*N*/ 
/*N*/             SfxChildAlignment eAlign = SFX_ALIGN_NOALIGNMENT;
/*N*/             SfxChild_Impl *pCli = ( nPos != USHRT_MAX ) ? (*pChilds)[nPos] : 0;
/*N*/             if ( pBox )
/*N*/ 			{
/*N*/ 				if ( pBox->IsFloatingMode() )
/*N*/ 				{
/*?*/ 					eAlign = SFX_ALIGN_NOALIGNMENT;
/*?*/ 					pCli->aSize = pBox->GetFloatingWindow()->GetSizePixel();
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					eAlign = pBox->GetAlignment();
/*N*/ 					pCli->bResize = TRUE;
/*N*/ 					Size aActSize( pBox->GetSizePixel() );
/*N*/ 					pCli->aSize = pBox->CalcWindowSizePixel();
/*N*/ 					if ( pBox->IsHorizontal() )
/*N*/ 						pCli->aSize.Width() = aActSize.Width();
/*N*/ 					else
/*N*/ 						pCli->aSize.Height() = aActSize.Height();
/*N*/ 				}
/*N*/ 			}
/*N*/             else if ( pCli && pDockWin )
/*N*/ 			{
/*N*/ 				eAlign = pDockWin->GetAlignment();
/*N*/                 if ( eChild == SFX_CHILDWIN_DOCKINGWINDOW || eAlign == SFX_ALIGN_NOALIGNMENT)
/*N*/ 				{
/*N*/                     // configuration inside the SplitWindow, no change for the SplitWindows' configuration
/*N*/ 					pCli->bResize = TRUE;
/*N*/ 					pCli->aSize = pDockWin->GetSizePixel();
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/             if ( pCli )
/*N*/             {
/*N*/                 if( pCli->eAlign != eAlign )
/*N*/                 {
/*?*/                     bSorted = FALSE;
/*?*/                     pCli->eAlign = eAlign;
/*N*/                 }
/*N*/ 
/*N*/                 ArrangeChilds_Impl();
/*N*/                 ShowChilds_Impl();
/*N*/             }
/*N*/ 
/*N*/             if ( pCW && pCW->pWin )
/*N*/ 			{
/*N*/                 // store changed configuration
/*N*/ 				BOOL bTask = ( pCW->aInfo.nFlags & SFX_CHILDWIN_TASK ) != 0;
/*N*/ 				pCW->aInfo = pCW->pWin->GetInfo();
/*N*/ 				if ( bTask )
/*?*/ 					pCW->aInfo.nFlags |= SFX_CHILDWIN_TASK;
/*N*/ 				if ( eConfig != SFX_MOVEDOCKINGWINDOW )
/*N*/ 					SaveStatus_Impl( pCW->pWin, pCW->aInfo);
/*N*/ 			}
/*N*/ 
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }


//--------------------------------------------------------------------

/*N*/ void SfxWorkWindow::SetChildWindowVisible_Impl( ULONG lId, BOOL bEnabled, USHORT nMode )
/*N*/ {
/*N*/ 	USHORT nInter = (USHORT) ( lId >> 16 );
/*N*/ 	USHORT nId = (USHORT) ( lId & 0xFFFF );
/*N*/ 
/*N*/ 	SfxChildWin_Impl *pCW=NULL;
/*N*/ 	SfxWorkWindow *pWork = pParent;
/*N*/ 
/*N*/ 	// Den obersten parent nehmen; ChildWindows werden immer am WorkWindow
/*N*/ 	// der Task bzw. des Frames oder am AppWorkWindow angemeldet
/*N*/ 	while ( pWork && pWork->pParent )
/*?*/ 		pWork = pWork->pParent;
/*N*/ 
/*N*/ 	if ( pWork )
/*N*/ 	{
/*N*/ 		// Dem Parent schon bekannt ?
/*?*/ 		USHORT nCount = pWork->pChildWins->Count();
/*?*/ 		for (USHORT n=0; n<nCount; n++)
/*?*/ 			if ((*pWork->pChildWins)[n]->nSaveId == nId)
/*?*/ 			{
/*?*/ 				pCW = (*pWork->pChildWins)[n];
/*?*/ 				break;
/*?*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pCW )
/*N*/ 	{
/*N*/ 		// Kein Parent oder dem Parent noch unbekannt, dann bei mir suchen
/*N*/ 		USHORT nCount = pChildWins->Count();
/*N*/ 		for (USHORT n=0; n<nCount; n++)
/*N*/ 			if ((*pChildWins)[n]->nSaveId == nId)
/*N*/ 			{
/*N*/ 				pCW = (*pChildWins)[n];
/*N*/ 				break;
/*N*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pCW )
/*N*/ 	{
/*N*/ 		// Ist neu, also initialisieren; je nach Flag beim Parent oder bei
/*N*/ 		// mir eintragen
/*N*/ 		pCW = new SfxChildWin_Impl( lId );
/*N*/ 		pCW->nId = nId;
/*N*/ 		InitializeChild_Impl( pCW );
/*N*/ 		if ( pWork && !( pCW->aInfo.nFlags & SFX_CHILDWIN_TASK ) )
/*?*/ 			pWork->pChildWins->Insert( pWork->pChildWins->Count(), pCW );
/*N*/ 		else
/*N*/ 			pChildWins->Insert( pChildWins->Count(), pCW );
/*N*/ 	}
/*N*/ 
/*N*/ 	pCW->nId = nId;
/*N*/ 	if ( nInter )
/*N*/ 		pCW->nInterfaceId = nInter;
/*N*/ 	pCW->nVisibility = nMode;
/*N*/ 	pCW->bEnable = bEnabled;
/*N*/ #if 0
/*N*/ 	if ( pCW->pWin )
/*N*/ 		pCW->pWin->GetWindow()->EnableInput( bEnabled &&
/*N*/             ( pWorkWin->IsInputEnabled() /* || pCW->pWin->GetAlignment() == SFX_ALIGN_NOALIGNMENT */ ) );
/*N*/ #endif
/*N*/ 	pCW->nVisibility = nMode;
/*N*/ }

//--------------------------------------------------------------------
// Der An/Aus-Status eines ChildWindows wird umgeschaltet.


//--------------------------------------------------------------------

/*N*/ BOOL SfxWorkWindow::HasChildWindow_Impl(USHORT nId)
/*N*/ {
/*N*/ 	USHORT nCount = pChildWins->Count();
/*N*/ 	USHORT n;
/*N*/ 	for (n=0; n<nCount; n++)
/*N*/ 		if ((*pChildWins)[n]->nSaveId == nId)
/*N*/ 			break;
/*N*/ 
/*N*/ 	if (n<nCount)
/*N*/ 	{
/*N*/ 		SfxChildWin_Impl *pCW = (*pChildWins)[n];
/*N*/ 		SfxChildWindow *pChild = pCW->pWin;
/*N*/ 		return ( pChild && pCW->bCreate );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pParent )
/*?*/ 		return pParent->HasChildWindow_Impl( nId );
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }

/*N*/ BOOL SfxWorkWindow::IsFloating( USHORT nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE; //STRIP001 
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxWorkWindow::KnowsChildWindow_Impl(USHORT nId)
/*N*/ {
/*N*/ 	SfxChildWin_Impl *pCW=0;
/*N*/ 	USHORT nCount = pChildWins->Count();
/*N*/ 	USHORT n;
/*N*/ 	for (n=0; n<nCount; n++)
/*N*/ 	{
/*N*/ 		pCW = (*pChildWins)[n];
/*N*/ 		if ( pCW->nSaveId == nId)
/*N*/ 			 break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (n<nCount)
/*N*/ 	{
/*N*/ 		if ( !IsVisible_Impl(  pCW->nVisibility ) )
/*N*/ 			return FALSE;
/*N*/ 		return pCW->bEnable;
/*N*/ 	}
/*N*/ 	else if ( pParent )
/*?*/ 		return pParent->KnowsChildWindow_Impl( nId );
/*N*/ 	else
/*N*/ 		return FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxWorkWindow::SetChildWindow_Impl(USHORT nId, BOOL bOn, BOOL bSetFocus)
/*N*/ {
/*N*/ 	SfxChildWin_Impl *pCW=NULL;
/*N*/ 	SfxWorkWindow *pWork = pParent;
/*N*/ 
/*N*/ 	// Den obersten parent nehmen; ChildWindows werden immer am WorkWindow
/*N*/ 	// der Task bzw. des Frames oder am AppWorkWindow angemeldet
/*N*/ 	while ( pWork && pWork->pParent )
/*?*/ 		pWork = pWork->pParent;
/*N*/ 
/*N*/ 	if ( pWork )
/*N*/ 	{
/*N*/ 		// Dem Parent schon bekannt ?
/*?*/ 		USHORT nCount = pWork->pChildWins->Count();
/*?*/ 		for (USHORT n=0; n<nCount; n++)
/*?*/ 			if ((*pWork->pChildWins)[n]->nSaveId == nId)
/*?*/ 			{
/*?*/ 				pCW = (*pWork->pChildWins)[n];
/*?*/ 				break;
/*N*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pCW )
/*N*/ 	{
/*N*/ 		// Kein Parent oder dem Parent noch unbekannt, dann bei mir suchen
/*N*/ 		USHORT nCount = pChildWins->Count();
/*N*/ 		for (USHORT n=0; n<nCount; n++)
/*N*/ 			if ((*pChildWins)[n]->nSaveId == nId)
/*N*/ 			{
/*N*/ 				pCW = (*pChildWins)[n];
/*N*/ 				pWork = this;
/*N*/ 				break;
/*N*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pCW )
/*N*/ 	{
/*N*/ 		// Ist neu, also initialisieren; je nach Flag beim Parent oder bei
/*N*/ 		// mir eintragen
/*N*/ 		pCW = new SfxChildWin_Impl( nId );
/*N*/ 		InitializeChild_Impl( pCW );
/*N*/ 		if ( !pWork || pCW->aInfo.nFlags & SFX_CHILDWIN_TASK )
/*N*/ 			pWork = this;
/*N*/ 		pWork->pChildWins->Insert( pWork->pChildWins->Count(), pCW );
/*N*/ 	}
/*N*/ 
/*N*/     if ( pCW->bCreate != bOn )
/*?*/         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pWork->ToggleChildWindow_Impl(nId,bSetFocus);
/*N*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------

/*N*/ SfxChildWindow* SfxWorkWindow::GetChildWindow_Impl(USHORT nId)
/*N*/ {
/*N*/ 	USHORT nCount = pChildWins->Count();
/*N*/ 	USHORT n;
/*N*/ 	for (n=0; n<nCount; n++)
/*N*/ 		if ((*pChildWins)[n]->nSaveId == nId)
/*N*/ 			 break;
/*N*/ 
/*N*/ 	if (n<nCount)
/*N*/ 		return (*pChildWins)[n]->pWin;
/*N*/ 	else if ( pParent )
/*N*/ 		return pParent->GetChildWindow_Impl( nId );
/*N*/ 	return 0;
/*N*/ }

//------------------------------------------------------------------------

/*N*/ void SfxWorkWindow::ResetChildWindows_Impl()
/*N*/ {
/*N*/ //	if ( pParent )
/*N*/ //		pParent->ResetChildWindows_Impl();
/*N*/ 
/*N*/ 	for ( USHORT n = 0; n < pChildWins->Count(); ++n )
/*N*/ 	{
/*N*/ 		(*pChildWins)[n]->nId = 0;
/*N*/ 		(*pChildWins)[n]->bEnable = FALSE;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
// Virtuelle Methode, die die Gr"o\se der Fl"ache (client area) des parent
// windows liefert, in der Child-Fenster angeordnet werden k"onnen.
// in der ClientArea des parent findet.

/*?*/ Rectangle SfxWorkWindow::GetTopRect_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return Rectangle();//STRIP001 
/*?*/ }

//------------------------------------------------------------------------
// Virtuelle Methode, die die Gr"o\se der Fl"ache (client area) des parent
// windows liefert, in der Child-Fenster angeordnet werden k"onnen.
// in der ClientArea des parent findet.

/*N*/ Rectangle SfxFrameWorkWin_Impl::GetTopRect_Impl()
/*N*/ {
/*N*/ 	return pFrame->GetTopOuterRectPixel_Impl();
/*N*/ }

//------------------------------------------------------------------------
// Virtuelle Methode, die die Gr"o\se der Fl"ache (client area) des parent
// windows liefert, in der Child-Fenster angeordnet werden k"onnen.
// in der ClientArea des parent findet.


//------------------------------------------------------------------------
// Virtuelle Methode, um herauszufinden, ob ein Child-Fenster noch Platz
// in der ClientArea des parent findet.

/*N*/ BOOL SfxWorkWindow::RequestTopToolSpacePixel_Impl( SvBorder aBorder )
/*N*/ {
/*N*/ 	if ( !IsDockingAllowed() ||
/*N*/ 			aClientArea.GetWidth() < aBorder.Left() + aBorder.Right() ||
/*N*/ 			aClientArea.GetHeight() < aBorder.Top() + aBorder.Bottom() )
/*N*/ 		return FALSE;
/*N*/ 	else
/*N*/ 		return TRUE;;
/*N*/ }

//------------------------------------------------------------------------
// Implementation am InPlaceObject: benutzt die SO-Methode, um am InPlaceClient
// um Platz nachzusuchen.



/*?*/ void SfxIPWorkWin_Impl::SaveStatus_Impl(SfxChildWindow *pChild, const SfxChildWinInfo &rInfo)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ void SfxWorkWindow::SaveStatus_Impl(SfxChildWindow *pChild, const SfxChildWinInfo &rInfo)
/*N*/ {
/*N*/ 	// Den Status vom Presentation mode wollen wir nicht sichern
/*N*/ 	if ( IsDockingAllowed() )
/*N*/ 		pChild->SaveStatus(rInfo);
/*N*/ }

/*N*/ void SfxWorkWindow::InitializeChild_Impl(SfxChildWin_Impl *pCW)
/*N*/ {
/*N*/ 	SfxChildWinFactory* pFact=0;
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	SfxChildWinFactArr_Impl &rFactories = pApp->GetChildWinFactories_Impl();
/*N*/ 	for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 	{
/*N*/ 		pFact = rFactories[nFactory];
/*N*/ 		if ( pFact->nId == pCW->nSaveId )
/*N*/ 		{
/*N*/ 			pCW->aInfo   = pFact->aInfo;
/*N*/ 			SfxChildWindow::InitializeChildWinFactory_Impl(
/*N*/ 										pCW->nSaveId, pCW->aInfo);
/*N*/             pCW->bCreate = pCW->aInfo.bVisible;
/*N*/ 			USHORT nFlags = pFact->aInfo.nFlags;
/*N*/ 			if ( nFlags & SFX_CHILDWIN_TASK )
/*?*/ 				pCW->aInfo.nFlags |= SFX_CHILDWIN_TASK;
/*N*/ 			if ( nFlags & SFX_CHILDWIN_CANTGETFOCUS )
/*?*/ 				pCW->aInfo.nFlags |= SFX_CHILDWIN_CANTGETFOCUS;
/*N*/ 			pFact->aInfo = pCW->aInfo;
/*N*/ 			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxDispatcher *pDisp = pBindings->GetDispatcher_Impl();
/*N*/ 	SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		SfxChildWinFactArr_Impl *pFactories = pMod->GetChildWinFactories_Impl();
/*N*/ 		if ( pFactories )
/*N*/ 		{
/*N*/ 			SfxChildWinFactArr_Impl &rFactories = *pFactories;
/*N*/ 			for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			{
/*N*/ 				pFact = rFactories[nFactory];
/*N*/ 				if ( pFact->nId == pCW->nSaveId )
/*N*/ 				{
/*N*/ 					pCW->aInfo   = pFact->aInfo;
/*N*/ 					SfxChildWindow::InitializeChildWinFactory_Impl(
/*N*/ 												pCW->nSaveId, pCW->aInfo);
/*N*/ 					pCW->bCreate = pCW->aInfo.bVisible;
/*N*/ 					USHORT nFlags = pFact->aInfo.nFlags;
/*N*/ 					if ( nFlags & SFX_CHILDWIN_TASK )
/*N*/ 						pCW->aInfo.nFlags |= SFX_CHILDWIN_TASK;
/*N*/ 					if ( nFlags & SFX_CHILDWIN_CANTGETFOCUS )
/*?*/ 						pCW->aInfo.nFlags |= SFX_CHILDWIN_CANTGETFOCUS;
/*N*/ 					pFact->aInfo = pCW->aInfo;
/*N*/ 					return;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ SfxSplitWindow* SfxWorkWindow::GetSplitWindow_Impl( SfxChildAlignment eAlign )
/*N*/ {
/*N*/ 	switch ( eAlign )
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_TOP:
/*?*/ 			return pSplit[2];
/*?*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 			return pSplit[3];
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LEFT:
/*?*/ 			return pSplit[0];
/*?*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_RIGHT:
/*?*/ 			return pSplit[1];
/*?*/ 			break;
/*N*/ 
/*N*/ 		default:
/*N*/ 			return 0;
/*N*/ 			break;
/*N*/ 	}
/*N*/ }




/*N*/ void SfxWorkWindow::EndAutoShow_Impl( Point aPos )
/*N*/ {
/*N*/ 	if ( pParent )
/*?*/         pParent->EndAutoShow_Impl( aPos );
/*N*/ 
/*N*/ 	for ( USHORT n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		SfxSplitWindow *p = pSplit[n];
/*N*/ 		if ( p && p->IsAutoHide() )
/*N*/         {
/*?*/             Point aLocalPos = p->ScreenToOutputPixel( aPos );
/*?*/ 	    Point aEmptyPoint = Point();
/*?*/             Rectangle aRect( aEmptyPoint, p->GetSizePixel() );
/*?*/             if ( !aRect.IsInside( aLocalPos ) )
/*?*/                 p->FadeOut();
/*N*/         }
/*N*/ 	}
/*N*/ }

/*N*/ void SfxWorkWindow::ArrangeAutoHideWindows( SfxSplitWindow *pActSplitWin )
/*N*/ {
/*N*/ 	if ( pParent )
/*?*/ 		pParent->ArrangeAutoHideWindows( pActSplitWin );
/*N*/ 
/*N*/     Rectangle aArea( aUpperClientArea );
/*N*/ 	for ( USHORT n=0; n<SFX_SPLITWINDOWS_MAX; n++ )
/*N*/ 	{
/*N*/ 		// Es werden entweder Dummyfenster oder Fenster im AutoShow-Modus
/*N*/ 		// ( nicht gepinned, FadeIn ) behandelt.
/*N*/ 		// Nur das "ubergebene Fenster darf unsichtbar sein, denn vielleicht
/*N*/ 		// soll daf"ur gerade die Gr"o\se berechnet werden, bevor es angezeigt
/*N*/ 		// wird.
/*N*/ 		SfxSplitWindow* pSplitWin = pSplit[n];
/*N*/ 		BOOL bDummyWindow = !pSplitWin->IsFadeIn();
/*N*/ 		Window *pDummy = pSplitWin->GetSplitWindow();
/*N*/ 		Window *pWin = bDummyWindow ? pDummy : pSplitWin;
/*N*/ 		if ( pSplitWin->IsPinned() && !bDummyWindow || !pWin->IsVisible() && pActSplitWin != pSplitWin )
/*N*/ 			continue;
/*N*/ 
/*N*/ 		// Breite und Position des Dummy-Fensters als Ausgangspunkt
/*N*/ 		Size aSize = pDummy->GetSizePixel();
/*N*/ 		Point aPos = pDummy->GetPosPixel();
/*N*/ 
/*N*/ 		switch ( n )
/*N*/ 		{
/*N*/ 			case ( 0 ) :
/*N*/ 			{
/*N*/ 				// Linkes SplitWindow
/*N*/ 				// Breite vom Fenster selbst holen, wenn nicht das DummyWindow
/*?*/ 				if ( !bDummyWindow )
/*?*/ 					aSize.Width() = pSplitWin->GetSizePixel().Width();
/*?*/ 
/*?*/ 				// Wenn links ein Window sichtbar ist, beginnt der freie
/*?*/ 				// Bereich rechts davon bzw. bei der Client area
/*?*/ 				long nLeft = aPos.X() + aSize.Width();
/*?*/ 				if ( nLeft > aArea.Left() )
/*?*/ 					aArea.Left() = nLeft;
/*?*/ 				break;
/*?*/ 			}
/*?*/ 			case ( 1 ) :
/*?*/ 			{
/*?*/ 				// Rechtes SplitWindow
/*?*/ 				// Position um Differenz der Breiten korrigieren
/*?*/ 				aPos.X() += aSize.Width();
/*?*/ 
/*?*/ 				// Breite vom Fenster selbst holen, wenn nicht das DummyWindow
/*?*/ 				if ( !bDummyWindow )
/*?*/ 					aSize.Width() = pSplitWin->GetSizePixel().Width();
/*?*/ 
/*?*/ 				aPos.X() -= aSize.Width();
/*?*/ 
/*?*/ 				// Wenn links schon ein Fenster aufgeklappt ist, darf
/*?*/ 				// das rechte nicht dar"uber gehen
/*?*/ 				if ( aPos.X() < aArea.Left() )
/*?*/ 				{
/*?*/ 					aPos.X() = aArea.Left();
/*?*/ 					aSize.Width() = aArea.GetWidth();
/*?*/ 				}
/*?*/ 
/*?*/ 				// Wenn rechts ein Window sichtbar ist, endet der freie
/*?*/ 				// Bereich links davon bzw. bei der Client area
/*?*/ 				long nRight = aPos.X();
/*?*/ 				if ( nRight < aArea.Right() )
/*?*/ 					aArea.Right() = nRight;
/*?*/ 				break;
/*?*/ 			}
/*?*/ 			case ( 2 ) :
/*?*/ 			{
/*?*/ 				// Oberes SplitWindow
/*?*/ 				// H"ohe vom Fenster selbst holen, wenn nicht das DummyWindow
/*?*/ 				if ( !bDummyWindow )
/*?*/ 					aSize.Height() = pSplitWin->GetSizePixel().Height();
/*?*/ 
/*?*/ 				// Breite anpassen, je nachdem ob links oder rechts
/*?*/ 				// schon ein Fenster aufgeklappt ist
/*?*/ 				aPos.X() = aArea.Left();
/*?*/ 				aSize.Width() = aArea.GetWidth();
/*?*/ 
/*?*/ 				// Wenn oben ein Window sichtbar ist, beginnt der freie
/*?*/ 				// Bereich darunter bzw. bei der Client Area
/*?*/ 				long nTop = aPos.Y() + aSize.Height();
/*?*/ 				if ( nTop > aArea.Top() )
/*?*/ 					aArea.Top() = nTop;
/*?*/ 				break;
/*?*/ 			}
/*?*/ 			case ( 3 ) :
/*N*/ 			{
/*N*/ 				// Das untere SplitWindow
/*N*/ 				// Position um Differenz der H"ohen korrigieren
/*N*/ 				aPos.Y() += aSize.Height();
/*N*/ 
/*N*/ 				// H"ohe vom Fenster selbst holen, wenn nicht das DummmyWindow
/*N*/ 				if ( !bDummyWindow )
/*?*/ 					aSize.Height() = pSplitWin->GetSizePixel().Height();
/*N*/ 
/*N*/ 				aPos.Y() -= aSize.Height();
/*N*/ 
/*N*/ 				// Breite anpassen, je nachdem ob links oder rechts
/*N*/ 				// schon ein Fenster aufgeklappt ist
/*N*/ 				aPos.X() = aArea.Left();
/*N*/ 				aSize.Width() = aArea.GetWidth();
/*N*/ 
/*N*/ 				// Wenn oben schon ein Fenster aufgeklappt ist, darf
/*N*/ 				// das untere nicht dar"uber gehen
/*N*/ 				if ( aPos.Y() < aArea.Top() )
/*N*/ 				{
/*?*/ 					aPos.Y() = aArea.Top();
/*?*/ 					aSize.Height() = aArea.GetHeight();
/*N*/ 				}
/*N*/ 
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !bDummyWindow )
/*N*/ 			// Das FadeIn-Window ist ein Float, dessen Koordinaten in
/*N*/ 			// Screenkoordinaten gesetzt werden
/*?*/ 			pSplitWin->SetPosSizePixel( pWorkWin->OutputToScreenPixel(aPos), aSize );
/*N*/ 		else
/*N*/ 			// Das angedockte DummyWindow
/*N*/ 			pDummy->SetPosSizePixel( aPos, aSize );
/*N*/ 	}
/*N*/ }






/*N*/ void SfxWorkWindow::SetActiveChild_Impl( Window *pChild )
/*N*/ {
/*N*/ 	pActiveChild = pChild;
/*N*/ }


/*?*/ BOOL SfxWorkWindow::ActivateNextChild_Impl( BOOL bForward )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }


}
