/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxcust.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:40:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _TBXCUST_HXX
#define _TBXCUST_HXX

// #include *****************************************************************

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#include <vcl/combobox.hxx>
#include <vcl/button.hxx>
#ifndef _HEADBAR_HXX
#include <svtools/headbar.hxx>
#endif

#include "basedlgs.hxx"
#include "imgmgr.hxx"
#include "childwin.hxx"
#include "sfxresid.hxx"
#include "cfgtreelstbox.hxx"

#include <vector>


namespace rtl { class OUString; }
class Bitmap;
namespace binfilter {
class SfxMacroInfoArr_Impl;
class SfxToolBoxManager;

// **************************************************************************


class SfxUserBitmapDialog_Impl;
class SfxTbxControlArr_Impl;


class SfxUserBitmapDialog_Impl : public ModalDialog
{
friend class SfxToolboxCustomizer;

	ToolBox         	aSymbolTb;
	FixedText       	aDescLabelFt;
	Edit       			aDescEdit;
	OKButton        	aOKButton;
	CancelButton    	aCancelButton;
	HelpButton      	aHelpBtn;
	PushButton			aDefaultBtn;
    FixedLine           aFunctionGb;
	USHORT          	nFuncId;
	String				aDirName;
    std::vector< ::rtl::OUString > aBitmapUrls;
	ToolBox*			pToolBox;
	SfxToolBoxManager*	pMgr;
    SfxImageManager*    pImageMgr;
	BOOL				bNoDefaultImage;
	BOOL				bBigImages;
	BmpConversion       nBmpColorConversion;
	USHORT              nBmpColorDepth;

    SfxUserBitmapDialog_Impl(SfxUserBitmapDialog_Impl &); // not implemented
    void operator =(SfxUserBitmapDialog_Impl); // not implemented

    Bitmap createBitmap(::rtl::OUString const & rUrl);

	Image				GetDefaultImage( USHORT nId );
	void				ResetToolBoxSelection();

public:

						SfxUserBitmapDialog_Impl(Window *pParent,
										const String& rName,
										ToolBox &rTbx,
                                        USHORT nId, SfxToolBoxManager* pMgr, SfxImageManager* );

						~SfxUserBitmapDialog_Impl();
	DECL_LINK( 			OKHdl, OKButton * );
	DECL_LINK( 			SelectHdl, ToolBox * );
	DECL_LINK( 			DefaultHdl, PushButton * );

	void				SetFunctionId(USHORT nId);
	void				SetToolBox(ToolBox& rTbx);
};

class SfxToolboxCustomWindow : public SfxChildWindow
{
public:
						SfxToolboxCustomWindow(Window *pParent, USHORT nId,
							SfxBindings *pBindings, SfxChildWinInfo *pInfo);
						SFX_DECL_CHILDWINDOW(SfxToolboxCustomWindow);

};

}//end of namespace binfilter
#endif // #ifndef _TBXCUST_HXX


