/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: virtmenu.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:41:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXVIRTMENU_HXX
#define _SFXVIRTMENU_HXX


#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef _SFXMNUITEM_HXX
#include "mnuitem.hxx"
#endif

#ifndef _SFXMNUCFGA_HXX
#include "mnucfga.hxx"
#endif
class Timer;
namespace binfilter {

class SfxBindings;
class SfxMenuImageControl_Impl;


class SfxVirtualMenu
{
friend class SfxMenuControl;

private:
	Menu*           pSVMenu;
	SfxVirtualMenu* pParent;
	SfxMenuControl*	pItems;
    SfxMenuImageControl_Impl* pImageControl;
	SfxBindings*	pBindings;
	ResMgr*			pResMgr;
    PopupMenu*      pWindowMenu;
    PopupMenu*      pPickMenu;
    PopupMenu*		pAddonsMenu;
	Timer*			pAutoDeactivate; // Hack fuer QAP-Bug
	USHORT          nVisibleItems;
	USHORT          nId;
	USHORT          nCount;
	USHORT			nLocks;
	BOOL            bResCtor : 1; // SV Menu created from resource
	BOOL			bOLE : 1;	  // InPlaceMenu
	BOOL			bHelpInitialized : 1;
	BOOL			bIsActive : 1;
	BOOL			bControllersUnBound : 1;
	BOOL			bWasHighContrast : 1;
	BOOL			bIsAddonPopupMenu : 1;

private:
	void			Construct_Impl();

protected:
	SfxVirtualMenu( USHORT nOwnId, SfxVirtualMenu* pParent, Menu& rMenu, BOOL bWithHelp,
						SfxBindings &rBind, BOOL bOLEServer=FALSE, BOOL bRes=FALSE, BOOL bIsAddonMenu=FALSE );

	void            CreateFromSVMenu();
	DECL_LINK( Highlight, Menu * );
	DECL_LINK( Activate, Menu * );
	DECL_LINK( Deactivate, Menu * );
    DECL_LINK( SettingsChanged, void* );

	// Used for runtime popup menus
	void			UpdateImages( Menu* pMenu ); 
	void			RemoveMenuImages( Menu* pMenu );

public:
					~SfxVirtualMenu();
					SfxVirtualMenu( Menu *pStarViewMenu, BOOL bWithHelp,
						SfxBindings &rBind, BOOL bOLEServer=FALSE, BOOL bRes=FALSE, BOOL bIsAddonMenu=FALSE );
	void            CheckItem( USHORT nItemId, BOOL bCheck );
	void            EnableItem( USHORT nItemId, BOOL bEnable );

	USHORT          GetItemPos( USHORT nItemId ) const;

	USHORT          GetItemCount() const;
	Menu*           GetSVMenu() const;
	SfxMenuControl& operator[]( USHORT nPos ) const;

	USHORT          GetItemId( USHORT nPos ) const;
	SfxVirtualMenu* GetPopupMenu( USHORT nId ) const;

	void			InvalidateKeyCodes();

	SfxVirtualMenu* GetParentMenu() const { return pParent; }
	void			SetParentMenu( SfxVirtualMenu* pNewParent )
					{ pParent = pNewParent; }

	BOOL			IsFromResource() const
					{ return bResCtor; }
	void			SetResMgr(ResMgr* pMgr)  {pResMgr = pMgr; }
	ResMgr*			GetResMgr() { return pResMgr; }
	BOOL			IsHiContrastMode() const;

	DECL_LINK( Select, Menu * );
};

//--------------------------------------------------------------------

// return the number of virtual items in this menu

inline USHORT SfxVirtualMenu::GetItemCount() const
{
	return nCount;
}
//--------------------------------------------------------------------

//

inline SfxMenuControl& SfxVirtualMenu::operator[]( USHORT nPos ) const
{
	return *(pItems+nPos);
}
//--------------------------------------------------------------------

// returns the item id at position nPos in the menu (or 0 if sep.)

inline USHORT SfxVirtualMenu::GetItemId( USHORT nPos ) const
{
	return pItems ? pItems[nPos].GetId() : 0;
}


}//end of namespace binfilter
#endif
