/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tbxconf.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:45:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxconf.hxx"
#include "toolbox.hrc"
#include "tbxmgr.hxx"
#include "tbxopdlg.hrc"
namespace binfilter {

static const USHORT nVersion = 6;

// two functions that take care for the removed RecordingToolbox
/*N*/ static USHORT IndexToPos_Impl( USHORT nIndex )
/*N*/ {
/*N*/ 	if ( nIndex < SFX_OBJECTBAR_RECORDING )
/*N*/ 		return nIndex;
/*N*/ 	else
/*N*/ 		return nIndex + 1;
/*N*/ }

/*N*/ static USHORT PosToIndex_Impl( USHORT nPos )
/*N*/ {
/*N*/ 	DBG_ASSERT( nPos != SFX_OBJECTBAR_RECORDING, "Wrong Position!" );
/*N*/ 	if ( nPos < SFX_OBJECTBAR_RECORDING )
/*N*/ 		return nPos;
/*N*/ 	else
/*N*/ 		return nPos - 1;
/*N*/ }

// create a descriptor array for all positions
/*N*/ void CreateArray_Impl()
/*N*/ {
/*N*/ }

// convert the SfxAlignment to a VCL alignment
extern WindowAlign ConvertAlign_Impl( SfxChildAlignment eAlign );

/*N*/ SfxChildAlignment ConvertToSfxAlign_Impl( WindowAlign eAlign, USHORT nPos )
/*N*/ {
/*N*/ 	switch ( eAlign)
/*N*/ 	{
/*N*/ 		case WINDOWALIGN_LEFT :
/*N*/ 			return SFX_ALIGN_TOOLBOXLEFT;
/*N*/ 		case WINDOWALIGN_RIGHT :
/*N*/ 			return SFX_ALIGN_TOOLBOXRIGHT;
/*N*/ 		case WINDOWALIGN_TOP :
/*N*/ 			if ( nPos == 0 )
/*N*/ 				return SFX_ALIGN_HIGHESTTOP;
/*N*/ 			else
/*N*/ 				return SFX_ALIGN_TOOLBOXTOP;
/*N*/ 		case WINDOWALIGN_BOTTOM :
/*N*/ 			return SFX_ALIGN_TOOLBOXBOTTOM;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ERROR("Wrong Alignment!");
/*N*/ 	return SFX_ALIGN_TOOLBOXTOP;
/*N*/ }

/*N*/ void MakeDefault_Impl()
/*N*/ {
/*N*/ }

//=========================================================================
/*N*/ SfxToolBoxConfig::SfxToolBoxConfig( SfxConfigManager* pCfgMgr ) :
/*N*/     SfxConfigItem( SFX_ITEMTYPE_TOOLBOXCONFIG, pCfgMgr ),
/*N*/     eSymbolsSize( SFX_SYMBOLS_SIZE_SMALL ),
/*N*/ 	nOutStyle( TOOLBOX_STYLE_FLAT ),
/*N*/ 	bQuiet(FALSE),
/*N*/ 	bStatusBarVisible(TRUE)
/*N*/ {
/*N*/     Initialize();
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxToolBoxConfig::SfxToolBoxConfig( const SfxToolBoxConfig& rOther, SfxConfigManager* pCfgMgr ) :
/*N*/     SfxConfigItem( SFX_ITEMTYPE_TOOLBOXCONFIG, pCfgMgr ),
/*N*/     eSymbolsSize( SFX_SYMBOLS_SIZE_SMALL ),
/*N*/ 	nOutStyle( TOOLBOX_STYLE_FLAT ),
/*N*/ 	bQuiet(FALSE),
/*N*/ 	bStatusBarVisible(TRUE)
/*N*/ {
/*N*/     Initialize();
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxToolBoxConfig::~SfxToolBoxConfig()
/*N*/ {
/*N*/ 	if ( IsModified() )
/*N*/ 		StoreConfig();
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ String SfxToolBoxConfig::GetStreamName() const
/*N*/ {
/*N*/     return SfxConfigItem::GetStreamName( GetType() );
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxToolBoxConfig::UseDefault()
/*N*/ {
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ BOOL SfxToolBoxConfig::IsToolBoxPositionVisible(USHORT nPos) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }

//-------------------------------------------------------------------------
/*?*/ void SfxToolBoxConfig::SetToolBoxPositionVisible(USHORT nPos, BOOL bVis)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ void SfxToolBoxConfig::SetButtonType( USHORT nPos, ButtonType eType )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
/*N*/ ButtonType SfxToolBoxConfig::GetButtonType( USHORT nPos ) const
/*N*/ {
/*N*/ 	return BUTTON_SYMBOL;
/*N*/ }

//-------------------------------------------------------------------------
/*?*/ void SfxToolBoxConfig::Configure_Impl( SfxToolBoxManager *pMgr )
/*?*/ {
/*?*/ }

//-------------------------------------------------------------------------
/*N*/ WinBits SfxToolBoxConfig::GetWinBits( USHORT nPos )
/*N*/ {
/*N*/     ULONG nStyles = WB_LINESPACING | WB_BORDER | WB_SCROLL | WB_MOVEABLE | WB_3DLOOK | WB_DOCKABLE;
/*N*/     if ( nPos != SFX_OBJECTBAR_FULLSCREEN )
/*N*/         nStyles |= ( WB_SIZEABLE | WB_CLOSEABLE );
/*N*/ 	return nStyles;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxChildAlignment SfxToolBoxConfig::GetAlignment( USHORT nPos ) const
/*N*/ {
/*N*/ 		return SFX_ALIGN_NOALIGNMENT;
/*N*/ }

//-------------------------------------------------------------------------
/*?*/ String SfxToolBoxConfig::GetToolBoxPositionName(USHORT nPos)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return String();
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ void SfxToolBoxConfig::SetToolBoxPositionUserName(USHORT nPos, const String& aUserName )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ String SfxToolBoxConfig::GetToolBoxPositionUserName(USHORT nPos )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 	return String();
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ BOOL SfxToolBoxConfig::Import( SvStream& rStream, SvStream& rOut )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ BOOL SfxToolBoxConfig::Export( SvStream* pIn, SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ int SfxToolBoxConfig::Load( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
	// array will be filled on load
/*?*/ }

/*?*/ BOOL SfxToolBoxConfig::Store( SotStorage& rStorage )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxToolBoxConfig::ReInitialize()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return false;//STRIP001 
 return FALSE; 
/*?*/ }
}
