/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_sfxbasecontroller.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:51:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//________________________________________________________________________________________________________
//	my own includes
//________________________________________________________________________________________________________

#include <time.h>

#ifndef _SFX_SFXBASECONTROLLER_HXX_
#include <sfxbasecontroller.hxx>
#endif

//________________________________________________________________________________________________________
//	include of other projects
//________________________________________________________________________________________________________





#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif




#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif




#ifndef _SFXVIEWFRM_HXX
#include <viewfrm.hxx>
#endif

#ifndef _SFX_OBJSH_HXX
#include <objsh.hxx>
#endif



#ifndef _SFXDISPATCH_HXX
#include <dispatch.hxx>
#endif

#include <viewimp.hxx>
#include <unoctitm.hxx>
#include <sfxsids.hrc>
#include <workwin.hxx>
#include <objface.hxx>

#include <vos/mutex.hxx>
namespace binfilter {

#define	OMULTITYPEINTERFACECONTAINERHELPER		::cppu::OMultiTypeInterfaceContainerHelper
#define OINTERFACECONTAINERHELPER               ::cppu::OInterfaceContainerHelper
#define	XFRAMEACTIONLISTENER					::com::sun::star::frame::XFrameActionListener
#define	XCLOSELISTENER							::com::sun::star::util::XCloseListener
#define	FRAMEACTIONEVENT						::com::sun::star::frame::FrameActionEvent
#define	EVENTOBJECT								::com::sun::star::lang::EventObject
#define OTYPECOLLECTION							::cppu::OTypeCollection
#define OIMPLEMENTATIONID						::cppu::OImplementationId
#define	MUTEXGUARD								::osl::MutexGuard
#define	UNOQUERY								::com::sun::star::uno::UNO_QUERY
#define	MAPPING									::com::sun::star::uno::Mapping
#define XSTATUSINDICATORSUPPLIER                ::com::sun::star::task::XStatusIndicatorSupplier
#define XCOMPONENT                              ::com::sun::star::lang::XComponent
#define	XINTERFACE								::com::sun::star::uno::XInterface
#define XKEYHANDLER								::com::sun::star::awt::XKeyHandler
#define XMOUSECLICKHANDLER						::com::sun::star::awt::XMouseClickHandler

#define TIMEOUT_START_RESCHEDULE	10L	/* 10th s */

/*N*/ sal_uInt32 Get10ThSec()
/*N*/ {
/*N*/ 	sal_uInt32 n10Ticks = 10 * (sal_uInt32)clock();
/*N*/ 	return n10Ticks / CLOCKS_PER_SEC;
/*N*/ }

sal_Int32 m_nInReschedule = 0;	///	static counter for rescheduling

/*N*/ void reschedule()
/*N*/ {
/*N*/ 	if ( m_nInReschedule == 0 )
/*N*/ 	{
/*N*/ 		++m_nInReschedule;
/*N*/ 		Application::Reschedule();
/*N*/ 		--m_nInReschedule;
/*N*/ 	}
/*N*/ }

/*N*/ class SfxStatusIndicator : public ::cppu::WeakImplHelper2< ::com::sun::star::task::XStatusIndicator, ::com::sun::star::lang::XEventListener >
/*N*/ {
/*N*/ friend class SfxBaseController;
/*N*/     ::com::sun::star::uno::Reference < XCONTROLLER > xOwner;
/*N*/     SfxWorkWindow*          pWorkWindow;
/*N*/     sal_Int32               _nRange;
/*N*/     sal_Int32               _nValue;
/*N*/ 	long					_nStartTime;
/*N*/ public:
/*N*/                             SfxStatusIndicator(SfxBaseController* pController, SfxWorkWindow* pWork)
/*N*/                                 : xOwner( pController )
/*N*/                                 , pWorkWindow( pWork )
/*N*/                             {
/*N*/ 								++m_refCount;
/*N*/ 								::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent > xComponent(
/*N*/ 									SAL_STATIC_CAST(::cppu::OWeakObject*, pController ), ::com::sun::star::uno::UNO_QUERY );
/*N*/ 								if (xComponent.is())
/*N*/ 									xComponent->addEventListener(this);
/*N*/ 								--m_refCount;
/*N*/ 							}
/*N*/ 
/*N*/     virtual void SAL_CALL   start(const ::rtl::OUString& aText, sal_Int32 nRange) throw(::com::sun::star::uno::RuntimeException);
/*N*/     virtual void SAL_CALL   end(void) throw(::com::sun::star::uno::RuntimeException);
/*N*/     virtual void SAL_CALL   setText(const ::rtl::OUString& aText) throw(::com::sun::star::uno::RuntimeException);
/*N*/     virtual void SAL_CALL   setValue(sal_Int32 nValue) throw(::com::sun::star::uno::RuntimeException);
/*N*/     virtual void SAL_CALL   reset() throw(::com::sun::star::uno::RuntimeException);
/*N*/ 
/*N*/ 	virtual void SAL_CALL	disposing( const ::com::sun::star::lang::EventObject& Source ) throw(::com::sun::star::uno::RuntimeException);
/*N*/ };

/*N*/ void SAL_CALL SfxStatusIndicator::start(const ::rtl::OUString& aText, sal_Int32 nRange) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( xOwner.is() )
/*N*/ 	{
/*N*/ 		_nRange = nRange;
/*N*/ 		_nValue = 0;
/*N*/         SfxStatusBarManager* pMgr = pWorkWindow->GetStatusBarManager_Impl();
/*N*/         if ( !pMgr )
/*?*/             pWorkWindow->SetTempStatusBar_Impl( TRUE );
/*N*/         pMgr = pWorkWindow->GetStatusBarManager_Impl();
/*N*/ 		if ( pMgr && !pMgr->IsProgressMode() )
/*N*/             pMgr->StartProgressMode( aText, nRange );
/*N*/ 		_nStartTime = Get10ThSec();
/*N*/     	reschedule();
/*N*/ 	}
/*N*/ }

/*N*/ void SAL_CALL SfxStatusIndicator::end(void) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( xOwner.is() )
/*N*/ 	{
/*N*/         SfxStatusBarManager* pMgr = pWorkWindow->GetStatusBarManager_Impl();
/*N*/ 		if ( pMgr && pMgr->IsProgressMode() )
/*N*/ 			pMgr->EndProgressMode();
/*N*/     	reschedule();
/*N*/ 	}
/*N*/ }

/*N*/ void SAL_CALL SfxStatusIndicator::setText(const ::rtl::OUString& aText) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SAL_CALL SfxStatusIndicator::setValue( sal_Int32 nValue ) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/     ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( xOwner.is() )
/*N*/ 	{
/*N*/ 		_nValue = nValue;
/*N*/         SfxStatusBarManager* pMgr = pWorkWindow->GetStatusBarManager_Impl();
/*N*/ 		if ( pMgr && pMgr->IsProgressMode() )
/*N*/ 			pMgr->SetProgressState( nValue );
/*N*/ 		sal_Bool bReschedule = (( Get10ThSec() - _nStartTime ) > TIMEOUT_START_RESCHEDULE );
/*N*/ 		if ( bReschedule )
/*N*/ 			reschedule();
/*N*/ 	}
/*N*/ }

/*N*/ void SAL_CALL SfxStatusIndicator::reset() throw(::com::sun::star::uno::RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SAL_CALL SfxStatusIndicator::disposing( const ::com::sun::star::lang::EventObject& Source ) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//________________________________________________________________________________________________________
//________________________________________________________________________________________________________
//	declaration IMPL_SfxBaseController_ListenerHelper
//________________________________________________________________________________________________________

/*N*/ class IMPL_SfxBaseController_ListenerHelper : public ::cppu::WeakImplHelper1< ::com::sun::star::frame::XFrameActionListener >
/*N*/ {
/*N*/ public:
/*N*/ 	IMPL_SfxBaseController_ListenerHelper(	MUTEX&				aMutex		,
/*N*/ 											SfxBaseController*	pController	) ;
/*N*/ 	virtual ~IMPL_SfxBaseController_ListenerHelper() ;
/*N*/     virtual void SAL_CALL frameAction( const FRAMEACTIONEVENT& aEvent ) throw (RUNTIMEEXCEPTION) ;
/*N*/ 	virtual void SAL_CALL disposing( const EVENTOBJECT& aEvent ) throw (RUNTIMEEXCEPTION) ;
/*N*/ 
/*N*/ private:
/*N*/ 
/*N*/ 	MUTEX&					m_aMutex		;
/*N*/ 	SfxBaseController*		m_pController	;
/*N*/ 
/*N*/ } ;	// class IMPL_SfxBaseController_ListenerContainer

class IMPL_SfxBaseController_CloseListenerHelper : public ::cppu::WeakImplHelper1< ::com::sun::star::util::XCloseListener >
{
public:
	IMPL_SfxBaseController_CloseListenerHelper(	MUTEX&				aMutex		,
											SfxBaseController*	pController	) ;
	virtual ~IMPL_SfxBaseController_CloseListenerHelper() ;
    virtual void SAL_CALL queryClosing( const EVENTOBJECT& aEvent, sal_Bool bDeliverOwnership ) throw (RUNTIMEEXCEPTION) ;
    virtual void SAL_CALL notifyClosing( const EVENTOBJECT& aEvent ) throw (RUNTIMEEXCEPTION) ;
	virtual void SAL_CALL disposing( const EVENTOBJECT& aEvent ) throw (RUNTIMEEXCEPTION) ;

private:

	MUTEX&					m_aMutex;
	SfxBaseController*		m_pController;

} ;	// class IMPL_SfxBaseController_ListenerContainer

/*N*/ IMPL_SfxBaseController_CloseListenerHelper::IMPL_SfxBaseController_CloseListenerHelper(	MUTEX&				aMutex		,
/*N*/ 																				SfxBaseController*	pController	)
/*N*/ 		: m_aMutex		( aMutex		)
/*N*/ 		, m_pController	( pController	)
/*N*/ {
/*N*/ }

/*N*/ IMPL_SfxBaseController_CloseListenerHelper::~IMPL_SfxBaseController_CloseListenerHelper()
/*N*/ {
/*N*/ }

/*?*/ void SAL_CALL IMPL_SfxBaseController_CloseListenerHelper::disposing( const EVENTOBJECT& aEvent ) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ }

/*N*/ void SAL_CALL IMPL_SfxBaseController_CloseListenerHelper::queryClosing( const EVENTOBJECT& aEvent, sal_Bool bDeliverOwnership ) throw (RUNTIMEEXCEPTION)
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 	if	( m_pController	!=	NULL && m_pController->GetViewShell_Impl() )
/*N*/ 	{
/*N*/ 		BOOL bCanClose = (BOOL) m_pController->GetViewShell_Impl()->PrepareClose( FALSE );
/*N*/ 		if ( !bCanClose )
/*N*/ 		{
/*?*/ 			if ( bDeliverOwnership )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 m_pController->TakeOwnerShip_Impl();
/*?*/ 			throw ::com::sun::star::util::CloseVetoException(::rtl::OUString::createFromAscii("Controller disagree ..."),static_cast< ::cppu::OWeakObject*>(this));
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*?*/ void SAL_CALL IMPL_SfxBaseController_CloseListenerHelper::notifyClosing( const EVENTOBJECT& aEvent ) throw (RUNTIMEEXCEPTION)
/*?*/ {
/*?*/ }

//________________________________________________________________________________________________________
//	declaration IMPL_SfxBaseController_DataContainer
//________________________________________________________________________________________________________

struct IMPL_SfxBaseController_DataContainer
{
    REFERENCE < XFRAME >    m_xFrame;
    REFERENCE < XFRAMEACTIONLISTENER >      m_xListener       ;
    REFERENCE < XCLOSELISTENER >      m_xCloseListener       ;
	OMULTITYPEINTERFACECONTAINERHELPER		m_aListenerContainer	;
    OINTERFACECONTAINERHELPER               m_aInterceptorContainer    ;
    REFERENCE < ::com::sun::star::task::XStatusIndicator > m_xIndicator;
	SfxViewShell*							m_pViewShell			;
	SfxBaseController*						m_pController			;
	sal_Bool								m_bDisposing			;
	sal_Bool								m_bGotOwnerShip;
	sal_Bool								m_bHasKeyListeners;
	sal_Bool								m_bHasMouseClickListeners;

	IMPL_SfxBaseController_DataContainer(	MUTEX&				aMutex		,
											SfxViewShell*		pViewShell	,
											SfxBaseController*	pController	)
            :   m_xListener       ( new IMPL_SfxBaseController_ListenerHelper( aMutex, pController ) )
            ,   m_xCloseListener       ( new IMPL_SfxBaseController_CloseListenerHelper( aMutex, pController ) )
			,	m_aListenerContainer	( aMutex												)
            ,   m_aInterceptorContainer ( aMutex                                                )
			,	m_pViewShell			( pViewShell											)
			,	m_pController			( pController											)
			,	m_bDisposing			( sal_False												)
			,	m_bGotOwnerShip			( sal_False												)
			,	m_bHasKeyListeners		( sal_False												)
			,	m_bHasMouseClickListeners( sal_False												)
	{
	}

} ;	// struct IMPL_SfxBaseController_DataContainer

//________________________________________________________________________________________________________
//	IMPL_SfxBaseController_ListenerHelper constructor
//________________________________________________________________________________________________________

/*N*/ IMPL_SfxBaseController_ListenerHelper::IMPL_SfxBaseController_ListenerHelper(	MUTEX&				aMutex		,
/*N*/ 																				SfxBaseController*	pController	)
/*N*/ 		: m_aMutex		( aMutex		)
/*N*/ 		, m_pController	( pController	)
/*N*/ {
/*N*/ }

//________________________________________________________________________________________________________
//	IMPL_SfxBaseController_ListenerHelper destructor
//________________________________________________________________________________________________________

/*N*/ IMPL_SfxBaseController_ListenerHelper::~IMPL_SfxBaseController_ListenerHelper()
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL IMPL_SfxBaseController_ListenerHelper::frameAction( const FRAMEACTIONEVENT& aEvent ) throw( RUNTIMEEXCEPTION )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 	if	(
/*N*/ 			( m_pController	!=	NULL ) &&
/*N*/ 			( aEvent.Frame	==	m_pController->getFrame() )	&&
/*N*/             ( m_pController->GetViewShell_Impl() && m_pController->GetViewShell_Impl()->GetWindow() !=  NULL                                                    )
/*N*/ 		)
/*N*/ 	{
/*N*/         if ( aEvent.Action == ::com::sun::star::frame::FrameAction_FRAME_UI_ACTIVATED )
/*N*/ 		{
/*N*/         	m_pController->GetViewShell_Impl()->GetViewFrame()->MakeActive_Impl( FALSE );
/*N*/ 		}
/*N*/         if ( aEvent.Action == ::com::sun::star::frame::FrameAction_FRAME_ACTIVATED )
/*N*/ 		{
/*N*/ 			SfxViewFrame* pFrame = m_pController->GetViewShell_Impl()->GetViewFrame();
/*N*/ 			if ( !pFrame->GetActiveChildFrame_Impl() )
/*N*/         		pFrame->MakeActive_Impl( FALSE );
/*N*/ 		}
/*N*/         else if ( aEvent.Action == ::com::sun::star::frame::FrameAction_CONTEXT_CHANGED )
/*N*/ 		{
/*N*/ 			m_pController->GetViewShell_Impl()->GetViewFrame()->GetBindings().ContextChanged_Impl();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//________________________________________________________________________________________________________
//	IMPL_SfxBaseController_ListenerHelper -> XEventListener
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL IMPL_SfxBaseController_ListenerHelper::disposing( const EVENTOBJECT& aEvent ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( m_pController && m_pController->getFrame().is() )
/*N*/ 		m_pController->getFrame()->removeFrameActionListener( this ) ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> constructor
//________________________________________________________________________________________________________

/*N*/ SfxBaseController::SfxBaseController( SfxViewShell* pViewShell )
/*N*/ 	:	IMPL_SfxBaseController_MutexContainer	(																		)
/*N*/ 	,	m_pData									( new IMPL_SfxBaseController_DataContainer( m_aMutex, pViewShell, this ))
/*N*/ {
/*N*/     m_pData->m_pViewShell->SetController( this );
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> destructor
//________________________________________________________________________________________________________

/*N*/ SfxBaseController::~SfxBaseController()
/*N*/ {
/*N*/ 	delete m_pData;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XInterface
//________________________________________________________________________________________________________
/*N*/ ANY SAL_CALL SfxBaseController::queryInterface( const UNOTYPE& rType ) throw( RUNTIMEEXCEPTION )
/*N*/ {
/*N*/ 	// Attention:
/*N*/ 	//	Don't use mutex or guard in this method!!! Is a method of XInterface.
/*N*/ 
/*N*/ 	// Ask for my own supported interfaces ...
/*N*/ 	ANY aReturn( ::cppu::queryInterface(	rType										,
/*N*/ 									   		static_cast< XTYPEPROVIDER*		> ( this )	,
/*N*/                                             static_cast< XCOMPONENT*       > ( this )  ,
/*N*/ 									   		static_cast< XCONTROLLER*		> ( this )	,
/*N*/ 									   		static_cast< XUSERINPUTINTERCEPTION*		> ( this )	,
/*N*/                                             static_cast< XSTATUSINDICATORSUPPLIER* > ( this )  ,
/*N*/                                             static_cast< XCONTEXTMENUINTERCEPTION* > ( this ) ,
/*N*/ 									   		static_cast< XDISPATCHPROVIDER*	> ( this )	) ) ;
/*N*/ 
/*N*/ 	// If searched interface supported by this class ...
/*N*/ 	if ( aReturn.hasValue() == sal_True )
/*N*/ 	{
/*N*/ 		// ... return this information.
/*N*/ 		return aReturn ;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// Else; ... ask baseclass for interfaces!
/*N*/ 		return OWeakObject::queryInterface( rType ) ;
/*N*/ 	}
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XInterface
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::acquire() throw()
/*N*/ {
/*N*/ 	// Attention:
/*N*/ 	//	Don't use mutex or guard in this method!!! Is a method of XInterface.
/*N*/ 
/*N*/ 	// Forward to baseclass
/*N*/ 	OWeakObject::acquire() ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XInterface
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::release() throw()
/*N*/ {
/*N*/ 	// Attention:
/*N*/ 	//	Don't use mutex or guard in this method!!! Is a method of XInterface.
/*N*/ 
/*N*/ 	// Forward to baseclass
/*N*/ 	OWeakObject::release() ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XTypeProvider
//________________________________________________________________________________________________________

/*N*/ SEQUENCE< UNOTYPE > SAL_CALL SfxBaseController::getTypes() throw( RUNTIMEEXCEPTION )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return SEQUENCE< UNOTYPE >(0); //STRIP001 
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XTypeProvider
//________________________________________________________________________________________________________

/*N*/ SEQUENCE< sal_Int8 > SAL_CALL SfxBaseController::getImplementationId() throw( RUNTIMEEXCEPTION )
/*N*/ {
/*?*/ 	// Create one Id for all instances of this class.
/*?*/ 	// Use ethernet address to do this! (sal_True)
/*?*/ 
/*?*/ 	// Optimize this method
/*?*/ 	// We initialize a static variable only one time. And we don't must use a mutex at every call!
/*?*/ 	// For the first call; pID is NULL - for the second call pID is different from NULL!
/*?*/ 	static OIMPLEMENTATIONID* pID = NULL ;
/*?*/ 
/*?*/ 	if ( pID == NULL )
/*?*/ 	{
/*?*/ 		// Ready for multithreading; get global mutex for first call of this method only! see before
/*?*/ 		MUTEXGUARD aGuard( MUTEX::getGlobalMutex() ) ;
/*?*/ 
/*?*/ 		// Control these pointer again ... it can be, that another instance will be faster then these!
/*?*/ 		if ( pID == NULL )
/*?*/ 		{
/*?*/ 			// Create a new static ID ...
/*?*/ 			static OIMPLEMENTATIONID aID( sal_False ) ;
/*?*/ 			// ... and set his address to static pointer!
/*?*/ 			pID = &aID ;
/*?*/ 		}
/*?*/ 	}
/*?*/ 
/*?*/ 	return pID->getImplementationId() ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::attachFrame( const REFERENCE< XFRAME >& xFrame ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     REFERENCE< XFRAME > xTemp( getFrame() ) ;
/*N*/ 
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 	if ( xTemp.is() )
/*N*/ 	{
/*N*/         xTemp->removeFrameActionListener( m_pData->m_xListener ) ;
/*N*/ 		REFERENCE < ::com::sun::star::util::XCloseBroadcaster > xCloseable( xTemp, ::com::sun::star::uno::UNO_QUERY );
/*N*/ 		if ( xCloseable.is() )
/*N*/ 			xCloseable->removeCloseListener( m_pData->m_xCloseListener );
/*N*/ 	}
/*N*/ 
/*N*/     m_pData->m_xFrame = xFrame;
/*N*/ 
/*N*/ 	if ( xFrame.is() )
/*N*/ 	{
/*N*/         xFrame->addFrameActionListener( m_pData->m_xListener ) ;
/*N*/ 		REFERENCE < ::com::sun::star::util::XCloseBroadcaster > xCloseable( xFrame, ::com::sun::star::uno::UNO_QUERY );
/*N*/ 		if ( xCloseable.is() )
/*N*/ 			xCloseable->addCloseListener( m_pData->m_xCloseListener );
/*N*/ 	}
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ sal_Bool SAL_CALL SfxBaseController::attachModel( const REFERENCE< XMODEL >& xModel ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	if ( m_pData->m_pViewShell && xModel.is() && xModel != m_pData->m_pViewShell->GetObjectShell()->GetModel() )
/*N*/ 	{
/*N*/ 		// don't allow to reattach a model!
/*N*/ 		DBG_ERROR("Can't reattach model!");
/*N*/ 		return sal_False;
/*N*/ 	}
/*N*/ 
/*N*/ 	REFERENCE < ::com::sun::star::util::XCloseBroadcaster > xCloseable( xModel, ::com::sun::star::uno::UNO_QUERY );
/*N*/ 	if ( xCloseable.is() )
/*N*/ 		xCloseable->addCloseListener( m_pData->m_xCloseListener );
/*N*/ 	return sal_True;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________


//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ ANY SfxBaseController::getViewData() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/     ANY         aAny;
/*N*/ 	return aAny ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::restoreViewData( const ANY& aValue ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ REFERENCE< XFRAME > SAL_CALL SfxBaseController::getFrame() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     return m_pData->m_xFrame;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XController
//________________________________________________________________________________________________________

/*N*/ REFERENCE< XMODEL > SAL_CALL SfxBaseController::getModel() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     return m_pData->m_pViewShell ? m_pData->m_pViewShell->GetObjectShell()->GetModel() : REFERENCE < XMODEL > () ;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XDispatchProvider
//________________________________________________________________________________________________________

/*N*/ REFERENCE< XDISPATCH > SAL_CALL SfxBaseController::queryDispatch(	const	UNOURL&				aURL			,
/*N*/ 																	const	OUSTRING&			sTargetFrameName,
/*N*/ 																			sal_Int32			eSearchFlags	) throw( RUNTIMEEXCEPTION )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     REFERENCE< XDISPATCH >  xDisp;
/*N*/     if ( m_pData->m_pViewShell )
/*N*/     {
/*N*/         SfxViewFrame*           pAct    = m_pData->m_pViewShell->GetViewFrame() ;
/*N*/         if ( !m_pData->m_bDisposing )
/*N*/         {
/*N*/             sal_uInt16 nId = 0;
/*N*/             if ( sTargetFrameName.compareToAscii( "_beamer" ) == COMPARE_EQUAL )
/*N*/             {
/*?*/                 SfxViewFrame *pFrame = m_pData->m_pViewShell->GetViewFrame();
/*?*/                 if ( eSearchFlags & ( ::com::sun::star::frame::FrameSearchFlag::CREATE ))
/*?*/                     pFrame->SetChildWindow( SID_BROWSER, TRUE );
/*?*/                 SfxChildWindow* pChildWin = pFrame->GetChildWindow( SID_BROWSER );
/*?*/                 REFERENCE < XFRAME > xFrame;
/*?*/                 if ( pChildWin )
/*?*/                     xFrame = ( pChildWin->GetFrame() );
/*?*/                 if ( xFrame.is() )
/*?*/                     xFrame->setName( sTargetFrameName );
/*?*/ 
/*?*/                 REFERENCE < XDISPATCHPROVIDER > xProv( xFrame, ::com::sun::star::uno::UNO_QUERY );
/*?*/                 if ( xProv.is() )
/*?*/                     return xProv->queryDispatch( aURL, sTargetFrameName, ::com::sun::star::frame::FrameSearchFlag::SELF );
/*N*/             }
/*N*/ 
/*N*/             if ( aURL.Protocol.compareToAscii( ".uno:" ) == COMPARE_EQUAL )
/*N*/             {
/*N*/                 SfxShell *pShell=0;
/*N*/                 USHORT nIdx;
/*N*/                 for (nIdx=0; (pShell=pAct->GetDispatcher()->GetShell(nIdx)); nIdx++)
/*N*/                 {
/*N*/                     const SfxInterface *pIFace = pShell->GetInterface();
/*N*/                     const SfxSlot* pSlot = pIFace->GetSlot( aURL.Path );
/*N*/                     if ( pSlot )
/*N*/                     {
/*N*/                         nId = pSlot->GetSlotId();
/*N*/                         break;
/*N*/                     }
/*N*/                 }
/*N*/             }
/*N*/             else if ( aURL.Protocol.compareToAscii( "slot:" ) == COMPARE_EQUAL )
/*N*/             {
/*N*/                 nId = (USHORT) aURL.Path.toInt32();
/*N*/             }
/*N*/             else if( sTargetFrameName.compareToAscii( "_self" )==COMPARE_EQUAL || sTargetFrameName.getLength()==0 )
/*N*/             {
/*?*/                 // check for already loaded URL ... but with additional jumpmark!
/*?*/                 REFERENCE< XMODEL > xModel = getModel();
/*?*/                 if( xModel.is() && aURL.Mark.getLength() )
/*?*/                 {
/*?*/                     if( aURL.Main.getLength() && aURL.Main == xModel->getURL() )
/*?*/                         nId = SID_JUMPTOMARK;
/*?*/                 }
/*N*/             }
/*N*/ 
/*N*/             if ( nId && pAct->GetDispatcher()->HasSlot_Impl( nId ) )
/*N*/                 xDisp = new SfxOfficeDispatch( pAct->GetBindings(), pAct->GetDispatcher(), nId, aURL) ;
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/ 	return xDisp;
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XDispatchProvider
//________________________________________________________________________________________________________

/*N*/ SEQUENCE< REFERENCE< XDISPATCH > > SAL_CALL SfxBaseController::queryDispatches( const SEQUENCE< DISPATCHDESCRIPTOR >& seqDescripts ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return SEQUENCE< REFERENCE< XDISPATCH > >(0);//STRIP001 
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XComponent
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::dispose() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     REFERENCE < XCONTROLLER > xTmp( this );
/*N*/ 	m_pData->m_bDisposing = sal_True ;
/*N*/ 
/*N*/ 	EVENTOBJECT aObject ;
/*N*/     aObject.Source = (XCONTROLLER*)this ;
/*N*/ 	m_pData->m_aListenerContainer.disposeAndClear( aObject ) ;
/*N*/ 
/*N*/     if ( m_pData->m_pController && m_pData->m_pController->getFrame().is() )
/*N*/         m_pData->m_pController->getFrame()->removeFrameActionListener( m_pData->m_xListener ) ;
/*N*/ 
/*N*/     if ( m_pData->m_pViewShell )
/*N*/     {
/*N*/         SfxViewFrame* pFrame = m_pData->m_pViewShell->GetViewFrame() ;
/*N*/ 		if ( pFrame && pFrame->GetViewShell() == m_pData->m_pViewShell )
/*N*/ 			pFrame->GetFrame()->SetIsClosing_Impl();
/*N*/ 		m_pData->m_pViewShell->DiscardClients_Impl();
/*N*/         m_pData->m_pViewShell->pImp->bControllerSet = sal_False ;
/*N*/         if ( pFrame )
/*N*/         {
/*N*/             EVENTOBJECT aObject;
/*N*/             aObject.Source = (OWEAKOBJECT*)this ;
/*N*/ 
/*N*/             // Bei Reload hat die alte ViewShell keinen Frame!
/*N*/             SfxObjectShell* pDoc = pFrame->GetObjectShell() ;
/*N*/             REFERENCE< XMODEL > xModel = pDoc->GetModel();
/*N*/ 			REFERENCE < ::com::sun::star::util::XCloseable > xCloseable( xModel, ::com::sun::star::uno::UNO_QUERY );
/*N*/             if ( xModel.is() )
/*N*/ 			{
/*N*/                 xModel->disconnectController( this );
/*N*/ 				if ( xCloseable.is() )
/*N*/ 					xCloseable->removeCloseListener( m_pData->m_xCloseListener );
/*N*/ 			}
/*N*/ 
/*N*/             REFERENCE < XFRAME > aXFrame;
/*N*/ 			attachFrame( aXFrame );
/*N*/ 
/*N*/             m_pData->m_xListener->disposing( aObject );
/*N*/             SfxViewShell *pShell = m_pData->m_pViewShell;
/*N*/             m_pData->m_pViewShell = NULL;
/*N*/             if ( pFrame->GetViewShell() == pShell )
/*N*/             {
/*N*/                 pFrame->GetBindings().ENTERREGISTRATIONS();
/*N*/                 pFrame->GetFrame()->SetFrameInterface_Impl(  aXFrame );
/*N*/                 pFrame->GetFrame()->DoClose_Impl();
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }


//________________________________________________________________________________________________________
//	SfxBaseController -> XComponent
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::addEventListener( const REFERENCE< XEVENTLISTENER >& aListener ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	m_pData->m_aListenerContainer.addInterface( ::getCppuType((const REFERENCE< XEVENTLISTENER >*)0), aListener );
/*N*/ }

//________________________________________________________________________________________________________
//	SfxBaseController -> XComponent
//________________________________________________________________________________________________________

/*N*/ void SAL_CALL SfxBaseController::removeEventListener( const REFERENCE< XEVENTLISTENER >& aListener ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	m_pData->m_aListenerContainer.removeInterface( ::getCppuType((const REFERENCE< XEVENTLISTENER >*)0), aListener );
/*N*/ }

/*N*/ void SfxBaseController::ReleaseShell_Impl()
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( m_pData->m_pViewShell )
/*N*/     {
/*?*/         SfxObjectShell* pDoc = m_pData->m_pViewShell->GetObjectShell() ;
/*?*/         REFERENCE< XMODEL > xModel = pDoc->GetModel();
/*?*/         REFERENCE < ::com::sun::star::util::XCloseable > xCloseable( xModel, ::com::sun::star::uno::UNO_QUERY );
/*?*/         if ( xModel.is() )
/*?*/         {
/*?*/             xModel->disconnectController( this );
/*?*/             if ( xCloseable.is() )
/*?*/                 xCloseable->removeCloseListener( m_pData->m_xCloseListener );
/*?*/         }
/*?*/         m_pData->m_pViewShell = 0;
/*?*/ 
/*?*/         REFERENCE < XFRAME > aXFrame;
/*?*/ 		attachFrame( aXFrame );
/*N*/     }
/*N*/ }

/*N*/ SfxViewShell* SfxBaseController::GetViewShell_Impl() const
/*N*/ {
/*N*/     return m_pData->m_pViewShell;
/*N*/ }

/*N*/ ::com::sun::star::uno::Reference< ::com::sun::star::task::XStatusIndicator > SAL_CALL SfxBaseController::getStatusIndicator(  ) throw (::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/     if ( m_pData->m_pViewShell && !m_pData->m_xIndicator.is() )
/*N*/         m_pData->m_xIndicator = new SfxStatusIndicator( this, m_pData->m_pViewShell->GetViewFrame()->GetFrame()->GetWorkWindow_Impl() );
/*N*/     return m_pData->m_xIndicator;
/*N*/ }

/*N*/ void SAL_CALL SfxBaseController::registerContextMenuInterceptor( const REFERENCE< XCONTEXTMENUINTERCEPTOR >& xInterceptor ) throw( RUNTIMEEXCEPTION )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SAL_CALL SfxBaseController::releaseContextMenuInterceptor( const REFERENCE< XCONTEXTMENUINTERCEPTOR >& xInterceptor ) throw( RUNTIMEEXCEPTION )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }









}
