/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svxmsbas.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:23:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SVXERR_HXX
#include <svxerr.hxx>
#endif

#ifndef _SVXMSBAS_HXX
#include <svxmsbas.hxx>
#endif

namespace binfilter {
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::script;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;






	// check if the MS-VBA-Storage exist in the RootStorage of the DocShell.
	// If it exist, then return the WarningId for loosing the information.
/*N*/ ULONG SvxImportMSVBasic::GetSaveWarningOfMSVBAStorage( SfxObjectShell &rDocSh)
/*N*/ {
/*N*/ 	SvStorageRef xSrcRoot( rDocSh.GetStorage() );
/*N*/ 	SvStorageRef xVBAStg( xSrcRoot->OpenStorage( GetMSBasicStorageName(),
/*N*/ 					STREAM_READ | STREAM_NOCREATE | STREAM_SHARE_DENYALL ));
/*N*/ 	return ( xVBAStg.Is() && !xVBAStg->GetError() )
/*N*/ 					? ERRCODE_SVX_VBASIC_STORAGE_EXIST
/*N*/ 					: ERRCODE_NONE;
/*N*/ }

/*N*/ String SvxImportMSVBasic::GetMSBasicStorageName()
/*N*/ {
/*N*/ char __READONLY_DATA sSO_VBAStgName[] = "_MS_VBA_Macros";
/*N*/ 	return String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM(sSO_VBAStgName));
/*N*/ }

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
}
