/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tbcontrl.cxx,v $
 *
 *  $Revision: 1.8.44.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 16:17:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX //autogen wg. ToolBox
#include <vcl/toolbox.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX //autogen wg. System
//#include <vcl/system.hxx>
//#endif
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
#ifndef _CTRLBOX_HXX //autogen
#include <svtools/ctrlbox.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFX_TPLPITEM_HXX
#include <bf_sfx2/tplpitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXISETHINT_HXX
#include <svtools/isethint.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_FONTOPTIONS_HXX
#include <svtools/fontoptions.hxx>
#endif
#pragma hdrstop

#define _SVX_TBCONTRL_CXX


#include "dialogs.hrc"
#include "svxitems.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE	0
#define ITEMID_FONTLIST		SID_ATTR_CHAR_FONTLIST
#define ITEMID_FONT			SID_ATTR_CHAR_FONT
#define ITEMID_FONTHEIGHT	SID_ATTR_CHAR_FONTHEIGHT
#define ITEMID_COLOR		SID_ATTR_CHAR_COLOR
#define ITEMID_BRUSH		SID_ATTR_BRUSH
#define ITEMID_BOX			SID_ATTR_BORDER_OUTER
#define ITEMID_BOXINFO		SID_ATTR_BORDER_INNER
#define ITEMID_LINE			SID_FRAME_LINESTYLE

#include "fontitem.hxx"
#include "fhgtitem.hxx"
#include "boxitem.hxx"
#include "colritem.hxx"
#include "flstitem.hxx"
#include "bolnitem.hxx"
#include "tbcontrl.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
namespace binfilter {

// ------------------------------------------------------------------------

#define IMAGE_COL_TRANSPARENT		COL_LIGHTMAGENTA
#define MAX_MRU_FONTNAME_ENTRIES	5
#define LOGICAL_EDIT_HEIGHT         12
// STATIC DATA -----------------------------------------------------------

#ifndef DELETEZ
#define DELETEZ(p) (delete (p), (p)=NULL)
#endif
#define MAX_STYLES_ENTRIES	((USHORT)26)

void lcl_ResizeValueSet( Window &rWin, ValueSet &rValueSet );
void lcl_CalcSizeValueSet( Window &rWin, ValueSet &rValueSet, const Size &aItemSize );
BOOL lcl_FontChangedHint( const SfxHint &rHint );

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxStyleToolBoxControl, SfxTemplateItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontNameToolBoxControl, SvxFontItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontHeightToolBoxControl, SvxFontHeightItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFontColorExtToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameToolBoxControl, SvxBoxItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameLineStyleToolBoxControl, SvxLineItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFrameLineColorToolBoxControl, SvxColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxReloadControllerItem,	SfxBoolItem );

//========================================================================
// class SvxStyleBox_Impl -----------------------------------------------------
//========================================================================

class SvxStyleBox_Impl : public ListBox
{
public:
    SvxStyleBox_Impl( Window* pParent, USHORT nSlot, SfxStyleFamily eFamily, SfxBindings& rBind );
	~SvxStyleBox_Impl();

	void 			SetFamily( SfxStyleFamily eNewFamily );
	BOOL			IsVisible() { return bVisible; }

    virtual void	StateChanged( StateChangedType nStateChange ){DBG_BF_ASSERT(0, "STRIP");}//STRIP001 virtual void	StateChanged( StateChangedType nStateChange );

	void			SetVisibilityListener( const Link& aVisListener ) { aVisibilityListener = aVisListener; }
	void			RemoveVisibilityListener() { aVisibilityListener = Link(); }

protected:

private:
	USHORT			nSlotId;
	SfxStyleFamily	eStyleFamily;
	USHORT			nCurSel;
	BOOL			bRelease;
	SfxBindings&	rBindings;
    Size            aLogicalSize;
	Link			aVisibilityListener;
	BOOL			bVisible;

};

//========================================================================
// class SvxFontNameBox --------------------------------------------------
//========================================================================

class SvxFontNameBox_Impl : public FontNameBox, public SfxListener
{
private:
	const FontList*	pFontList;
	Font			aCurFont;
    Size            aLogicalSize;
	String			aCurText;
	USHORT			nFtCount;
	BOOL			bRelease;
	SfxBindings&	rBindings;

	void			EnableControls_Impl();

protected:
	virtual void	Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

public:
    SvxFontNameBox_Impl( Window* pParent, SfxBindings& rBind, WinBits nStyle = WB_SORT );

	void			Update( const SvxFontItem* pFontItem );
	USHORT			GetListCount() { return nFtCount; }
	void			Clear() { FontNameBox::Clear(); nFtCount = 0; }
	void			Fill( const FontList* pList )
						{ FontNameBox::Fill( pList );
						  nFtCount = pList->GetFontNameCount(); }
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();
};

//========================================================================
// class SvxFontSizeBox_Impl --------------------------------------------------
//========================================================================

class SvxFontHeightToolBoxControl;

class SvxFontSizeBox_Impl : public FontSizeBox
{
private:
	SvxFontHeightToolBoxControl*	pCtrl;
	String							aCurText;
    Size                            aLogicalSize;
	BOOL							bRelease;
	SfxBindings&					rBindings;


protected:

public:
                        SvxFontSizeBox_Impl( Window* pParent,
										SvxFontHeightToolBoxControl& rCtrl, SfxBindings& rBind );

	void				StateChanged_Impl( SfxItemState eState,
										   const SfxPoolItem* pState );
	void				Update( const SvxFontItem& rFontItem );

	virtual long		Notify( NotifyEvent& rNEvt );
};

//========================================================================
// class SvxColorWindow_Impl --------------------------------------------------
//========================================================================


//========================================================================
// class SvxFrameWindow_Impl --------------------------------------------------
//========================================================================

// fuer den SelectHdl werden die Modifier gebraucht, also
// muss man sie im MouseButtonUp besorgen

class SvxFrmValueSet_Impl : public ValueSet
{
	USHORT			nModifier;

	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
public:
    SvxFrmValueSet_Impl(Window* pParent,  WinBits nWinStyle)
		: ValueSet(pParent, nWinStyle), nModifier(0) {}
	USHORT			GetModifier() const {return nModifier;}

};




//========================================================================
// class SvxLineWindow_Impl ---------------------------------------------------
//========================================================================

//########################################################################
// Hilfsklassen:
//========================================================================
// class SvxTbxButtonColorUpdater_Impl ----------------------------------------
//========================================================================
#define TBX_UPDATER_MODE_NONE 				0x00
#define TBX_UPDATER_MODE_CHAR_COLOR 		0x01
#define TBX_UPDATER_MODE_CHAR_BACKGROUND 	0x02
#define TBX_UPDATER_MODE_CHAR_COLOR_NEW		0x03

class SvxTbxButtonColorUpdater_Impl
{
public:
                SvxTbxButtonColorUpdater_Impl( USHORT nTbxBtnId,
										  ToolBox* ptrTbx, USHORT nMode = 0 );
                ~SvxTbxButtonColorUpdater_Impl();

	void 		Update( const Color& rColor );

protected:

private:
	USHORT		nDrawMode;
	USHORT		nBtnId;
	ToolBox*	pTbx;
	Bitmap*		pBtnBmp;
	Color		aCurColor;
	Rectangle	theUpdRect;
	Size		theBmpSize;
	BOOL		bWasHiContrastMode;
};

//========================================================================
// class SfxStyleControllerItem ------------------------------------------
//========================================================================
class SvxStyleToolBoxControl;

class SfxStyleControllerItem_Impl : public SfxControllerItem
{
public:
    SfxStyleControllerItem_Impl( USHORT nId, SfxBindings& rBindings, SvxStyleToolBoxControl& rTbxCtl );

protected:
	virtual void StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );

private:
	SvxStyleToolBoxControl& rControl;
};

//========================================================================
// class SvxStyleBox_Impl -----------------------------------------------------
//========================================================================

/*N*/ SvxStyleBox_Impl::SvxStyleBox_Impl( Window* pParent, USHORT nSlot, SfxStyleFamily eFamily, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	ListBox( pParent, SVX_RES( RID_SVXTBX_STYLE ) ),
/*N*/ 
/*N*/ 	eStyleFamily( eFamily ),
/*N*/ 	nSlotId		( nSlot ),
/*N*/ 	bRelease	( TRUE ),
/*N*/ 	rBindings	( rBind )
/*N*/ 
/*N*/ {
/*N*/     aLogicalSize = PixelToLogic( GetSizePixel(), MAP_APPFONT );
/*N*/ }

/*N*/ SvxStyleBox_Impl::~SvxStyleBox_Impl()
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

/*N*/ void SvxStyleBox_Impl::SetFamily( SfxStyleFamily eNewFamily )
/*N*/ {
/*N*/ 	eStyleFamily = eNewFamily;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/* -----------------------------08.03.2002 13:03------------------------------

 ---------------------------------------------------------------------------*/



// -----------------------------------------------------------------------

#define BRUSH(style,name) BrushStyle(style),SVX_RESSTR(name)
#define COLOR(color,name) Color(color),SVX_RESSTR(name)


//========================================================================
// class SvxFontNameBox_Impl --------------------------------------------------
//========================================================================

/*N*/ SvxFontNameBox_Impl::SvxFontNameBox_Impl( Window* pParent, SfxBindings& rBind, WinBits nStyle ) :
/*N*/ 
/*N*/ 	FontNameBox	( pParent, nStyle | WinBits( WB_DROPDOWN | WB_AUTOHSCROLL ) ),
/*N*/     aLogicalSize(55,80),
/*N*/ 	pFontList	( NULL ),
/*N*/ 	nFtCount	( 0 ),
/*N*/ 	bRelease	( TRUE ),
/*N*/ 	rBindings	( rBind )
/*N*/ 
/*N*/ {
/*N*/     SetSizePixel(LogicToPixel( aLogicalSize, MAP_APPFONT ));
/*N*/     EnableControls_Impl();
/*N*/ 	StartListening( *SFX_APP() );
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::Update( const SvxFontItem* pFontItem )
/*N*/ {
/*N*/ 	if ( pFontItem )
/*N*/ 	{
/*N*/ 		aCurFont.SetName		( pFontItem->GetFamilyName() );
/*N*/ 		aCurFont.SetFamily		( pFontItem->GetFamily() );
/*N*/ 		aCurFont.SetStyleName	( pFontItem->GetStyleName() );
/*N*/ 		aCurFont.SetPitch		( pFontItem->GetPitch() );
/*N*/ 		aCurFont.SetCharSet		( pFontItem->GetCharSet() );
/*N*/ 	}
/*N*/ 	String aCurName = aCurFont.GetName();
/*N*/ 	if ( GetText() != aCurName )
/*N*/ 		SetText( aCurName );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontNameBox_Impl::PreNotify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	USHORT nType = rNEvt.GetType();
/*N*/ 
/*N*/ 	if ( EVENT_MOUSEBUTTONDOWN == nType || EVENT_GETFOCUS == nType )
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		FillList();
/*N*/     return FontNameBox::PreNotify( rNEvt );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontNameBox_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	long nHandled = 0;
/*N*/ 
/*N*/ 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/ 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
/*?*/ 
/*?*/ 		switch ( nCode )
/*?*/ 		{
/*?*/ 			case KEY_RETURN:
/*?*/ 			case KEY_TAB:
/*?*/ 			{
/*?*/ 				if ( KEY_TAB == nCode )
/*?*/ 					bRelease = FALSE;
/*?*/ 				else
/*?*/ 					nHandled = 1;
/*?*/ 				Select();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			case KEY_ESCAPE:
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				SetText( aCurText );
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/     else if ( EVENT_LOSEFOCUS == rNEvt.GetType() )
/*N*/ 	{
/*?*/ 		Window* pFocusWin = Application::GetFocusWindow();
/*?*/ 		if ( !HasFocus() && GetSubEdit() != pFocusWin )
/*?*/ 			SetText( GetSavedValue() );
/*N*/ 	}
/*N*/ 
/*N*/ 	return nHandled ? nHandled : FontNameBox::Notify( rNEvt );
/*N*/ }
/* -----------------------------08.03.2002 13:23------------------------------

 ---------------------------------------------------------------------------*/

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::EnableControls_Impl()
/*N*/ {
/*N*/ 	SvtFontOptions aFontOpt;
/*N*/ 	BOOL bEnable = aFontOpt.IsFontHistoryEnabled();
/*N*/ 	USHORT nEntries = bEnable ? MAX_MRU_FONTNAME_ENTRIES : 0;
/*N*/ 	if ( GetMaxMRUCount() != nEntries )
/*N*/ 	{
/*N*/ 		// refill in the next GetFocus-Handler
/*N*/ 		pFontList = NULL;
/*N*/ 		Clear();
/*N*/ 		SetMaxMRUCount( nEntries );
/*N*/ 	}
/*N*/ 
/*N*/ 	bEnable = aFontOpt.IsFontWYSIWYGEnabled();
/*N*/ 	EnableWYSIWYG( bEnable );
/*N*/ 	EnableSymbols( bEnable );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameBox_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	SfxItemSetHint* pHint = PTR_CAST(SfxItemSetHint, &rHint);
/*N*/ 	if ( pHint )
/*?*/ 		EnableControls_Impl();
/*N*/ }

// -----------------------------------------------------------------------


//========================================================================
// class SvxFontSizeBox_Impl --------------------------------------------------
//========================================================================

/*N*/ SvxFontSizeBox_Impl::SvxFontSizeBox_Impl( Window* pParent, SvxFontHeightToolBoxControl &rCtrl, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	FontSizeBox( pParent, WinBits( WB_DROPDOWN ) ),
/*N*/ 
/*N*/ 	pCtrl		( &rCtrl ),
/*N*/ 	bRelease	( TRUE ),
/*N*/     rBindings   ( rBind ),
/*N*/     aLogicalSize(20,80)
/*N*/ 
/*N*/ {
/*N*/     SetSizePixel(LogicToPixel( aLogicalSize, MAP_APPFONT ));
/*N*/ 	SetValue( 0 );
/*N*/ 	SetText( String() );
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

/*N*/ void SvxFontSizeBox_Impl::StateChanged_Impl( SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 	{
/*N*/ 		// Metric Umrechnen
/*N*/ 		long nH = ( (const SvxFontHeightItem*)pState )->GetHeight() * 10;
/*N*/ 		long nVal = LogicToLogic( nH, (MapUnit)pCtrl->GetCoreMetric(), MAP_POINT );
/*N*/ 
/*N*/ 		// ge"andert => neuen Wert setzen
/*N*/ 		if ( GetValue() != nVal )
/*N*/ 			SetValue( nVal );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// Wert in der Anzeige l"oschen
/*N*/ 		SetValue( -1L );
/*N*/ 		SetText( String() );
/*N*/ 	}
/*N*/     SaveValue();
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontSizeBox_Impl::Update( const SvxFontItem& rFontItem )
/*N*/ {
/*N*/ 	// Fontliste vom Document abholen
/*N*/ 	const SfxObjectShell* pDocSh = SfxObjectShell::Current();
/*N*/ 	const SvxFontListItem* pFontListItem = (const SvxFontListItem*)
/*N*/ 		( pDocSh ? pDocSh->GetItem( SID_ATTR_CHAR_FONTLIST ) : NULL );
/*N*/ 
/*N*/ 	// Sizes-Liste auff"ullen
/*N*/ 	long nOldVal = GetValue(); // alten Wert merken
/*N*/ 	FontInfo aFontInfo;
/*N*/ 	FASTBOOL bCreate = FALSE;
/*N*/ 	const FontList* pFontList = pFontListItem ? pFontListItem->GetFontList() : NULL;
/*N*/ 	if ( pFontList )
/*N*/ 	{
/*N*/ 		aFontInfo = FontInfo( pFontList->Get( rFontItem.GetFamilyName(), rFontItem.GetStyleName() ) );
/*N*/ 		Fill( &aFontInfo, pFontList );
/*N*/ 	}
/*N*/ 	SetValue( nOldVal ); // alten Wert wiederherstellen
/*N*/ 	aCurText = GetText(); // zum R"ucksetzen bei ESC merken
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ long SvxFontSizeBox_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	long nHandled = 0;
/*N*/ 
/*N*/ 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/ 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
/*?*/ 
/*?*/ 		switch ( nCode )
/*?*/ 		{
/*?*/ 			case KEY_RETURN:
/*?*/ 			case KEY_TAB:
/*?*/ 			{
/*?*/ 				if ( KEY_TAB == nCode )
/*?*/ 					bRelease = FALSE;
/*?*/ 				else
/*?*/ 					nHandled = 1;
/*?*/ 				Select();
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/ 			case KEY_ESCAPE:
/*?*/				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				SetText( aCurText );
/*?*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/     else if(EVENT_LOSEFOCUS == rNEvt.GetType())
/*N*/ 	{
/*?*/ 		Window* pFocusWin = Application::GetFocusWindow();
/*?*/ 		if(!HasFocus() && GetSubEdit() != pFocusWin)
/*?*/ 			SetText(GetSavedValue());
/*N*/ 	}
/*N*/ 
/*N*/ 	return nHandled ? nHandled : FontSizeBox::Notify( rNEvt );
/*N*/ }
/* -----------------------------08.03.2002 13:24------------------------------

 ---------------------------------------------------------------------------*/

//========================================================================
// class SvxColorWindow_Impl --------------------------------------------------
//========================================================================
#ifndef WB_NO_DIRECTSELECT
#define WB_NO_DIRECTSELECT      ((WinBits)0x04000000)
#endif




// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


//========================================================================
// class SvxFrameWindow_Impl --------------------------------------------------
//========================================================================





// -----------------------------------------------------------------------

#define FRM_VALID_LEFT 		0x01
#define FRM_VALID_RIGHT 	0x02
#define FRM_VALID_TOP 		0x04
#define FRM_VALID_BOTTOM 	0x08
#define FRM_VALID_HINNER 	0x10
#define FRM_VALID_VINNER 	0x20
#define FRM_VALID_OUTER		0x0f
#define FRM_VALID_ALL       0xff

//
// Per default bleiben ungesetzte Linien unveraendert
// Mit Shift werden ungesetzte Linien zurueckgsetzt
//

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


//========================================================================
// class SvxLineWindow_Impl --------------------------------------------------
//========================================================================



// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

#undef BRUSH
#undef COLOR
#undef GET_DOCFONTLIST

//########################################################################
// Hilfsklassen

//========================================================================
// class SvxTbxButtonColorUpdater_Impl ----------------------------------------
//========================================================================

/*N*/ SvxTbxButtonColorUpdater_Impl::SvxTbxButtonColorUpdater_Impl( USHORT nTbxBtnId,
/*N*/ 													ToolBox* ptrTbx,
/*N*/ 													USHORT nMode ) :
/*N*/ 	nDrawMode		  ( nMode ),
/*N*/ 	nBtnId			  ( nTbxBtnId ),
/*N*/ 	pTbx			  ( ptrTbx ),
/*N*/ 	pBtnBmp			  ( NULL ),
/*N*/ 	aCurColor		  ( COL_TRANSPARENT )
/*N*/ {
/*N*/     if (nTbxBtnId == SID_BACKGROUND_COLOR)
/*N*/         nDrawMode = TBX_UPDATER_MODE_CHAR_COLOR_NEW;
/*N*/ 	DBG_ASSERT( pTbx, "ToolBox not found :-(" );
/*N*/ 	bWasHiContrastMode = pTbx ? ( pTbx->GetBackground().GetColor().IsDark() ) : FALSE;
/*N*/ 	Update(nTbxBtnId == SID_ATTR_CHAR_COLOR2 ? COL_BLACK : COL_GRAY);
/*N*/ 	return;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxTbxButtonColorUpdater_Impl::~SvxTbxButtonColorUpdater_Impl()
/*N*/ {
/*N*/ 	delete pBtnBmp;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxTbxButtonColorUpdater_Impl::Update( const Color& rColor )
/*N*/ {
/*N*/ 	Image	aImage( pTbx->GetItemImage( nBtnId ) );
/*N*/ 	BOOL	bSizeChanged = ( theBmpSize != aImage.GetSizePixel() );
/*N*/ 	BOOL	bDisplayModeChanged = ( bWasHiContrastMode != pTbx->GetBackground().GetColor().IsDark() );
/*N*/ 
/*N*/     Color aColor( rColor );
/*N*/     
/*N*/     // #109290# Workaround for SetFillColor with COL_AUTO
/*N*/     if ( aColor.GetColor() == COL_AUTO )
/*N*/         aColor = Color( IMAGE_COL_TRANSPARENT );
/*N*/ 
/*N*/ 	if ( aCurColor == aColor && !bSizeChanged && !bDisplayModeChanged )
/*N*/ 		return;
/*N*/ 
/*N*/ 	VirtualDevice aVirDev( *pTbx );
/*N*/ 	Point aNullPnt;
/*N*/ 
/*N*/ 	if ( bSizeChanged || bDisplayModeChanged )
/*N*/ 	{
/*N*/ 		bWasHiContrastMode = pTbx->GetBackground().GetColor().IsDark();
/*N*/ 		theBmpSize = aImage.GetSizePixel();
/*N*/ 
/*N*/ 		if ( theBmpSize.Width() <= 16 )
/*N*/ 			theUpdRect = Rectangle( Point(7,7), Size(8,8) );
/*N*/ 		else
/*N*/ 			theUpdRect = Rectangle( Point(14,14), Size(11,11) );
/*N*/ 
/*N*/ 		aVirDev.SetLineColor();
/*N*/ 		aVirDev.SetOutputSizePixel( theBmpSize );
/*N*/ 		aVirDev.SetFillColor( Color( IMAGE_COL_TRANSPARENT ) );
/*N*/ 		aVirDev.DrawRect( Rectangle( aNullPnt, theBmpSize ) );
/*N*/ 		aVirDev.DrawImage( aNullPnt, aImage );
/*N*/ 		delete pBtnBmp;
/*N*/ 		pBtnBmp = new Bitmap( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 		if ( nDrawMode != TBX_UPDATER_MODE_CHAR_COLOR_NEW )
/*N*/ 			aVirDev.DrawRect( theUpdRect );
/*N*/ 	}
/*N*/ 	else if ( !pBtnBmp )
/*?*/ 		pBtnBmp = new Bitmap( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 
/*N*/ 	aVirDev.SetOutputSizePixel( theBmpSize );
/*N*/ 	aVirDev.DrawBitmap( aNullPnt, *pBtnBmp );
/*N*/ 
/*N*/ 	// Choose line color according to background color
/*N*/ 	if ( pTbx->GetBackground().GetColor().IsDark() )
/*?*/ 		aVirDev.SetLineColor( COL_WHITE );
/*N*/ 	else
/*N*/ 		aVirDev.SetLineColor( COL_BLACK );
/*N*/ 
/*N*/ 	if ( nDrawMode == TBX_UPDATER_MODE_CHAR_COLOR_NEW &&
/*N*/ 		 ( aColor.GetColor() != COL_AUTO &&
/*N*/ 		   aColor.GetColor() != IMAGE_COL_TRANSPARENT ))
/*N*/ 	{
/*N*/ 		// Draw border only if COLOR_AUTO is the new color!
/*N*/ 		aVirDev.SetLineColor( aColor );
/*N*/ 	}
/*N*/ 	aVirDev.SetFillColor( aColor );
/*N*/ 
/*N*/ 	if ( nDrawMode == TBX_UPDATER_MODE_CHAR_COLOR_NEW )
/*N*/ 	{
/*N*/ 		// New mode for our new high contrast enabled bitmaps
/*N*/ 		if ( theBmpSize.Width() <= 16 )
/*N*/ 			theUpdRect = Rectangle( Point( 0,12 ), Size(theBmpSize.Width(), 4 ) );
/*N*/ 		else
/*?*/ 			theUpdRect = Rectangle( Point( 1,19 ), Size( 24,6 ) );
/*N*/ 		aVirDev.DrawRect( theUpdRect );
/*N*/ 	}
/*N*/ 	else if ( nDrawMode != TBX_UPDATER_MODE_NONE )
/*N*/ 	{
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 DrawChar( aVirDev, aColor );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aVirDev.DrawRect( theUpdRect );
/*N*/ 
/*N*/ 	aCurColor = aColor;
/*N*/ 
/*N*/     // The following code asumes that we cannot change the display color depth
/*N*/     // during Office runtime. Which is at least NOT true for newer Windows versions!
/*N*/ 	const Bitmap	aBmp( aVirDev.GetBitmap( aNullPnt, theBmpSize ) );
/*N*/ 	static Color	aTransparentColor;
/*N*/ 	static sal_Bool	bTransparentColorInitialized = sal_False;
/*N*/ 
/*N*/ 	if( !bTransparentColorInitialized )
/*N*/ 	{
/*N*/ 		aVirDev.DrawPixel( aNullPnt, IMAGE_COL_TRANSPARENT );
/*N*/ 		aTransparentColor = aVirDev.GetPixel( aNullPnt );
/*N*/ 		bTransparentColorInitialized = sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	Bitmap	aMaskBitmap = aBmp.CreateMask( aTransparentColor );
/*N*/ 	Image aNewImage( aBmp, aMaskBitmap );
/*N*/ 	pTbx->SetItemImage( nBtnId, aNewImage );
/*N*/ }

// -----------------------------------------------------------------------

//========================================================================
// class SfxStyleControllerItem_Impl ------------------------------------------
//========================================================================

/*N*/ SfxStyleControllerItem_Impl::SfxStyleControllerItem_Impl(
/*N*/ 				USHORT					nId,		// Family-ID
/*N*/ 				SfxBindings&			rBindings,	// the Bindings
/*N*/ 				SvxStyleToolBoxControl&	rTbxCtl )	// Controller-Instanz, dem
/*N*/ 													// dieses Item zugeordnet ist.
/*N*/ 	:	SfxControllerItem	( nId, rBindings ),
/*N*/ 		rControl			( rTbxCtl )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SfxStyleControllerItem_Impl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	switch ( GetId() )
/*N*/ 	{
/*N*/ 		case SID_STYLE_FAMILY1:
/*N*/ 		case SID_STYLE_FAMILY2:
/*N*/ 		case SID_STYLE_FAMILY3:
/*N*/ 		case SID_STYLE_FAMILY4:
/*N*/ 		case SID_STYLE_FAMILY5:
/*N*/ 		{
/*N*/ 			const USHORT nIdx = GetId() - SID_STYLE_FAMILY_START;
/*N*/ 
/*N*/ 			if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 			{
/*N*/ 				const SfxTemplateItem* pStateItem =
/*N*/ 					PTR_CAST( SfxTemplateItem, pState );
/*N*/ 				DBG_ASSERT( pStateItem != NULL, "SfxTemplateItem expected" );
/*N*/ 				rControl.SetFamilyState( nIdx, pStateItem );
/*N*/ 			}
/*N*/ 			else
/*N*/ 				rControl.SetFamilyState( nIdx, NULL );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//########################################################################

//========================================================================
// class SvxStyleToolBoxControl ------------------------------------------
//========================================================================

/*N*/ SvxStyleToolBoxControl::SvxStyleToolBoxControl( USHORT		 nId,
/*N*/ 												ToolBox&	 rTbx,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl	( nId, rTbx, rBindings ),
/*N*/ 		pStyleSheetPool		( NULL ),
/*N*/ 		nActFamily			( 0xffff ),
/*N*/ 		bListening			( FALSE )
/*N*/ {
/*N*/ 	rBindings.ENTERREGISTRATIONS();
/*N*/ 	USHORT i=0;
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/         pBoundItems [i] = new SfxStyleControllerItem_Impl( SID_STYLE_FAMILY_START + i, rBindings, *this );
/*N*/ 		pFamilyState[i] = NULL;
/*N*/ 	}
/*N*/ 	rBindings.LEAVEREGISTRATIONS();
/*N*/ 
/*N*/ 	// Default now: Unbind() controllers until we get our first visibility notification from our UI control.
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/ 		pBoundItems[i]->UnBind();
/*N*/ 		DBG_ASSERT( !pBoundItems[i]->IsBound(), "Invalidate bindings state!" );
/*N*/ 	}
/*N*/ 	UnBind();
/*N*/ 	DBG_ASSERT( !IsBound(), "Invalidate bindings state!" );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxStyleToolBoxControl::~SvxStyleToolBoxControl()
/*N*/ {
/*N*/ 	for( USHORT i=0; i<MAX_FAMILIES; i++ )
/*N*/ 	{
/*N*/ 		DELETEZ( pBoundItems [i] );
/*N*/ 		DELETEZ( pFamilyState[i] );
/*N*/ 	}
/*N*/ 	pStyleSheetPool = NULL;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SfxStyleFamily SvxStyleToolBoxControl::GetActFamily()
/*N*/ {
/*N*/ 	switch ( nActFamily-1 + SID_STYLE_FAMILY_START )
/*N*/ 	{
/*?*/ 		case SID_STYLE_FAMILY1:	return SFX_STYLE_FAMILY_CHAR;
/*N*/ 		case SID_STYLE_FAMILY2:	return SFX_STYLE_FAMILY_PARA;
/*?*/ 		case SID_STYLE_FAMILY3:	return SFX_STYLE_FAMILY_FRAME;
/*?*/ 		case SID_STYLE_FAMILY4:	return SFX_STYLE_FAMILY_PAGE;
/*?*/ 		case SID_STYLE_FAMILY5:	return SFX_STYLE_FAMILY_PSEUDO;
/*?*/ 		default:
/*?*/ 			DBG_ERROR( "unknown style family" );
/*?*/ 			break;
/*?*/ 	}
/*?*/ 	return SFX_STYLE_FAMILY_PARA;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::FillStyleBox()
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = (SvxStyleBox_Impl*)GetToolBox().GetItemWindow( GetId() );
/*N*/ 
/*N*/ 	DBG_ASSERT( pStyleSheetPool, "StyleSheetPool not found!" );
/*N*/ 	DBG_ASSERT( pBox,			 "Control not found!" );
/*N*/ 
/*N*/ 	if ( pStyleSheetPool && pBox && nActFamily!=0xffff )
/*N*/ 	{
/*N*/ 		const SfxStyleFamily	eFamily 	= GetActFamily();
/*N*/ 		USHORT					nCount  	= pStyleSheetPool->Count();
/*N*/ 		USHORT 					i			= 0;
/*N*/ 		SfxStyleSheetBase*		pStyle  	= NULL;
/*N*/ 		BOOL 					bDoFill 	= FALSE;
/*N*/ 
/*N*/ 		pStyleSheetPool->SetSearchMask( eFamily, SFXSTYLEBIT_USED );
/*N*/ 
/*N*/ 		//------------------------------
/*N*/ 		// Ueberpruefen, ob Fill noetig:
/*N*/ 		//------------------------------
/*N*/ 
/*N*/ 		pStyle = pStyleSheetPool->First();
/*N*/ 
/*N*/ 		if ( nCount != pBox->GetEntryCount() )
/*N*/ 		{
/*N*/ 			bDoFill = TRUE;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			while ( pStyle && !bDoFill )
/*?*/ 			{
/*?*/ 				bDoFill = ( pBox->GetEntry(i) != pStyle->GetName() );
/*?*/ 				pStyle = pStyleSheetPool->Next();
/*?*/ 				i++;
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( bDoFill )
/*N*/ 		{
/*N*/ 			pBox->SetUpdateMode( FALSE );
/*N*/ 			pBox->Clear();
/*N*/ 
/*N*/ 			// Listbox nur so gross, wie Eintraege vorhanden,
/*N*/ 			// hoechstens MAX_STYLES_ENTRIES Eintraege
/*N*/ 			// mindestens 4 Eintraege
/*N*/ 
/*N*/ 			if ( nCount > MAX_STYLES_ENTRIES )
/*?*/ 				nCount = MAX_STYLES_ENTRIES;
/*N*/ 			else if (nCount < 4)
/*N*/ 				nCount = 4;
/*N*/ 
/*N*/ 			nCount += 1; // +1 fuer Selektion
/*N*/ 
/*N*/ 			Size aSize( pBox->GetOutputSizePixel() );
/*N*/ 			long nNewHeight = nCount * (14 + 2) ; // 14 == TextHeight
/*N*/ 
/*N*/ 			if ( aSize.Height() != nNewHeight )
/*N*/ 			{
/*N*/ 				aSize.Height() = nNewHeight;
/*N*/ 				pBox->SetOutputSizePixel( aSize );
/*N*/ 			}
/*N*/ 
/*N*/ 			pStyle = pStyleSheetPool->First();
/*N*/ 
/*N*/ 			while ( pStyle )
/*N*/ 			{
/*N*/ 				pBox->InsertEntry( pStyle->GetName() );
/*N*/ 				pStyle = pStyleSheetPool->Next();
/*N*/ 			}
/*N*/ 
/*N*/ 			pBox->SetUpdateMode( TRUE );
/*N*/ 			pBox->SetFamily( eFamily );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SelectStyle( const String& rStyleName )
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = (SvxStyleBox_Impl*)GetToolBox().GetItemWindow( GetId() );
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( pBox )
/*N*/ 	{
/*N*/ 		String aStrSel( pBox->GetSelectEntry() );
/*N*/ 
/*N*/ 		if ( rStyleName.Len() > 0 )
/*N*/ 		{
/*N*/ 			if ( rStyleName != aStrSel )
/*N*/ 				pBox->SelectEntry( rStyleName );
/*N*/ 		}
/*N*/ 		else
/*?*/ 			pBox->SetNoSelection();
/*N*/         pBox->SaveValue();
/*N*/     }
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::Update()
/*N*/ {
/*N*/ 	SfxStyleSheetBasePool*	pPool	  = NULL;
/*N*/ 	SfxObjectShell*		pDocShell = SfxObjectShell::Current();
/*N*/ 
/*N*/ 	if ( pDocShell )
/*N*/ 		pPool = pDocShell->GetStyleSheetPool();
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for ( i=0; i<MAX_FAMILIES; i++ )
/*N*/ 		if( pFamilyState[i] )
/*N*/ 			break;
/*N*/ 
/*N*/ 	if ( i==MAX_FAMILIES || !pPool )
/*N*/ 	{
/*N*/ 		pStyleSheetPool = pPool;
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	//--------------------------------------------------------------------
/*N*/ 	const SfxTemplateItem* pItem = NULL;
/*N*/ 
/*N*/ 	if ( nActFamily == 0xffff || 0 == (pItem = pFamilyState[nActFamily-1]) )
/*N*/ 		// aktueller Bereich nicht innerhalb der erlaubten Bereiche
/*N*/ 		// oder Default
/*N*/ 	{
/*N*/ 		pStyleSheetPool = pPool;
/*N*/ 		nActFamily		= 2;
/*N*/ 
/*N*/ 		pItem = pFamilyState[nActFamily-1];
/*N*/ 		if ( !pItem )
/*N*/ 		{
/*?*/ 			nActFamily++;
/*?*/ 			pItem = pFamilyState[nActFamily-1];
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !pItem )
/*N*/ 			DBG_WARNING( "Unknown Family" ); // can happens
/*N*/ 	}
/*N*/ 	else if ( pPool != pStyleSheetPool )
/*?*/ 		pStyleSheetPool = pPool;
/*N*/ 
/*N*/ 	FillStyleBox(); // entscheidet selbst, ob gefuellt werden muss
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		SelectStyle( pItem->GetStyleName() );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
/*N*/ 	const TypeId& rBCType, const SfxHint&  rHint, const TypeId& rHintType )
/*N*/ {
/*N*/ 	if ( rHint.Type() == TYPE(SfxSimpleHint) &&
/*N*/ 		 ( (SfxSimpleHint&)rHint ).GetId() == SFX_HINT_UPDATEDONE )
/*N*/ 	{
/*N*/ 		Update();	// Aktualisierung anstossen
/*N*/ 		EndListening( GetBindings() );
/*N*/ 		bListening = FALSE;
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::SetFamilyState( USHORT nIdx,
/*N*/ 											 const SfxTemplateItem* pItem )
/*N*/ {
/*N*/ 	DELETEZ( pFamilyState[nIdx] );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pFamilyState[nIdx] = new SfxTemplateItem( *pItem );
/*N*/ 
/*N*/ 	if( !bListening )
/*N*/ 	{
/*N*/ 		StartListening( GetBindings() );
/*N*/ 		bListening = TRUE;
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*?*/ IMPL_LINK( SvxStyleToolBoxControl, VisibilityNotification, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxStyleToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 		 nId	= GetId();
/*N*/ 	ToolBox&	 rTbx   = GetToolBox();
/*N*/     SvxStyleBox_Impl* pBox   = (SvxStyleBox_Impl*)(rTbx.GetItemWindow( nId ));
/*N*/ 	TriState	 eTri	= STATE_NOCHECK;
/*N*/ 
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DISABLED == eState )
/*N*/ 		pBox->Disable();
/*N*/ 	else
/*N*/ 		pBox->Enable();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 			eTri = ((const SfxBoolItem*)pState)->GetValue()
/*N*/ 						? STATE_CHECK
/*N*/ 						: STATE_NOCHECK;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.SetItemState( nId, eTri );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxStyleToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     SvxStyleBox_Impl* pBox = new SvxStyleBox_Impl( pParent,
/*N*/ 										 SID_STYLE_APPLY,
/*N*/ 										 SFX_STYLE_FAMILY_PARA, GetBindings() );
/*N*/ 
/*N*/ 	// Set visibility listener to bind/unbind controller
/*N*/ 	pBox->SetVisibilityListener( LINK( this, SvxStyleToolBoxControl, VisibilityNotification ));
/*N*/ 
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontNameToolBoxControl ---------------------------------------
//========================================================================

/*N*/ SvxFontNameToolBoxControl::SvxFontNameToolBoxControl(
/*N*/ 											USHORT			nId,
/*N*/ 											ToolBox&		rTbx ,
/*N*/ 											SfxBindings&	rBindings)
/*N*/ 
/*N*/ 	:	SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontNameToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 			nId	= GetId();
/*N*/ 	ToolBox&		rTbx   = GetToolBox();
/*N*/     SvxFontNameBox_Impl* pBox   = (SvxFontNameBox_Impl*)(rTbx.GetItemWindow( nId ));
/*N*/ 	TriState		eTri   = STATE_NOCHECK;
/*N*/ 
/*N*/ 	DBG_ASSERT( pBox, "Control not found!" );
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DISABLED == eState )
/*N*/ 	{
/*N*/ 		pBox->Disable();
/*N*/ 		pBox->Update( (const SvxFontItem*)NULL );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		pBox->Enable();
/*N*/ 
/*N*/ 		if ( SFX_ITEM_AVAILABLE == eState )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( pState->ISA(SvxFontItem), "falscher ItemType" );
/*N*/ 			pBox->Update( (const SvxFontItem*) pState );
/*N*/ 		}
/*N*/ 		else
/*?*/ 			pBox->SetText( String() );
/*N*/         pBox->SaveValue();
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 
/*N*/ 	switch ( eState )
/*N*/ 	{
/*N*/ 		case SFX_ITEM_AVAILABLE:
/*N*/ 			eTri = ((const SfxBoolItem*)pState)->GetValue()
/*N*/ 						? STATE_CHECK
/*N*/ 						: STATE_NOCHECK;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ITEM_DONTCARE:
/*N*/ 			eTri = STATE_DONTKNOW;
/*N*/ 			break;
/*N*/ 	}
/*N*/ 
/*N*/ 	rTbx.SetItemState( nId, eTri );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxFontNameToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     SvxFontNameBox_Impl* pBox = new SvxFontNameBox_Impl( pParent, GetBindings() );
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontHeightToolBoxControl -------------------------------------
//========================================================================

/*N*/ SvxFontHeightToolBoxControl::SvxFontHeightToolBoxControl( USHORT nId, ToolBox& rTbx,
/*N*/ 														  SfxBindings& rBindings ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 
/*N*/ 	aFontNameForwarder	( SID_ATTR_CHAR_FONT, *this ),
/*N*/ 	pBox				( NULL ),
/*N*/ 	pFontItem			( NULL )
/*N*/ 
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------
/*N*/ SvxFontHeightToolBoxControl::~SvxFontHeightToolBoxControl()
/*N*/ {
/*N*/ 	delete pFontItem;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxFontHeightToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	// FontHeight?
/*N*/ 	if ( SID_ATTR_CHAR_FONTHEIGHT == nSID )
/*N*/ 	{
/*N*/ 		SfxToolBoxControl::StateChanged( nSID, eState, pState );
/*N*/ 		pBox->StateChanged_Impl( eState, pState );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// FontItem (Name) nur zur sp"aterne Verwendung merken
/*N*/ 		delete pFontItem;
/*N*/ 		pFontItem = (eState == SFX_ITEM_AVAILABLE) ? (SvxFontItem*)pState->Clone() : NULL;
/*N*/ 
/*N*/ 		if ( pFontItem )
/*N*/ 			pBox->Update( *pFontItem );
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ Window* SvxFontHeightToolBoxControl::CreateItemWindow( Window *pParent )
/*N*/ {
/*N*/     pBox = new SvxFontSizeBox_Impl( pParent, *this, GetBindings() );
/*N*/ 	return pBox;
/*N*/ }

//========================================================================
// class SvxFontColorToolBoxControl --------------------------------------
//========================================================================

/*N*/ SvxFontColorToolBoxControl::SvxFontColorToolBoxControl(
/*N*/ 										USHORT			nId,
/*N*/ 										ToolBox&		rTbx ,
/*N*/ 										SfxBindings&	rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl	( nId, rTbx, rBindings ),
/*N*/ 	pBtnUpdater(new SvxTbxButtonColorUpdater_Impl(nId, &GetToolBox(), TBX_UPDATER_MODE_CHAR_COLOR_NEW ))
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFontColorToolBoxControl::~SvxFontColorToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFontColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	const SvxColorItem*	pItem = 0;
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 	   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pBtnUpdater->Update( pItem->GetValue());
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxColorToolBoxControl --------------------------------
//========================================================================

/*N*/ SvxColorToolBoxControl::SvxColorToolBoxControl(	USHORT  nId, ToolBox& rTbx, SfxBindings& rBindings ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl	( nId, rTbx, rBindings )
/*N*/ {
/*N*/     pBtnUpdater = new SvxTbxButtonColorUpdater_Impl( nId, &GetToolBox() );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxColorToolBoxControl::~SvxColorToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	const SvxColorItem*	pItem	= 0;
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*N*/ 		pBtnUpdater->Update( pItem->GetValue() );
/*N*/ 
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFontColorExtToolBoxControl --------------------------------------
//========================================================================

/*N*/ SvxFontColorExtToolBoxControl::SvxFontColorExtToolBoxControl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rTbx,
/*N*/ 	SfxBindings& rBindings
/*N*/ ) :
/*N*/ 
/*N*/ 	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 	pBtnUpdater(0),
/*N*/ 	aForward( SID_ATTR_CHAR_COLOR2 == nId
/*N*/ 				? SID_ATTR_CHAR_COLOR_EXT
/*N*/ 				: SID_ATTR_CHAR_COLOR_BACKGROUND_EXT, *this )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nMode =	SID_ATTR_CHAR_COLOR2 == nId
/*N*/ 		? TBX_UPDATER_MODE_CHAR_COLOR_NEW :	TBX_UPDATER_MODE_CHAR_COLOR_NEW;
/*N*/     pBtnUpdater = new SvxTbxButtonColorUpdater_Impl( nId, &GetToolBox(), nMode );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFontColorExtToolBoxControl::~SvxFontColorExtToolBoxControl()
/*N*/ {
/*N*/ 	delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFontColorExtToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	const SvxColorItem*	pItem = 0;
/*N*/ 
/*N*/ 	if ( nSID == SID_ATTR_CHAR_COLOR_EXT ||
/*N*/ 		 nSID == SID_ATTR_CHAR_COLOR_BACKGROUND_EXT )
/*N*/ 	{
/*N*/ 		if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		{
/*N*/ 			const SfxBoolItem* pBool = PTR_CAST( SfxBoolItem, pState );
/*N*/ 			rTbx.CheckItem( nId, pBool && pBool->GetValue());
/*N*/ 		}
/*N*/ 		rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/ 
/*N*/ 		if ( pItem )
/*N*/ 			pBtnUpdater->Update( pItem->GetValue() );
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------


//========================================================================
// class SvxFrameToolBoxControl ------------------------------------------
//========================================================================

/*N*/ SvxFrameToolBoxControl::SvxFrameToolBoxControl( USHORT		 nId,
/*N*/ 												ToolBox&	 rTbx,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 
/*N*/ 	:	SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/ 		bParagraphMode	 ( FALSE )
/*N*/ {
/*N*/ 	rTbx.SetItemBits( nId, TIB_DROPDOWN | rTbx.GetItemBits( nId ) );
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFrameToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 					nId		= GetId();
/*N*/ 	ToolBox&	 			rTbx	= GetToolBox();
/*N*/ 	const SfxUInt16Item* 	pItem	= 0;
/*N*/ 
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/ 		pItem = PTR_CAST( SfxUInt16Item, pState );
/*N*/ 
/*N*/ 	if ( pItem )
/*?*/ 		bParagraphMode = (BOOL)pItem->GetValue();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, (SFX_ITEM_DONTCARE == eState)
/*N*/ 								? STATE_DONTKNOW
/*N*/ 								: STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFrameLineStyleToolBoxControl ---------------------------------
//========================================================================

/*N*/ SvxFrameLineStyleToolBoxControl::SvxFrameLineStyleToolBoxControl(
/*N*/ 											USHORT   		nId,
/*N*/ 											ToolBox& 		rTbx,
/*N*/ 											SfxBindings&	rBindings )
/*N*/ 
/*N*/ 	:    SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ {
/*N*/ 	rTbx.SetItemBits( nId, TIB_DROPDOWN | rTbx.GetItemBits( nId ) );
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFrameLineStyleToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT 		 nId	= GetId();
/*N*/ 	ToolBox&	 rTbx   = GetToolBox();
/*N*/ 
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, (SFX_ITEM_DONTCARE == eState)
/*N*/ 								? STATE_DONTKNOW
/*N*/ 								: STATE_NOCHECK );
/*N*/ }

//========================================================================
// class SvxFrameLineColorToolBoxControl ---------------------------------
//========================================================================

/*N*/ SvxFrameLineColorToolBoxControl::SvxFrameLineColorToolBoxControl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rTbx,
/*N*/ 	SfxBindings& rBindings
/*N*/ ) :
/*N*/ 
/*N*/     SfxToolBoxControl( nId, rTbx, rBindings ),
/*N*/     pBtnUpdater(new SvxTbxButtonColorUpdater_Impl(   nId, &GetToolBox() ))
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SvxFrameLineColorToolBoxControl::~SvxFrameLineColorToolBoxControl()
/*N*/ {
/*N*/ 
/*N*/     delete pBtnUpdater;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ void SvxFrameLineColorToolBoxControl::StateChanged(
/*N*/ 
/*N*/ 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nId = GetId();
/*N*/ 	ToolBox& rTbx = GetToolBox();
/*N*/ 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
/*N*/ 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
/*N*/ 
/*N*/     const SvxColorItem* pItem = 0;
/*N*/ 	if ( SFX_ITEM_DONTCARE != eState )
/*N*/     {
/*N*/ 	   pItem = PTR_CAST( SvxColorItem, pState );
/*N*/         if ( pItem )
/*N*/             pBtnUpdater->Update( pItem->GetValue());
/*N*/     }
/*N*/ }

// class SvxReloadControllerItem_Impl ------------------------------------

class SvxReloadControllerItem_Impl
{
public:
	Image* pNormalImage;
	Image* pSpecialImage;

	SvxReloadControllerItem_Impl() :
		pSpecialImage( 0 ), pNormalImage( new Image( SVX_RES( RID_SVX_RELOAD_NORMAL ) ) ) {}
	~SvxReloadControllerItem_Impl() { delete pNormalImage; delete pSpecialImage; }

	Image& GetNormalImage() { return *pNormalImage; }
	Image& GetSpecialImage()
		{
			if ( !pSpecialImage )
				pSpecialImage = new Image( SVX_RES( RID_SVX_RELOAD_SPECIAL ) );
			return *pSpecialImage;
		}
};

// -----------------------------------------------------------------------

/*?*/ SvxReloadControllerItem::SvxReloadControllerItem(
/*?*/ 	USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	: pImpl( new SvxReloadControllerItem_Impl ),
/*?*/ 	  SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemImage( nId, pImpl->GetNormalImage() );
/*?*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


//========================================================================


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

// -----------------------------------------------------------------------------
/*?*/ ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SvxFontNameBox_Impl::CreateAccessible()
/*?*/ {DBG_BF_ASSERT(0, "STRIP");::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > x; return x;//STRIP001 
/*?*/ }
}
