/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: basedlgs.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 02:55:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _BASEDLGS_HXX
#define _BASEDLGS_HXX

// include ---------------------------------------------------------------

#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
class SfxItemSet;
class SfxItemPool;
class OKButton;
class CancelButton;
class HelpButton;
class Button;
namespace binfilter {

class SfxTabPage;
class SfxViewFrame;
class SfxBindings;
class SfxChildWindow;
struct SfxChildWinInfo;

// class SfxModalDefParentHelper -----------------------------------------


// class SfxModalDialog --------------------------------------------------

class SfxModalDialog: public ModalDialog
{
	SfxViewFrame*		pFrame;
	USHORT				nUniqId;
	String              aExtraData;
	Timer				aTimer;

protected:
	SfxModalDialog(SfxViewFrame *pViewFrame, Window *pParent, const ResId &);
	SfxModalDialog(SfxViewFrame *pViewFrame, Window* pParent,
				   USHORT nUniqueId, WinBits nWinStyle = WB_STDMODAL);
	SfxModalDialog(Window *pParent, const ResId &);
	SfxModalDialog(Window* pParent, USHORT nUniqueId,
				   WinBits nWinStyle = WB_STDMODAL);
};

// class SfxModelessDialog --------------------------------------------------
class SfxModelessDialog_Impl;
class SfxModelessDialog: public ModelessDialog
{
	SfxBindings*			pBindings;
	Size					aSize;
    SfxModelessDialog_Impl* pImp;

protected:
							SfxModelessDialog( SfxBindings*, SfxChildWindow*,
								Window*, const ResId& );
							SfxModelessDialog( SfxBindings*, SfxChildWindow*,
								Window*, WinBits nWinStyle = WB_STDMODELESS );
							~SfxModelessDialog();

public:
	virtual void        	FillInfo(SfxChildWinInfo&) const;
};

// class SfxFloatingWindow --------------------------------------------------
class SfxFloatingWindow_Impl;
class SfxFloatingWindow: public FloatingWindow
{
	SfxBindings*			pBindings;
	Size					aSize;
    SfxFloatingWindow_Impl* pImp;

protected:
							SfxFloatingWindow( SfxBindings *pBindings,
											  SfxChildWindow *pCW,
											  Window* pParent,
											  const ResId& rResId);
							~SfxFloatingWindow();

    virtual void            StateChanged( StateChangedType nStateChange );
	virtual BOOL			Close();
	virtual void			Resize();
    virtual void            Move();
	virtual long			Notify( NotifyEvent& rNEvt );
    SfxBindings&            GetBindings()
                            { return *pBindings; }

public:
	virtual void        	FillInfo(SfxChildWinInfo&) const;
};

// class SfxSingleTabDialog --------------------------------------------------

typedef USHORT*	(*GetTabPageRanges)(); // liefert internationale Which-Werte


}//end of namespace binfilter
#endif

