/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stbitem.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:09:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXSTBITEM_HXX
#define _SFXSTBITEM_HXX

#ifndef _SFXCTRLITEM_HXX
#include <bf_sfx2/ctrlitem.hxx>
#endif
class SvStream;
class SvStream;
class StatusBar;
class  MouseEvent;
class UserDrawEvent;
namespace binfilter {

class SfxModule;

//------------------------------------------------------------------

class SfxStatusBarControl;
class SfxBindings;

typedef SfxStatusBarControl* (*SfxStatusBarControlCtor)( USHORT nId, StatusBar &rStb, SfxBindings & );

struct SfxStbCtrlFactory
{
	SfxStatusBarControlCtor pCtor;
	TypeId					nTypeId;
	USHORT					nSlotId;

	SfxStbCtrlFactory( SfxStatusBarControlCtor pTheCtor,
			TypeId nTheTypeId, USHORT nTheSlotId ):
		pCtor(pTheCtor),
		nTypeId(nTheTypeId),
		nSlotId(nTheSlotId)
	{}
};

//------------------------------------------------------------------

class  CommandEvent;

class SfxStatusBarControl: public SfxControllerItem
{
friend class SfxStatusBar_Impl;

	StatusBar*		pBar;

protected:
	virtual void	StateChanged( USHORT nSID, SfxItemState eState,
								  const SfxPoolItem* pState );
	virtual void	Click(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	Click();
	virtual void	DoubleClick(){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	DoubleClick();
	virtual void	Command( const CommandEvent& rCEvt ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	Command( const CommandEvent& rCEvt );
	virtual BOOL	MouseButtonDown( const MouseEvent & ){DBG_BF_ASSERT(0, "STRIP"); return FALSE; } //STRIP001 virtual BOOL	MouseButtonDown( const MouseEvent & );
	virtual BOOL	MouseMove( const MouseEvent & ){DBG_BF_ASSERT(0, "STRIP"); return FALSE; } //STRIP001 virtual BOOL	MouseMove( const MouseEvent & );
	virtual BOOL	MouseButtonUp( const MouseEvent & ){DBG_BF_ASSERT(0, "STRIP"); return FALSE; } //STRIP001 virtual BOOL	MouseButtonUp( const MouseEvent & );
	virtual void	Paint( const UserDrawEvent &rUDEvt ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual void	Paint( const UserDrawEvent &rUDEvt );

public:
					SfxStatusBarControl( USHORT nId, StatusBar& rBar, SfxBindings & );
	virtual 		~SfxStatusBarControl();

	StatusBar&		GetStatusBar() const { return *pBar; }

	static SfxStatusBarControl* CreateControl( USHORT nId, StatusBar *pBar, SfxBindings&, SfxModule* );
};

//------------------------------------------------------------------

#define SFX_DECL_STATUSBAR_CONTROL() \
		static SfxStatusBarControl* CreateImpl( USHORT nId, StatusBar &rStb, SfxBindings &rBindings ); \
		static void RegisterControl(USHORT nSlotId = 0, SfxModule *pMod=NULL)

#define SFX_IMPL_STATUSBAR_CONTROL(Class, nItemClass) \
		SfxStatusBarControl* __EXPORT Class::CreateImpl( USHORT nId, StatusBar &rStb, SfxBindings &rBindings ) \
			   { return new Class(nId, rStb, rBindings); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterStatusBarControl( pMod, new SfxStbCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

}//end of namespace binfilter
#endif

