/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: view.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:14:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef VIEW_HXX
#define VIEW_HXX

#ifndef _SFXDOCKWIN_HXX //autogen
#include <bf_sfx2/dockwin.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SCRWIN_HXX //autogen
#include <svtools/scrwin.hxx>
#endif
#ifndef _SFXCTRLITEM_HXX //autogen
#include <bf_sfx2/ctrlitem.hxx>
#endif
#ifndef _SFX_SHELL_HXX //autogen
#include <bf_sfx2/shell.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <bf_sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef EDIT_HXX
#include "edit.hxx"
#endif
#ifndef NODE_HXX
#include "node.hxx"
#endif
#ifndef _ACCESSIBILITY_HXX_
#include "accessibility.hxx"
#endif
class Menu; 
namespace binfilter {


class DataChangedEvent;
class SmClipboardChangeListener;
class SmDocShell;
class SmViewShell;

/**************************************************************************/

class SmGraphicWindow : public ScrollableWindow
{
	Point			aFormulaDrawPos;
	Rectangle		aCursorRect;


    SmViewShell    *pViewShell;
	USHORT			nZoom;
	short			nModifyCount;
	BOOL			bIsCursorVisible;

protected:
	void		SetFormulaDrawPos(const Point &rPos) { aFormulaDrawPos = rPos; }
	void		SetIsCursorVisible(BOOL bVis) { bIsCursorVisible = bVis; }
	void        SetCursor(const SmNode *pNode);
	void 		SetCursor(const Rectangle &rRect);

	virtual void Paint(const Rectangle&);
	virtual void StateChanged( StateChangedType eChanged );

public:
	SmGraphicWindow(SmViewShell* pShell);
    ~SmGraphicWindow();

    // Window
    virtual void    GetFocus();
    virtual void    LoseFocus();

    SmViewShell *   GetView()   { return pViewShell; }

	USHORT GetZoom() const { return nZoom; }

    const Point &   GetFormulaDrawPos() const { return aFormulaDrawPos; }

	void SetTotalSize();

	BOOL IsCursorVisible() const { return bIsCursorVisible; }
	void ShowCursor(BOOL bShow);
	const SmNode * SetCursorPos(USHORT nRow, USHORT nCol);

    void ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg );

    // for Accessibility

};

/**************************************************************************/

class SmGraphicController: public SfxControllerItem
{
protected:
	SmGraphicWindow &rGraphic;
public:
	SmGraphicController(SmGraphicWindow &, USHORT, SfxBindings & );
	virtual void StateChanged(USHORT			 nSID,
							  SfxItemState		 eState,
							  const SfxPoolItem* pState);
};

/**************************************************************************/

class SmEditController: public SfxControllerItem
{
protected:
	SmEditWindow &rEdit;

public:
	SmEditController(SmEditWindow &, USHORT, SfxBindings  & );
#if OSL_DEBUG_LEVEL > 1
    virtual ~SmEditController();
#endif

	virtual void StateChanged(USHORT			 nSID,
							  SfxItemState		 eState,
							  const SfxPoolItem* pState);
};

/**************************************************************************/

class SmCmdBoxWindow : public SfxDockingWindow
{
	SmEditWindow		aEdit;
	SmEditController	aController;
	Timer				aGrabTimer;
    BOOL                bExiting;

protected :
	DECL_LINK(UpdateTimeoutHdl, Timer *);

    // Window
    virtual void    GetFocus();
	virtual void Paint(const Rectangle& rRect);
    virtual void StateChanged( StateChangedType nStateChange );

	virtual SfxChildAlignment CheckAlignment(SfxChildAlignment eActual,
											 SfxChildAlignment eWish);

	virtual void	ToggleFloatingMode();

public:
	SmCmdBoxWindow(SfxBindings	  *pBindings,
				   SfxChildWindow *pChildWindow,
				   Window		  *pParent);

	virtual ~SmCmdBoxWindow ();

	void AdjustPosition();

	SmEditWindow *GetEditWindow() { return (&aEdit); }
    SmViewShell  *GetView();

	void RestartFocusTimer ()
	{
		aGrabTimer.SetTimeout (100);
		aGrabTimer.Start ();
	}

	void Grab ();
};

/**************************************************************************/

class SmCmdBoxWrapper : public SfxChildWindow
{
	SFX_DECL_CHILDWINDOW(SmCmdBoxWrapper);

protected:
	SmCmdBoxWrapper(Window			*pParentWindow,
					USHORT			 nId,
					SfxBindings 	*pBindings,
					SfxChildWinInfo *pInfo);

#if OSL_DEBUG_LEVEL > 1
    virtual ~SmCmdBoxWrapper();
#endif

public:

	SmEditWindow *GetEditWindow()
	{
		return (((SmCmdBoxWindow *)pWindow)->GetEditWindow());
	}

	void RestartFocusTimer ()
	{
		((SmCmdBoxWindow *)pWindow)->RestartFocusTimer ();
	}

};

/**************************************************************************/

class SmViewShell: public SfxViewShell
{
	// for handling the PasteClipboardState
	friend class SmClipboardChangeListener;

	SmGraphicWindow 	aGraphic;
	SmGraphicController aGraphicController;
	String				StatusText;

	::com::sun::star::uno:: Reference <
			::com::sun::star::lang:: XEventListener > xClipEvtLstnr;
	SmClipboardChangeListener*	pClipEvtLstnr;
	Window			   *pViewFrame;
	BOOL				bPasteState;

	void AddRemoveClipboardListener( BOOL bAdd );

protected:


	virtual SfxPrinter *GetPrinter(BOOL bCreate = FALSE);

	virtual void Deactivate(BOOL IsMDIActivate);
	virtual void Activate(BOOL IsMDIActivate);
	virtual void OuterResizePixel(const Point &rOfs, const Size  &rSize);

public:
	TYPEINFO();

    SmViewShell(SfxViewFrame *pFrame, SfxViewShell *pOldSh);
	~SmViewShell();

	SmDocShell * GetDoc()
	{
		return (SmDocShell *) GetViewFrame()->GetObjectShell();
	}

	SmEditWindow * GetEditWindow();
		  SmGraphicWindow & GetGraphicWindow() 		 { return aGraphic; }
	const SmGraphicWindow & GetGraphicWindow() const { return aGraphic; }

	void		SetStatusText(const String& Text);


	SFX_DECL_INTERFACE(SFX_INTERFACE_SMA_START+2);
	SFX_DECL_VIEWFACTORY(SmViewShell);

	virtual void Execute( SfxRequest& rReq );
	virtual void GetState(SfxItemSet &);

    void Impl_Print( OutputDevice &rOutDev, const SmPrintSize ePrintSize,
                     Rectangle aOutRect, Point aZeroPoint );
};

} //namespace binfilter
#endif

