/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: LayoutHelper.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:24:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "LayoutHelper.hxx"

#include <cmath>

// for F_PI (M_PI does not exist on Windows)
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

using namespace ::com::sun::star;

namespace chart
{
namespace helper
{

// static

layout::Alignment LayoutHelper::getStandardAlignmentByAngle( double fAngle )
{
    layout::Alignment aResult;

    double fNormedAngle = fmod( fAngle, 360.0 );
    if( fNormedAngle < 0.0 )
        fNormedAngle += 360.0;

    if( fNormedAngle <= 22.5 ||
        fNormedAngle > 337.5 )
    {
        aResult = ::layout_defaults::const_aWest;
    }
    else if( fNormedAngle > 22.5 &&
             fNormedAngle <= 67.5 )
    {
        aResult = ::layout_defaults::const_aSouthWest;
    }
    else if( fNormedAngle > 67.5 &&
             fNormedAngle <= 112.5 )
    {
        aResult = ::layout_defaults::const_aSouth;
    }
    else if( fNormedAngle > 112.5 &&
             fNormedAngle <= 157.5 )
    {
        aResult = ::layout_defaults::const_aSouthEast;
    }
    else if( fNormedAngle > 157.5 &&
             fNormedAngle <= 202.5 )
    {
        aResult = ::layout_defaults::const_aEast;
    }
    else if( fNormedAngle > 202.5 &&
             fNormedAngle <= 247.5 )
    {
        aResult = ::layout_defaults::const_aNorthEast;
    }
    else if( fNormedAngle > 247.5 &&
             fNormedAngle <= 292.5 )
    {
        aResult = ::layout_defaults::const_aNorth;
    }
    else if( fNormedAngle > 292.5 &&
             fNormedAngle <= 337.5 )
    {
        aResult = ::layout_defaults::const_aNorthWest;
    }
    else
    {
        OSL_ENSURE( false, "Shouldn't have come here" );
    }

    return aResult;
}

void LayoutHelper::rotatePoint(
    double fAngle,
    double & rOutX,
    double & rOutY )
{
    double fRad = fAngle / 180.0 * F_PI;
    double fX = rOutX;
    double fY = rOutY;

    rOutX = fX * cos(fRad) - fY * sin(fRad);
    rOutY = fX * sin(fRad) + fY * cos(fRad);
}

} //  namespace helper
} //  namespace chart
