/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: propertybag.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/10/24 15:14:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBACCESS_SOURCE_CORE_MISC_PROPERTYBAG_HXX
#define DBACCESS_SOURCE_CORE_MISC_PROPERTYBAG_HXX

/** === begin UNO includes === **/
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include <com/sun/star/beans/XPropertyAccess.hpp>
#endif
/** === end UNO includes === **/

#ifndef _CPPUHELPER_IMPLBASE4_HXX_
#include <cppuhelper/implbase4.hxx>
#endif
#ifndef COMPHELPER_PROPERTYSTATECONTAINER_HXX
#include <comphelper/propertystatecontainer.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif

#include <map>
#include <set>
#include <memory>

//........................................................................
namespace dba
{
//........................................................................

    namespace
    {
        struct SAL_DLLPRIVATE UnoTypeLess : public ::std::unary_function< ::com::sun::star::uno::Type, bool >
        {
            inline bool operator()( const ::com::sun::star::uno::Type& _rLHS, const ::com::sun::star::uno::Type& _rRHS ) const
            {
                return rtl_ustr_compare(
                    _rLHS.getTypeLibType()->pTypeName->buffer,
                    _rRHS.getTypeLibType()->pTypeName->buffer
                ) < 0;
            }
        };
    }

    typedef ::std::map< sal_Int32, ::com::sun::star::uno::Any >     MapInt2Any;
    typedef ::std::set< ::com::sun::star::uno::Type, UnoTypeLess >  TypeBag;

    //====================================================================
	//= OPropertyBag
	//====================================================================

    typedef ::comphelper::OMutexAndBroadcastHelper  OPropertyBag_BBase;
    typedef ::cppu::WeakAggImplHelper4  <   ::com::sun::star::beans::XPropertyContainer
                                        ,   ::com::sun::star::beans::XPropertyAccess
                                        ,   ::com::sun::star::lang::XServiceInfo
                                        ,   ::com::sun::star::lang::XInitialization
                                        >   OPropertyBag_Base;
    typedef ::comphelper::OPropertyStateContainer   OPropertyBag_CBase;

    class OPropertyBag  :public OPropertyBag_BBase  // must be before OPropertyBag_CBase
                        ,public OPropertyBag_CBase
                        ,public OPropertyBag_Base
	{
    private:
        ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
                        m_xORB;

        /// our IPropertyArrayHelper implementation
        ::std::auto_ptr< ::cppu::OPropertyArrayHelper >
                        m_pArrayHelper;
        /// flag denoting whether <member>m_pArrayHelper</member> must be re-created before accessing it next time
        bool            m_bArrayHelperDirty;
        /// the default values for our registered properties
        MapInt2Any      m_aDefaultValues;
        /// set of allowed property types
        TypeBag         m_aAllowedTypes;
        /// should we automatically add properties which are tried to set, if they don't exist previously?
        bool            m_bAutoAddProperties;

    public:
        OPropertyBag( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB );

        // XServiceInfo - static versions
		static ::com::sun::star::uno::Sequence< ::rtl::OUString > getSupportedServiceNames_Static(void) throw( ::com::sun::star::uno::RuntimeException );
		static ::rtl::OUString getImplementationName_Static(void) throw( ::com::sun::star::uno::RuntimeException );
		static ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >
				SAL_CALL Create(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&);

    protected:
        virtual ~OPropertyBag();
        DECLARE_XINTERFACE()
        DECLARE_XTYPEPROVIDER()

        /** === begin UNO interface implementations == **/
        // XInitialization
        virtual void SAL_CALL initialize( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments ) throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

        // XServiceInfo
        virtual ::rtl::OUString SAL_CALL getImplementationName(  ) throw (::com::sun::star::uno::RuntimeException);
        virtual ::sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException);
        virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw (::com::sun::star::uno::RuntimeException);

        // XPropertyContainer
        virtual void SAL_CALL addProperty( const ::rtl::OUString& Name, ::sal_Int16 Attributes, const ::com::sun::star::uno::Any& DefaultValue ) throw (::com::sun::star::beans::PropertyExistException, ::com::sun::star::beans::IllegalTypeException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL removeProperty( const ::rtl::OUString& Name ) throw (::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::NotRemoveableException, ::com::sun::star::uno::RuntimeException);

        // XPropertyAccess
        virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > SAL_CALL getPropertyValues(  ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL setPropertyValues( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aProps ) throw (::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

        // XPropertySet
        virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException);
        /** === UNO interface implementations == **/

        // XPropertyState (OPropertyStateContainer)
		virtual void getPropertyDefaultByHandle( sal_Int32 _nHandle, ::com::sun::star::uno::Any& _rDefault ) const;

        // OPropertySetHelper
        virtual ::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();

    private:
        /** finds a free property handle
            @precond
                our mutex is locked
        */
        sal_Int32   findFreeHandle() const;

        /** implements the setPropertyValues method
            @param _rProps
                the property values to set
            @param _bTolerateUnknownProperties 
                determines whether UnknownPropertyExceptions should be tolerated. If <TRUE/>, and
                an UnknownPropertyException occurs, the method tries to add all properties which
                currently are not added. After this, it tries to set all given property values,
                again.

            @throws PropertyVetoException
                if the XMultiPropertySet::setPropertyValues call does so

            @throws ::com::sun::star::lang::IllegalArgumentException
                if the XMultiPropertySet::setPropertyValues call does so

            @throws ::com::sun::star::lang::WrappedTargetException
                if the XMultiPropertySet::setPropertyValues call does so

            @throws ::com::sun::star::uno::RuntimeException
                if the XMultiPropertySet::setPropertyValues call does so

            @throws ::com::sun::star::beans::UnknownPropertyException
                if the XMultiPropertySet::setPropertyValues call does so, and <arg>_bTolerateUnknownProperties</arg>
                was set to <FALSE/>

            @throws ::com::sun::star::lang::WrappedTargetException
                if the XMultiPropertySet::setPropertyValues call did throw an exception not listed
                above
        */
        void implSetPropertyValues( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rProps, bool _bTolerateUnknownProperties );

        /** ensures that the property bag contains a property with the given name, and the given
            initial/default value

            If a property with the given name already exists in the bag, nothing happens.

            If the property does not yet exist, it is automatically added, with the
            PropertyAttribute::BOUND, PropertyAttribute::REMOVEABLE and PropertyAttribute::MAYBEDEFAULT
            attributes.

            @return
                <TRUE/> if the property was successfully added, <FALSE/> otherwise. Failure conditions are
                <ul><li><arg>_rValue</arg> is <NULL/>. In this case, the property is not added, since
                    no type for it can be determined.</li>
                </ul>

            @throws ::com::sun::star::lang::WrappedTargetException
                if the <member>addPropertyWithType</member> call does throw an
                ::com::sun::star::beans::IllegalTypeException
            @throws ::com::sun::star::lang::IllegalArgumentException
                if the <member>addPropertyWithType</member> call does so
            @throws ::com::sun::star::uno::RuntimeException
                if the <member>addPropertyWithType</member> call does so
        */
        bool implEnsureContainsProperty(
            const ::rtl::OUString& _rName,
            const ::com::sun::star::uno::Any& _rValue
        );

    private:
        OPropertyBag();                                 // never implemented
        OPropertyBag( const OPropertyBag& );            // never implemented
        OPropertyBag& operator=( const OPropertyBag& ); // never implemented

        using OPropertyStateContainer::getPropertyValues;
        using OPropertyStateContainer::setPropertyValues;
    };

//........................................................................
} // namespace dba
//........................................................................

#endif // OOO_DBACCESS_SOURCE_CORE_MISC_PROPERTYBAG_HXX
